/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.util.DbUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RoleUtil {
    private static Log log = LogFactory.getLog(RoleUtil.class);

    public static Set<String> getUserIdList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String roleId = String.valueOf(request.getAttribute("roleId"));
        String branchNo = String.valueOf(request.getAttribute("branchNo"));
        HashSet<String> userIdList = new HashSet<String>();
        RoleUtil.userList(roleId, branchNo, userIdList);
        return userIdList;
    }

    public static Set<String> getUserIdList(String roleId, String branchNo) {
        HashSet<String> userIdList = new HashSet<String>();
        RoleUtil.userList(roleId, branchNo, userIdList);
        return userIdList;
    }

    public static void userList(String roleId, String branchNo, Set<String> userIdList) {
        block8: {
            HashMap<String, String> deptIdToUserIdMap = null;
            ArrayList<String> deptIdToBranchNoList = null;
            Connection conn = null;
            PreparedStatement st = null;
            ResultSet rs = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    st = conn.prepareStatement("SELECT USER_ID FROM KS_USER_ROLE WHERE ROLE_ID=?");
                    st.setString(1, roleId);
                    rs = st.executeQuery();
                    while (rs.next()) {
                        userIdList.add(rs.getString(1));
                    }
                    if (!branchNo.isEmpty()) {
                        deptIdToUserIdMap = new HashMap<String, String>();
                        deptIdToBranchNoList = new ArrayList<String>();
                        RoleUtil.getDeptIdToUserId(deptIdToUserIdMap, userIdList);
                        RoleUtil.getDeptIdToBranchNo(deptIdToBranchNoList, branchNo);
                        if (deptIdToUserIdMap.size() > 0 && deptIdToBranchNoList.size() > 0) {
                            userIdList = new HashSet<String>();
                            RoleUtil.getUserIdList(deptIdToUserIdMap, deptIdToBranchNoList, userIdList);
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                    DbUtil.close(rs);
                    DbUtil.close(st);
                    DbUtil.close(conn);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(st);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
        }
    }

    public static void getUserIdList(Map<String, String> deptIdToUserIdMap, List<String> deptIdToBranchNoList, Set<String> list) {
        for (String userId : deptIdToUserIdMap.keySet()) {
            for (String deptId : deptIdToBranchNoList) {
                if (!deptId.equals(deptIdToUserIdMap.get(userId))) continue;
                list.add(userId);
            }
        }
    }

    public static void getDeptIdToUserId(Map<String, String> deptIdToUserIdMap, Set<String> userIdList) {
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            try {
                conn = DbUtil.getConnection();
                if (userIdList != null) {
                    for (String userId : userIdList) {
                        st = conn.prepareStatement("SELECT DEPT_ID FROM WB_USER WHERE USER_ID=?");
                        st.setString(1, userId);
                        rs = st.executeQuery();
                        while (rs.next()) {
                            deptIdToUserIdMap.put(userId, rs.getString(1));
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                DbUtil.close(rs);
                DbUtil.close(st);
                DbUtil.close(conn);
            }
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
        }
    }

    public static void getDeptIdToBranchNo(List<String> deptIdToBranchNoList, String branchNo) {
        block6: {
            Connection conn = null;
            PreparedStatement st = null;
            ResultSet rs = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    st = conn.prepareStatement("SELECT DEPT_ID FROM WB_DEPT WHERE BRANCH_NO=?");
                    st.setString(1, branchNo);
                    rs = st.executeQuery();
                    while (rs.next()) {
                        deptIdToBranchNoList.add(rs.getString(1));
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                    DbUtil.close(rs);
                    DbUtil.close(st);
                    DbUtil.close(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(st);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
        }
    }
}

