/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.util.DbUtil;
import java.sql.Connection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReleaseDbConnUtils {
    private static Log log = LogFactory.getLog(ReleaseDbConnUtils.class);
    private static int overTime = 1800;
    public static ConcurrentHashMap<String, Connection> buffer = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, String> stackMap = new ConcurrentHashMap();

    public static void add(Connection con) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            sb.append(e.getClassName()).append("\t").append(e.getMethodName()).append("\t").append(e.getLineNumber()).append("\n");
            ++n2;
        }
        String key = String.valueOf(Thread.currentThread().getId()) + "==" + System.currentTimeMillis() + "--" + System.nanoTime();
        buffer.put(key, con);
        stackMap.put(key, sb.toString());
    }

    public static long getDate(String date) {
        int index = date.indexOf("==");
        if (index > 0) {
            date = date.substring(index + 2);
        }
        if ((index = date.indexOf("--")) > 0) {
            date = date.substring(0, index);
        }
        return Long.parseLong(date);
    }

    public static boolean isOverTime(String date1, int second) {
        try {
            long now = System.currentTimeMillis();
            long date = ReleaseDbConnUtils.getDate(date1);
            if (now - date > (long)(second * 1000)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)("--------------" + date1));
            log.error((Object)"", (Throwable)e);
        }
        return false;
    }

    public static void runCleanConn() {
        Thread cc = new Thread(new CleanConnectionThread());
        cc.setName("CleanConnectionThread");
        cc.start();
    }

    public static void main(String[] args) {
        System.out.println(System.nanoTime());
    }

    static class CleanConnectionThread
    implements Runnable {
        CleanConnectionThread() {
        }

        @Override
        public void run() {
            while (true) {
                Iterator it = ((ConcurrentHashMap.KeySetView)buffer.keySet()).iterator();
                try {
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        Connection sr = buffer.get(key);
                        if (sr != null && sr instanceof Connection) {
                            Connection conn = sr;
                            if (conn.isClosed()) {
                                buffer.remove(key);
                                stackMap.remove(key);
                                continue;
                            }
                            boolean isOv = ReleaseDbConnUtils.isOverTime(key, overTime);
                            if (!isOv) continue;
                            try {
                                log.error((Object)("release connection :" + sr));
                                DbUtil.close(conn);
                                log.error((Object)("problem------ connection not release in stack:" + stackMap.get(key)));
                            }
                            catch (Exception e) {
                                log.error((Object)"", (Throwable)e);
                            }
                            buffer.remove(key);
                            stackMap.remove(key);
                            continue;
                        }
                        log.error((Object)sr);
                    }
                    Thread.sleep(5000L);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

