/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.DataSource;

public class MonitorDbUtils {
    public static int waitTime = 3600;
    private static Log log = LogFactory.getLog(MonitorDbUtils.class);
    private static ConcurrentHashMap<String, javax.sql.DataSource> dsMap = new ConcurrentHashMap();

    public static void monitorDatSource() {
        Thread cc = new Thread(new MonitorDatasourceThread());
        cc.setName("MonitorDatasourceThread");
        cc.start();
    }

    private static void monitorDatasource() {
        log.debug((Object)"dataSource monior--------");
        Iterator<javax.sql.DataSource> iterator = dsMap.values().iterator();
        while (iterator.hasNext()) {
            if (iterator == null) continue;
            MonitorDbUtils.showDs(iterator.next());
        }
    }

    private static void showDs(javax.sql.DataSource ds) {
        String cl = ds.getClass().getName();
        if (cl.equals("com.alibaba.druid.pool.DruidDataSource")) {
            DruidDataSource dd = (DruidDataSource)ds;
            long active = dd.getActiveCount();
            long max = dd.getMaxActive();
            long idle = dd.getPoolingCount();
            MonitorDbUtils.showDbPool(dd.getName(), idle, max, active);
        } else if (cl.equals("org.apache.tomcat.jdbc.pool.DataSource")) {
            DataSource dd = (DataSource)ds;
            long active = dd.getActive();
            long max = dd.getMaxActive();
            long idle = dd.getNumIdle();
            MonitorDbUtils.showDbPool(dd.getName(), idle, max, active);
        } else {
            log.warn((Object)("dataSource factory not in list of show:" + cl));
        }
    }

    private static void showDbPool(String db, long idle, long max, long active) {
        StringBuffer sb = new StringBuffer();
        sb.append("connection pool :").append(db).append(" ").append("active=").append(active).append(" ").append("idle=").append(idle).append(" ").append("max= ").append(max).append("\n");
        if (max - active < 10L) {
            log.error((Object)sb);
        } else {
            log.info((Object)sb);
        }
    }

    public static void add(String jndi, javax.sql.DataSource ds) {
        if (dsMap.get(jndi) == null) {
            dsMap.put(jndi, ds);
        }
    }

    static class MonitorDatasourceThread
    implements Runnable {
        MonitorDatasourceThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    MonitorDbUtils.monitorDatasource();
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
                try {
                    Thread.sleep(1000 * waitTime);
                    continue;
                }
                catch (InterruptedException e) {
                    log.error((Object)"", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

