/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.util.FileUtil;
import com.wb.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtil {
    public static Object getValue(JSONObject object, String path, char separator) {
        if (path == null) {
            throw new RuntimeException("null path value");
        }
        if (path.isEmpty()) {
            return object;
        }
        String[] items = StringUtil.split(path, separator);
        JSONObject obj = object;
        int j = items.length - 1;
        int i = 0;
        while (i < j) {
            String item = items[i];
            if ((obj = obj.optJSONObject(item)) == null) {
                return null;
            }
            ++i;
        }
        return obj.opt(items[j]);
    }

    public static JSONObject setValue(JSONObject object, String path, char separator, Object value) {
        if (StringUtil.isEmpty(path)) {
            throw new RuntimeException("Path is null or empty");
        }
        String[] items = StringUtil.split(path, separator);
        JSONObject obj = object;
        int j = items.length - 1;
        int i = 0;
        while (i < j) {
            String item = items[i];
            if ((obj = obj.optJSONObject(item)) == null) {
                throw new RuntimeException("Path \"" + path + "\" does not exist.");
            }
            ++i;
        }
        obj.put(items[j], value);
        return object;
    }

    public static JSONObject readObject(File file) throws IOException {
        String text = FileUtil.readString(file);
        if (text.isEmpty()) {
            return new JSONObject();
        }
        try {
            return new JSONObject(text.substring(text.indexOf(123)));
        }
        catch (Throwable e) {
            throw new JSONException("Invalid JSONObject: " + StringUtil.ellipsis(text, 50));
        }
    }

    public static JSONArray readArray(File file) throws IOException {
        String text = FileUtil.readString(file);
        if (text.isEmpty()) {
            return new JSONArray();
        }
        try {
            return new JSONArray(text.substring(text.indexOf(91)));
        }
        catch (Throwable e) {
            throw new JSONException("Invalid JSONArray: " + StringUtil.ellipsis(text, 30));
        }
    }

    public static JSONObject findObject(JSONObject jo, String itemsKey, String key, String value) {
        if (jo.optString(key).equals(value)) {
            return jo;
        }
        JSONArray ja = jo.optJSONArray(itemsKey);
        if (ja != null) {
            int j = ja.length();
            int i = 0;
            while (i < j) {
                JSONObject result;
                JSONObject item = ja.optJSONObject(i);
                if (item != null && (result = JsonUtil.findObject(item, itemsKey, key, value)) != null) {
                    return result;
                }
                ++i;
            }
        }
        return null;
    }

    public static JSONObject findObject(JSONArray ja, String key, String text) {
        int j = ja.length();
        int i = 0;
        while (i < j) {
            JSONObject jo = ja.getJSONObject(i);
            if (jo.optString(key).equals(text)) {
                return jo;
            }
            ++i;
        }
        return null;
    }

    public static JSONArray findArray(JSONObject jo, String itemsKey, String key, String value) {
        JSONArray ja = jo.optJSONArray(itemsKey);
        if (ja != null) {
            int j = ja.length();
            int i = 0;
            while (i < j) {
                JSONObject item = ja.optJSONObject(i);
                if (item != null) {
                    if (item.optString(key).equals(value)) {
                        return ja;
                    }
                    JSONArray result = JsonUtil.findArray(item, itemsKey, key, value);
                    if (result != null) {
                        return result;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static int indexOf(JSONArray ja, String value) {
        int j = ja.length();
        int i = 0;
        while (i < j) {
            if (value == null && ja.isNull(i) || value != null && value.equals(ja.opt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String remove(JSONObject jo, String itemsKey, String key, String value) {
        JSONArray ja = jo.optJSONArray(itemsKey);
        if (ja != null) {
            int j = ja.length();
            int i = j - 1;
            while (i >= 0) {
                JSONObject item = ja.optJSONObject(i);
                if (item != null) {
                    String result;
                    if (StringUtil.isEqual(item.optString(key, null), value)) {
                        result = item.toString();
                        ja.remove(i);
                        return result;
                    }
                    result = JsonUtil.remove(item, itemsKey, key, value);
                    if (result != null) {
                        return result;
                    }
                }
                --i;
            }
        }
        return null;
    }

    public static boolean replace(JSONObject jo, String itemsKey, String key, String value, Object data) {
        JSONArray ja = jo.optJSONArray(itemsKey);
        if (ja != null) {
            int j = ja.length();
            int i = 0;
            while (i < j) {
                JSONObject item = ja.optJSONObject(i);
                if (item != null) {
                    if (StringUtil.isEqual(item.optString(key, null), value)) {
                        ja.put(i, data);
                        return true;
                    }
                    if (JsonUtil.replace(item, itemsKey, key, value, data)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static String join(JSONArray array, String separator) {
        int j = array.length();
        if (j == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < j) {
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(array.getString(i));
            ++i;
        }
        return buf.toString();
    }

    public static JSONObject fromCSV(String text) {
        String[] items;
        JSONObject jo = new JSONObject();
        if (StringUtil.isEmpty(text)) {
            return jo;
        }
        String[] stringArray = items = StringUtil.split(text, ',', true);
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            jo.put(item, true);
            ++n2;
        }
        return jo;
    }

    public static boolean addAll(Collection<String> list, JSONArray array) {
        int j = array.length();
        int i = 0;
        while (i < j) {
            list.add(array.optString(i, null));
            ++i;
        }
        return j != 0;
    }

    public static Object opt(JSONObject jo, String key) {
        if (jo.isNull(key)) {
            return null;
        }
        return jo.opt(key);
    }

    public static Object opt(JSONArray ja, int index) {
        if (ja.isNull(index)) {
            return null;
        }
        return ja.opt(index);
    }

    public static void apply(JSONObject source, JSONObject dest) {
        Set es = dest.entrySet();
        for (Map.Entry e : es) {
            source.put((String)e.getKey(), e.getValue());
        }
    }

    public static JSONObject copy(JSONObject source, String[] keys) {
        JSONObject jo = new JSONObject();
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            jo.put(key, source.opt(key));
            ++n2;
        }
        return jo;
    }

    public static JSONArray getArray(Object value) {
        if (value == null || value instanceof JSONArray) {
            return (JSONArray)value;
        }
        return new JSONArray(value.toString());
    }

    public static JSONArray toArray(Object value) {
        if (value == null || value instanceof JSONArray) {
            return (JSONArray)value;
        }
        return new JSONArray().put(value);
    }

    public static JSONObject getObject(Object value) {
        if (value == null || value instanceof JSONObject) {
            return (JSONObject)value;
        }
        return new JSONObject(value.toString());
    }

    public static HashSet<String> toHashSet(JSONArray array) {
        if (array == null) {
            return null;
        }
        int j = array.length();
        HashSet<String> hs = new HashSet<String>();
        int i = 0;
        while (i < j) {
            hs.add(array.optString(i));
            ++i;
        }
        return hs;
    }

    public static String[] createArray(JSONArray array) {
        if (array == null) {
            return null;
        }
        int j = array.length();
        String[] result = new String[j];
        int i = 0;
        while (i < j) {
            result[i] = array.getString(i);
            ++i;
        }
        return result;
    }
}

