/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import cn.hutool.core.util.NumberUtil;
import javax.servlet.http.HttpServletRequest;

public class IpUtils {
    public static String getClientIP(HttpServletRequest request) {
        String ip;
        String[] headers;
        String[] stringArray = headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            String header = stringArray[n2];
            ip = request.getHeader(header);
            if (!IpUtils.isUnknow(ip)) {
                return IpUtils.getMultistageReverseProxyIp(ip);
            }
            ++n2;
        }
        ip = request.getRemoteAddr();
        return IpUtils.getMultistageReverseProxyIp(ip);
    }

    public static boolean isUnknow(String checkString) {
        return IpUtils.isBlank(checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            String[] stringArray = ips = ip.trim().split(",");
            int n = ips.length;
            int n2 = 0;
            while (n2 < n) {
                String subIp = stringArray[n2];
                if (!IpUtils.isUnknow(subIp)) {
                    ip = subIp;
                    break;
                }
                ++n2;
            }
        }
        return ip;
    }

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        int i = 0;
        while (i < length) {
            if (!NumberUtil.isBlankChar((char)str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

