/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ks.fintech.bw.support.PermUtil;
import com.syspatch.zip.ZipEntry;
import com.syspatch.zip.ZipInputStream;
import com.wb.common.UrlBuffer;
import com.wb.common.Var;
import com.wb.interact.Service;
import com.wb.util.FileUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ks.fintech.framework.core.exception.KException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class ImportModuleUtil {
    private static Log log = LogFactory.getLog(ImportModuleUtil.class);

    public static void importModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean urlAdded = false;
        boolean overwritten = false;
        ZipEntry z = null;
        String name = null;
        String sysUser = null;
        String content = null;
        List<Object> childList = new ArrayList();
        org.json.JSONObject app = WebUtil.fetch(request);
        if (!app.has("file__name")) {
            return;
        }
        overwritten = Boolean.parseBoolean(app.getString("overwritten"));
        if (!app.getString("file__name").toString().toLowerCase().endsWith(".wb")) {
            throw new KException("\u5f15\u5165\u6a21\u5757\u5305\u9519\u8bef", new Object[]{"\u6a21\u5757\u5305\u6587\u4ef6\u6269\u5c55\u540d\u987b\u4e3a.wb"});
        }
        InputStream in = (InputStream)app.opt("file");
        ByteArrayOutputStream inCache = FileUtil.cloneInputStream(in);
        try (ZipInputStream zipStream = new ZipInputStream((InputStream)new ByteArrayInputStream(inCache.toByteArray()));){
            zipStream.fileCharset = Var.getString("sys.locale.filenameCharset");
            sysUser = (String)request.getSession().getAttribute("sys.username");
            while ((z = zipStream.getNextEntry()) != null) {
                name = z.getName();
                Service.checkMoudle(name, null);
                content = ImportModuleUtil.getFolderJsonContentByPath(new ByteArrayInputStream(inCache.toByteArray()), name);
                String path = FileUtil.getPath("modules" + File.separator + name);
                if (!StringUtils.isEmpty((Object)content)) {
                    childList = ImportModuleUtil.getChildFileNameList(content);
                }
                if (z.isDirectory()) {
                    path = path.substring(0, path.length() - 1);
                    PermUtil.menuPerm((String)path, (String)sysUser, childList);
                    continue;
                }
                if (name.equals("url.json") || name.equals("folder.json")) continue;
                if (!name.equals("folder.json")) {
                    name.endsWith("/folder.json");
                }
                PermUtil.syncPerm((String)path, (String)StringUtil.getStringA((InputStream)zipStream), (String)sysUser, childList, (boolean)overwritten);
            }
            if (urlAdded) {
                UrlBuffer.save();
            }
        }
        WebUtil.send(response, null, true);
    }

    public static String getFolderJsonContentByPath(InputStream in, String path) throws Exception {
        ZipEntry z = null;
        String name = null;
        ZipInputStream zipStream = new ZipInputStream(in);
        try {
            zipStream.fileCharset = Var.getString("sys.locale.filenameCharset");
            path = ImportModuleUtil.fixPath(path);
            while ((z = zipStream.getNextEntry()) != null) {
                name = z.getName();
                if (!name.contains("folder.json") || !name.equals(path)) continue;
                String stringA = StringUtil.getStringA((InputStream)zipStream);
                return stringA;
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return null;
    }

    private static String fixPath(String path) {
        if (path.endsWith("/")) {
            path = (path = path.substring(0, path.length() - 1)).contains("/") ? String.valueOf(path.substring(0, path.lastIndexOf("/") + 1)) + "folder.json" : "folder.json";
        }
        if (path.endsWith(".xwl")) {
            path = String.valueOf(path.substring(0, path.lastIndexOf("/") + 1)) + "folder.json";
        }
        return path;
    }

    public static List<String> getChildFileNameList(String content) {
        JSONObject obj = JSON.parseObject((String)content);
        return obj.getJSONArray("index").toJavaList(String.class);
    }

    public static Map getUrlMap(ZipInputStream stream) throws IOException, Exception {
        String object = StringUtil.encode(StringUtil.getStringA((InputStream)stream));
        HashMap map = org.json.JSONObject.toHashMap((Object)object);
        return map;
    }
}

