/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.ks.fintech.bw.api.FunctionEObj;
import com.wb.common.Base;
import com.wb.common.Path;
import com.wb.common.UrlBuffer;
import com.wb.common.Var;
import com.wb.common.XwlBuffer;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.swing.filechooser.FileSystemView;
import ks.fintech.bw.api.service.CacheServiceAware;
import ks.fintech.bw.api.service.FunctionContentCacheAware;
import ks.fintech.framework.core.exception.KException;
import ks.fintech.framework.utils.DateUtils;
import ks.fintech.framework.utils.SpringContextUtil;
import ks.fintech.framework.utils.StringUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class FileUtil {
    static Log log = LogFactory.getLog(FileUtil.class);

    public static File getUniqueFile(File file) {
        if (file.exists()) {
            File parent = file.getParentFile();
            String fullName = file.getName();
            String namePart = FileUtil.removeExtension(fullName);
            String extPart = FileUtil.getFileExt(fullName);
            boolean emptyExt = extPart.isEmpty();
            int i = 1;
            if (!emptyExt) {
                extPart = String.valueOf('.') + extPart;
            }
            do {
                file = emptyExt ? new File(parent, StringUtil.concat(namePart, Integer.toString(i))) : new File(parent, StringUtil.concat(namePart, Integer.toString(i), extPart));
                ++i;
            } while (file.exists());
        }
        return file;
    }

    public static String readString(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (String)"utf-8");
    }

    public static String readContent(File file) throws IOException, KException {
        CacheServiceAware roleCache = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
        String path = Path.getRelativePath(file.getAbsolutePath());
        Long funcId = 0L;
        Map funcMap = roleCache.getFuncMap();
        if (funcMap != null) {
            for (FunctionEObj functionEObj : funcMap.values()) {
                if (!path.equals(functionEObj.getFuncPath())) continue;
                funcId = functionEObj.getFuncId();
                break;
            }
        }
        FunctionContentCacheAware contentCache = (FunctionContentCacheAware)SpringContextUtil.getBean((String)"contentCacheServcie");
        String content = StringUtils.format((Object)("{\"children\":[" + contentCache.getContent(funcId) + "]}"));
        return content;
    }

    public static void writeString(File file, String content) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)content, (String)"utf-8");
    }

    public static void saveStream(InputStream inputStream, File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)os);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    public static String getFileExt(String fileName) {
        int i;
        if (fileName != null && (i = fileName.lastIndexOf(46)) != -1) {
            return fileName.substring(i + 1);
        }
        return "";
    }

    public static String getFileExt(File file) {
        return FileUtil.getFileExt(file.getName());
    }

    public static String getFileType(File file) {
        String type;
        try {
            type = FileSystemView.getFileSystemView().getSystemTypeDescription(file);
        }
        catch (Throwable e) {
            type = null;
        }
        if (StringUtil.isEmpty(type)) {
            return FileUtil.getFileExt(file.getName());
        }
        return type;
    }

    public static String getFilename(String path) {
        if (StringUtil.isEmpty(path)) {
            return "";
        }
        int p = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        if (p == -1) {
            return path;
        }
        return path.substring(p + 1);
    }

    public static String removeExtension(String fileName) {
        String s = FileUtil.getFilename(fileName);
        int i = s.lastIndexOf(46);
        if (i != -1) {
            return s.substring(0, i);
        }
        return s;
    }

    public static String addExtension(String fileName, String extension) {
        if (fileName == null) {
            return null;
        }
        if (fileName.toLowerCase().endsWith("." + extension.toLowerCase())) {
            return fileName;
        }
        return String.valueOf(fileName) + "." + extension;
    }

    public static String getPath(String path) {
        return StringUtil.replaceAll(path, "\\", "/");
    }

    public static String getPath(File file) {
        return FileUtil.getPath(file.getAbsolutePath());
    }

    public static String getRelativePath(File parent, File child) {
        String parentPath;
        if (parent == null) {
            throw new NullPointerException("Parent file is null.");
        }
        if (child == null) {
            throw new NullPointerException("Child file is null.");
        }
        String originChildPath = child.getAbsolutePath();
        String childPath = String.valueOf(originChildPath) + File.separatorChar;
        if (childPath.equals(parentPath = String.valueOf(parent.getAbsolutePath()) + File.separatorChar)) {
            return "";
        }
        if (childPath.startsWith(parentPath)) {
            return FileUtil.getPath(originChildPath.substring(parentPath.length()));
        }
        return null;
    }

    public static String getRelativePath(String parent, String child) {
        String parentPath;
        if (parent == null) {
            throw new NullPointerException("Parent file is null.");
        }
        if (child == null) {
            throw new NullPointerException("Child file is null.");
        }
        String childPath = String.valueOf(child) + File.separatorChar;
        if (childPath.equals(parentPath = String.valueOf(parent) + File.separatorChar)) {
            return "";
        }
        if (childPath.startsWith(parentPath)) {
            return FileUtil.getPath(child.substring(parentPath.length()));
        }
        return null;
    }

    public static boolean isAncestor(File parent, File child) throws IOException {
        return FileUtil.isAncestor(parent, child, true);
    }

    public static boolean isAncestor(File parent, File child, boolean includeSelf) throws IOException {
        String parentPath = parent.getCanonicalPath();
        String childPath = child.getCanonicalPath();
        if (!parentPath.endsWith(String.valueOf(File.separatorChar))) {
            parentPath = String.valueOf(parentPath) + File.separatorChar;
        }
        if (!childPath.endsWith(String.valueOf(File.separatorChar))) {
            childPath = String.valueOf(childPath) + File.separatorChar;
        }
        return childPath.startsWith(parentPath) && (includeSelf || childPath.length() > parentPath.length());
    }

    public static boolean isEmpty(File folder) {
        String[] fs;
        return folder == null || (fs = folder.list()) == null || fs.length == 0;
    }

    public static boolean hasFolder(File folder) {
        File[] fs;
        if (folder != null && (fs = folder.listFiles()) != null && fs.length > 0) {
            File[] fileArray = fs;
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean checkLastModified(File file, Date lastModified) {
        if (file.isDirectory()) {
            File[] fs;
            File[] fileArray = fs = file.listFiles();
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (FileUtil.checkLastModified(f, lastModified)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return file.lastModified() >= lastModified.getTime();
    }

    public static File[] listFiles(File file) {
        if (!file.exists()) {
            throw new RuntimeException("\"" + file.getName() + "\" does not exist.");
        }
        File[] fs = file.listFiles();
        if (fs == null) {
            return new File[0];
        }
        return fs;
    }

    public static Object[] syncCopy(File src, File dst) throws IOException {
        String name = src.getName();
        dst = new File(dst, name);
        File syncDst = FileUtil.getSyncPath(dst);
        boolean isDir = src.isDirectory();
        boolean sameParent = src.getParentFile().equals(dst.getParentFile());
        if (sameParent) {
            dst = FileUtil.getUniqueFile(dst);
        }
        boolean dstExists = dst.exists();
        if (isDir) {
            FileUtils.copyDirectory((File)src, (File)dst);
        } else {
            FileUtils.copyFile((File)src, (File)dst);
        }
        if (syncDst != null) {
            if (sameParent) {
                syncDst = FileUtil.getUniqueFile(syncDst);
            }
            if (isDir) {
                FileUtils.copyDirectory((File)src, (File)syncDst);
            } else {
                FileUtils.copyFile((File)src, (File)syncDst);
            }
        }
        Object[] result = new Object[]{FileUtil.getPath(dst), dstExists};
        return result;
    }

    public static void syncCopyA(File src, File dst) throws IOException {
        boolean isDir = src.isDirectory();
        if (isDir) {
            FileUtils.copyDirectory((File)src, (File)dst);
        } else {
            FileUtils.copyFile((File)src, (File)dst);
        }
        File syncPath = FileUtil.getSyncPath(dst);
        if (syncPath != null) {
            if (isDir) {
                FileUtils.copyDirectory((File)src, (File)syncPath);
            } else {
                FileUtils.copyFile((File)src, (File)syncPath);
            }
        }
    }

    public static void syncCreate(File file, boolean isDir) throws IOException {
        String name = file.getName();
        File syncPath = FileUtil.getSyncPath(file);
        if (file.exists()) {
            throw new IllegalArgumentException("\"" + name + "\" already exists.");
        }
        if (syncPath != null && syncPath.exists()) {
            throw new IllegalArgumentException("\"" + syncPath.getAbsolutePath() + "\" already exists.");
        }
        if (isDir) {
            if (syncPath != null && !FileUtil.createFolder(syncPath)) {
                throw new IOException("Create \"" + syncPath.getAbsolutePath() + "\" failure.");
            }
            if (!file.mkdir()) {
                throw new IOException("Create \"" + name + "\" failure.");
            }
        } else {
            if (syncPath != null && !FileUtil.createFile(syncPath)) {
                throw new IOException("Create \"" + syncPath.getAbsolutePath() + "\" failure.");
            }
            if (!file.createNewFile()) {
                throw new IOException("Create \"" + name + "\" failure.");
            }
        }
        if (syncPath != null) {
            syncPath.setLastModified(file.lastModified());
        }
    }

    public static void syncDelete(File file, boolean clearUrl) throws Exception {
        if (!FileUtils.deleteQuietly((File)file)) {
            throw new IOException("Cannot delete \"" + file.getName() + "\".");
        }
        File syncPath = FileUtil.getSyncPath(file);
        if (syncPath != null && !FileUtils.deleteQuietly((File)syncPath)) {
            throw new IOException("Cannot delete \"" + syncPath.toString() + "\".");
        }
        FileUtil.clearFiles(file, clearUrl);
    }

    public static void syncMove(File src, File dst) throws Exception {
        File syncDst = FileUtil.getSyncPath(dst);
        FileUtils.moveToDirectory((File)src, (File)dst, (boolean)true);
        if (syncDst != null) {
            try {
                File syncSrc = FileUtil.getSyncPath(src);
                if (syncSrc == null) {
                    if (syncDst.isDirectory()) {
                        FileUtils.copyDirectory((File)dst, (File)syncDst);
                    } else {
                        FileUtils.copyFile((File)dst, (File)syncDst);
                    }
                } else {
                    FileUtils.moveToDirectory((File)syncSrc, (File)syncDst, (boolean)true);
                }
            }
            catch (Throwable e) {
                log.error((Object)"", e);
            }
        }
        FileUtil.clearFiles(src, false);
    }

    public static void syncRename(File file, File newFile) throws IOException {
        File syncPath = FileUtil.getSyncPath(file);
        if (!file.renameTo(newFile)) {
            throw new IOException("Cannot rename \"" + file.getName() + "\".");
        }
        if (syncPath != null && !syncPath.renameTo(FileUtil.getSyncPath(newFile))) {
            throw new IOException("Cannot rename \"" + syncPath.toString() + "\".");
        }
    }

    public static void syncSave(File file, byte[] content) throws Exception {
        FileUtils.writeByteArrayToFile((File)file, (byte[])content);
        File syncPath = FileUtil.getSyncPath(file);
        if (syncPath != null) {
            FileUtils.copyFile((File)file, (File)syncPath);
        }
    }

    public static void syncSave(File file, String content) throws Exception {
        FileUtil.syncSave(file, content, "utf-8", false);
    }

    public static void syncSave(File file, String content, String charset) throws Exception {
        FileUtil.syncSave(file, content, charset, false);
    }

    public static void syncSave(File file, String content, String charset, boolean keepLastModified) throws Exception {
        String relPath;
        File syncPath;
        long lastModified;
        long l = lastModified = keepLastModified ? file.lastModified() : 0L;
        if (StringUtil.isEmpty(charset)) {
            FileUtils.writeStringToFile((File)file, (String)content);
        } else {
            FileUtils.writeStringToFile((File)file, (String)content, (String)charset);
        }
        if (keepLastModified) {
            file.setLastModified(lastModified);
        }
        if ((syncPath = FileUtil.getSyncPath(file)) != null) {
            FileUtils.copyFile((File)file, (File)syncPath);
            if (keepLastModified) {
                syncPath.setLastModified(lastModified);
            }
        }
        if ((relPath = FileUtil.getModulePath(file)) != null) {
            XwlBuffer.clear(relPath);
        }
    }

    public static File getSyncPath(File path) throws IOException {
        if (!Var.syncPath.isEmpty() && FileUtil.isAncestor(Base.path, path)) {
            File base = new File(Var.syncPath);
            return new File(base, FileUtil.getPath(path).substring(Base.pathLen));
        }
        return null;
    }

    private static void clearFiles(File file, boolean clearUrl) throws Exception {
        String relPath;
        JSONObject object;
        JSONArray index;
        File folder = file.getParentFile();
        File configFile = new File(folder, "folder.json");
        if (configFile.exists() && (index = (object = JsonUtil.readObject(configFile)).optJSONArray("index")) != null) {
            int j = index.length();
            int i = j - 1;
            while (i >= 0) {
                File indexFile = new File(folder, index.getString(i));
                if (!indexFile.exists()) {
                    index.remove(i);
                }
                --i;
            }
            FileUtil.syncSave(configFile, object.toString());
        }
        if ((relPath = FileUtil.getModulePath(file)) != null) {
            XwlBuffer.clear(relPath);
            if (clearUrl && UrlBuffer.remove(relPath)) {
                UrlBuffer.save();
            }
        }
    }

    public static String getModulePath(File file) {
        String path = FileUtil.getPath(file);
        if (path.startsWith(Base.modulePathText)) {
            return path.substring(Base.modulePathLen);
        }
        return null;
    }

    public static String getModuleFile(String url) {
        return FileUtil.getModuleFile(url, false);
    }

    public static String getModuleFile(String url, boolean silent) {
        if (url == null) {
            if (silent) {
                return null;
            }
            throw new NullPointerException("The requested url is not specified.");
        }
        if (url.startsWith("m?xwl=")) {
            return String.valueOf(url.substring(6)) + ".xwl";
        }
        if (url.endsWith(".xwl")) {
            return url;
        }
        String shortcut = url;
        if ((url = UrlBuffer.get("/" + shortcut)) == null) {
            if (silent) {
                return null;
            }
            throw new NullPointerException("The requested url shortcut \"" + shortcut + "\" is not found.");
        }
        return url;
    }

    public static String getIconPath(String iconCls, String theme) {
        int len = iconCls.length() - 5;
        if (theme == null) {
            theme = Var.defaultTheme;
        }
        if (len > 0) {
            return StringUtil.concat("wb/images/", theme, "/", iconCls.substring(0, iconCls.length() - 5), ".png");
        }
        return null;
    }

    public static void checkProctected(HttpServletRequest request, File file, boolean containModule) throws IOException {
        if (!FileUtil.isAncestor(Base.path, file) || FileUtil.isAncestor(new File(Base.path, "wb/system"), file) || FileUtil.isAncestor(new File(Base.path, "META-INF"), file) || FileUtil.isAncestor(new File(Base.path, "WEB-INF"), file) || containModule && FileUtil.isAncestor(new File(Base.path, "wb/modules"), file)) {
            SysUtil.accessDenied(request);
        }
    }

    public static boolean createFolder(File folderFile) {
        if (folderFile.exists()) {
            return true;
        }
        if (folderFile.getParentFile().exists()) {
            return folderFile.mkdir();
        }
        if (FileUtil.createFolder(folderFile.getParentFile())) {
            return folderFile.mkdir();
        }
        return false;
    }

    public static boolean createFile(File file) throws IOException {
        File parent = file.getParentFile();
        if (FileUtil.createFolder(parent)) {
            return file.createNewFile();
        }
        return false;
    }

    public static void createMkdirs(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static void copyFileOrDir(String srcPath, String copyPath) throws IOException {
        File srcFile = new File(srcPath);
        String srcName = srcFile.getName();
        File dstFile = new File(String.valueOf(copyPath) + File.separator + srcName);
        boolean isDir = srcFile.isDirectory();
        if (isDir) {
            FileUtils.copyDirectory((File)srcFile, (File)dstFile);
        } else {
            FileUtils.copyFile((File)srcFile, (File)dstFile);
        }
    }

    public static void checkProctectedPath(HttpServletRequest request, String filePath, boolean containModule) throws IOException {
        if (!FileUtil.isAncestorPath("" + Base.path, filePath) || FileUtil.isAncestorPath(Base.path + "wb/system", filePath) || FileUtil.isAncestorPath(Base.path + "META-INF", filePath) || FileUtil.isAncestorPath(Base.path + "WEB-INF", filePath) || containModule && FileUtil.isAncestorPath(Base.path + "wb/modules", filePath)) {
            SysUtil.accessDenied(request);
        }
    }

    public static boolean isAncestorPath(String parentPath, String childPath) throws IOException {
        return FileUtil.isAncestorPath(parentPath, childPath, true);
    }

    public static boolean isAncestorPath(String parentPath, String childPath, boolean includeSelf) throws IOException {
        if (!parentPath.endsWith(String.valueOf(File.separatorChar))) {
            parentPath = String.valueOf(parentPath) + File.separatorChar;
        }
        if (!childPath.endsWith(String.valueOf(File.separatorChar))) {
            childPath = String.valueOf(childPath) + File.separatorChar;
        }
        return childPath.startsWith(parentPath) && (includeSelf || childPath.length() > parentPath.length());
    }

    public static String obtainParent(String firstPath) {
        String parentName = "";
        parentName = firstPath.substring(firstPath.lastIndexOf(File.separator, firstPath.lastIndexOf(File.separator) - 1) + 1, firstPath.lastIndexOf(File.separator));
        return parentName;
    }

    public static String replacePath(String input) {
        while (input.indexOf("/") > 0) {
            input = StringUtils.replace((String)input, (String)"/", (String)"\\");
        }
        while (input.indexOf("//") > 0) {
            input = StringUtils.replace((String)input, (String)"//", (String)"\\");
        }
        return input;
    }

    public static Boolean checkLastModified(Date lastModified, Timestamp lastTimes) {
        Date lastDate;
        boolean flag = false;
        if (lastModified != null && lastTimes != null && (lastDate = DateUtils.parse((String)DateUtils.formatISODatetime((Timestamp)lastTimes), (String)"yyyy-MM-dd")).getTime() >= lastModified.getTime()) {
            flag = true;
        }
        return flag;
    }

    public static boolean isContainXwlFile(File file) {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles(file);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                FileUtil.isContainXwlFile(f);
            } else if (!f.getName().equals("folder.json") && !FileUtil.getFileExt(f).equals("xwl")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static ByteArrayOutputStream cloneInputStream(InputStream input) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = input.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            return baos;
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        String path = "c://xwl/dd/cc/aa.xwl";
        System.out.println(FileUtil.createFile(new File(path)));
        path = "c://xwl/gg/cc/xx";
        System.out.println(FileUtil.createFolder(new File(path)));
        path = "x://xwl/dd/cc/aa.xwl";
        System.out.println(FileUtil.createFile(new File(path)));
    }
}

