/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.SysConfigOperator;
import com.wb.common.Var;
import com.wb.tool.VarChangeObserver;
import com.wb.tool.WebVarConstant;
import com.wb.util.WhitesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ks.fintech.framework.core.exception.KException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class WebVarOpt {
    private static Log log = LogFactory.getLog(WebVarOpt.class);
    private static List<VarChangeObserver> observerList = new ArrayList<VarChangeObserver>();
    private static boolean modify = false;

    public static synchronized void attach(VarChangeObserver varChangeObserver) {
        observerList.add(varChangeObserver);
    }

    private static void notifyAllObservers() throws KException {
        if (modify) {
            for (VarChangeObserver varChangeObserver : observerList) {
                varChangeObserver.update();
            }
        }
    }

    public static synchronized void load() {
        try {
            WebVarOpt.notifyAllObservers();
        }
        catch (Exception e) {
            log.error((Object)"notifyAllObservers error", (Throwable)e);
        }
    }

    public static synchronized void webInfo2VarConfig() {
        try {
            try {
                String webFilePath = SysConfigOperator.getRelFilePath(WebVarConstant.WEB_FILE_PATH);
                Map<String, Map<String, String>> filterInfoMap = WhitesUtil.getFilterInfoMap(webFilePath);
                WebVarOpt.compareAndWriterVar(filterInfoMap);
                modify = true;
            }
            catch (Exception e) {
                log.error((Object)"webInfo2VarConfig error", (Throwable)e);
                WebVarOpt.load();
            }
        }
        finally {
            WebVarOpt.load();
        }
    }

    private static void compareAndWriterVar(Map<String, Map<String, String>> filterInfoMap) {
        Set<String> filterKeySet = WhitesUtil.getFilterKeySet("sys.whitesFilters", filterInfoMap);
        if (filterKeySet != null && !WhitesUtil.isExistFilterKey(filterKeySet)) {
            JSONObject filters = new JSONObject();
            JSONObject perFilter = new JSONObject();
            for (Map.Entry<String, Map<String, String>> entry : filterInfoMap.entrySet()) {
                String filterName = entry.getKey();
                Map<String, String> paramMap = entry.getValue();
                perFilter = WhitesUtil.getPerFilterJson(filterName, paramMap);
                filters.put(filterName, (Object)perFilter);
            }
            Var.add("sys", "whitesFilters", filters);
        }
    }
}

