/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.ScriptBuffer;
import com.wb.common.Var;
import com.wb.task.ScriptProxy;
import com.wb.util.DbUtil;
import com.wb.util.StringUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;

public class TaskManager {
    private static Log log = LogFactory.getLog(TaskManager.class);
    public static Scheduler scheduler;

    public static void loadTask(String taskId, String taskName, int intervalType, String intervalExpress, String className, String serverScript, Date beginDate, Date endDate) throws Exception {
        JobDetail job;
        String cronStr = null;
        TaskManager.deleteTask(taskId);
        if (StringUtil.isEmpty(className)) {
            job = JobBuilder.newJob(ScriptProxy.class).withIdentity(taskId, "DEFAULT").withDescription(taskName).build();
            JobDataMap dataMap = job.getJobDataMap();
            dataMap.put("job.id", "job." + taskId);
            dataMap.put("job.serverScript", serverScript);
        } else {
            job = JobBuilder.newJob(Class.forName(className)).withIdentity(taskId, "DEFAULT").withDescription(taskName).build();
        }
        String[] express = StringUtil.split(intervalExpress, ":");
        switch (intervalType) {
            case 0: {
                cronStr = String.format("0/%d * * * * ?", Integer.parseInt(express[0]));
                break;
            }
            case 1: {
                cronStr = String.format("0 0/%d * * * ?", Integer.parseInt(express[0]));
                break;
            }
            case 2: {
                cronStr = String.format("0 0 0/%d * * ?", Integer.parseInt(express[0]));
                break;
            }
            case 3: {
                cronStr = String.format("0 %d %d ? * *", Integer.parseInt(express[1]), Integer.parseInt(express[0]));
                break;
            }
            case 4: {
                cronStr = String.format("0 %d %d ? * %d", Integer.parseInt(express[2]), Integer.parseInt(express[1]), Integer.parseInt(express[0]));
                break;
            }
            case 5: {
                cronStr = Integer.parseInt(express[0]) != -1 ? String.format("0 %d %d %d * ?", Integer.parseInt(express[2]), Integer.parseInt(express[1]), Integer.parseInt(express[0])) : String.format("0 %d %d L * ?", Integer.parseInt(express[2]), Integer.parseInt(express[1]));
            }
        }
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
        triggerBuilder.withIdentity(taskId, "DEFAULT");
        triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule(cronStr));
        if (beginDate != null) {
            triggerBuilder.startAt(beginDate);
        }
        if (endDate != null) {
            triggerBuilder.endAt(endDate);
        }
        CronTrigger cronTrigger = (CronTrigger)triggerBuilder.build();
        if (scheduler != null) {
            scheduler.scheduleJob(job, (Trigger)cronTrigger);
        }
    }

    public static void deleteTask(String taskId) throws Exception {
        if (scheduler != null && scheduler.getJobDetail(JobKey.jobKey((String)taskId, (String)"DEFAULT")) != null) {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)taskId, (String)"DEFAULT");
            scheduler.pauseTrigger(triggerKey);
            scheduler.unscheduleJob(triggerKey);
            scheduler.deleteJob(JobKey.jobKey((String)taskId, (String)"DEFAULT"));
        }
        ScriptBuffer.remove("job." + taskId);
    }

    public static synchronized void start() throws Exception {
        if (!Var.getBool("sys.task.enabled")) {
            return;
        }
        if (scheduler == null) {
            StdSchedulerFactory factory = new StdSchedulerFactory();
            Properties props = new Properties();
            props.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
            props.put("org.quartz.threadPool.threadCount", Var.getString("sys.task.threadCount"));
            factory.initialize(props);
            scheduler = factory.getScheduler();
            scheduler.start();
        } else if (scheduler.isStarted()) {
            return;
        }
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = DbUtil.getConnection();
            st = conn.createStatement();
            rs = st.executeQuery("select * from WB_TASK");
            while (rs.next()) {
                if (rs.getInt("STATUS") == 0) continue;
                String className = rs.getString("CLASS_NAME");
                if (className != null && !"".equals(className)) {
                    try {
                        Class<?> clazz = Class.forName(className);
                    }
                    catch (Exception e) {
                        log.error((Object)("\u5f53\u524d\u6846\u67b6\u6ca1\u6709" + className + "\u5bf9\u5e94\u7684\u8ba1\u5212\u4efb\u52a1\u5904\u7406\u7c7b"), (Throwable)e);
                        continue;
                    }
                }
                TaskManager.loadTask(rs.getString("TASK_ID"), rs.getString("TASK_NAME"), rs.getInt("INTERVAL_TYPE"), rs.getString("INTERVAL_EXPRESS"), rs.getString("CLASS_NAME"), (String)DbUtil.getObject(rs, "SERVER_SCRIPT", 2011), rs.getTimestamp("BEGIN_DATE"), rs.getTimestamp("END_DATE"));
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(st);
        DbUtil.close(conn);
    }

    public static synchronized void stop() throws Exception {
        if (!Var.getBool("sys.task.enabled")) {
            return;
        }
        if (scheduler == null || scheduler.isShutdown()) {
            return;
        }
        scheduler.shutdown();
        scheduler = null;
        Thread.sleep(Var.getInt("sys.task.stopDelay"));
    }

    public static synchronized void triggerJob(String taskId) throws Exception {
        JobKey jobKey;
        if (scheduler != null && scheduler.getJobDetail(jobKey = JobKey.jobKey((String)taskId, (String)"DEFAULT")) != null) {
            scheduler.triggerJob(jobKey);
        }
    }
}

