/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.Var;
import com.wb.util.StringUtil;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnUtil {
    private static String workspace;
    private static String USERNAME;
    private static String PASSWORD;
    private static String SVNROOT;
    private static String SVNFOLDER;
    private static String COMMITMESSAGE;
    private static String WB_XWL;
    private static Log logger;

    static {
        COMMITMESSAGE = "autoMessage";
        WB_XWL = "/wb/xwl";
        logger = LogFactory.getLog(SvnUtil.class);
    }

    public static void submitSvn(String fileName, String path, int isFirst) {
        USERNAME = Var.getString("sys.app.svnUserName");
        PASSWORD = Var.getString("sys.app.svnPassWord");
        SVNROOT = Var.getString("sys.app.svnUrl");
        SVNFOLDER = Var.getString("sys.app.svnFolder");
        if (path != null) {
            workspace = path.substring(0, path.indexOf(WB_XWL) + WB_XWL.length());
        }
        if (isFirst == 1) {
            SvnUtil.checkWorkCopy(SVNROOT, SVNFOLDER);
        } else {
            SvnUtil.commitProjectToSvn(path);
        }
    }

    public static boolean commitProjectToSvn(String path0) {
        SVNClientManager clientManager = SvnUtil.authSvn(SVNROOT, USERNAME, PASSWORD);
        File wc_project = new File(path0);
        SvnUtil.checkVersiondDirectory(clientManager, wc_project);
        SVNCommitInfo commitResult = SvnUtil.commit(clientManager, wc_project, false, COMMITMESSAGE);
        if (commitResult == null) {
            String path = StringUtil.replaceAll(wc_project.getAbsolutePath(), "\\", "/");
            String basePath = path.substring(0, path.indexOf(WB_XWL) + WB_XWL.length());
            String tempPath = path.substring(path.indexOf(WB_XWL) + WB_XWL.length() + 1);
            String[] e = tempPath.split("/");
            StringBuffer buffer = new StringBuffer();
            buffer.append(basePath);
            String[] stringArray = e;
            int n = e.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                buffer.append("/" + string);
                File tempFile = new File(buffer.toString());
                SvnUtil.commit(clientManager, tempFile, false, COMMITMESSAGE);
                ++n2;
            }
        }
        return true;
    }

    private static void checkVersiondDirectory(SVNClientManager clientManager, File wc) {
        if (!SVNWCUtil.isVersionedDirectory((File)wc)) {
            SvnUtil.addEntry(clientManager, wc);
        }
        if (wc.isDirectory()) {
            File[] fileArray = wc.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File sub = fileArray[n2];
                if (!sub.isDirectory() || !sub.getName().equals(".svn")) {
                    SvnUtil.checkVersiondDirectory(clientManager, sub);
                }
                ++n2;
            }
        }
    }

    private static void checkWorkCopy(String svnRoot, String foldName) {
        SVNClientManager clientManager = SvnUtil.authSvn(svnRoot, USERNAME, PASSWORD);
        SVNURL repositoryURL = null;
        try {
            repositoryURL = SVNURL.parseURIEncoded((String)svnRoot);
        }
        catch (SVNException e) {
            logger.error((Object)e);
        }
        File wc = new File(workspace);
        File wc_project = new File(workspace);
        SVNURL projectURL = null;
        try {
            projectURL = repositoryURL.appendPath(foldName, false);
        }
        catch (SVNException e) {
            logger.error((Object)e);
        }
        if (!SvnUtil.isWorkingCopy(wc)) {
            if (!SvnUtil.isURLExist(projectURL, USERNAME, PASSWORD)) {
                SvnUtil.checkout(clientManager, repositoryURL, SVNRevision.HEAD, wc, SVNDepth.EMPTY);
            } else {
                SvnUtil.checkout(clientManager, projectURL, SVNRevision.HEAD, wc_project, SVNDepth.INFINITY);
            }
            SvnUtil.update(clientManager, wc, SVNRevision.HEAD, SVNDepth.INFINITY);
        } else {
            SvnUtil.update(clientManager, wc, SVNRevision.HEAD, SVNDepth.INFINITY);
        }
    }

    public static void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    public static SVNClientManager authSvn(String svnRoot, String username, String password) {
        SvnUtil.setupLibrary();
        SVNRepository repository = null;
        try {
            repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)svnRoot));
        }
        catch (SVNException e) {
            logger.error((Object)e);
            return null;
        }
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
        repository.setAuthenticationManager(authManager);
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        SVNClientManager clientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authManager);
        return clientManager;
    }

    public static SVNCommitInfo makeDirectory(SVNClientManager clientManager, SVNURL url, String COMMITMESSAGE) {
        try {
            return clientManager.getCommitClient().doMkDir(new SVNURL[]{url}, COMMITMESSAGE);
        }
        catch (SVNException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static SVNCommitInfo importDirectory(SVNClientManager clientManager, File localPath, SVNURL dstURL, String COMMITMESSAGE, boolean isRecursive) {
        try {
            return clientManager.getCommitClient().doImport(localPath, dstURL, COMMITMESSAGE, null, true, true, SVNDepth.fromRecurse((boolean)isRecursive));
        }
        catch (SVNException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static void addEntry(SVNClientManager clientManager, File wcPath) {
        try {
            clientManager.getWCClient().doAdd(new File[]{wcPath}, true, false, false, SVNDepth.INFINITY, false, false, true);
        }
        catch (SVNException e) {
            logger.error((Object)e);
        }
    }

    public static SVNStatus showStatus(SVNClientManager clientManager, File wcPath, boolean remote) {
        SVNStatus status = null;
        try {
            status = clientManager.getStatusClient().doStatus(wcPath, remote);
        }
        catch (SVNException e) {
            logger.error((Object)e);
        }
        return status;
    }

    public static SVNCommitInfo commit(SVNClientManager clientManager, File wcPath, boolean keepLocks, String COMMITMESSAGE) {
        try {
            return clientManager.getCommitClient().doCommit(new File[]{wcPath}, keepLocks, COMMITMESSAGE, null, null, false, false, SVNDepth.INFINITY);
        }
        catch (SVNException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static long update(SVNClientManager clientManager, File wcPath, SVNRevision updateToRevision, SVNDepth depth) {
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        try {
            return updateClient.doUpdate(wcPath, updateToRevision, depth, false, false);
        }
        catch (SVNException e) {
            logger.error((Object)e);
            return 0L;
        }
    }

    public static long checkout(SVNClientManager clientManager, SVNURL url, SVNRevision revision, File destPath, SVNDepth depth) {
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        try {
            return updateClient.doCheckout(url, destPath, revision, revision, depth, false);
        }
        catch (SVNException e) {
            logger.error((Object)e);
            return 0L;
        }
    }

    public static boolean isWorkingCopy(File path) {
        if (!path.exists()) {
            logger.warn((Object)("'" + path + "' not exist!"));
            return false;
        }
        try {
            if (SVNWCUtil.getWorkingCopyRoot((File)path, (boolean)false) == null) {
                return false;
            }
        }
        catch (SVNException e) {
            logger.error((Object)e);
        }
        return true;
    }

    public static boolean isURLExist(SVNURL url, String username, String password) {
        try {
            SVNRepository svnRepository = SVNRepositoryFactory.create((SVNURL)url);
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
            svnRepository.setAuthenticationManager(authManager);
            SVNNodeKind nodeKind = svnRepository.checkPath("", -1L);
            return nodeKind != SVNNodeKind.NONE;
        }
        catch (SVNException e) {
            logger.error((Object)e);
            return false;
        }
    }
}

