/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.Var;
import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import ks.fintech.framework.excel.POIExcelUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class ScriptCompressor {
    public static Log log = LogFactory.getLog(POIExcelUtils.class);

    public static synchronized void compressJs(File oldFile, File newFile, boolean lineBreak) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(oldFile), "utf-8"));
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), "utf-8"));
        final String filename = oldFile.getName();
        try {
            JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)in, new ErrorReporter(){

                public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                    if (Var.printError) {
                        System.err.println("WARNING in compress " + filename);
                        if (line < 0) {
                            System.err.println("  " + message);
                        } else {
                            System.err.println("  " + line + ':' + lineOffset + ':' + message);
                        }
                    }
                }

                public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                    if (Var.printError) {
                        System.err.println("ERROR in compress " + filename);
                        if (line < 0) {
                            System.err.println("  " + message);
                        } else {
                            System.err.println("  " + line + ':' + lineOffset + ':' + message);
                        }
                    }
                }

                public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                    this.error(message, sourceName, line, lineSource, lineOffset);
                    return new EvaluatorException(message);
                }
            });
            ScriptCompressor.compress(compressor, out, null, lineBreak);
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
            IOUtils.closeQuietly((Writer)out);
        }
    }

    public static void compress(JavaScriptCompressor compressor, Writer out, Writer mungemap, boolean lineBreak) {
        int lb = lineBreak ? 0 : -1;
        try {
            Method m = compressor.getClass().getMethod("compress", Writer.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            m.invoke((Object)compressor, out, lb, true, false, lineBreak, false);
        }
        catch (NoSuchMethodException en) {
            try {
                Method m = compressor.getClass().getMethod("compress", Writer.class, Writer.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                Object[] objectArray = new Object[7];
                objectArray[0] = out;
                objectArray[2] = lb;
                objectArray[3] = true;
                objectArray[4] = false;
                objectArray[5] = lineBreak;
                objectArray[6] = false;
                m.invoke((Object)compressor, objectArray);
                log.error((Object)"", (Throwable)en);
            }
            catch (NoSuchMethodException es) {
                try {
                    Method m = compressor.getClass().getMethod("compressor", Writer.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                    m.invoke((Object)compressor, out, lb, true, false, lineBreak, false);
                }
                catch (NoSuchMethodException eee) {
                    try {
                        Method m = compressor.getClass().getMethod("compressor", Writer.class, Writer.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                        Object[] objectArray = new Object[7];
                        objectArray[0] = out;
                        objectArray[2] = lb;
                        objectArray[3] = true;
                        objectArray[4] = false;
                        objectArray[5] = lineBreak;
                        objectArray[6] = false;
                        m.invoke((Object)compressor, objectArray);
                    }
                    catch (Exception e) {
                        log.error((Object)"", (Throwable)e);
                    }
                    log.error((Object)"", (Throwable)eee);
                }
                catch (Exception ee) {
                    log.error((Object)"", (Throwable)ee);
                }
                log.error((Object)"", (Throwable)es);
            }
            catch (Exception ee) {
                log.error((Object)"", (Throwable)ee);
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public static synchronized void compressCss(File oldFile, File newFile) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(oldFile), "utf-8"));
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), "utf-8"));
        try {
            CssCompressor compressor = new CssCompressor((Reader)in);
            compressor.compress((Writer)out, -1);
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
            IOUtils.closeQuietly((Writer)out);
        }
    }
}

