/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Map;
import ks.fintech.framework.core.exception.KException;
import ks.fintech.framework.sql.DbUtils;
import ks.fintech.framework.sql.HolderConnSqlExecutorXh;
import ks.fintech.framework.utils.PropKit;
import ks.fintech.framework.utils.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExcuteQuerySql {
    private static Log log = LogFactory.getLog(ExcuteQuerySql.class);

    public static Map<String, Object> excuteSql(String schema, String sql) throws KException {
        return ExcuteQuerySql.execQuery(schema, sql);
    }

    public static Connection getCon(String schema) throws KException {
        Map<String, String> proMap = ExcuteQuerySql.getProMap(schema);
        Connection conn = null;
        try {
            Class.forName(proMap.get("driverClassName"));
            conn = DriverManager.getConnection(proMap.get("url"), proMap.get("username"), proMap.get("password"));
        }
        catch (Exception e) {
            log.error((Object)"getConnection is Error", (Throwable)e);
            throw new KException((Throwable)e);
        }
        return conn;
    }

    public static Map<String, Object> execQuery(String schema, String sql) throws KException {
        Connection conn = null;
        try {
            conn = ExcuteQuerySql.getCon(schema);
            HolderConnSqlExecutorXh cq = new HolderConnSqlExecutorXh(conn);
            Map map = cq.queryMapListResult(sql, null);
            return map;
        }
        catch (Exception e) {
            log.error((Object)"excuteQuery Error", (Throwable)e);
            throw new KException((Throwable)e);
        }
        finally {
            DbUtils.closeQuietly((Connection)conn);
        }
    }

    public static Map<String, String> getProMap(String schema) throws KException {
        HashMap<String, String> map = new HashMap<String, String>();
        String url = null;
        String username = null;
        String password = null;
        String driverClassName = null;
        try {
            driverClassName = PropKit.getProperty((String)"dynamicJDBC.driverClassName");
            url = PropKit.getProperty((String)"dynamicJDBC.url");
            username = PropKit.getProperty((String)"dynamicJDBC.username");
            password = PropKit.getProperty((String)"dynamicJDBC.password");
        }
        catch (Exception e) {
            log.error((Object)"getURLProperties is Error", (Throwable)e);
            throw new KException((Throwable)e);
        }
        if (StringUtils.isEmpty((String)driverClassName) || StringUtils.isEmpty((String)url) || StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)password)) {
            log.error((Object)("dynamicJDBC.driverClassName:" + driverClassName + ",dynamicJDBC.url:" + url + ",dynamicJDBC.username:" + username + ",dynamicJDBC.password:" + password));
            throw new KException("getProperteis is Null");
        }
        url = String.valueOf(url) + schema;
        map.put("driverClassName", driverClassName);
        map.put("url", url);
        map.put("username", username);
        map.put("password", password);
        return map;
    }
}

