/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.Var;
import com.wb.controls.ExtCombo;
import com.wb.tool.DataOutput;
import com.wb.tool.ExcelObject;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONObject;

public class ExcelForm {
    public static String getHtmlForReq(HttpServletRequest request, JSONObject params, File excelFile, int sheetIndex, String excelFormAlign) throws Exception {
        if (excelFile.getName().toLowerCase().endsWith(".xls")) {
            throw new IllegalArgumentException("Excel file version requires 2007+");
        }
        try (FileInputStream is = new FileInputStream(excelFile);){
            String string = ExcelForm.getHtmlStreamForReq(request, params, is, sheetIndex, excelFormAlign);
            return string;
        }
    }

    public static String getHtml(JSONObject params, File excelFile, int sheetIndex, String excelFormAlign) throws Exception {
        return ExcelForm.getHtmlForReq(null, params, excelFile, sheetIndex, excelFormAlign);
    }

    public static String getHtml(JSONObject params, InputStream inputStream, int sheetIndex, String excelFormAlign) throws Exception {
        return ExcelForm.getHtmlStreamForReq(null, params, inputStream, sheetIndex, excelFormAlign);
    }

    public static String getHtmlStreamForReq(HttpServletRequest request, JSONObject params, InputStream inputStream, int sheetIndex, String excelFormAlign) throws Exception {
        StringBuilder tableHtml = new StringBuilder();
        StringBuilder rowsHtml = new StringBuilder();
        int maxRows = Var.getInt("sys.service.excel.maxTableRows") - 1;
        int maxCols = Var.getInt("sys.service.excel.maxTableColumns") - 1;
        try (XSSFWorkbook book = new XSSFWorkbook(inputStream);){
            XSSFSheet sheet = book.getSheetAt(sheetIndex);
            DataOutput.dealDynHeader((Workbook)book, (Sheet)sheet, params);
            ExcelObject.executeInstruction((Sheet)sheet, params);
            int maxColumnIndex = ExcelForm.getMaxColumnIndex(sheet);
            int defaultHeight = ExcelForm.getPixcelHeight(sheet.getDefaultRowHeight());
            Object[] mergeRegion = ExcelForm.getMergeRegion(sheet);
            Iterator rows = sheet.rowIterator();
            int lastRow = 0;
            while (rows.hasNext()) {
                XSSFRow row = (XSSFRow)rows.next();
                int rowIndex = row.getRowNum();
                if (rowIndex > maxRows) {
                    throw new IndexOutOfBoundsException("Excel exceeds the maximum allowed rows: Var.sys.service.excel.maxTableRows");
                }
                ExcelForm.fillTR(rowsHtml, lastRow, rowIndex, defaultHeight, maxColumnIndex);
                lastRow = rowIndex + 1;
                Iterator cells = row.cellIterator();
                rowsHtml.append("<tr height=\"");
                rowsHtml.append(ExcelForm.getPixcelHeight(row.getHeight()));
                rowsHtml.append("px\">");
                int lastCol = 0;
                boolean requiredField = false;
                while (cells.hasNext()) {
                    XSSFCell cell = (XSSFCell)cells.next();
                    int columnIndex = cell.getColumnIndex();
                    if (columnIndex > maxCols) {
                        throw new IndexOutOfBoundsException("Excel exceeds the maximum allowed columns: Var.sys.service.excel.maxTableColumns");
                    }
                    int[] spanXY = ExcelForm.getSpanXY(mergeRegion, columnIndex, rowIndex);
                    ExcelForm.fillTD(rowsHtml, lastCol, columnIndex);
                    lastCol = columnIndex + 1;
                    if (spanXY[0] == -1) continue;
                    XSSFCellStyle style = cell.getCellStyle();
                    if (spanXY[0] > 1) {
                        lastCol += spanXY[0];
                    }
                    rowsHtml.append("<td");
                    if (spanXY[0] > 1) {
                        rowsHtml.append(" colspan=\"");
                        rowsHtml.append(spanXY[0]);
                        rowsHtml.append("\"");
                    }
                    if (spanXY[1] > 1) {
                        rowsHtml.append(" rowspan=\"");
                        rowsHtml.append(spanXY[1]);
                        rowsHtml.append("\"");
                    }
                    rowsHtml.append(" style=\"white-space:nowrap;overflow:hidden;");
                    boolean isNumericCell = ExcelObject.isNumericCell((Cell)cell);
                    if (style != null) {
                        rowsHtml.append(ExcelObject.getCellStyle(style, isNumericCell));
                    }
                    rowsHtml.append("\">");
                    String value = ExcelObject.getDisplayText((Cell)cell);
                    if (!isNumericCell) {
                        value = (value = WebUtil.replaceParams(params, value)).startsWith("{") && value.endsWith("}") ? ExcelForm.createExpress(request, value, requiredField) : StringUtil.toHTML(value);
                    }
                    rowsHtml.append(value);
                    rowsHtml.append("</td>");
                    requiredField = value.startsWith("*");
                }
                ExcelForm.fillTD(rowsHtml, lastCol, maxColumnIndex);
                rowsHtml.append("</tr>");
            }
            int tableWidth = 0;
            tableHtml.append("<tr style=\"height:0;\">");
            int i = 0;
            while (i < maxColumnIndex) {
                int columnWidth = ExcelForm.getPixcelWidth(sheet.getColumnWidth(i));
                tableHtml.append("<td style=\"border:none;padding:0;width:");
                tableHtml.append(columnWidth);
                tableHtml.append("px;\"></td>");
                tableWidth += columnWidth;
                ++i;
            }
            tableHtml.append("</tr>");
            String alignHtml = "left".equals(excelFormAlign) ? "margin-left:0;margin-right:auto;" : ("right".equals(excelFormAlign) ? "margin-left:auto;margin-right:0;" : "margin-left:auto;margin-right:auto;");
            tableHtml.insert(0, StringUtil.concat("<div style=\"padding:8px;\"><table style=\"margin-top:0;margin-bottom:0;", alignHtml, "table-layout:fixed;border-collapse:collapse;\" cellspacing=\"0\" cellpadding=\"5\" width=\"", Integer.toString(tableWidth), "px\"></div>"));
            tableHtml.append((CharSequence)rowsHtml);
            tableHtml.append("</table>");
        }
        return tableHtml.toString();
    }

    private static String createExpress(HttpServletRequest request, String value, boolean required) {
        String innerText = value.substring(1, value.length() - 1).trim();
        if (innerText.startsWith("%")) {
            return "##" + innerText.substring(1);
        }
        if (innerText.indexOf(58) == -1) {
            String[] items = StringUtil.split(innerText, ' ');
            StringBuilder script = new StringBuilder();
            if (items[0].startsWith("*")) {
                required = true;
                items[0] = items[0].substring(1);
            } else if (items[0].startsWith("!")) {
                required = false;
                items[0] = items[0].substring(1);
            }
            script.append("##{itemId:\"");
            script.append(items[0]);
            script.append("\"");
            if (required) {
                script.append(",allowBlank:false");
            }
            script.append(",xtype:\"");
            if (items.length > 1) {
                if (items[1].startsWith("%")) {
                    script.append("combobox\",");
                    script.append(ExtCombo.getkeyNameScript(request, items[1].substring(1)));
                    script.append('}');
                } else {
                    script.append(items[1]);
                    if (items.length > 2) {
                        if ("image".equals(items[1])) {
                            script.append("\",src:\"");
                        } else {
                            script.append("\",vtype:\"");
                        }
                        script.append(items[2]);
                    }
                    script.append("\"}");
                }
            } else {
                script.append("textfield");
                script.append("\"}");
            }
            return script.toString();
        }
        return "##" + value;
    }

    private static void fillTD(StringBuilder html, int fromIndex, int toIndex) {
        int i = fromIndex;
        while (i < toIndex) {
            html.append("<td></td>");
            ++i;
        }
    }

    private static void fillTR(StringBuilder html, int fromIndex, int toIndex, int defaultRowHeight, int maxColumnIndex) {
        int i = fromIndex;
        while (i < toIndex) {
            html.append("<tr height=\"");
            html.append(defaultRowHeight);
            html.append("px\"><td colspan=\"");
            html.append(maxColumnIndex);
            html.append("\"></tr>");
            ++i;
        }
    }

    private static int[] getSpanXY(Object[] mergeRegion, int columnIndex, int rowIndex) {
        int[] result = new int[]{-2, -2};
        Object[] objectArray = mergeRegion;
        int n = mergeRegion.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            int[] info = (int[])obj;
            if (columnIndex == info[0] && rowIndex == info[1]) {
                result[0] = info[2] - info[0] + 1;
                result[1] = info[3] - info[1] + 1;
                return result;
            }
            if (columnIndex >= info[0] && columnIndex <= info[2] && rowIndex >= info[1] && rowIndex <= info[3]) {
                result[0] = -1;
                result[1] = -1;
            }
            ++n2;
        }
        return result;
    }

    private static int getMaxColumnIndex(XSSFSheet sheet) {
        int index = 0;
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            XSSFRow row = (XSSFRow)rows.next();
            index = Math.max(index, row.getLastCellNum());
        }
        return index;
    }

    private static int getPixcelWidth(int width) {
        return Math.round((float)width * 0.0281f);
    }

    private static int getPixcelHeight(int height) {
        return Math.round((float)height / 15.12f);
    }

    private static Object[] getMergeRegion(XSSFSheet sheet) {
        int mergeCount = sheet.getNumMergedRegions();
        Object[] mergeRegion = new Object[mergeCount];
        int i = 0;
        while (i < mergeCount) {
            CellRangeAddress rangeAddress = sheet.getMergedRegion(i);
            int[] info = new int[]{rangeAddress.getFirstColumn(), rangeAddress.getFirstRow(), rangeAddress.getLastColumn(), rangeAddress.getLastRow()};
            mergeRegion[i] = info;
            ++i;
        }
        return mergeRegion;
    }
}

