/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.Var;
import com.wb.common.XwlBuffer;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Console {
    static Log log = LogFactory.getLog(Console.class);

    public static void log(HttpServletRequest request, Object object) {
        Console.print(request, object, "log");
    }

    public static void debug(HttpServletRequest request, Object object) {
        Console.print(request, object, "debug");
    }

    public static void info(HttpServletRequest request, Object object) {
        Console.print(request, object, "info");
    }

    public static void warn(HttpServletRequest request, Object object) {
        Console.print(request, object, "warn");
    }

    public static void error(HttpServletRequest request, Object object) {
        Console.print(request, object, "error");
    }

    public static void print(HttpServletRequest request, Object object, String type) {
        Console.print(request, object, type, false);
    }

    public static void print(HttpServletRequest request, Object object, String type, boolean encoded) {
        if (Var.serverConsolePrint) {
            System.out.println(object);
        }
        Console.printToClient(request, object, type, encoded);
    }

    public static void printToClient(HttpServletRequest request, Object object, String type, boolean encoded) {
        if (Var.consolePrint) {
            Console.printToClient(request.getSession(false), object, type, encoded);
        }
    }

    public static void printToClient(HttpSession httpSession, Object object, String type, boolean encoded) {
        if (Var.consolePrint && httpSession != null) {
            try {
                String string = object == null ? "null" : object.toString();
                StringBuilder buf = new StringBuilder(string.length() + 30);
                buf.append("{\"type\":\"");
                buf.append(type);
                buf.append("\",\"msg\":");
                buf.append(StringUtil.quote(string));
                if (encoded) {
                    buf.append(",\"encode\":true");
                }
                buf.append('}');
                if (XwlBuffer.canAccess(httpSession, "ide")) {
                    WebUtil.send(httpSession, "ide.console", (Object)buf);
                }
            }
            catch (Throwable throwable) {
                log.error((Object)"", throwable);
            }
        }
    }
}

