/*
 * Decompiled with CFR 0.152.
 */
package com.wb.thread;

import com.wb.splogic.EcecLogWb;
import com.wb.util.DbUtil;
import com.wb.util.LogUtil;
import com.wb.util.SysUtil;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExecLog
implements Runnable {
    private static Log log = LogFactory.getLog(ExecLog.class);
    private String type;
    private String functionId;
    private String userName;
    private String spName;
    private String title;
    private String url;
    private Map<String, Object> paramValMap;
    private String status;
    private String remark;
    private long execTime;

    public ExecLog(String type, String functionId, String userName, String spName, String title, String url, Map<String, Object> paramValMap, String status, String remark, long execTime) {
        this.type = type;
        this.functionId = functionId;
        this.userName = userName;
        this.spName = spName;
        this.title = title;
        this.url = url;
        this.paramValMap = paramValMap;
        this.status = status;
        this.remark = remark;
        this.execTime = execTime;
    }

    @Override
    public void run() {
        EcecLogWb.recordForSpLogic(this.type, this.functionId, this.userName, this.spName, this.title, this.url, this.paramValMap, this.status, this.remark, this.execTime);
    }

    public void recordForSp(String type, String functionId, String userName, String spName, String title, String url, Map<String, Object> paramValMap, String status, String remark, long execTime) {
        block7: {
            Connection conn = null;
            CallableStatement cst = null;
            StringBuffer sb = new StringBuffer();
            try {
                try {
                    conn = DbUtil.getConnection();
                    cst = conn.prepareCall("{call P_ECEC_LOG_WB(?,?,?,?,?,?,?,?,?,?,?,?)}");
                    String mapString = this.transMapToString(paramValMap);
                    sb.append(type).append(",").append(functionId).append(",").append(userName).append(",").append(spName).append(",").append(title).append(",").append(url).append(",").append(mapString).append(",").append(status).append(",").append(remark).append(",").append(execTime);
                    log.debug((Object)sb.toString());
                    cst.setString(1, SysUtil.getId());
                    cst.setString(2, userName);
                    cst.setString(3, functionId);
                    if ("call".equals(type)) {
                        cst.setString(4, "PROCEDURE");
                    } else {
                        cst.setString(4, "TABLE");
                    }
                    cst.setString(5, spName);
                    cst.setString(6, mapString);
                    cst.setString(7, status);
                    cst.setString(8, url);
                    cst.setString(9, remark);
                    cst.setLong(10, execTime);
                    cst.registerOutParameter(11, 12);
                    cst.registerOutParameter(12, 4);
                    cst.execute();
                }
                catch (Throwable e) {
                    log.error((Object)"", e);
                    LogUtil.error(e.getMessage());
                    DbUtil.close(cst);
                    DbUtil.close(conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(cst);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(cst);
            DbUtil.close(conn);
        }
    }

    public String transMapToString(Map<String, Object> map) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append(entry.getKey()).append(":").append(ObjectUtils.toString((Object)entry.getValue(), (String)"")).append(";");
        }
        return sb.toString();
    }
}

