/*
 * Decompiled with CFR 0.152.
 */
package com.wb.task;

import com.wb.common.ScriptBuffer;
import com.wb.common.Var;
import com.wb.util.DateUtil;
import com.wb.util.LogUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ScriptProxy
implements Job {
    public void execute(JobExecutionContext context) throws JobExecutionException {
        block6: {
            long start = System.currentTimeMillis();
            String jobDesc = context.getJobDetail().getDescription();
            try {
                JobDataMap dataMap;
                String serverScript;
                if (Var.taskLog) {
                    LogUtil.info("Start job " + jobDesc);
                }
                if (!StringUtil.isEmpty(serverScript = (dataMap = context.getJobDetail().getJobDataMap()).getString("job.serverScript"))) {
                    ScriptBuffer.run(dataMap.getString("job.id"), serverScript, context);
                }
                if (Var.taskLog) {
                    LogUtil.info(StringUtil.concat("Finish job ", jobDesc, " in ", DateUtil.format(System.currentTimeMillis() - start)));
                }
            }
            catch (Throwable e) {
                if (Var.taskLog) {
                    LogUtil.error(StringUtil.concat("Execute job ", jobDesc, " failed with error ", SysUtil.getRootError(e), " in ", DateUtil.format(System.currentTimeMillis() - start)));
                }
                if (!Var.printError) break block6;
                throw new RuntimeException(e);
            }
        }
    }
}

