/*
 * Decompiled with CFR 0.152.
 */
package com.wb.splogic.util;

import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPUtils {
    private static final Logger logger = LoggerFactory.getLogger(SPUtils.class);

    public static String lineToHump(String str) {
        str = str.toLowerCase();
        Matcher matcher = Pattern.compile("_(\\w)").matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static Map<String, Object> checkMap(Map<String, Object> params) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            map.put(SPUtils.lineToHump(entry.getKey()), entry.getValue());
        }
        return map;
    }

    public static Integer convert(Object obj) {
        return null;
    }

    public static HashMap<String, Object> getSqlError(String errorMsg) {
        logger.debug("erroeMSG\u3010{}\u3011", (Object)errorMsg);
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        Integer errorCode = -1;
        if (errorMsg.startsWith("ORA")) {
            errorCode = Integer.parseInt(errorMsg.substring(errorMsg.indexOf(45), errorMsg.indexOf(58)));
        }
        return retMap;
    }

    public static int convertNull(Object string) {
        if (string != null && !"".equals(string)) {
            int parseInt = Integer.parseInt(string.toString());
            return parseInt;
        }
        return 0;
    }

    public static String printRealSql(String sql, Object[] params) {
        if (params == null || params.length == 0) {
            logger.info("The SQL is------------>\n\u3010{}\u3011", (Object)sql);
            return sql;
        }
        if (!SPUtils.match(sql, params)) {
            logger.info("SQL \u8bed\u53e5\u4e2d\u7684\u5360\u4f4d\u7b26\u4e0e\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d\u3002SQL\uff1a\u3010{}\u3011", (Object)sql);
            return null;
        }
        int cols = params.length;
        Object[] values = new Object[cols];
        System.arraycopy(params, 0, values, 0, cols);
        int i = 0;
        while (i < cols) {
            Object value = values[i];
            if (value instanceof Date) {
                values[i] = "'" + value + "'";
            } else if (value instanceof String) {
                values[i] = "'" + value + "'";
            } else if (value instanceof Boolean) {
                values[i] = (Boolean)value != false ? 1 : 0;
            }
            ++i;
        }
        sql = sql.replaceAll("%", "%%");
        String statement = String.format(sql.replaceAll("\\?", "%s"), values);
        logger.info("The SQL is------------>\n\u3010{}\u3011", (Object)statement);
        return statement;
    }

    private static boolean match(String sql, Object[] params) {
        if (params == null || params.length == 0) {
            return true;
        }
        Matcher m = Pattern.compile("(\\?)").matcher(sql);
        int count = 0;
        while (m.find()) {
            ++count;
        }
        return count == params.length;
    }

    public static int executeUpdate(Connection conn, String sql, Object[] obj) throws Exception {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        SPUtils.printRealSql(sql, obj);
        int ret = 0;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                int i = 0;
                while (i < obj.length) {
                    ps.setObject(i + 1, obj[i]);
                    ++i;
                }
                ret = ps.executeUpdate();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new Exception(e.getMessage());
        }
        return ret;
    }

    public static int executeUpdateTx(Connection conn, String sql, Object[] obj) throws Exception {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        SPUtils.printRealSql(sql, obj);
        int ret = 0;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                if (obj != null) {
                    int i = 0;
                    while (i < obj.length) {
                        ps.setObject(i + 1, obj[i]);
                        ++i;
                    }
                }
                ret = ps.executeUpdate();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new Exception(e.getMessage());
        }
        return ret;
    }

    public static ResultSet executeQuery(HttpServletRequest request, Connection conn, String sql, Object[] obj) throws Exception {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        SPUtils.printRealSql(sql, obj);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = conn.prepareStatement(sql);
                int i = 0;
                while (i < obj.length) {
                    ps.setObject(i + 1, obj[i]);
                    ++i;
                }
                rs = ps.executeQuery();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw new Exception(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                WebUtil.setObject(request, SysUtil.getId(), rs);
            }
            if (ps != null) {
                WebUtil.setObject(request, SysUtil.getId(), ps);
            }
            throw throwable;
        }
        if (rs != null) {
            WebUtil.setObject(request, SysUtil.getId(), rs);
        }
        if (ps != null) {
            WebUtil.setObject(request, SysUtil.getId(), ps);
        }
        return rs;
    }

    public static ResultSet executeQuery(HttpServletRequest request, Connection conn, String sql) throws Exception {
        SPUtils.printRealSql(sql, null);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = conn.prepareStatement(sql);
                rs = ps.executeQuery();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw new Exception(e.getMessage());
            }
        }
        finally {
            if (rs != null) {
                WebUtil.setObject(request, SysUtil.getId(), rs);
            }
            if (ps != null) {
                WebUtil.setObject(request, SysUtil.getId(), ps);
            }
        }
        return rs;
    }

    public static int executeQueryCount(Connection conn, String sql, Object[] obj) throws Exception {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        SPUtils.printRealSql(sql, obj);
        int t = 0;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                int i = 0;
                while (i < obj.length) {
                    ps.setObject(i + 1, obj[i]);
                    ++i;
                }
                Throwable throwable2 = null;
                Object var8_13 = null;
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        t = rs.getInt(1);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new Exception(e.getMessage());
        }
        return t;
    }

    public static String executeQueryOneString(Connection conn, String sql, Object[] obj, String string) throws Exception {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        SPUtils.printRealSql(sql, obj);
        String t = "";
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                int i = 0;
                while (i < obj.length) {
                    ps.setObject(i + 1, obj[i]);
                    ++i;
                }
                Throwable throwable2 = null;
                Object var9_14 = null;
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        t = rs.getString(string);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new Exception(e.getMessage());
        }
        return t;
    }
}

