/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.ks.fintech.bw.api.FunctionEObj;
import com.ks.fintech.bw.support.BwIDE;
import com.ks.fintech.bw.support.PermUtil;
import com.wb.common.Base;
import com.wb.common.MenuEnum;
import com.wb.common.Parser;
import com.wb.common.Resource;
import com.wb.common.Var;
import com.wb.tool.Encrypter;
import com.wb.tool.ExcelObject;
import com.wb.tool.GlobeStorage;
import com.wb.util.DbUtil;
import com.wb.util.ExportUtil;
import com.wb.util.FileUtil;
import com.wb.util.RSAUtils;
import com.wb.util.StringUtil;
import com.wb.util.SystemKit;
import com.wb.util.WebUtil;
import com.wb.util.ZipUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.security.interfaces.RSAPrivateKey;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import ks.fintech.bw.api.utils.RoleUtils;
import ks.fintech.framework.core.exception.KException;
import ks.fintech.framework.utils.DateUtils;
import ks.fintech.framework.utils.EncryptUtil;
import ks.fintech.framework.utils.SpringContextUtil;
import ks.fintech.framework.utils.StringUtils;
import ks.fintech.user.api.UserService;
import ks.fintech.user.eobj.UserEObj;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class Service {
    public static String xwl_path = "/wb/modules/";
    public static final String ADMIN = "admin";
    public static final String DESC = "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u64cd\u4f5c\u6846\u67b6\u81ea\u5e26xwl\u6587\u4ef6\u548c\u6587\u4ef6\u5939\uff01";

    public static void saveState(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!Var.saveState) {
            throw new RuntimeException("Variable sys.controls.saveState disabled.");
        }
        String clientState = "clientState";
        String state = Resource.getString(request, clientState, null);
        JSONObject stateObject = StringUtil.isEmpty(state) ? new JSONObject() : new JSONObject(state);
        stateObject.put(WebUtil.fetch(request, "name"), (Object)WebUtil.fetch(request, "value"));
        Resource.set(request, clientState, stateObject.toString());
    }

    private static void download(HttpServletRequest request, HttpServletResponse response, boolean webFilesOnly) throws Exception {
        String filename;
        JSONArray ja = new JSONArray(WebUtil.fetch(request, "files"));
        FunctionEObj funceobj = new FunctionEObj();
        int j = ja.length();
        File base = null;
        File sysFolder = null;
        File[] files = new File[j];
        if (webFilesOnly) {
            base = new File(Base.path, "wb");
            sysFolder = new File(Base.path, "wb/system");
        }
        int i = 0;
        while (i < j) {
            if (webFilesOnly) {
                files[i] = new File(Base.path, ja.optString(i));
                FileUtil.checkProctected(request, files[i], true);
            } else {
                files[i] = new File(ja.optString(i));
            }
            ++i;
        }
        boolean useZip = StringUtil.getBool(WebUtil.fetch(request, "zip")) || j > 1 || files[0].isDirectory();
        String downloadName = WebUtil.fetch(request, "downloadName");
        if (StringUtil.isEmpty(downloadName)) {
            filename = files[0].getName();
            if (j == 1) {
                if (useZip) {
                    filename = String.valueOf(FileUtil.removeExtension(filename)) + ".zip";
                }
            } else {
                File parentFile = files[0].getParentFile();
                filename = parentFile == null ? "file.zip" : String.valueOf(parentFile.getName()) + ".zip";
            }
            if (filename.equals(".zip") || filename.equals("/.zip")) {
                filename = "file.zip";
            }
        } else {
            filename = downloadName;
        }
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, filename));
        if (useZip) {
            ZipUtil.zip(files, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        } else {
            WebUtil.send(response, (Object)new FileInputStream(files[0]));
        }
    }

    private static void downloadForCache(HttpServletRequest request, HttpServletResponse response, boolean webFilesOnly) throws Exception {
        String filename;
        JSONArray ja = new JSONArray(WebUtil.fetch(request, "files"));
        int j = ja.length();
        File base = null;
        File sysFolder = null;
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        String zipTmpPath = String.valueOf(request.getSession().getServletContext().getRealPath("downloadTemp/")) + uuid;
        FileUtil.createMkdirs(zipTmpPath);
        if (webFilesOnly) {
            base = new File(Base.path, "wb");
            sysFolder = new File(Base.path, "wb/system");
        }
        int i = 0;
        while (i < j) {
            if (webFilesOnly) {
                ja.put(i, (Object)FileUtil.replacePath(Base.path + File.separator + ja.optString(i)));
                FileUtil.checkProctectedPath(request, ja.optString(i), true);
            }
            if (ja.optString(i).contains("/wb/modules")) {
                ExportUtil.downloadModules(zipTmpPath, RoleUtils.getRelativePath((String)ja.optString(i)));
            } else {
                FileUtil.copyFileOrDir(ja.optString(i), zipTmpPath);
            }
            ++i;
        }
        File[] files = new File(zipTmpPath).listFiles();
        boolean useZip = StringUtil.getBool(WebUtil.fetch(request, "zip")) || j > 1 || files[0].isDirectory();
        String downloadName = WebUtil.fetch(request, "downloadName");
        if (StringUtil.isEmpty(downloadName)) {
            filename = FileUtil.getFilename(ja.optString(0));
            if (j == 1) {
                if (useZip) {
                    filename = String.valueOf(FileUtil.removeExtension(filename)) + ".zip";
                }
            } else {
                String path = FileUtil.replacePath(ja.optString(0));
                String parentName = FileUtil.obtainParent(path);
                filename = parentName == null ? "file.zip" : String.valueOf(parentName) + ".zip";
            }
            if (filename.equals(".zip") || filename.equals("/.zip")) {
                filename = "file.zip";
            }
        } else {
            filename = downloadName;
        }
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, filename));
        if (useZip) {
            ZipUtil.zip(files, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        } else {
            WebUtil.send(response, (Object)new FileInputStream(files[0]));
        }
        FileUtils.deleteDirectory((File)new File(zipTmpPath));
    }

    public static void downloadAtAll(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Service.downloadForCache(request, response, false);
    }

    public static void downloadAtApp(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Service.downloadForCache(request, response, true);
    }

    public static void containAdmin(String path, String desc) throws KException {
        String devtag = !"".equals(Var.getString("sys.app.devTag")) && Var.getString("sys.app.devTag") != null ? Var.getString("sys.app.devTag").trim() : null;
        String tempPath = RoleUtils.getRelativePath((String)path);
        if (!Service.check(devtag) && tempPath != null) {
            MenuEnum[] listMenuEnum;
            MenuEnum[] menuEnumArray = listMenuEnum = MenuEnum.listMenuEnum();
            int n = listMenuEnum.length;
            int n2 = 0;
            while (n2 < n) {
                MenuEnum menuEnum = menuEnumArray[n2];
                if (tempPath.startsWith(menuEnum.getName())) {
                    throw new KException(desc == null ? DESC : desc);
                }
                ++n2;
            }
        }
    }

    public static void checkMoudle(String fileName, String desc) throws KException {
        String devtag;
        String string = devtag = !"".equals(Var.getString("sys.app.devTag")) && Var.getString("sys.app.devTag") != null ? Var.getString("sys.app.devTag").trim() : null;
        if (!Service.check(devtag)) {
            MenuEnum[] listMenuEnum;
            MenuEnum[] menuEnumArray = listMenuEnum = MenuEnum.listMenuEnum();
            int n = listMenuEnum.length;
            int n2 = 0;
            while (n2 < n) {
                MenuEnum menuEnum = menuEnumArray[n2];
                if (fileName.startsWith(menuEnum.getName())) {
                    throw new KException(desc == null ? DESC : desc);
                }
                ++n2;
            }
        }
    }

    public static boolean check(String time) {
        block3: {
            try {
                if (time != null && !"".equals(time)) break block3;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        String nowDate = DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        String key = "v8wolfdb";
        String input = EncryptUtil.decrypt((String)time, (String)key);
        Date d1 = DateUtils.parse((String)nowDate, (String)"yyyy-MM-dd HH:mm:ss");
        Date d2 = DateUtils.parse((String)input, (String)"yyyy-MM-dd HH:mm:ss");
        return d2.getTime() > d1.getTime();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void upload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean unzip = StringUtil.getBool((String)request.getAttribute("unzip"));
        boolean sync = StringUtil.getBool((String)request.getAttribute("sync"));
        String path = request.getAttribute("path").toString();
        Service.containAdmin(path, null);
        InputStream stream = (InputStream)request.getAttribute("file");
        String filename = null;
        String tempPath = null;
        filename = request.getAttribute("filename") != null ? (String)request.getAttribute("filename") : (String)request.getAttribute("file__name");
        boolean isSync = BwIDE.isModeuleFile((String)FileUtil.getPath(String.valueOf(path) + File.separator));
        boolean isRoot = BwIDE.isRootModules((String)FileUtil.getPath(String.valueOf(path) + File.separator));
        String sysUser = (String)request.getSession().getAttribute("sys.username");
        if (unzip) {
            if (!filename.toLowerCase().endsWith(".zip")) throw new Exception("Invalid zip file.");
            if (!isSync) {
                File syncFile;
                File destFile = new File(path);
                ZipUtil.unzip(request, stream, destFile);
                if (!sync || (syncFile = FileUtil.getSyncPath(destFile)) == null) return;
                FileUtils.copyDirectory((File)destFile, (File)syncFile);
                return;
            } else {
                String uuid = UUID.randomUUID().toString().replaceAll("-", "");
                String zipTmpPath = String.valueOf(request.getSession().getServletContext().getRealPath("wb/system/tmp/ziptmp/")) + uuid;
                File zipTmpFile = new File(zipTmpPath);
                if (!zipTmpFile.exists()) {
                    zipTmpFile.mkdirs();
                }
                String filePath = String.valueOf(zipTmpPath) + File.separator + filename;
                FileOutputStream fileOutputStream = new FileOutputStream(new File(filePath));
                IOUtils.copy((InputStream)stream, (OutputStream)fileOutputStream);
                fileOutputStream.close();
                String desParentPath = FileUtil.getPath(String.valueOf(zipTmpPath) + File.separator);
                ZipUtil.unZip(filePath, desParentPath, true, isRoot);
                File parentFile = new File(desParentPath);
                if (!FileUtil.isContainXwlFile(parentFile)) {
                    throw new KException("\u5bfc\u5165\u6587\u4ef6\u5e76\u89e3\u538b\u9519\u8bef ", new Object[]{"\u6587\u4ef6\u5939\u5185\u7684\u975exwl\u6587\u4ef6\u4e0d\u80fd\u5bfc\u5165\u6a21\u5757\u76ee\u5f55\u4e0b"});
                }
                tempPath = desParentPath;
                PermUtil.modulePerm((String)path, (String)tempPath, (String)sysUser);
                String delTmpPath = String.valueOf(request.getSession().getServletContext().getRealPath("wb/system/tmp/ziptmp/")) + uuid;
                FileUtils.deleteDirectory((File)new File(delTmpPath));
            }
            return;
        } else {
            Service.validateFile(request, filename);
            if (!isSync) {
                File syncFile;
                File destFile = new File(path, filename);
                FileUtil.saveStream(stream, destFile);
                if (!sync || (syncFile = FileUtil.getSyncPath(destFile)) == null) return;
                FileUtils.copyFile((File)destFile, (File)syncFile);
                return;
            } else {
                String xwlPath = FileUtil.getPath(String.valueOf(path) + File.separator + filename);
                if (!FileUtil.getFileExt(xwlPath).equals("xwl")) {
                    throw new KException("\u5bfc\u5165\u6587\u4ef6\u9519\u8bef ", new Object[]{"\u6a21\u5757\u4e0b\u4e0d\u80fd\u5bfc\u5165\u975exwl\u6587\u4ef6"});
                }
                if (path.endsWith("/wb/modules")) {
                    throw new KException("\u5bfc\u5165\u6587\u4ef6\u9519\u8bef ", new Object[]{"xwl\u6587\u4ef6\u4e0d\u80fd\u76f4\u63a5\u4f4d\u4e8e\u6a21\u5757\u4e0b"});
                }
                String filePath = FileUtil.getPath(String.valueOf(path) + File.separator + filename);
                PermUtil.syncPerm((String)filePath, (String)IOUtils.toString((InputStream)stream, (String)"UTF-8"), (String)sysUser, null, (boolean)true);
            }
        }
    }

    public static void getProgress(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id = request.getParameter("progressId");
        HttpSession session = request.getSession(true);
        Long pos = (Long)session.getAttribute("sys.upread." + id);
        Long len = (Long)session.getAttribute("sys.uplen." + id);
        double result = pos == null || len == null || len == 0L ? 0.0 : (double)pos.longValue() / (double)len.longValue();
        WebUtil.send(response, (Object)result);
    }

    public static void importData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        InputStream stream;
        String filename;
        boolean fromServer = StringUtil.getBool(WebUtil.fetch(request, "fromServer"));
        if (fromServer) {
            filename = WebUtil.fetch(request, "filename");
            stream = new FileInputStream(new File(filename));
            filename = filename.toLowerCase();
        } else {
            filename = ((String)request.getAttribute("file__name")).toLowerCase();
            stream = (InputStream)request.getAttribute("file");
        }
        try {
            String tableName = WebUtil.fetch(request, "table");
            boolean trans = StringUtil.getBool(WebUtil.fetch(request, "trans"));
            Connection connection = DbUtil.getConnection(WebUtil.fetch(request, "jndi"));
            try {
                if (trans) {
                    connection.setAutoCommit(false);
                }
                if (filename.endsWith(".gz")) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(stream), "utf-8"));
                    DbUtil.importData(connection, tableName, reader);
                } else if (filename.endsWith(".xls") || filename.endsWith(".xlsx")) {
                    BufferedReader reader = new BufferedReader(new StringReader(ExcelObject.excelToJson(stream, filename.endsWith(".xlsx"))));
                    DbUtil.importData(connection, tableName, reader);
                } else {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "utf-8"));
                    String fields = reader.readLine();
                    char separator = fields.indexOf(9) == -1 ? (char)',' : '\t';
                    String[] fieldList = StringUtil.split(fields, separator);
                    DbUtil.importData(connection, tableName, reader, fieldList, separator);
                }
                if (trans) {
                    connection.commit();
                }
            }
            finally {
                DbUtil.close(connection);
            }
        }
        finally {
            stream.close();
        }
    }

    public static void exportJson(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultSet rs = (ResultSet)DbUtil.run(request, WebUtil.fetch(request, "sql"), WebUtil.fetch(request, "jndi"));
        String filename = WebUtil.fetch(request, "filename");
        if (filename == null) {
            filename = "data.gz";
        }
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, filename));
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream((OutputStream)response.getOutputStream()), "utf-8"));){
            DbUtil.exportData(rs, writer);
        }
        response.flushBuffer();
    }

    public static void exportJsonToServer(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultSet rs = (ResultSet)DbUtil.run(request, WebUtil.fetch(request, "sql"), WebUtil.fetch(request, "jndi"));
        String filename = WebUtil.fetch(request, "filename");
        File file = new File(filename);
        if (file.exists()) {
            throw new Exception("\u6587\u4ef6 \u201c" + filename + "\u201d \u5df2\u7ecf\u5b58\u5728\u3002");
        }
        FileOutputStream fos = null;
        BufferedWriter writer = null;
        try {
            fos = new FileOutputStream(file);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(fos), "utf-8"));
            DbUtil.exportData(rs, writer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            fos.close();
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
        fos.close();
    }

    private static void validateFile(HttpServletRequest request, String fileName) throws Exception {
        String type = (String)request.getAttribute("type");
        Service.validateExt(type, fileName);
    }

    private static void validateExt(String type, String fileName) throws Exception {
        if (StringUtils.isEmpty((String)type)) {
            type = "default";
        }
        boolean checkExt = Var.getBool("sys.file.import." + type + ".checkExt");
        String extList = Var.getString("sys.file.import." + type + ".extList");
        if (!checkExt || StringUtils.isEmpty((String)extList)) {
            return;
        }
        String fileExt = fileName.substring(fileName.lastIndexOf("."));
        if (StringUtils.isEmpty((String)fileExt)) {
            return;
        }
        if (!extList.toLowerCase().contains(fileExt.substring(1).toLowerCase())) {
            throw new KException("\u64cd\u4f5c\u5931\u8d25\u3002\u4e0a\u4f20\u7684\u6587\u4ef6\u540e\u7f00\u540d\u5fc5\u987b\u4e3a" + extList);
        }
    }

    public static boolean validatePassword(ServletRequest request, String username, String password) throws KException {
        UserService userService = (UserService)SpringContextUtil.getBean((String)"userService");
        String userIP = SystemKit.getClientIP((HttpServletRequest)request);
        try {
            UserEObj user = userService.findUser(username);
            if (user == null) {
                throw new KException("\u7528\u6237\u4e0d\u5b58\u5728");
            }
            HashMap<String, Object> keyMap = GlobeStorage.globeStorage.get(userIP);
            if (keyMap == null) {
                keyMap = RSAUtils.getKeys();
            }
            RSAPrivateKey privateKey = (RSAPrivateKey)keyMap.get("private");
            String pwd = RSAUtils.decryptByPrivateKey(password, privateKey);
            String inputMd5Psw = Encrypter.getMD5(user.getUserId(), pwd);
            return StringUtil.isEqual(user.getPassword(), inputMd5Psw);
        }
        catch (Exception e) {
            throw new KException("\u6821\u9a8c\u7528\u6237\u5bc6\u7801\u5931\u8d25", (Throwable)e);
        }
    }

    public static boolean runParser(HttpServletRequest request, HttpServletResponse response, String xwl) throws Exception {
        Parser parser = new Parser(request, response);
        parser.parse(xwl);
        return true;
    }
}

