/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.wb.common.Base;
import com.wb.common.Session;
import com.wb.common.Str;
import com.wb.common.Var;
import com.wb.util.DbUtil;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.SortUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class ResourceManager {
    public static final File basePath = new File(Base.path, "wb/system/resources");
    private static final String[] resourceExt = Var.getString("sys.file.resourceFiles").split(",");

    public static void getFileList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isTree;
        File path = new File(request.getParameter("path"));
        int type = StringUtil.isEmpty(request.getParameter("type")) ? Integer.parseInt(request.getParameter("flowFile")) : Integer.parseInt(request.getParameter("type"));
        boolean bl = isTree = type == 1;
        if (!FileUtil.isAncestor(basePath, path)) {
            SysUtil.accessDenied(request);
        }
        File[] files = FileUtil.listFiles(path);
        if (isTree) {
            SortUtil.sort(files);
        } else {
            String[] sortInfo = WebUtil.getSortInfo(request);
            String[] fields = new String[]{"text", "size", "type", "date"};
            SortUtil.sort(files, StringUtil.indexOf(fields, sortInfo[0]), sortInfo[1].equalsIgnoreCase("desc"));
        }
        JSONArray rows = new JSONArray();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            boolean isDir = file.isDirectory();
            if ((!isTree || isDir) && ResourceManager.canDisplay(request, file)) {
                String dirPath = FileUtil.getPath(file);
                JSONObject item = new JSONObject();
                item.put("text", (Object)StringUtil.select(file.getName(), dirPath));
                item.put("path", (Object)dirPath);
                item.put("leaf", !isDir);
                if (isTree) {
                    if (ResourceManager.isLeafFolder(request, file)) {
                        item.put("children", (Object)new JSONArray());
                    }
                } else {
                    item.put("icon", (Object)WebUtil.encode(dirPath));
                    item.put("date", (Object)new Date(file.lastModified()));
                    item.put("size", file.length());
                    item.put("type", (Object)(isDir ? Str.format(request, "folder") : FileUtil.getFileType(file)));
                }
                rows.put((Object)item);
            }
            ++n2;
        }
        WebUtil.send(response, (Object)new JSONObject().put(isTree ? "children" : "rows", (Object)rows));
    }

    public static void getPerm(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject result;
        File file = new File(basePath, request.getParameter("fileName"));
        if (!FileUtil.isAncestor(basePath, file)) {
            SysUtil.accessDenied(request);
        }
        String[] types = new String[]{"get", "read", "write", "execute"};
        JSONObject content = JsonUtil.readObject(file);
        JSONObject rolePerms = (JSONObject)content.opt("roles");
        if (rolePerms == null) {
            result = new JSONObject();
        } else {
            ResourceManager.checkPerm(request, content, "get");
            HashMap<String, String> roleMap = DbUtil.getMap("select ROLE_ID,ROLE_NAME from KS_ROLE");
            String[] stringArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                JSONArray roles = rolePerms.optJSONArray(type);
                if (roles != null) {
                    JSONArray roleNames = new JSONArray();
                    int j = roles.length();
                    int i = 0;
                    while (i < j) {
                        String roleName = roleMap.get(roles.getString(i));
                        if (roleName != null) {
                            roleNames.put((Object)roleName);
                        }
                        ++i;
                    }
                    rolePerms.put(String.valueOf(type) + "RoleCombo", (Object)roleNames);
                }
                ++n2;
            }
            result = rolePerms;
        }
        WebUtil.send(response, (Object)result);
    }

    private static boolean hasPerm(HttpServletRequest request, JSONObject content, String type) throws Exception {
        JSONObject permRoles = content.optJSONObject("roles");
        if (permRoles == null) {
            return true;
        }
        JSONArray roles = permRoles.optJSONArray(type);
        if (roles == null) {
            return true;
        }
        boolean hasPerm = false;
        String[] userRoles = Session.getRoles(request);
        if (userRoles == null) {
            return false;
        }
        if (StringUtil.indexOf(userRoles, "admin") != -1) {
            return true;
        }
        HashSet<String> hs = JsonUtil.toHashSet(roles);
        String[] stringArray = userRoles;
        int n = userRoles.length;
        int n2 = 0;
        while (n2 < n) {
            String role = stringArray[n2];
            if (hs.contains(role)) {
                hasPerm = true;
                break;
            }
            ++n2;
        }
        return hasPerm;
    }

    private static void checkPerm(HttpServletRequest request, JSONObject content, String type) throws Exception {
        if (!ResourceManager.hasPerm(request, content, type)) {
            SysUtil.accessDenied(request);
        }
    }

    public static void saveResource(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray array = new JSONArray(request.getParameter("data"));
        int j = array.length();
        int i = 0;
        while (i < j) {
            JSONObject object = array.getJSONObject(i);
            ResourceManager.saveFile(request, new File(object.getString("file")), object.getJSONObject("data"), true);
            ++i;
        }
    }

    public static void openResource(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray result = new JSONArray();
        JSONArray items = new JSONArray(request.getParameter("filenames"));
        int j = items.length();
        int i = 0;
        while (i < j) {
            String fileData;
            String filename = items.getString(i);
            File file = new File(filename);
            if (!file.exists()) {
                String.format("\u6587\u4ef6 \u201c%s\u201d \u4e0d\u5b58\u5728\u3002", file.getName());
            }
            if (!FileUtil.isAncestor(basePath, file)) {
                SysUtil.accessDenied(request);
            }
            if (!StringUtil.isEmpty(fileData = FileUtil.readString(file))) {
                ResourceManager.checkPerm(request, new JSONObject(fileData), "read");
            }
            JSONObject content = new JSONObject();
            content.put("file", (Object)file);
            content.put("data", (Object)fileData);
            result.put((Object)content);
            ++i;
        }
        WebUtil.send(response, (Object)result);
    }

    public static void setPerm(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray fileNames = new JSONArray(request.getParameter("fileNames"));
        JSONObject perms = new JSONObject(request.getParameter("perms"));
        int j = fileNames.length();
        int i = 0;
        while (i < j) {
            File file = new File(basePath, fileNames.getString(i));
            ResourceManager.doSetPerm(request, file, perms);
            ++i;
        }
    }

    private static void doSetPerm(HttpServletRequest request, File file, JSONObject perms) throws Exception {
        if (file.isDirectory()) {
            File[] fs;
            File[] fileArray = fs = file.listFiles();
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                ResourceManager.doSetPerm(request, f, perms);
                ++n2;
            }
        } else {
            JSONObject content = JsonUtil.readObject(file);
            content.put("roles", (Object)perms);
            ResourceManager.saveFile(request, file, content, false);
        }
    }

    public static JSONObject getExecuteObject(HttpServletRequest request, File file) throws Exception {
        if (!FileUtil.isAncestor(basePath, file)) {
            SysUtil.accessDenied(request);
        }
        JSONObject content = JsonUtil.readObject(file);
        ResourceManager.checkPerm(request, content, "execute");
        return content;
    }

    private static void saveFile(HttpServletRequest request, File file, JSONObject content, boolean reservePerm) throws Exception {
        if (!FileUtil.isAncestor(basePath, file)) {
            SysUtil.accessDenied(request);
        }
        if (file.exists()) {
            JSONObject oldContent = JsonUtil.readObject(file);
            ResourceManager.checkPerm(request, oldContent, "write");
            if (reservePerm) {
                content.put("roles", oldContent.opt("roles"));
            }
        }
        FileUtil.syncSave(file, content.toString());
    }

    private static boolean isLeafFolder(HttpServletRequest request, File file) throws Exception {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles(file);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File subFile = fileArray[n2];
            if (subFile.isDirectory() && ResourceManager.canDisplay(request, subFile)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean canDisplay(HttpServletRequest request, File file) throws Exception {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = FileUtil.listFiles(file);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                if (ResourceManager.canDisplay(request, subFile)) {
                    return true;
                }
                ++n2;
            }
        } else {
            String ext = FileUtil.getFileExt(file);
            if (StringUtil.indexOf(resourceExt, ext) == -1) {
                return true;
            }
            JSONObject content = JsonUtil.readObject(file);
            if (ResourceManager.hasPerm(request, content, "get")) {
                return true;
            }
        }
        return false;
    }
}

