/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.wb.common.Base;
import com.wb.fit.CustomResponse;
import com.wb.tool.MgDataOutput;
import com.wb.tool.MgMailSend;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class MgFilePush {
    public static void transfer(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray records;
        JSONObject metaParams = new JSONObject(request.getParameter("__metaParams"));
        String type = metaParams.optString("type");
        String to = metaParams.optString("to");
        String subject = metaParams.optString("subject");
        String content = metaParams.optString("content");
        String data = metaParams.optString("data", null);
        if (data == null) {
            CustomResponse resp = new CustomResponse(response);
            request.setAttribute("sys.rowOnly", (Object)1);
            request.setAttribute("sys.fromExport", (Object)1);
            WebUtil.include(request, (HttpServletResponse)resp, metaParams.optString("url"));
            String respText = MgFilePush.getResponseString(resp);
            data = respText.substring(10, respText.length() - 11);
            JSONObject responseObject = new JSONObject(data);
            data = (String)responseObject.opt("value");
            records = new JSONObject(data).getJSONArray("rows");
        } else {
            records = new JSONArray(data);
        }
        JSONArray headers = metaParams.optJSONArray("headers");
        String title = metaParams.optString("title", null);
        boolean neptune = metaParams.optBoolean("neptune");
        String filename = metaParams.optString("filename");
        if (StringUtil.isEmpty(filename)) {
            filename = "data";
        }
        String fileDatName = "VV_2162966_" + filename + "_1_FED_MSHX.dat";
        if (type.equals("dat")) {
            File datFile = new File(Base.path, fileDatName);
            FileUtils.write((File)datFile, (CharSequence)MgDataOutput.outputDat(headers, records, filename), (String)"UTF-8");
            response.reset();
            response.addHeader("Content-Length", "" + datFile.length());
            response.setHeader("content-type", "application/force-download");
            response.setHeader("Content-Disposition", "attachment;" + WebUtil.encodeFilename(request, fileDatName));
            response.getOutputStream().write(FileUtils.readFileToByteArray((File)datFile));
        }
        if (type.equals("all")) {
            String fileExtName = "VV_2162966_" + filename + "_1_FED_MSHX.xls";
            String finalXlsxPath = Base.path + File.separator + fileExtName;
            File file = new File(finalXlsxPath);
            if (!file.exists()) {
                file.createNewFile();
            }
            File datFile = new File(Base.path, fileDatName);
            MgDataOutput.outputExc(headers, records, title, neptune, "true".equals(WebUtil.fetch(request, "isAjax")), finalXlsxPath, filename);
            request.setAttribute(fileExtName, (Object)new FileInputStream(finalXlsxPath));
            FileUtils.write((File)datFile, (CharSequence)MgDataOutput.outputDat(headers, records, filename), (String)"UTF-8");
            request.setAttribute(fileDatName, (Object)new FileInputStream(datFile));
            String attachementFileList = String.valueOf(fileExtName) + "," + fileDatName;
            MgMailSend.mgMailSend(attachementFileList, to, subject, content, request);
        }
    }

    private static String getResponseString(CustomResponse response) throws Exception {
        String result;
        byte[] data = response.getBytes();
        if (data.length > 2 && data[0] == 31 && data[1] == -117) {
            try (GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(data));){
                result = StringUtil.getString(is);
            }
        } else {
            result = new String(data, "utf-8");
        }
        return result;
    }
}

