/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.db.DbUtil;
import com.wb.common.Base;
import com.wb.common.Var;
import com.wb.interact.IDEModulesPerm;
import com.wb.splogic.SaveMenu;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuEntry {
    private static int order = 1;
    private static final Logger logger = LoggerFactory.getLogger(IDEModulesPerm.class);

    public static void saveMenu(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList<Map<String, Object>> menuList = new ArrayList<Map<String, Object>>();
        MenuEntry.getMenus(null, menuList);
        MenuEntry.savePathToOral(menuList);
        ArrayList<Map<String, Object>> operationsList = new ArrayList<Map<String, Object>>();
        MenuEntry.getOperations(null, operationsList);
        MenuEntry.saveOperationToOral(operationsList);
    }

    public static void permInit(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap perms = new HashMap();
        ArrayList<Map<String, Object>> modulPerms = new ArrayList<Map<String, Object>>();
        MenuEntry.getModulePerm(Base.modulePath, modulPerms);
        if (!modulPerms.isEmpty()) {
            MenuEntry.savePerm(modulPerms);
        }
    }

    public static void savePerm(List<Map<String, Object>> dataList) throws Exception {
        Connection connection = null;
        PreparedStatement st = null;
        String sql = "insert into WB_MODULES_PERM(PK_ID,PATH,IS_DEFAULT,ROLES,OPERATOR,OPERATE_TIME) values(?,?,?,?,?,?)";
        try {
            try {
                connection = com.wb.util.DbUtil.getConnection();
                st = connection.prepareStatement(sql);
                for (Map<String, Object> map : dataList) {
                    st.setString(1, map.get("PK_ID").toString());
                    st.setString(2, map.get("PATH").toString());
                    st.setBoolean(3, Boolean.parseBoolean(map.get("IS_DEFAULT").toString()));
                    st.setString(4, map.get("ROLES").toString());
                    st.setString(5, map.get("OPERATOR").toString());
                    st.setTimestamp(6, DbUtil.toSqlTimestamp((Date)new Date()));
                    st.addBatch();
                }
                st.executeBatch();
                connection.commit();
            }
            catch (Exception e) {
                logger.error(" \u521d\u59cb\u5316\u4fdd\u5b58\u5168\u90e8\u5df2\u6709\u6743\u9650\u64cd\u4f5c\u5f02\u5e38\uff1a" + e.getMessage());
                throw e;
            }
        }
        catch (Throwable throwable) {
            com.wb.util.DbUtil.close(st);
            com.wb.util.DbUtil.close(connection);
            throw throwable;
        }
        com.wb.util.DbUtil.close(st);
        com.wb.util.DbUtil.close(connection);
    }

    private static void getModulePerm(File path, List<Map<String, Object>> modulPerms) throws Exception {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles(path);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                MenuEntry.getModulePerm(file, modulPerms);
            } else {
                String filename = file.getName();
                if (filename.endsWith(".xwl")) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    JSONObject jo = JsonUtil.readObject(file);
                    JSONObject roles = (JSONObject)jo.opt("roles");
                    Set keys = roles.keySet();
                    String pkId = RandomUtil.simpleUUID();
                    jo.put("pkId", (Object)pkId);
                    FileUtil.syncSave(file, jo.toString());
                    map.put("PK_ID", pkId);
                    map.put("PATH", FileUtil.getModulePath(file));
                    map.put("IS_DEFAULT", jo.has("isDefaultRole") ? jo.getBoolean("isDefaultRole") : false);
                    map.put("ROLES", CollUtil.join((Iterable)keys, (CharSequence)","));
                    map.put("OPERATOR", "system");
                    modulPerms.add(map);
                }
            }
            ++n2;
        }
    }

    private static void savePathToOral(List<Map<String, Object>> dataList) throws Exception {
        Connection connection = null;
        PreparedStatement st = null;
        CallableStatement callableStatement = null;
        String sql = "DELETE from WB_RESOURCE_PATH";
        String sql1 = "insert into WB_RESOURCE_PATH(PATH,TITLE,INFRAME,ICON,PAGELINK,QTIP,PARENT_PATH,IS_FUNC,FILENAME,FILE_SORT) values(?,?,?,?,?,?,?,?,?,?)";
        try {
            try {
                connection = com.wb.util.DbUtil.getConnection();
                connection.setAutoCommit(false);
                st = connection.prepareStatement(sql);
                st.executeUpdate();
                st.close();
                st = connection.prepareStatement(sql1);
                for (Map<String, Object> map : dataList) {
                    st.setString(1, map.get("PATH").toString());
                    st.setString(2, String.valueOf(map.get("TITLE")));
                    st.setString(3, String.valueOf(map.get("INFRAME")));
                    st.setString(4, String.valueOf(map.get("ICON")));
                    st.setString(5, String.valueOf(map.get("PAGELINK")));
                    st.setString(6, String.valueOf(map.get("QTIP")));
                    st.setString(7, String.valueOf(map.get("PARENT_PATH")));
                    st.setString(8, String.valueOf(map.get("IS_FUNC")));
                    st.setString(9, map.get("FILENAME").toString());
                    st.setInt(10, Integer.parseInt(map.get("FILE_SORT").toString()));
                    st.addBatch();
                }
                st.executeBatch();
                if (Var.getBool("sys.spLogic.isSpLogic")) {
                    SaveMenu.getData();
                } else {
                    callableStatement = connection.prepareCall("{call P_SAVEMENU()}");
                    callableStatement.execute();
                }
                connection.commit();
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u5168\u90e8\u83dc\u5355\u4fe1\u606f\u5b58\u5230\u7269\u7406\u83dc\u5355\u8868\u64cd\u4f5c\u5f02\u5e38\uff1a" + e.getMessage());
                throw e;
            }
        }
        catch (Throwable throwable) {
            com.wb.util.DbUtil.close(st);
            com.wb.util.DbUtil.close(callableStatement);
            com.wb.util.DbUtil.close(connection);
            throw throwable;
        }
        com.wb.util.DbUtil.close(st);
        com.wb.util.DbUtil.close(callableStatement);
        com.wb.util.DbUtil.close(connection);
    }

    public static void getMenus(String path, List<Map<String, Object>> list) throws Exception {
        File base = path == null ? Base.modulePath : new File(Base.modulePath, path);
        File[] files = FileUtil.listFiles(base);
        JSONObject content = null;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File subFile = fileArray[n2];
            if (subFile.exists() && !MenuEntry.canDisplay(subFile)) {
                HashMap<String, Object> map;
                if (subFile.isDirectory()) {
                    File file = new File(subFile, "folder.json");
                    content = JsonUtil.readObject(file);
                    map = new HashMap();
                    map.put("FILENAME", subFile.getName());
                    map.put("PATH", FileUtil.getModulePath(subFile));
                    map.put("TITLE", content.optString("title"));
                    map.put("ICON", content.optString("iconCls"));
                    if (!subFile.getParentFile().equals(Base.modulePath)) {
                        map.put("PARENT_PATH", FileUtil.getModulePath(subFile.getParentFile()));
                    }
                    map.put("FILE_SORT", order++);
                    list.add(map);
                    MenuEntry.getMenus(map.get("PATH").toString(), list);
                } else {
                    content = JsonUtil.readObject(subFile);
                    map = new HashMap<String, Object>();
                    map.put("FILENAME", subFile.getName());
                    map.put("PATH", FileUtil.getModulePath(subFile));
                    map.put("TITLE", content.optString("title"));
                    map.put("INFRAME", content.optBoolean("inframe"));
                    map.put("ICON", content.optString("iconCls"));
                    map.put("PAGELINK", content.optString("pageLink"));
                    map.put("QTIP", content.optString("qtip"));
                    map.put("IS_FUNC", true);
                    if (!subFile.getParentFile().equals(Base.modulePath)) {
                        map.put("PARENT_PATH", FileUtil.getModulePath(subFile.getParentFile()));
                    }
                    map.put("FILE_SORT", order++);
                    list.add(map);
                }
            }
            ++n2;
        }
    }

    public static boolean canDisplay(File file) throws IOException {
        if (file.isDirectory()) {
            File configFile = new File(file, "folder.json");
            if (configFile.exists()) {
                JSONObject content = JsonUtil.readObject(configFile);
                return content.optBoolean("hidden");
            }
        } else if (file.getName().endsWith(".xwl")) {
            JSONObject content = JsonUtil.readObject(file);
            return content.optBoolean("hidden");
        }
        return true;
    }

    public static void updateModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, String> perms = new HashMap<String, String>();
        HashMap<String, String> modulePerms = new HashMap<String, String>();
        MenuEntry.scanModulePerm(Base.modulePath, perms, modulePerms);
        for (Map.Entry entry : perms.entrySet()) {
            if (((String)entry.getValue()).equals("")) continue;
            File file = new File(Base.modulePath, (String)entry.getKey());
            JSONObject olddata = JsonUtil.readObject(file);
            JSONObject newRoles = new JSONObject();
            olddata.remove("roles");
            olddata.put("roles", (Object)newRoles);
            FileUtil.syncSave(file, olddata.toString(), "utf-8", true);
        }
        List<Map<String, Object>> list = MenuEntry.selModulePerm();
        for (Map<String, Object> map : list) {
            File file;
            String path = (String)map.get("PATH");
            String roles = (String)map.get("ROLES");
            if (StringUtil.isEmpty(roles) || !(file = new File(Base.modulePath, path)).exists()) continue;
            JSONObject data = JsonUtil.readObject(file);
            JSONObject newRoles = new JSONObject();
            String[] stringArray = roles.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String role = stringArray[n2];
                newRoles.put(role, 1);
                ++n2;
            }
            data.put("roles", (Object)newRoles);
            FileUtil.syncSave(file, data.toString(), "utf-8", true);
        }
    }

    private static void scanModulePerm(File path, Map<String, String> perms, Map<String, String> modulePerms) throws Exception {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles(path);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                MenuEntry.scanModulePerm(file, perms, modulePerms);
            } else if (file.getName().endsWith(".xwl")) {
                String filePath = FileUtil.getModulePath(file);
                JSONObject jo = JsonUtil.readObject(file);
                String title = (String)jo.opt("title");
                JSONObject roles = (JSONObject)jo.opt("roles");
                Set keys = roles.keySet();
                perms.put(filePath, CollUtil.join((Iterable)keys, (CharSequence)","));
                modulePerms.put(filePath, title);
            }
            ++n2;
        }
    }

    private static List<Map<String, Object>> selModulePerm() throws Exception {
        Connection connection = null;
        PreparedStatement st = null;
        String sql = "select PATH,ROLES from WB_MODULES_PERM";
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            try {
                connection = com.wb.util.DbUtil.getConnection();
                st = connection.prepareStatement(sql);
                ResultSet rs = st.executeQuery();
                while (rs.next()) {
                    HashMap<String, String> map = new HashMap<String, String>(2);
                    map.put("PATH", rs.getString(1));
                    map.put("ROLES", rs.getString(2));
                    list.add(map);
                }
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u5168\u90e8\u7684\u6a21\u5757\u53ca\u5176\u6743\u9650\u4fe1\u606f\u64cd\u4f5c\u5f02\u5e38\uff1a" + e.getMessage());
                throw e;
            }
        }
        catch (Throwable throwable) {
            com.wb.util.DbUtil.close(st);
            com.wb.util.DbUtil.close(connection);
            throw throwable;
        }
        com.wb.util.DbUtil.close(st);
        com.wb.util.DbUtil.close(connection);
        return list;
    }

    public static void getOperations(String path, List<Map<String, Object>> list) throws Exception {
        File[] files;
        File base = path == null ? Base.modulePath : new File(Base.modulePath, path);
        File[] fileArray = files = FileUtil.listFiles(base);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File subFile = fileArray[n2];
            if (subFile.exists()) {
                if (!MenuEntry.canDisplay(subFile)) {
                    MenuEntry.getOperations(FileUtil.getModulePath(subFile), list);
                } else {
                    MenuEntry.getFileInfo(list, subFile);
                }
            }
            ++n2;
        }
    }

    public static void getFileInfo(List<Map<String, Object>> list, File file) throws Exception {
        HashMap<String, Object> map;
        JSONObject content;
        File newfile;
        File parentFile = file.getParentFile();
        if (!MenuEntry.canDisplay(parentFile) && !parentFile.equals(Base.modulePath) && (newfile = new File(parentFile, "folder.json")).exists()) {
            content = JsonUtil.readObject(newfile);
            map = new HashMap();
            map.put("FILENAME", parentFile.getName());
            map.put("PATH", FileUtil.getModulePath(parentFile));
            map.put("TITLE", content.optString("title"));
            map.put("ICON", content.optString("iconCls"));
            if (!parentFile.getParentFile().equals(Base.modulePath)) {
                map.put("PARENT_PATH", FileUtil.getModulePath(parentFile.getParentFile()));
            }
            if (!list.contains(map)) {
                list.add(map);
            }
        }
        if (file.isDirectory()) {
            File subfile = new File(file, "folder.json");
            if (subfile.exists()) {
                File[] dirFiles;
                content = JsonUtil.readObject(subfile);
                map = new HashMap();
                map.put("FILENAME", file.getName());
                map.put("PATH", FileUtil.getModulePath(file));
                map.put("TITLE", content.optString("title"));
                map.put("ICON", content.optString("iconCls"));
                if (!file.getParentFile().equals(Base.modulePath)) {
                    map.put("PARENT_PATH", FileUtil.getModulePath(file.getParentFile()));
                }
                list.add(map);
                File[] fileArray = dirFiles = FileUtil.listFiles(file);
                int n = dirFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File operFile = fileArray[n2];
                    if (operFile.exists()) {
                        MenuEntry.getFileInfo(list, operFile);
                    }
                    ++n2;
                }
            }
        } else if (file.getPath().endsWith(".xwl")) {
            content = JsonUtil.readObject(file);
            map = new HashMap<String, Object>();
            map.put("FILENAME", file.getName());
            map.put("PATH", FileUtil.getModulePath(file));
            map.put("TITLE", content.optString("title"));
            map.put("INFRAME", content.optBoolean("inframe"));
            map.put("ICON", content.optString("iconCls"));
            map.put("PAGELINK", content.optString("pageLink"));
            map.put("QTIP", content.optString("qtip"));
            map.put("IS_FUNC", true);
            if (!file.getParentFile().equals(Base.modulePath)) {
                map.put("PARENT_PATH", FileUtil.getModulePath(file.getParentFile()));
            }
            list.add(map);
        }
    }

    private static void saveOperationToOral(List<Map<String, Object>> dataList) throws Exception {
        Connection connection = null;
        PreparedStatement st = null;
        try {
            try {
                connection = com.wb.util.DbUtil.getConnection();
                connection.setAutoCommit(false);
                String sql = "DELETE from WB_OPERATION_PATH";
                st = connection.prepareStatement(sql);
                st.executeUpdate();
                st.close();
                String sql1 = "insert into WB_OPERATION_PATH(PATH,TITLE,INFRAME,ICON,PAGELINK,QTIP,PARENT_PATH,IS_FUNC,FILENAME) values(?,?,?,?,?,?,?,?,?)";
                st = connection.prepareStatement(sql1);
                for (Map<String, Object> map : dataList) {
                    st.setString(1, map.get("PATH").toString());
                    st.setString(2, String.valueOf(map.get("TITLE")));
                    st.setString(3, String.valueOf(map.get("INFRAME")));
                    st.setString(4, String.valueOf(map.get("ICON")));
                    st.setString(5, String.valueOf(map.get("PAGELINK")));
                    st.setString(6, String.valueOf(map.get("QTIP")));
                    st.setString(7, String.valueOf(map.get("PARENT_PATH")));
                    st.setString(8, String.valueOf(map.get("IS_FUNC")));
                    st.setString(9, map.get("FILENAME").toString());
                    st.addBatch();
                }
                st.executeBatch();
                connection.commit();
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u5168\u90e8\u64cd\u4f5c\u6587\u4ef6\u4fe1\u606f\u5230\u64cd\u4f5c\u6587\u4ef6\u8868\u64cd\u4f5c\u5f02\u5e38\uff1a" + e.getMessage());
                throw e;
            }
        }
        catch (Throwable throwable) {
            com.wb.util.DbUtil.close(st);
            com.wb.util.DbUtil.close(connection);
            throw throwable;
        }
        com.wb.util.DbUtil.close(st);
        com.wb.util.DbUtil.close(connection);
    }
}

