/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.wb.util.WebUtil;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.json.JSONException;
import org.json.JSONObject;

public class DocPreviewKit {
    private static Logger logger = Logger.getLogger("DocPreviewKit.class");

    public static void ToPdf(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject resultObject = new JSONObject();
            String inputFilePath = request.getParameter("inputFilePath").trim();
            if (inputFilePath == null || inputFilePath.isEmpty()) {
                WebUtil.send(response, (Object)new JSONObject().put("pdfUrl", (Object)""));
                return;
            }
            String root = request.getSession().getServletContext().getRealPath("/");
            String inputFileRootPath = String.valueOf(root) + inputFilePath;
            if (inputFilePath.endsWith("pdf")) {
                WebUtil.send(response, (Object)new JSONObject().put("pdfUrl", (Object)inputFilePath));
                return;
            }
            String outputFileDirPath = String.valueOf(root) + "pdfDir";
            File pdfDir = new File(outputFileDirPath);
            if (!pdfDir.exists()) {
                pdfDir.mkdirs();
            }
            File inputFile = new File(inputFileRootPath);
            String fileName = inputFile.getName();
            fileName = String.valueOf(fileName.substring(0, fileName.lastIndexOf("."))) + ".pdf";
            String outputFileRootPath = String.valueOf(outputFileDirPath) + "/" + fileName;
            File outputFile = new File(outputFileRootPath);
            DocPreviewKit.convert(inputFile, outputFile);
            String outputFilePath = "./pdfDir/" + fileName;
            WebUtil.send(response, (Object)new JSONObject().put("pdfUrl", (Object)outputFilePath));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void convert(File inputFile, File outputFile) {
        try {
            logger.info("libreOffice\u5f00\u59cb\u8f6c\u6362....................................");
            String libreOfficePath = "C:/Program Files/LibreOffice 5";
            DefaultOfficeManagerConfiguration configuration = new DefaultOfficeManagerConfiguration();
            configuration.setOfficeHome(new File(libreOfficePath));
            configuration.setPortNumber(8100);
            OfficeManager officeManager = configuration.buildOfficeManager();
            officeManager.start();
            OfficeDocumentConverter converter = new OfficeDocumentConverter(officeManager);
            converter.convert(inputFile, outputFile);
            logger.info("libreOffice\u8f6c\u6362\u7ed3\u675f....................................");
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (OfficeException e) {
            e.printStackTrace();
        }
    }
}

