/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.wb.common.KVBuffer;
import com.wb.common.Var;
import com.wb.tool.ExcelObject;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ks.fintech.framework.sql.DbUtils;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomGridExport {
    private static final Logger logger = LoggerFactory.getLogger(CustomGridExport.class);
    public static ConcurrentHashMap<String, Object> varMap = new ConcurrentHashMap(16);
    private static CustomGridExport CustomGridExport = new CustomGridExport();

    public static CustomGridExport getInstance() {
        return CustomGridExport;
    }

    public void customExcelOutput(HttpServletRequest request, ResultSet result) throws Exception {
        QueryCustom query = new QueryCustom();
        query.request = request;
        query.export(result);
    }

    public static void respFile2Client(byte[] data, String fileName, HttpServletRequest request, HttpServletResponse response) {
        try {
            String userAgent = request.getHeader("user-agent").toLowerCase();
            fileName = userAgent.contains("msie") || userAgent.contains("like gecko") ? URLEncoder.encode(fileName, "UTF-8") : new String(fileName.getBytes("UTF-8"), "iso-8859-1");
            response.setCharacterEncoding("utf-8");
            response.setContentType("multipart/form-data");
            response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
            ServletOutputStream fos = response.getOutputStream();
            fos.write(data);
            fos.flush();
            if (fos != null) {
                fos.close();
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    private boolean addRowToSheet(SXSSFWorkbook book, SXSSFSheet sheet, ResultSet resultSet, int startRow, int headerCols, String[] fieldNames, Object[] keyMaps) throws SQLException {
        int maxLimit = -1;
        int index = startRow;
        boolean usefulSheet = false;
        try {
            maxLimit = Var.getInt("sys.service.excel.exportGridMaxRows");
        }
        catch (RuntimeException e) {
            logger.debug("\u4e0d\u9650\u5236excel\u5355sheet\u6700\u5927\u6761\u6570");
        }
        while (resultSet.next()) {
            usefulSheet = true;
            this.createRow(sheet, index, headerCols, fieldNames, keyMaps, resultSet);
            if (++index > maxLimit && maxLimit != -1) {
                return false;
            }
            if (index <= 1000000) continue;
            return true;
        }
        if (!usefulSheet) {
            book.removeSheetAt(book.getSheetIndex((Sheet)sheet));
        }
        return false;
    }

    private void createRow(SXSSFSheet sheet, int index, int headerCols, String[] fieldNames, Object[] keyMaps, ResultSet resultSet) {
        SXSSFRow row = sheet.createRow(index);
        int k = 0;
        while (k < headerCols) {
            String val;
            String columnName = fieldNames[k];
            SXSSFCell cell = row.createCell(k);
            try {
                val = resultSet.getObject(columnName) != null ? resultSet.getObject(columnName) : "";
            }
            catch (Exception e) {
                val = null;
            }
            if (val == null) {
                val = "";
            } else if (keyMaps[k] != null) {
                val = KVBuffer.getValue((Map)keyMaps[k], (Object)val);
            }
            if (val instanceof Number) {
                cell.setCellValue(Double.parseDouble(val.toString()));
            } else if (val instanceof Clob) {
                cell.setCellValue(DbUtils.getClobString((Clob)((Clob)((Object)val))));
            } else {
                cell.setCellValue(val.toString());
            }
            ++k;
        }
    }

    public class QueryCustom {
        public JSONObject reportInfo;
        public String title;
        public JSONArray headers;
        public boolean neptune;
        public HttpServletResponse response;
        public String excelFilePath;
        public FileOutputStream os;
        public HttpServletRequest request;

        public void export(ResultSet result) throws Exception {
            this.initParams();
            this.customExcelOutput(result, this.request);
        }

        private void initParams() {
            String filePath = this.request.getSession().getServletContext().getRealPath("wb/system/tmp/grid_export_excel");
            File excelFile = new File(filePath);
            if (!excelFile.exists()) {
                excelFile.mkdirs();
            }
            String excelName = "data" + UUID.randomUUID().toString().replaceAll("-", "") + ".xlsx";
            this.excelFilePath = String.valueOf(filePath) + File.separator + excelName;
            try {
                this.os = new FileOutputStream(new File(this.excelFilePath));
            }
            catch (FileNotFoundException e) {
                logger.error("", (Throwable)e);
            }
            Map map = (Map)varMap.get(this.request.toString());
            this.reportInfo = (JSONObject)map.get("reportInfo");
            this.title = (String)map.get("title");
            this.headers = (JSONArray)map.get("headers");
            this.neptune = (Boolean)map.get("neptune");
            this.response = (HttpServletResponse)map.get("response");
            varMap.remove(this.request.toString());
        }

        private void customExcelOutput(ResultSet resultSet, HttpServletRequest request) {
            SXSSFWorkbook book = new SXSSFWorkbook(500);
            SXSSFSheet sheet = book.createSheet();
            JSONArray topHtml = this.reportInfo.optJSONArray("topHtml");
            JSONArray srcHeaders = new JSONArray(this.headers.toString());
            int startRow = 0;
            if (topHtml != null) {
                this.createHtml((Sheet)sheet, topHtml);
                startRow = topHtml.length();
                this.title = null;
            }
            if (this.title != null) {
                startRow = 1;
            }
            JSONArray tmpHeaders = new JSONArray(srcHeaders.toString());
            Object[] values = this.createHeaders((Sheet)sheet, tmpHeaders, startRow, this.neptune);
            int headerCols = (Integer)values[0];
            int headerRows = (Integer)values[1];
            JSONArray fields = (JSONArray)values[2];
            if (this.title != null) {
                this.createTitle((Sheet)sheet, this.title, headerCols);
            }
            startRow += headerRows;
            int length = fields.length();
            String[] fieldNames = new String[fields.length()];
            Object[] keyMaps = new Object[length];
            int k = 0;
            while (k < length) {
                JSONObject field = fields.getJSONObject(k);
                fieldNames[k] = field.optString("field");
                String keyName = field.optString("keyName");
                keyMaps[k] = keyName.isEmpty() ? null : KVBuffer.getLangBuffer(request).get(keyName);
                ++k;
            }
            try {
                try {
                    boolean needMoreSheet = true;
                    while (needMoreSheet) {
                        needMoreSheet = CustomGridExport.this.addRowToSheet(book, sheet, resultSet, startRow, headerCols, fieldNames, keyMaps);
                        if (!needMoreSheet) continue;
                        sheet = book.createSheet();
                        startRow = 0;
                        if (topHtml != null) {
                            this.createHtml((Sheet)sheet, topHtml);
                            startRow = topHtml.length();
                            this.title = null;
                        }
                        if (this.title != null) {
                            startRow = 1;
                        }
                        tmpHeaders = new JSONArray(srcHeaders.toString());
                        values = this.createHeaders((Sheet)sheet, tmpHeaders, startRow, this.neptune);
                        headerCols = (Integer)values[0];
                        headerRows = (Integer)values[1];
                        if (this.title != null) {
                            this.createTitle((Sheet)sheet, this.title, headerCols);
                        }
                        startRow += headerRows;
                    }
                    book.write((OutputStream)this.os);
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    try {
                        byte[] eData = FileUtils.readFileToByteArray((File)new File(this.excelFilePath));
                        com.wb.interact.CustomGridExport.respFile2Client(eData, "data.xlsx", request, this.response);
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException e2) {
                                logger.error("", (Throwable)e2);
                            }
                        }
                        book.close();
                        book.dispose();
                        if (this.os != null) {
                            this.os.close();
                            new File(this.excelFilePath).delete();
                        }
                    }
                    catch (IOException e3) {
                        logger.error("", (Throwable)e3);
                    }
                }
            }
            finally {
                try {
                    byte[] eData = FileUtils.readFileToByteArray((File)new File(this.excelFilePath));
                    com.wb.interact.CustomGridExport.respFile2Client(eData, "data.xlsx", request, this.response);
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            logger.error("", (Throwable)e);
                        }
                    }
                    book.close();
                    book.dispose();
                    if (this.os != null) {
                        this.os.close();
                        new File(this.excelFilePath).delete();
                    }
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }

        private void createTitle(Sheet sheet, String title, int headerCols) {
            Row row = sheet.createRow(0);
            Object[] styles = this.createCellStyle(sheet.getWorkbook(), "title");
            row.setHeight(((Short)styles[1]).shortValue());
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, headerCols - 1));
            Cell cell = row.createCell(0);
            cell.setCellStyle((CellStyle)styles[0]);
            cell.setCellValue(title);
        }

        private Object[] createHeaders(Sheet sheet, JSONArray headers, int startRow, boolean neptune) {
            Workbook book = sheet.getWorkbook();
            JSONArray processedHeaders = new JSONArray();
            Object[] values = this.prepareHeaders(sheet, headers, processedHeaders, startRow, neptune);
            Cell cell = null;
            Cell[][] cells = (Cell[][])values[0];
            Object[] styles = this.createCellStyle(book, "header");
            CellStyle baseStyle = (CellStyle)styles[0];
            int j = processedHeaders.length();
            int brCount = 1;
            int i = 0;
            while (i < j) {
                JSONObject header = processedHeaders.getJSONObject(i);
                String text = header.optString("text");
                int count = 1;
                int index = 0;
                while ((index = text.indexOf("<br>", index)) != -1) {
                    index += "<br>".length();
                    ++count;
                }
                brCount = Math.max(count, brCount);
                int x = header.getInt("x");
                int y = header.getInt("y");
                int colspan = Math.max(header.getInt("colspan"), 0);
                int rowspan = Math.max(header.getInt("rowspan"), 0);
                if (colspan > 0 || rowspan > 0) {
                    sheet.addMergedRegion(new CellRangeAddress(y + startRow, y + startRow + rowspan, x, x + colspan));
                }
                cell = cells[x][y];
                CellStyle style = book.createCellStyle();
                style.cloneStyleFrom(baseStyle);
                style.setAlignment(ExcelObject.getAlignment(header.optString("titleAlign"), header.has("child") ? (short)2 : 1));
                cell.setCellStyle(style);
                if (text.contains("span")) {
                    text = StringUtil.replaceAll(text, "<br>", "\n\r");
                    text = StringUtil.replaceAll(text, "<span style=\"color:red\">*</span>", "*");
                    XSSFRichTextString richString = null;
                    if (sheet instanceof XSSFSheet) {
                        richString = new XSSFRichTextString(text);
                    } else if (sheet instanceof HSSFSheet) {
                        richString = new HSSFRichTextString(text);
                    }
                    Font redFont = null;
                    redFont = book.createFont();
                    redFont.setColor((short)10);
                    richString.applyFont(0, 1, redFont);
                    cell.setCellValue((RichTextString)richString);
                } else {
                    cell.setCellValue(StringUtil.replaceAll(text, "<br>", "\n\r"));
                }
                ++i;
            }
            cell.getRow().setHeight((short)(cell.getRow().getHeight() * brCount));
            Object[] result = new Object[]{cells.length, cells[0].length, values[1]};
            return result;
        }

        private Object[] prepareHeaders(Sheet sheet, JSONArray rawHeaders, JSONArray processedHeaders, int startRow, boolean neptune) {
            JSONArray leafs = new JSONArray();
            Object[] result = new Object[2];
            int flexWidth = Var.getInt("sys.service.excel.flexColumnMaxWidth");
            Object[] styles = this.createCellStyle(sheet.getWorkbook(), "header");
            CellStyle style = (CellStyle)styles[0];
            short rowHeight = (Short)styles[1];
            double rate = neptune ? 32.06 : 36.55;
            leafs.put(0);
            this.markParents(leafs, rawHeaders, null, 0);
            int maxDepth = leafs.getInt(0);
            leafs.remove(0);
            int j = leafs.length();
            int i = 0;
            while (i < j) {
                JSONObject node = leafs.getJSONObject(i);
                int width = node.has("width") ? node.getInt("width") : (node.has("flex") ? flexWidth : 100);
                sheet.setColumnWidth(i, (int)((double)width * rate));
                node.put("rowspan", maxDepth - node.getInt("y"));
                do {
                    node.put("colspan", node.getInt("colspan") + 1);
                    if (node.has("x")) continue;
                    node.put("x", i);
                    processedHeaders.put((Object)node);
                } while ((node = (JSONObject)node.opt("parent")) != null);
                ++i;
            }
            Cell[][] cells = new Cell[j][++maxDepth];
            int k = 0;
            while (k < maxDepth) {
                Row row = sheet.createRow(k + startRow);
                row.setHeight(rowHeight);
                int l = 0;
                while (l < j) {
                    Cell cell = row.createCell(l);
                    cell.setCellStyle(style);
                    cells[l][k] = cell;
                    ++l;
                }
                ++k;
            }
            result[0] = cells;
            result[1] = leafs;
            return result;
        }

        private void markParents(JSONArray leafs, JSONArray headers, JSONObject parent, int depth) {
            int j = headers.length();
            leafs.put(0, Math.max(leafs.getInt(0), depth));
            int i = 0;
            while (i < j) {
                JSONArray items;
                JSONObject header = headers.getJSONObject(i);
                header.put("y", depth);
                header.put("colspan", -1);
                header.put("rowspan", -1);
                if (parent != null) {
                    header.put("parent", (Object)parent);
                    parent.put("child", (Object)header);
                }
                if ((items = (JSONArray)header.opt("items")) != null) {
                    this.markParents(leafs, items, header, depth + 1);
                } else {
                    leafs.put((Object)header);
                }
                ++i;
            }
        }

        private Object[] createCellStyle(Workbook book, String type) {
            CellStyle style = book.createCellStyle();
            Font font = book.createFont();
            String fontName = Var.getString("sys.service.excel." + type + ".fontName");
            int fontHeight = Var.getInt("sys.service.excel." + type + ".fontHeight");
            double rowHeight = Var.getDouble("sys.service.excel." + type + ".rowHeight");
            Object[] result = new Object[2];
            if (!fontName.isEmpty()) {
                font.setFontName(fontName);
            }
            font.setBoldweight((short)Var.getInt("sys.service.excel." + type + ".fontWeight"));
            font.setFontHeight((short)fontHeight);
            if (rowHeight < 10.0) {
                rowHeight *= (double)fontHeight;
            }
            if (!"text".equals(type) && Var.getBool("sys.service.excel." + type + ".wrapText")) {
                style.setWrapText(true);
            }
            if ("title".equals(type)) {
                String align = Var.getString("sys.service.excel." + type + ".align");
                if (!align.isEmpty()) {
                    Object[][] alignments = new Object[][]{{"\u5c45\u4e2d", (short)2}, {"\u5de6", (short)1}, {"\u53f3", (short)3}, {"\u5c45\u4e2d\u9009\u62e9", (short)6}, {"\u586b\u5145", (short)4}, {"\u5e38\u89c4", (short)0}, {"\u4e24\u7aef\u5bf9\u9f50", (short)5}};
                    style.setAlignment(((Short)SysUtil.getValue(alignments, align)).shortValue());
                }
            } else if (Var.getBool("sys.service.excel.border")) {
                style.setBorderTop((short)1);
                style.setBorderBottom((short)1);
                style.setBorderLeft((short)1);
                style.setBorderRight((short)1);
            }
            if ("header".equals(type)) {
                String backColor = Var.getString("sys.service.excel.header.backColor");
                style.setWrapText(true);
                if (!"\u9ed8\u8ba4".equals(backColor)) {
                    Object[][] colors = new Object[][]{{"\u9ed8\u8ba4", -1}, {"\u91d1\u8272", HSSFColor.GOLD.index}, {"\u7070\u8272", HSSFColor.GREY_25_PERCENT.index}, {"\u6d45\u9ec4", HSSFColor.LIGHT_YELLOW.index}, {"\u6d45\u68d5", HSSFColor.TAN.index}};
                    style.setFillForegroundColor(((Short)SysUtil.getValue(colors, backColor)).shortValue());
                    style.setFillPattern((short)1);
                }
            }
            style.setVerticalAlignment((short)1);
            style.setFont(font);
            result[0] = style;
            result[1] = Double.valueOf(rowHeight).shortValue();
            return result;
        }

        private void createHtml(Sheet sheet, JSONArray data) {
            Workbook book = sheet.getWorkbook();
            int y = data.length();
            int startIndex = sheet.getLastRowNum();
            if (startIndex > 0) {
                ++startIndex;
            }
            int x = 0;
            while (x < y) {
                JSONObject dataRow = data.optJSONObject(x);
                JSONArray dataCells = dataRow.optJSONArray("items");
                Row row = sheet.createRow(startIndex + x);
                int j = dataCells.length();
                int cellIndex = 0;
                int brCount = 1;
                int i = 0;
                while (i < j) {
                    int fontSize;
                    JSONObject dataCell = dataCells.optJSONObject(i);
                    int colSpan = dataCell.optInt("colSpan");
                    Cell cell = row.createCell(cellIndex);
                    String text = dataCell.optString("value");
                    int count = 1;
                    int index = 0;
                    while ((index = text.indexOf("<br>", index)) != -1) {
                        index += "<br>".length();
                        ++count;
                    }
                    brCount = Math.max(count, brCount);
                    cell.setCellValue(StringUtil.replaceAll(text, "<br>", "\n\r"));
                    CellStyle style = book.createCellStyle();
                    style.setWrapText(true);
                    style.setAlignment(ExcelObject.getAlignment(dataCell.optString("align"), (short)1));
                    style.setVerticalAlignment((short)1);
                    Font font = book.createFont();
                    if ("bold".equals(dataCell.optString("weight"))) {
                        font.setBoldweight((short)700);
                    }
                    if ((fontSize = dataCell.optInt("size")) > 0) {
                        font.setFontHeightInPoints((short)fontSize);
                    }
                    style.setFont(font);
                    cell.setCellStyle(style);
                    int k = 1;
                    while (k < colSpan) {
                        row.createCell(cellIndex + k);
                        ++k;
                    }
                    if (colSpan > 1) {
                        sheet.addMergedRegion(new CellRangeAddress(startIndex + x, startIndex + x, cellIndex, cellIndex + colSpan - 1));
                    }
                    cellIndex += colSpan;
                    ++i;
                }
                row.setHeight((short)(dataRow.optInt("height") * 20 * brCount));
                ++x;
            }
        }
    }
}

