/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.wb.interact.CustomGridExport;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ks.fintech.framework.sql.DbUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class CustomCsvExport {
    private String templateFilePath;
    private static final Log LOG = LogFactory.getLog(CustomCsvExport.class);
    private static final byte[] BOM = new byte[]{-17, -69, -65};
    public static ConcurrentHashMap<String, HashMap<String, Object>> varMap = new ConcurrentHashMap(16);
    private static CustomCsvExport customCsvExport = new CustomCsvExport();

    public static CustomCsvExport getInstance() {
        return customCsvExport;
    }

    private CustomCsvExport() {
    }

    public void customCsvExport(HttpServletRequest request, ResultSet resultSet) throws IOException {
        this.templateFilePath = String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "wb" + File.separator + "template" + File.separator + "templateCsv";
        File folder = new File(this.templateFilePath);
        if (!folder.exists()) {
            folder.mkdir();
        }
        long current = System.currentTimeMillis();
        File file = new File(String.valueOf(this.templateFilePath) + current + ".csv");
        HashMap<String, Object> map = varMap.get(request.toString());
        JSONArray headers = (JSONArray)map.get("headers");
        Object[] objects = this.getFileds(headers);
        JSONArray fileds = (JSONArray)objects[0];
        StringBuilder columnText = (StringBuilder)objects[1];
        String[] keyNames = this.getKeyNames(fileds);
        HttpServletResponse response = (HttpServletResponse)map.get("response");
        CustomCsvExport.generateCsv(resultSet, keyNames, current, this.templateFilePath, columnText);
        CustomGridExport.respFile2Client(FileUtils.readFileToByteArray((File)file), "data.csv", request, response);
        file.delete();
    }

    private static void generateCsv(ResultSet resultSet, String[] headers, long current, String templateFilePath, StringBuilder columnText) throws FileNotFoundException {
        File file = new File(String.valueOf(templateFilePath) + current + ".csv");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                LOG.error((Object)"\u521b\u5efa\u6587\u4ef6\u9519\u8bef", (Throwable)e);
            }
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        try {
            CustomCsvExport.generateHeader(bufferedOutputStream, columnText);
            CustomCsvExport.generateBody(bufferedOutputStream, resultSet, headers);
        }
        catch (SQLException e) {
            LOG.info((Object)"\u7ed3\u679c\u96c6\u65e0\u8be5\u5b57\u6bb5\u4fe1\u606f");
        }
        catch (IOException e) {
            LOG.error((Object)"\u6784\u9020CSV\u9519\u8bef", (Throwable)e);
        }
    }

    private static void generateHeader(BufferedOutputStream bufferedOutputStream, StringBuilder columnText) throws IOException {
        System.out.println(columnText.toString());
        bufferedOutputStream.write(BOM);
        String[] stringArray = columnText.toString().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String header = stringArray[n2];
            bufferedOutputStream.write((String.valueOf(header) + ",").getBytes(StandardCharsets.UTF_8));
            ++n2;
        }
        bufferedOutputStream.write(10);
    }

    private static void generateBody(BufferedOutputStream bufferedOutputStream, ResultSet resultSet, String[] headers) throws IOException, SQLException {
        int i = 0;
        while (resultSet.next()) {
            ++i;
            String[] stringArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                String object;
                String header = stringArray[n2];
                try {
                    Object o = resultSet.getObject(header);
                    object = o == null ? "" : (o instanceof Number ? o.toString() : (o instanceof Clob ? DbUtils.getClobString((Clob)((Clob)o)) : o.toString()));
                }
                catch (Exception e) {
                    LOG.error((Object)"\u83b7\u53d6\u503c\u9519\u8bef", (Throwable)e);
                    object = "";
                }
                bufferedOutputStream.write((String.valueOf(object) + ",").getBytes(StandardCharsets.UTF_8));
                ++n2;
            }
            bufferedOutputStream.write(10);
        }
        LOG.info((Object)("\u7ed3\u679c\u96c6\u5171\u6709\uff1a" + (i + 1) + "\u6761\u6570\u636e"));
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    private String[] getKeyNames(JSONArray fileds) {
        String[] fieldNames = new String[fileds.length()];
        int i = 0;
        while (i < fileds.length()) {
            fieldNames[i] = fileds.getJSONObject(i).optString("field");
            ++i;
        }
        return fieldNames;
    }

    private Object[] getFileds(JSONArray headers) {
        StringBuilder text = new StringBuilder();
        JSONArray leafs = new JSONArray();
        leafs.put(0);
        CustomCsvExport.markParents(leafs, headers, null, 0);
        leafs.remove(0);
        int j = leafs.length();
        int i = 0;
        while (i < j) {
            if (i > 0) {
                text.append(',');
            }
            text.append(leafs.getJSONObject(i).optString("text"));
            ++i;
        }
        Object[] objects = new Object[]{leafs, text};
        return objects;
    }

    private static void markParents(JSONArray leafs, JSONArray headers, JSONObject parent, int depth) {
        int j = headers.length();
        leafs.put(0, Math.max(leafs.getInt(0), depth));
        int i = 0;
        while (i < j) {
            JSONArray items;
            JSONObject header = headers.getJSONObject(i);
            header.put("y", depth);
            header.put("colspan", -1);
            header.put("rowspan", -1);
            if (parent != null) {
                header.put("parent", (Object)parent);
                parent.put("child", (Object)header);
            }
            if ((items = (JSONArray)header.opt("items")) != null) {
                CustomCsvExport.markParents(leafs, items, header, depth + 1);
            } else {
                leafs.put((Object)header);
            }
            ++i;
        }
    }
}

