/*
 * Decompiled with CFR 0.152.
 */
package com.wb.controls.page;

import com.wb.controls.page.AbstractPageHandler;
import com.wb.controls.page.DefaultNotPageHandler;
import com.wb.controls.page.PageHandler;
import com.wb.controls.page.pageprovider.MySqlPageHandler;
import com.wb.controls.page.pageprovider.NetezzaPageHandler;
import com.wb.controls.page.pageprovider.OraclePageHandler;
import com.wb.controls.page.pageprovider.PostgreSQLPageHandler;
import com.wb.util.RDTypeEnum;
import ks.fintech.framework.core.exception.KException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PageHandlerFactory {
    private static Log log = LogFactory.getLog(PageHandlerFactory.class);

    public static PageHandler createPageHandler(RDTypeEnum dbType) throws KException {
        AbstractPageHandler pageHandler = null;
        switch (dbType) {
            case ORACLE: {
                pageHandler = new OraclePageHandler();
                break;
            }
            case MYSQL: {
                pageHandler = new MySqlPageHandler();
                break;
            }
            case POSTGRESQL: {
                pageHandler = new PostgreSQLPageHandler();
                break;
            }
            case NETEZZA: {
                pageHandler = new NetezzaPageHandler();
                break;
            }
            default: {
                log.error((Object)("not support this dbType for page:" + dbType.getRdType()));
                pageHandler = new DefaultNotPageHandler();
            }
        }
        return pageHandler;
    }
}

