/*
 * Decompiled with CFR 0.152.
 */
package com.wb.controls;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.http.HtmlUtil;
import com.wb.controls.Control;
import com.wb.controls.page.PageHandler;
import com.wb.interact.CustomCsvExport;
import com.wb.interact.CustomGridExport;
import com.wb.tool.DataProvider;
import com.wb.util.DbPageUtil;
import com.wb.util.DbUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class DpControl
extends Control {
    private static Log log = LogFactory.getLog(DpControl.class);

    @Override
    public void create() throws Exception {
        this.getContent(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getContent(boolean directOutput) throws Exception {
        PageHandler pageHandler;
        long endIndex;
        long beginIndex;
        if (this.gb("disabled", false)) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        Long totalCount = null;
        String jndi = this.gs("jndi");
        String limitRecords = this.gs("limitRecords");
        String limitExportRecords = this.gs("limitExportRecords");
        String startParam = this.request.getParameter("start");
        String limitParam = this.request.getParameter("limit");
        String type = this.gs("type");
        if (StringUtil.isEmpty(type) || "array".equals(type)) {
            this.setOrderVars();
        }
        String sql = this.gs("sql");
        String totalSql = this.gs("totalSql");
        if (StringUtil.isEmpty(startParam) || !NumberUtil.isInteger((String)startParam)) {
            beginIndex = 1L;
            this.request.setAttribute("start", (Object)0L);
        } else {
            beginIndex = Long.parseLong(startParam) + 1L;
        }
        if (StringUtil.isEmpty(limitParam) || !NumberUtil.isInteger((String)limitParam)) {
            endIndex = Long.MAX_VALUE;
            this.request.setAttribute("limit", (Object)endIndex);
        } else {
            endIndex = beginIndex + Long.parseLong(limitParam) - 1L;
        }
        boolean dealPageSucc = false;
        if (this.isNeedDealPage() && (dealPageSucc = (pageHandler = DbPageUtil.getPageHandler(jndi)).isPage())) {
            totalSql = pageHandler.getTotalPageSql(sql);
            sql = pageHandler.getLimitPageSql(sql, Long.parseLong(startParam), Long.parseLong(limitParam));
        }
        this.request.setAttribute("beginIndex", (Object)beginIndex);
        this.request.setAttribute("endIndex", (Object)endIndex);
        Object result = this.getResult(DbUtil.run(this.request, sql, jndi));
        if (!(result instanceof ResultSet)) {
            String text = StringUtil.concat("{\"total\":1,\"metaData\":{\"fields\":[{\"name\":\"result\",\"type\":\"string\"}]},\"columns\":[{\"xtype\":\"rownumberer\",\"width\":40},{\"dataIndex\":\"result\",flex:1,\"text\":\"result\"}],\"rows\":[{\"result\":", result == null ? "null" : StringUtil.quote(result.toString()), "}],\"elapsed\":", Long.toString(System.currentTimeMillis() - startTime), "}");
            if (!directOutput) return text;
            WebUtil.send(this.response, (Object)text);
            return null;
        }
        ResultSet resultSet = (ResultSet)result;
        if (!StringUtil.isEmpty(totalSql)) {
            Object totalResult = this.getResult(DbUtil.run(this.request, totalSql, jndi));
            if (totalResult == null) {
                throw new NullPointerException("No value in the totalSql.");
            }
            if (totalResult instanceof ResultSet) {
                ResultSet totalResultSet = (ResultSet)totalResult;
                if (!totalResultSet.next()) throw new NullPointerException("Empty total ResultSet.");
                totalCount = Long.parseLong(totalResultSet.getString(1));
            } else {
                totalCount = Long.parseLong(totalResult.toString());
            }
        }
        if ("true".equals((String)this.request.getAttribute("isExportGrid"))) {
            CustomGridExport.getInstance().customExcelOutput(this.request, resultSet);
            return null;
        }
        if ("true".equals(this.request.getAttribute("isExportAllCsv"))) {
            CustomCsvExport.getInstance().customCsvExport(this.request, resultSet);
            return null;
        }
        DataProvider dp = new DataProvider();
        dp.startTime = startTime;
        dp.request = this.request;
        dp.response = this.response;
        dp.resultSet = resultSet;
        dp.fields = this.gs("fields");
        dp.fieldsTag = this.gs("fieldsTag");
        dp.keyDefines = this.gs("keyDefines");
        dp.createColumns = this.gb("createColumns", true);
        if (this.gb("autoPage", true) && !dealPageSucc) {
            dp.beginIndex = beginIndex;
            dp.endIndex = endIndex;
        }
        if (!limitRecords.isEmpty()) {
            int limitMaxRecords = Integer.parseInt(limitRecords);
            dp.limitRecords = limitMaxRecords;
            if (dealPageSucc && limitMaxRecords != -1) {
                if ((long)limitMaxRecords < totalCount) {
                    totalCount = limitMaxRecords;
                }
                dp.endIndex = totalCount - Long.parseLong(startParam);
            }
        }
        if (!limitExportRecords.isEmpty()) {
            dp.limitExportRecords = Integer.parseInt(limitExportRecords);
        }
        dp.totalCount = totalCount;
        dp.tag = this.gs("tag");
        dp.type = type;
        String dictTableNames = this.gs("dictTableNames");
        dp.createKeyValues = this.gb("createKeyValues", false);
        dp.dictTableNames = dictTableNames.isEmpty() ? null : StringUtil.split(dictTableNames, ',', true);
        dp.dictFieldsMap = this.gs("dictFieldsMap");
        if (!directOutput) return dp.getScript();
        dp.output();
        return null;
    }

    private boolean isNeedDealPage() {
        String flag = this.gs("physicalPaging");
        return StringUtils.isNotBlank((String)flag) && "true".equals(flag);
    }

    private Object getResult(Object result) {
        if (result instanceof HashMap) {
            HashMap map = (HashMap)result;
            Set es = map.entrySet();
            String itemId = StringUtil.select(this.gs("itemId"));
            for (Map.Entry e : es) {
                Map.Entry entry = e;
                String name = (String)entry.getKey();
                if (name.equals("return")) {
                    name = itemId;
                } else if (!itemId.isEmpty()) {
                    name = StringUtil.concat(itemId, ".", name);
                }
                this.request.setAttribute(name, entry.getValue());
            }
            Object val = map.get(StringUtil.select(this.gs("resultName"), "result"));
            if (val == null) {
                return map.get("return");
            }
            return val;
        }
        return result;
    }

    private void setOrderVars() throws Exception {
        String sort = this.request.getParameter("sort");
        if (StringUtil.isEmpty(sort) || this.request.getAttribute("sql.orderBy") != null) {
            return;
        }
        JSONArray ja = new JSONArray(sort);
        int j = ja.length();
        if (j > 0) {
            String defaultPrefix;
            JSONObject orderJo;
            StringBuilder exp = new StringBuilder();
            int order = 0;
            String direction = "";
            String orderFields = this.gs("orderFields");
            if (StringUtil.isEmpty(orderFields)) {
                orderJo = null;
                defaultPrefix = null;
            } else {
                orderJo = new JSONObject(orderFields);
                defaultPrefix = orderJo.optString("default", null);
            }
            int i = 0;
            while (i < j) {
                JSONObject jo = ja.getJSONObject(i);
                if (i > 0) {
                    exp.append(',');
                }
                String property = jo.getString("property");
                if (jo.has("sorterIndex")) {
                    order = jo.getInt("sorterIndex");
                }
                if (!StringUtil.checkName(property)) {
                    throw new IllegalArgumentException("Invalid name \"" + HtmlUtil.filter((String)property) + "\".");
                }
                if (orderJo != null) {
                    if (orderJo.has(property)) {
                        String prefix = orderJo.optString(property);
                        if (!prefix.isEmpty()) {
                            exp.append(prefix);
                            exp.append('.');
                        }
                    } else if (defaultPrefix != null) {
                        exp.append(defaultPrefix);
                        exp.append('.');
                    }
                }
                exp.append(property);
                direction = jo.optString("direction");
                if (StringUtil.isSame(direction, "desc")) {
                    exp.append(" desc");
                }
                ++i;
            }
            this.request.setAttribute("I_ORDER_BY", (Object)order);
            this.request.setAttribute("I_ORDER_DIR", (Object)direction);
            this.request.setAttribute("sql.orderBy", (Object)(" order by " + exp));
            this.request.setAttribute("sql.orderFields", (Object)("," + exp));
        }
    }
}

