/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.ks.fintech.bw.api.FunctionEObj;
import com.ks.fintech.bw.support.BwIDE;
import com.wb.common.ResourceUtils;
import com.wb.common.Session;
import com.wb.common.Var;
import com.wb.interact.Controls;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import ks.fintech.bw.api.service.CacheServiceAware;
import ks.fintech.bw.api.service.FunctionContentCacheAware;
import ks.fintech.bw.api.utils.VarUtils;
import ks.fintech.framework.core.exception.KException;
import ks.fintech.framework.utils.SpringContextUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class XwlBuffer {
    private static Log log = LogFactory.getLog(XwlBuffer.class);

    public static JSONObject get(String path) throws IOException {
        return XwlBuffer.get(path, false);
    }

    public static JSONObject get(String path, boolean silent) throws IOException {
        JSONObject jsonObject;
        Object[] obj;
        FunctionEObj function;
        JSONObject root;
        JSONObject moduleNode;
        FunctionContentCacheAware contentCache;
        block12: {
            if (path == null) {
                if (silent) {
                    return null;
                }
                throw new NullPointerException("Module path is not specified.");
            }
            contentCache = (FunctionContentCacheAware)SpringContextUtil.getBean((String)"contentCacheServcie");
            CacheServiceAware cs = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
            moduleNode = null;
            root = new JSONObject();
            function = null;
            obj = null;
            if (!contentCache.isAlredyLoad()) {
                contentCache.load(Long.valueOf(VarUtils.getInstance().getTag()));
            }
            function = cs.getFunctionByPath(path);
            jsonObject = contentCache.getContent(function.getFuncId());
            obj = contentCache.get(function.getFuncId());
            if (jsonObject != null) break block12;
            log.error((Object)("funcId:" + function.getFuncId() + " is not exist!"));
            return null;
        }
        try {
            moduleNode = jsonObject.getJSONObject("configs");
            root.put("hidden", false);
            JSONObject object = new JSONObject(String.valueOf(contentCache.getContent(function.getFuncId())));
            root.put("children", (Object)new JSONArray().put((Object)object));
        }
        catch (KException e) {
            log.info((Object)e);
        }
        String lastModified = null;
        String getInframe = null;
        String getPageLink = null;
        String getFuncIcon = null;
        String getFuncName = null;
        String getQtip = null;
        Long getFuncId = null;
        if (function != null) {
            lastModified = String.valueOf(function.getLastUpdateTms());
            getInframe = function.getInframe();
            getPageLink = function.getPageLink();
            getFuncIcon = function.getFuncIcon();
            getFuncName = function.getFuncName();
            getQtip = function.getQtip();
            getFuncId = function.getFuncId();
        }
        if (obj != null && (Var.uncheckModified || lastModified != null && lastModified.equals(obj[1]))) {
            return (JSONObject)obj[0];
        }
        root.put("roles", (Object)new JSONObject().put("admin", 1));
        root.put("inframe", "1".equals(getInframe));
        root.put("pageLink", (Object)getPageLink);
        root.put("iconCls", (Object)getFuncIcon);
        root.put("title", (Object)getFuncName);
        root.put("qtip", (Object)getQtip);
        if (function == null) {
            log.info((Object)("funcPath:" + path + " is not exist!"));
            throw new NullPointerException("funcPath:" + path + " is not exist!");
        }
        root.put("loginRequired", !"0".equals(function.getLoginRequired()));
        boolean[] libTypes = XwlBuffer.optimize(root, true, String.valueOf(SysUtil.getId()) + ".");
        XwlBuffer.autoSetConfig(moduleNode, libTypes);
        if (moduleNode.optString("loadJS").indexOf("touch") != -1) {
            root.put("hasTouch", true);
        }
        obj = new Object[]{root, String.valueOf(function.getLastUpdateTms())};
        try {
            contentCache.getFuncRunMap().put(function.getFuncId(), obj);
        }
        catch (KException e) {
            log.info((Object)e);
        }
        return root;
    }

    public static void autoSetConfig(JSONObject moduleNode, boolean[] libTypes) {
        String loadJS = (String)moduleNode.opt("loadJS");
        if (loadJS == null) {
            ArrayList<String> libs = new ArrayList<String>();
            if (libTypes[1]) {
                libs.add("ext");
            }
            if (libTypes[2]) {
                libs.add("touch");
            }
            if (libTypes[3]) {
                libs.add("bootstrap");
            }
            moduleNode.put("loadJS", (Object)StringUtil.join(libs, '+'));
        }
    }

    public static void clear(String path) {
    }

    public static synchronized void load() {
    }

    public static boolean[] optimize(JSONObject data, boolean parentRoot, String moduleId) throws IOException {
        JSONArray ja = data.getJSONArray("children");
        int j = ja.length();
        boolean[] libTypes = new boolean[4];
        int l = libTypes.length;
        if (j == 0) {
            data.remove("children");
        } else {
            String parentType = (String)data.opt("type");
            int i = 0;
            while (i < j) {
                JSONObject jo = ja.getJSONObject(i);
                String type = (String)jo.opt("type");
                JSONObject configs = (JSONObject)jo.opt("configs");
                JSONObject meta = Controls.get(type);
                JSONObject general = (JSONObject)meta.opt("general");
                JSONObject tag = (JSONObject)general.opt("tag");
                if (tag != null) {
                    Integer lib = (Integer)tag.opt("lib");
                    if (lib == null) {
                        lib = 0;
                    }
                    libTypes[lib.intValue()] = true;
                }
                JSONObject autoNames = (JSONObject)general.opt("autoNames");
                Object isConfig = configs.opt("isConfig");
                boolean asConfig = !parentRoot && autoNames != null && isConfig == null && (autoNames.has(parentType) || autoNames.has("any")) ? true : "true".equals(isConfig);
                if (asConfig) {
                    JSONArray children;
                    JSONObject configItems = (JSONObject)data.opt("__configs");
                    if (configItems == null) {
                        configItems = new JSONObject();
                        children = new JSONArray();
                        configItems.put("children", (Object)children);
                        data.put("__configs", (Object)configItems);
                    } else {
                        children = (JSONArray)configItems.opt("children");
                    }
                    children.put((Object)jo);
                    ja.remove(i);
                    --i;
                    --j;
                }
                if ("module".equals(type)) {
                    configs.put("id", (Object)moduleId);
                } else if ("serverscript".equals(type)) {
                    configs.put("id", (Object)StringUtil.concat(moduleId, SysUtil.getId()));
                }
                jo.remove("expanded");
                boolean[] subLibTypes = XwlBuffer.optimize(jo, Boolean.TRUE.equals(general.opt("root")), moduleId);
                int k = 0;
                while (k < l) {
                    if (subLibTypes[k]) {
                        libTypes[k] = true;
                    }
                    ++k;
                }
                ++i;
            }
            if (j == 0) {
                data.remove("children");
            }
        }
        return libTypes;
    }

    public static boolean canDisplay(File file, String[] roles, int type) throws Exception {
        if (file.isDirectory()) {
            File[] files;
            File configFile = new File(file, "folder.json");
            if (configFile.exists()) {
                JSONObject content = JsonUtil.readObject(configFile);
                if (type != 3 && Boolean.TRUE.equals(content.opt("hidden"))) {
                    return false;
                }
            }
            File[] fileArray = files = FileUtil.listFiles(file);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                if (XwlBuffer.canDisplay(subFile, roles, type)) {
                    return true;
                }
                ++n2;
            }
        } else if (file.getName().endsWith(".xwl")) {
            JSONObject content = XwlBuffer.get(FileUtil.getModulePath(file), false);
            if (type != 3 && (content.has("hasTouch") ? type == 1 && !Var.homeShowApp : type == 2)) {
                return false;
            }
            if ((type == 3 || Boolean.FALSE.equals(content.opt("hidden"))) && XwlBuffer.canAccess(content, roles, FileUtil.getModulePath(file))) {
                return true;
            }
        }
        return false;
    }

    public static boolean canAccess(JSONObject module, String[] roles, String path) throws KException {
        return BwIDE.canAccess((JSONObject)module, (String[])roles, (String)path);
    }

    public static boolean canAccess(HttpServletRequest request, String path) throws Exception {
        if (request == null || path == null) {
            return false;
        }
        JSONObject module = XwlBuffer.get(FileUtil.getModuleFile(path), false);
        String[] roles = Session.getRoles(request);
        return XwlBuffer.canAccess(module, roles, FileUtil.getModuleFile(path));
    }

    public static boolean canAccess(HttpSession session, String path) throws Exception {
        if (session == null || path == null) {
            return false;
        }
        JSONObject module = XwlBuffer.get(FileUtil.getModuleFile(path));
        String[] roles = (String[])session.getAttribute("sys.roles");
        return XwlBuffer.canAccess(module, roles, FileUtil.getModuleFile(path));
    }

    public static boolean resourceCanAccess(HttpServletRequest request, String itemId, String funcId) throws Exception {
        if (request == null || itemId == null) {
            return false;
        }
        ArrayList whiteResources = (ArrayList)WebUtil.fetchObject(request, "sys.resource.perms.white");
        ArrayList blackResources = (ArrayList)WebUtil.fetchObject(request, "sys.resource.perms.black");
        return ResourceUtils.resourceCanAccess(whiteResources, blackResources, itemId, funcId, Session.getRoles(request));
    }
}

