/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.common.SessionBridge;
import com.wb.common.Var;
import com.wb.tool.Console;
import com.wb.tool.HttpSessionConfig;
import com.wb.util.SysUtil;
import com.wb.util.WbUtil;
import com.wb.util.WebUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

@ServerEndpoint(value="/s", configurator=HttpSessionConfig.class)
public class WebSocket {
    private HttpSession httpSession;
    private String xwl;
    private String name;
    static Log log = LogFactory.getLog(WebSocket.class);

    @OnMessage
    public void onMessage(String message, Session session) throws Throwable {
        try {
            JSONObject params = new JSONObject();
            params.put("data", (Object)message);
            params.put("xwl", (Object)this.xwl);
            params.put("session", (Object)session);
            params.put("httpSession", (Object)this.httpSession);
            WebUtil.sendSocketText(session, WbUtil.run(this.xwl, params, true), true, true);
        }
        catch (Throwable e) {
            this.showException(e);
            WebUtil.sendSocketText(session, SysUtil.getRootError(e), false, true);
        }
    }

    @OnOpen
    public void onOpen(Session session, EndpointConfig conf) {
        try {
            if (!Var.getBool("sys.webSocketIsOpen", true)) {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, "Is it enabled webSocket"));
                log.info((Object)"webSocket is close,code is 1003,reason is(Is it enabled webSocket)");
                return;
            }
            Map map = session.getRequestParameterMap();
            Object value = conf.getUserProperties().get("WbHttpSession");
            List paramList = (List)map.get("xwl");
            this.xwl = paramList != null && paramList.size() > 0 ? String.valueOf((String)paramList.get(0)) + ".xwl" : ((paramList = (List)map.get("xwls")) != null && paramList.size() > 0 ? (String)paramList.get(0) : null);
            paramList = (List)map.get("name");
            this.name = paramList != null && paramList.size() > 0 ? (String)paramList.get(0) : this.xwl;
            this.httpSession = value instanceof HttpSession ? (HttpSession)value : null;
            if (WbUtil.canAccess(this.httpSession, this.xwl)) {
                SessionBridge.addSession(this.httpSession, session, this.name);
            } else {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, "You do not have permission to access \"" + this.xwl + "\"."));
            }
        }
        catch (Throwable e) {
            try {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, SysUtil.getRootError(e)));
            }
            catch (Throwable ex) {
                log.error((Object)"", ex);
            }
            this.showException(e);
        }
    }

    @OnClose
    public void onClose(Session session, CloseReason reason) {
        if (this.httpSession != null) {
            try {
                SessionBridge.removeSession(this.httpSession, session, this.name);
            }
            catch (Throwable e) {
                log.error((Object)"", e);
            }
            this.httpSession = null;
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        if (Var.showSocketError) {
            this.showException(error);
        }
    }

    private void showException(Throwable exception) {
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter((Writer)writer, true);
        exception.printStackTrace(pwriter);
        pwriter.close();
        String errorMessage = writer.toString();
        Console.printToClient(this.httpSession, (Object)errorMessage, "error", false);
        if (Var.printError) {
            System.err.println(errorMessage);
        }
    }
}

