/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.common.Var;
import com.wb.splogic.util.RunSqlLogic;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class UserList {
    static Log log = LogFactory.getLog(UserList.class);
    private static HashMap<String, HashSet<HttpSession>> users = new HashMap();

    public static void add(String userId, HttpSession session) {
        if (Var.recordSession) {
            UserList.doAdd(userId, session);
        }
    }

    public static boolean isValidateUserSession(String userId, String sessionId) {
        HashSet<HttpSession> sessions = users.get(userId);
        if (sessions == null || sessions.size() == 0) {
            return false;
        }
        for (HttpSession session : sessions) {
            if (!session.getId().equals(sessionId)) continue;
            return true;
        }
        return false;
    }

    private static synchronized void doAdd(String userId, HttpSession session) {
        HashSet<Object> sessions = users.get(userId);
        if (sessions == null) {
            sessions = new HashSet();
            users.put(userId, sessions);
        }
        sessions.add(session);
    }

    public static void remove(String userId, HttpSession session) {
        if (Var.recordSession) {
            UserList.doRemove(userId, session);
        }
    }

    private static synchronized void doRemove(String userId, HttpSession session) {
        HashSet<HttpSession> sessions = users.get(userId);
        if (sessions != null && session != null) {
            sessions.remove(session);
            if (sessions.isEmpty()) {
                users.remove(userId);
            }
        }
    }

    public static void invalidate(String[] userIds) {
        if (Var.recordSession) {
            UserList.doInvalidate(userIds);
        }
    }

    private static synchronized void doInvalidate(String[] userIds) {
        if (userIds != null) {
            String[] stringArray = userIds;
            int n = userIds.length;
            int n2 = 0;
            while (n2 < n) {
                String userId = stringArray[n2];
                HashSet<HttpSession> sessions = users.get(userId);
                if (sessions != null) {
                    HttpSession[] sessionArray;
                    HttpSession[] httpSessionArray = sessionArray = sessions.toArray(new HttpSession[sessions.size()]);
                    int n3 = sessionArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        HttpSession session = httpSessionArray[n4];
                        try {
                            session.invalidate();
                        }
                        catch (Throwable throwable) {
                            log.error((Object)"", throwable);
                        }
                        ++n4;
                    }
                    users.remove(userId);
                }
                ++n2;
            }
        }
    }

    public static void update(String userId, String[] roles, boolean status) {
        if (Var.recordSession) {
            UserList.doUpdate(userId, roles, status);
        }
    }

    private static synchronized void doUpdate(String userId, String[] roles, boolean status) {
        HashSet<HttpSession> sessions = users.get(userId);
        if (sessions != null) {
            if (status) {
                sessions.forEach(session -> {
                    try {
                        session.setAttribute("sys.roles", (Object)roles);
                        session.setAttribute("sys.roleList", (Object)StringUtil.join(roles, ','));
                    }
                    catch (Throwable var7) {
                        log.error((Object)"", var7);
                    }
                });
            } else {
                String[] userIds = new String[]{userId};
                UserList.invalidate(userIds);
            }
        }
    }

    public static synchronized HttpSession[] getSessions(String userId) {
        HashSet<HttpSession> sessions = users.get(userId);
        return sessions == null ? null : sessions.toArray(new HttpSession[sessions.size()]);
    }

    public static synchronized String[] getUsers() {
        return users.keySet().toArray(new String[users.size()]);
    }

    public static void getSessionList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (Var.recordSession) {
            UserList.doGetSessionList(request, response);
        }
    }

    private static synchronized void doGetSessionList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String user = request.getParameter("user");
        int start = Integer.parseInt(request.getParameter("start"));
        int limit = Integer.parseInt(request.getParameter("limit"));
        int index = -1;
        JSONArray rows = new JSONArray();
        HashSet<HttpSession> sessions = users.get(user);
        if (limit > Var.limitRecords) {
            limit = Var.limitRecords;
        }
        int end = start + limit;
        if (sessions != null) {
            for (HttpSession session : sessions) {
                if (++index < start) continue;
                if (index >= end) break;
                JSONObject row = new JSONObject();
                try {
                    row.put("ip", session.getAttribute("sys.ip"));
                    row.put("userAgent", session.getAttribute("sysx.userAgent"));
                    row.put("createDate", (Object)new Date(session.getCreationTime()));
                    row.put("lastAccessDate", (Object)new Date(session.getLastAccessedTime()));
                    rows.put((Object)row);
                }
                catch (Throwable throwable) {
                    log.error((Object)"", throwable);
                    --index;
                }
            }
        }
        JSONObject result = new JSONObject();
        result.put("rows", (Object)rows);
        result.put("total", sessions == null ? 0 : sessions.size());
        WebUtil.send(response, (Object)result);
    }

    public static void getUserList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (Var.recordSession) {
            UserList.doGetUserList(request, response);
        }
    }

    private static JSONObject getDeptList() throws Exception {
        String sql = "select DEPT_ID,DEPT_NAME FROM WB_DEPT";
        List<Map<String, Object>> list = RunSqlLogic.getResultSet(sql, null);
        JSONObject deptObject = new JSONObject();
        for (Map<String, Object> map : list) {
            deptObject.put(map.get("DEPT_ID").toString(), map.get("DEPT_NAME"));
        }
        return deptObject;
    }

    private static synchronized void doGetUserList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int start = Integer.parseInt(request.getParameter("start"));
        int limit = Integer.parseInt(request.getParameter("limit"));
        int index = -1;
        JSONArray rows = new JSONArray();
        JSONObject deptObject = UserList.getDeptList();
        Set<Map.Entry<String, HashSet<HttpSession>>> es = users.entrySet();
        if (limit > Var.limitRecords) {
            limit = Var.limitRecords;
        }
        int end = start + limit;
        for (Map.Entry<String, HashSet<HttpSession>> e : es) {
            if (++index < start) continue;
            if (index >= end) break;
            HashSet<HttpSession> sessions = e.getValue();
            int sessionCount = 0;
            HttpSession session = null;
            for (HttpSession sess : sessions) {
                if (session == null) {
                    session = sess;
                }
                ++sessionCount;
            }
            if (sessionCount == 0) continue;
            JSONObject row = new JSONObject();
            row.put("sessionCount", sessionCount);
            row.put("user", (Object)e.getKey());
            row.put("username", session.getAttribute("sys.username"));
            row.put("dispname", session.getAttribute("sys.dispname"));
            row.put("ip", session.getAttribute("sys.ip"));
            row.put("userAgent", session.getAttribute("sysx.userAgent"));
            Object orgNum = session.getAttribute("sys.orgNum");
            if (orgNum != null) {
                String deptId = orgNum.toString();
                row.put("deptId", (Object)deptId);
                row.put("deptname", (Object)deptObject.getString(deptId));
            }
            rows.put((Object)row);
        }
        JSONObject result = new JSONObject();
        result.put("rows", (Object)rows);
        result.put("total", users.size());
        WebUtil.send(response, (Object)result);
    }
}

