/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.common.SysConfigOperator;
import com.wb.common.Var;
import com.wb.util.FileUtil;
import com.wb.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import ks.fintech.framework.core.exception.KException;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class UrlBuffer {
    public static ConcurrentHashMap<String, String> buffer;
    private static String CONFIG_TYPE;

    static {
        CONFIG_TYPE = "url";
    }

    public static String get(String url) {
        return buffer.get(url);
    }

    public static void put(String url, String path) {
        buffer.put(url, path);
    }

    public static boolean exists(String url, File file) throws IOException {
        if (!StringUtil.isEmpty(url)) {
            String urlPath = UrlBuffer.get(String.valueOf('/') + url);
            String relPath = file == null ? null : FileUtil.getModulePath(file);
            if (!(urlPath == null || relPath != null && StringUtil.isSame(urlPath, relPath))) {
                return false;
            }
        }
        return true;
    }

    public static boolean remove(String path) {
        Set<Map.Entry<String, String>> es = buffer.entrySet();
        boolean result = false;
        String delPath = StringUtil.concat(path, "/");
        for (Map.Entry<String, String> e : es) {
            String key = e.getKey();
            String modulePath = StringUtil.concat(e.getValue(), "/");
            if (!modulePath.startsWith(delPath) || key.length() <= 1) continue;
            buffer.remove(key);
            if (result) continue;
            result = true;
        }
        return result;
    }

    public static synchronized void load() {
        try {
            UrlBuffer.checkTableExist();
            ConcurrentHashMap<String, String> tempBuffer = new ConcurrentHashMap<String, String>();
            JSONObject object = UrlBuffer.readUrlConfig();
            Set es = object.entrySet();
            for (Map.Entry e : es) {
                tempBuffer.put((String)e.getKey(), (String)e.getValue());
            }
            String portal = Var.getString("sys.portal");
            if (portal.endsWith(".xwl")) {
                tempBuffer.put("/", portal);
            } else {
                tempBuffer.put("/", (String)tempBuffer.get("/" + portal));
            }
            tempBuffer.put("/m", "");
            buffer = tempBuffer;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void save() throws Exception {
        Set<Map.Entry<String, String>> es = buffer.entrySet();
        JSONObject object = new JSONObject();
        for (Map.Entry<String, String> e : es) {
            String key = e.getKey();
            if (key.equals("/") || key.equals("/m")) continue;
            object.put(key, (Object)e.getValue());
        }
        UrlBuffer.writeUrlConfig(object.toString());
    }

    public static String find(File file) {
        String path = FileUtil.getModulePath(file);
        if (path == null) {
            return null;
        }
        Set<Map.Entry<String, String>> es = buffer.entrySet();
        for (Map.Entry<String, String> e : es) {
            String key = e.getKey();
            if (!path.equals(e.getValue()) || key.equals("/")) continue;
            return key.substring(1);
        }
        return null;
    }

    public static boolean change(String src, String dest, boolean isDir) {
        Set<Map.Entry<String, String>> es = buffer.entrySet();
        int srcLen = src.length() + 1;
        boolean result = false;
        src = String.valueOf(src) + '/';
        if (isDir) {
            dest = String.valueOf(dest) + '/';
        }
        for (Map.Entry<String, String> e : es) {
            String key = e.getKey();
            String value = e.getValue();
            String path = StringUtil.concat(value, "/");
            if (!path.startsWith(src)) continue;
            if (isDir) {
                buffer.put(key, String.valueOf(dest) + value.substring(srcLen));
            } else {
                buffer.put(key, dest);
            }
            if (result) continue;
            result = true;
        }
        return result;
    }

    public static void deleteFileUrl(String files) throws KException {
        String[] filePaths;
        files = files.substring(1, files.length() - 1).replaceAll("\"", "");
        String[] stringArray = filePaths = files.split(",");
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String filePath = stringArray[n2];
            if ((filePath = UrlBuffer.getModulePath(filePath)).contains(".xwl")) {
                UrlBuffer.deleteFunc(filePath);
            } else {
                UrlBuffer.deleteMenu(filePath);
            }
            ++n2;
        }
    }

    private static void deleteFunc(String filePath) throws KException {
        String url = UrlBuffer.getUrl(filePath);
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        buffer.remove(url);
    }

    private static void deleteMenu(String filePath) throws KException {
        Set<Map.Entry<String, String>> urls = buffer.entrySet();
        for (Map.Entry<String, String> entry : urls) {
            String path = entry.getValue();
            if (!path.startsWith(filePath)) continue;
            String url = entry.getKey();
            buffer.remove(url);
        }
    }

    public static void moveFileUrl(String src, String dest) throws KException {
        String[] filePaths;
        dest = UrlBuffer.getModulePath(dest);
        src = src.substring(1, src.length() - 1).replaceAll("\"", "");
        String[] stringArray = filePaths = src.split(",");
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String filePath = stringArray[n2];
            if ((filePath = UrlBuffer.getModulePath(filePath)).contains(".xwl")) {
                UrlBuffer.moveFunc(filePath, dest);
            } else {
                UrlBuffer.moveMenu(filePath, dest);
            }
            ++n2;
        }
    }

    private static void moveFunc(String src, String dest) throws KException {
        String url = UrlBuffer.getUrl(src);
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        String newPath = String.valueOf(dest) + UrlBuffer.getXwlName(src);
        buffer.put(url, newPath);
    }

    private static void moveMenu(String src, String dest) throws KException {
        Set<Map.Entry<String, String>> urls = buffer.entrySet();
        for (Map.Entry<String, String> entry : urls) {
            String path = entry.getValue();
            if (!path.startsWith(src)) continue;
            String newPath = UrlBuffer.prefixReplace(src, path, dest);
            String url = entry.getKey();
            buffer.put(url, newPath);
        }
    }

    public static String getUrl(String path) {
        for (Map.Entry<String, String> entry : buffer.entrySet()) {
            String value = entry.getValue();
            if (!StringUtils.equalsIgnoreCase((CharSequence)path, (CharSequence)value)) continue;
            return entry.getKey();
        }
        return "";
    }

    private static void checkTableExist() {
        SysConfigOperator.checkTableExist();
    }

    public static JSONObject readUrlConfig() {
        return SysConfigOperator.readConfig(CONFIG_TYPE);
    }

    public static void writeUrlConfig(String urlContent) {
        SysConfigOperator.writeConfig(CONFIG_TYPE, urlContent);
    }

    public static void refreshCache() {
        ConcurrentHashMap<String, String> tempBuffer = new ConcurrentHashMap<String, String>();
        try {
            JSONObject object = UrlBuffer.readUrlConfig();
            Set es = object.entrySet();
            for (Map.Entry e : es) {
                tempBuffer.put((String)e.getKey(), (String)e.getValue());
            }
            String portal = Var.getString("sys.portal");
            if (portal.endsWith(".xwl")) {
                tempBuffer.put("/", portal);
            } else {
                tempBuffer.put("/", (String)tempBuffer.get("/" + portal));
            }
            tempBuffer.put("/m", "");
            buffer = tempBuffer;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static String getModulePath(String path) {
        String xwl = path;
        int index = (path = UrlBuffer.clean(path)).indexOf("modules/");
        if (index != -1) {
            xwl = path.substring(index + 8, path.length());
        }
        return xwl;
    }

    private static String clean(String input) {
        while (input.indexOf("\\") > 0) {
            input = StringUtils.replace((String)input, (String)"\\", (String)"/");
        }
        while (input.indexOf("//") > 0) {
            input = StringUtils.replace((String)input, (String)"//", (String)"/");
        }
        return input;
    }

    private static String prefixReplace(String src, String path, String dest) {
        int prefix = src.lastIndexOf("/");
        if (prefix != -1) {
            String pre = src.substring(0, prefix);
            return path.replace(pre, dest);
        }
        return String.valueOf(dest) + "/" + path;
    }

    private static String getXwlName(String xwlPath) {
        int index = xwlPath.lastIndexOf("/");
        return xwlPath.substring(index, xwlPath.length());
    }
}

