/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.common.SysConfigDbOperator;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import java.io.File;
import ks.fintech.framework.sql.SqlExecutor;
import ks.fintech.framework.utils.PathUtil;
import ks.fintech.framework.utils.SpringContextUtil;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysConfigOperator {
    private static Logger log = LoggerFactory.getLogger(SysConfigOperator.class);
    private static volatile int dataSource = 0;

    public static int getDataSource() {
        return dataSource;
    }

    public static void setSysConfigFromDb() {
        dataSource = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkTableExist() {
        if (dataSource != 0) return;
        Class<SysConfigOperator> clazz = SysConfigOperator.class;
        synchronized (SysConfigOperator.class) {
            if (dataSource != 0) return;
            try {
                SqlExecutor sqlExecutor = (SqlExecutor)SpringContextUtil.getBean((String)"sqlExecutor");
                String sql = "select * from ks_sys_config";
                sqlExecutor.queryMapList(sql, null);
                dataSource = 1;
                SysConfigDbOperator.initTableData("var", SysConfigOperator.getSysConfigFilePath("var"));
                SysConfigDbOperator.initTableData("url", SysConfigOperator.getSysConfigFilePath("url"));
                SysConfigDbOperator.initTableData("controls", SysConfigOperator.getSysConfigFilePath("controls"));
            }
            catch (Exception e) {
                String msg = e.toString();
                dataSource = msg.contains("\u8868\u6216\u89c6\u56fe\u4e0d\u5b58\u5728") || msg.contains("ORA-00942") ? 2 : (msg.contains("Table") && msg.contains("doesn't exist") ? 2 : 2);
            }
            return;
        }
    }

    public static JSONObject readConfig(String configType) {
        try {
            switch (dataSource) {
                case 1: {
                    return SysConfigDbOperator.readSysConfig(configType);
                }
                case 2: {
                    return JsonUtil.readObject(new File(SysConfigOperator.getSysConfigFilePath(configType)));
                }
            }
            return JsonUtil.readObject(new File(SysConfigOperator.getSysConfigFilePath(configType)));
        }
        catch (Exception e) {
            log.error("read {}.json error", (Object)configType, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static void writeConfig(String configType, String content) {
        try {
            switch (dataSource) {
                case 1: {
                    SysConfigDbOperator.writeSysConfig(configType, content);
                    break;
                }
                case 2: {
                    FileUtil.syncSave(new File(SysConfigOperator.getSysConfigFilePath(configType)), content);
                    break;
                }
                default: {
                    FileUtil.syncSave(new File(SysConfigOperator.getSysConfigFilePath(configType)), content);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("write {}.json error", (Object)configType, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static String getSysConfigFilePath(String configType) {
        String sep = File.separator;
        String filePath = String.valueOf(PathUtil.getWebContent()) + sep + "wb" + sep + "system" + sep + configType + ".json";
        return filePath;
    }

    public static String getRelFilePath(String relFilePath) {
        String sep = File.separator;
        String filePath = String.valueOf(PathUtil.getWebContent()) + sep + relFilePath;
        return filePath;
    }
}

