/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.common.ProductTagOperator;
import java.io.File;
import java.sql.Clob;
import java.sql.Timestamp;
import java.util.Map;
import ks.fintech.bw.api.utils.CacheSynOperator;
import ks.fintech.framework.core.exception.KException;
import ks.fintech.framework.core.exception.KRuntimeException;
import ks.fintech.framework.sql.DbUtils;
import ks.fintech.framework.sql.SqlExecutor;
import ks.fintech.framework.utils.DateUtils;
import ks.fintech.framework.utils.SpringContextUtil;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysConfigDbOperator {
    private static Logger log = LoggerFactory.getLogger(SysConfigDbOperator.class);
    private static SqlExecutor sqlExecutor = (SqlExecutor)SpringContextUtil.getBean((String)"sqlExecutor");
    private static String SYN_TYPE = "sys_config";
    public static Timestamp cacheUpdateTime = null;
    private static long PRODUCT_TAG = ProductTagOperator.readProductTag();

    public static void initTableData(String configType, String path) throws KException {
        try {
            String selSql = "SELECT config_content FROM ks_sys_config WHERE config_type=? and product_tag=?";
            Map map = sqlExecutor.queryMap(selSql, new Object[]{configType, PRODUCT_TAG});
            if (map == null) {
                String content = FileUtils.readFileToString((File)new File(path), (String)"utf-8");
                String insSql = "INSERT INTO ks_sys_config(config_id,config_content,config_type,update_time,product_tag) values(?,?,?,?,?)";
                Object[] params = new Object[]{System.currentTimeMillis(), content, configType, DateUtils.getCurrentTimestamp(), PRODUCT_TAG};
                sqlExecutor.update(insSql, params);
            }
        }
        catch (Exception e) {
            log.error("Init table[ks_sys_config] error", (Throwable)e);
            throw new KException((Throwable)e);
        }
    }

    public static JSONObject readSysConfig(String configType) {
        String sql = "SELECT config_content FROM ks_sys_config WHERE config_type=? and product_tag=?";
        Map map = sqlExecutor.queryMap(sql, new Object[]{configType, PRODUCT_TAG});
        Object configContent = map.get("CONFIG_CONTENT");
        String content = "";
        if (configContent != null) {
            if (configContent instanceof Clob) {
                Clob clob = (Clob)configContent;
                content = DbUtils.getClobString((Clob)clob);
            } else {
                content = configContent.toString();
            }
        }
        return new JSONObject(content);
    }

    public static synchronized void writeSysConfig(String configType, String content) {
        Timestamp lastChangeTime = SysConfigDbOperator.getLastChangeTime();
        if (lastChangeTime.getTime() > cacheUpdateTime.getTime()) {
            throw new KRuntimeException("Local cache invalid, write failed");
        }
        String sql = "UPDATE ks_sys_config SET config_content=?,update_time=? WHERE config_type=? AND product_tag=?";
        Object[] params = new Object[4];
        params[0] = content;
        Timestamp ts = DateUtils.getCurrentTimestamp();
        params[1] = ts;
        params[2] = configType;
        params[3] = PRODUCT_TAG;
        int ret = sqlExecutor.update(sql, params);
        if (ret < 0) {
            log.warn("Update ks_sys_config table failed");
            throw new KRuntimeException();
        }
        SysConfigDbOperator.synLastUpdateTime(ts);
    }

    private static void synLastUpdateTime(Timestamp ts) {
        SysConfigDbOperator.synDbUpdateTime(ts);
        cacheUpdateTime = ts;
    }

    public static void synCacheAndDbUpdateTime() {
        Timestamp ts = DateUtils.getCurrentTimestamp();
        SysConfigDbOperator.synDbUpdateTime(ts);
        cacheUpdateTime = ts;
    }

    public static Timestamp getLastChangeTime() {
        return CacheSynOperator.getLastChangeTime((SqlExecutor)sqlExecutor, (String)SYN_TYPE);
    }

    private static void synDbUpdateTime(Timestamp ts) {
        CacheSynOperator.synDbUpdateTime((SqlExecutor)sqlExecutor, (Timestamp)ts, (String)SYN_TYPE);
    }

    public static void initSynData() {
        cacheUpdateTime = CacheSynOperator.initSynData((SqlExecutor)sqlExecutor, (String)SYN_TYPE);
    }
}

