/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.common.Base;
import com.wb.common.Var;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;

public class Str {
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, String>> wbLang;
    private static ConcurrentHashMap<String, String> extLang;
    private static ConcurrentHashMap<String, String> touchLangList;
    private static ConcurrentHashMap<String, String> langMap;

    public static String format(String key, Object ... args) {
        return Str.langFormat(Var.defaultLanguage, key, args);
    }

    public static String format(HttpServletRequest request, String key, Object ... args) {
        return Str.langFormat(Str.getLanguage(request), key, args);
    }

    private static String optLang(ConcurrentHashMap<String, ?> map, String lang) {
        if (!StringUtil.isEmpty(lang)) {
            if (map.containsKey(lang)) {
                return lang;
            }
            int pos = lang.indexOf(95);
            if (pos != -1 && map.containsKey(lang = lang.substring(0, pos))) {
                return lang;
            }
        }
        return Var.defaultLanguage;
    }

    public static String optLanguage(String lang) {
        return Str.optLang(wbLang, lang);
    }

    public static String optExtLanguage(String lang) {
        return Str.optLang(extLang, lang);
    }

    public static String optTouchLanguage(String lang) {
        return Str.optLang(touchLangList, lang);
    }

    public static String getLanguage(HttpServletRequest request) {
        String useLang = (String)request.getAttribute("sys.useLang");
        if (useLang != null) {
            return useLang;
        }
        useLang = Str.optLanguage(Str.getClientLanguage(request));
        request.setAttribute("sys.useLang", (Object)useLang);
        return useLang;
    }

    public static String getText(HttpServletRequest request, String string) {
        if (!StringUtil.isEmpty(string) && string.startsWith("Str.")) {
            return Str.format(request, string.substring(4), new Object[0]);
        }
        return string;
    }

    public static String getClientLanguage(HttpServletRequest request) {
        String sessionLan;
        String setLan = (String)request.getAttribute("sys.clientLang");
        if (setLan != null) {
            return setLan;
        }
        HttpSession session = request.getSession(false);
        setLan = Var.language;
        if (session != null && !StringUtil.isEmpty(sessionLan = (String)session.getAttribute("sys.lang"))) {
            setLan = sessionLan;
        }
        if (setLan.equals("auto")) {
            setLan = Var.defaultLanguage;
            String acceptLang = request.getHeader("Accept-Language");
            if (acceptLang != null) {
                String language;
                String mappedLang;
                int pos = acceptLang.indexOf(44);
                if (pos != -1) {
                    acceptLang = acceptLang.substring(0, pos);
                }
                if ((pos = acceptLang.indexOf(59)) != -1) {
                    acceptLang = acceptLang.substring(0, pos);
                }
                setLan = (pos = acceptLang.indexOf(45)) == -1 ? acceptLang.toLowerCase() : ((mappedLang = langMap.get(language = StringUtil.concat(acceptLang.substring(0, pos).toLowerCase(), "_", acceptLang.substring(pos + 1).toUpperCase()))) == null ? language : mappedLang);
            }
        }
        request.setAttribute("sys.clientLang", (Object)setLan);
        return setLan;
    }

    public static String getMappedLang(String lang) {
        return langMap.get(lang);
    }

    public static String langFormat(String lang, String key, Object ... args) {
        ConcurrentHashMap<String, String> buffer = wbLang.get(Str.optLanguage(lang));
        if (buffer == null) {
            return key;
        }
        String str = buffer.get(key);
        if (str == null) {
            return key;
        }
        int i = 0;
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            str = StringUtil.replaceAll(str, "{" + i++ + "}", object == null ? "null" : object.toString());
            ++n2;
        }
        return str;
    }

    public static String format(HttpServletRequest request, String key) {
        ConcurrentHashMap<String, String> buffer = wbLang.get(Str.optLanguage(WebUtil.fetch(request, "sys.lang")));
        if (buffer == null) {
            return key;
        }
        String str = buffer.get(key);
        if (str == null) {
            return key;
        }
        return str;
    }

    public static String format(String key, String lang) {
        ConcurrentHashMap<String, String> buffer = wbLang.get(Str.optLanguage(lang));
        if (buffer == null) {
            return key;
        }
        String str = buffer.get(key);
        if (str == null) {
            return key;
        }
        return str;
    }

    public static synchronized void load() {
        try {
            String name;
            File file;
            langMap = new ConcurrentHashMap();
            wbLang = new ConcurrentHashMap();
            File[] fs = FileUtil.listFiles(new File(Base.path, "wb/script/locale"));
            JSONObject jo = JsonUtil.readObject(new File(Base.path, "wb/system/language.json"));
            Set es = jo.entrySet();
            for (Map.Entry e : es) {
                String[] langList = StringUtil.split((String)e.getValue(), ',', true);
                String[] stringArray = langList;
                int n = langList.length;
                int n2 = 0;
                while (n2 < n) {
                    String ln = stringArray[n2];
                    langMap.put(ln, (String)e.getKey());
                    ++n2;
                }
            }
            File[] fileArray = fs;
            int n = fs.length;
            int n3 = 0;
            while (n3 < n) {
                file = fileArray[n3];
                name = file.getName();
                ConcurrentHashMap<String, String> buffer = new ConcurrentHashMap<String, String>();
                jo = JsonUtil.readObject(file);
                es = jo.entrySet();
                for (Map.Entry e : es) {
                    buffer.put((String)e.getKey(), (String)e.getValue());
                }
                if (Var.debug) {
                    if (name.endsWith("-debug.js")) {
                        wbLang.put(name.substring(8, name.length() - 9), buffer);
                    }
                } else {
                    wbLang.put(name.substring(8, name.length() - 3), buffer);
                }
                ++n3;
            }
            extLang = new ConcurrentHashMap();
            fileArray = fs = FileUtil.listFiles(new File(Base.path, "wb/libs/ext/locale"));
            n = fs.length;
            n3 = 0;
            while (n3 < n) {
                file = fileArray[n3];
                name = file.getName();
                if (!name.endsWith("-debug.js")) {
                    name = name.substring(9, name.length() - 3);
                    extLang.put(name, name);
                }
                ++n3;
            }
            touchLangList = new ConcurrentHashMap();
            fileArray = fs = FileUtil.listFiles(new File(Base.path, "wb/libs/touch/locale"));
            n = fs.length;
            n3 = 0;
            while (n3 < n) {
                File f = fileArray[n3];
                name = f.getName();
                if (!name.endsWith("-debug.js")) {
                    name = name.substring(7, name.length() - 3);
                    touchLangList.put(name, name);
                }
                ++n3;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

