/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionBridge
implements HttpSessionBindingListener,
Serializable {
    private static final long serialVersionUID = 4199757719833802282L;
    private transient HashMap<String, HashSet<Session>> sessionsMap;
    static Log log = LogFactory.getLog(SessionBridge.class);

    public void valueBound(HttpSessionBindingEvent arg0) {
    }

    public void valueUnbound(HttpSessionBindingEvent arg0) {
        if (this.sessionsMap != null) {
            this.closeAllSocket();
        }
    }

    private void addSocketSession(Session session, String name) {
        HashSet<Object> sessions;
        if (this.sessionsMap == null) {
            this.sessionsMap = new HashMap();
        }
        if ((sessions = this.sessionsMap.get(name)) == null) {
            sessions = new HashSet();
            this.sessionsMap.put(name, sessions);
        }
        sessions.add(session);
    }

    private void closeAllSocket() {
        try {
            Set<Map.Entry<String, HashSet<Session>>> es = this.sessionsMap.entrySet();
            for (Map.Entry<String, HashSet<Session>> e : es) {
                HashSet<Session> list = e.getValue();
                for (Session sess : list) {
                    try {
                        sess.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Http session timeout"));
                    }
                    catch (Throwable ex) {
                        log.error((Object)"", ex);
                    }
                }
            }
        }
        catch (Throwable ex) {
            log.error((Object)"", ex);
        }
    }

    public static synchronized Session[] getSessions(HttpSession httpSession, String name) {
        SessionBridge sessionBridge = (SessionBridge)httpSession.getAttribute("sysx.socket");
        if (sessionBridge == null || sessionBridge.sessionsMap == null) {
            return null;
        }
        HashSet<Session> list = sessionBridge.sessionsMap.get(name);
        if (list == null) {
            return null;
        }
        return list.toArray(new Session[list.size()]);
    }

    public static synchronized void addSession(HttpSession httpSession, Session session, String name) {
        SessionBridge sessionBridge = (SessionBridge)httpSession.getAttribute("sysx.socket");
        if (sessionBridge == null) {
            sessionBridge = new SessionBridge();
            httpSession.setAttribute("sysx.socket", (Object)sessionBridge);
        }
        sessionBridge.addSocketSession(session, name);
    }

    public static synchronized void removeSession(HttpSession httpSession, Session session, String name) {
        HashSet<Session> list;
        SessionBridge sessionBridge = (SessionBridge)httpSession.getAttribute("sysx.socket");
        if (sessionBridge != null && sessionBridge.sessionsMap != null && (list = sessionBridge.sessionsMap.get(name)) != null) {
            list.remove(session);
        }
    }
}

