/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.util.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ks.fintech.framework.utils.PathUtil;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductTagOperator {
    private static Logger logger = LoggerFactory.getLogger(ProductTagOperator.class);
    private static volatile Long PRODUCT_TAG = null;

    public static void refreshProductTag() {
        PRODUCT_TAG = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static long readProductTag() {
        try {
            if (PRODUCT_TAG == null) {
                Class<ProductTagOperator> clazz = ProductTagOperator.class;
                // MONITORENTER : com.wb.common.ProductTagOperator.class
                if (PRODUCT_TAG == null) {
                    Long productTag = ProductTagOperator.readProductTagFromFile();
                    if (productTag == null) {
                        productTag = ProductTagOperator.readProductTagFromOldVarJson();
                    }
                    PRODUCT_TAG = productTag;
                }
                // MONITOREXIT : clazz
            }
            logger.debug("read wb/system/productTag: {}", (Object)PRODUCT_TAG);
            return PRODUCT_TAG;
        }
        catch (Exception e) {
            logger.error("read wb/system/productTag error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Long readProductTagFromFile() throws Exception {
        byte[] bytes;
        block5: {
            Path filePath;
            block4: {
                try {
                    filePath = ProductTagOperator.getProductTagFilePath();
                    if (Files.exists(filePath, new LinkOption[0])) break block4;
                    return null;
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
            bytes = Files.readAllBytes(filePath);
            if (bytes != null && bytes.length >= 1) break block5;
            return null;
        }
        String systemTag = new String(bytes, StandardCharsets.UTF_8);
        String tag = ProductTagOperator.replaceBlank(systemTag);
        return Long.parseLong(tag);
    }

    private static Long readProductTagFromOldVarJson() throws Exception {
        JSONObject var = JsonUtil.readObject(new File(ProductTagOperator.getVarJsonFilePath()));
        JSONObject system = (JSONObject)var.get("sys");
        JSONObject app = (JSONObject)system.get("app");
        JSONArray productTagArray = app.getJSONArray("productTag");
        String product_tag = productTagArray.get(0).toString();
        ProductTagOperator.writeFile(product_tag);
        Long productTag = Long.parseLong(product_tag);
        logger.info("Read productTag from var.json, product: {}", (Object)productTag);
        return productTag;
    }

    private static void writeFile(String content) {
        try {
            Path filePath = ProductTagOperator.getProductTagFilePath();
            byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
            Files.write(filePath, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            logger.error("write wb/system/productTag error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    private static Path getProductTagFilePath() {
        String sep = File.separator;
        String path = String.valueOf(PathUtil.getWebContent()) + sep + "wb" + sep + "system" + sep + "productTag";
        File file = new File(path);
        return file.toPath();
    }

    private static String getVarJsonFilePath() {
        String sep = File.separator;
        String filePath = String.valueOf(PathUtil.getWebContent()) + sep + "wb" + sep + "system" + sep + "var.json";
        return filePath;
    }
}

