/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.common.KVBuffer;
import com.wb.common.KeyValueBean;
import com.wb.common.Str;
import com.wb.common.Var;
import com.wb.util.DbUtil;
import com.wb.util.StringUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KVMultilLang {
    private static final String UNDEFINED_KEY = "u";
    private static final String UNDEFINED_VALUE = "\u672a\u5b9a\u4e49";
    private static Logger logger = LoggerFactory.getLogger(KVMultilLang.class);
    private static ConcurrentHashMap<String, Map<String, Map<Object, String>>> multiLangBuffer;
    private static Set<String> supportLangSet;
    public static String DEFAULT_LANG;

    static {
        supportLangSet = new HashSet<String>();
        DEFAULT_LANG = "zh-cn";
    }

    public static Map<String, Map<Object, String>> getLangBuffer(String lang) {
        Map<String, Map<Object, String>> map = multiLangBuffer.get(lang);
        return new ConcurrentHashMap<String, Map<Object, String>>(map);
    }

    public static String getList(String lang, String keyName) {
        Map<String, Map<Object, String>> ret = multiLangBuffer.get(lang);
        Map<Object, String> map = ret.get(keyName);
        if (map == null) {
            return "[]";
        }
        return KVMultilLang.getListJson(map);
    }

    private static String getListJson(Map<Object, String> map) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (Object key : map.keySet()) {
            buf.append("{\"K\":");
            if (key instanceof Integer) {
                buf.append(Integer.toString((Integer)key));
            } else {
                buf.append(StringUtil.quote((String)key));
            }
            buf.append(",\"V\":");
            String value = map.get(key).toString();
            value = value.startsWith("@") ? value.substring(1) : StringUtil.quote(value);
            buf.append(value);
            buf.append("}");
            buf.append(",");
        }
        buf.substring(0, buf.length() - 1);
        buf.append("]");
        return buf.toString();
    }

    public static Object getKey(String lang, String keyName, String value) {
        Map<String, Map<Object, String>> langbuffer = multiLangBuffer.get(lang);
        Map<Object, String> map = langbuffer.get(keyName);
        Object key = null;
        for (Object k : map.keySet()) {
            if (!map.get(k).equals(value)) continue;
            key = k;
        }
        if (key == null) {
            if (map.keySet().contains(UNDEFINED_KEY) && UNDEFINED_VALUE.equals(map.get(UNDEFINED_KEY))) {
                return UNDEFINED_KEY;
            }
            return null;
        }
        return key;
    }

    public static String getValue(String lang, String keyName, Object key) {
        Map<String, Map<Object, String>> langMap = multiLangBuffer.get(lang);
        if (langMap == null) {
            return null;
        }
        Map<Object, String> map = langMap.get(keyName);
        return KVMultilLang.getValue(map, key);
    }

    public static String getValue(Map<?, ?> map, Object key) {
        if (key == null) {
            return null;
        }
        Object value = key instanceof Number ? map.get(((Number)key).intValue()) : map.get(key.toString());
        if (value == null) {
            return key.toString();
        }
        return value.toString();
    }

    private static String findSuitableSql(Connection conn) {
        StringBuilder sb = new StringBuilder();
        String viewName = Var.getString("sys.custom.kvViewName", "V_WB_KEY");
        sb.append("select KEY_ID,KEY_NAME,K,V,TYPE");
        try {
            ArrayList<String> columns = new ArrayList<String>();
            DatabaseMetaData metaData = conn.getMetaData();
            String currDbUser = metaData.getUserName();
            ResultSet rs = metaData.getColumns(conn.getCatalog(), currDbUser, viewName, null);
            while (rs.next()) {
                columns.add(rs.getString("COLUMN_NAME").toUpperCase());
            }
            boolean hasSeq = columns.contains("SEQ");
            boolean hasLanguage = columns.contains("LANGUAGE");
            if (hasSeq) {
                sb.append(", SEQ");
            } else {
                sb.append(", 1 as SEQ");
            }
            if (hasLanguage) {
                sb.append(", LANGUAGE");
            } else {
                sb.append(",'").append(DEFAULT_LANG).append("' as LANGUAGE");
            }
            sb.append(" from ");
            sb.append(viewName);
            sb.append(" order by SEQ");
        }
        catch (SQLException e) {
            logger.error("read V_WB_KEY metadata error", (Throwable)e);
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    public static String optLang(HttpServletRequest request) {
        if (request == null) {
            return DEFAULT_LANG;
        }
        String lang = Str.getLanguage(request);
        if (!supportLangSet.contains(lang)) {
            return DEFAULT_LANG;
        }
        return lang;
    }

    public static synchronized void load() {
        List<KeyValueBean> list = KVMultilLang.loadData();
        Map<String, Map<String, Map>> ret = list.stream().collect(Collectors.groupingBy(KeyValueBean::getLANGUAGE, Collectors.groupingBy(KeyValueBean::getKEY_NAME, Collectors.groupingBy(KeyValueBean::getK, LinkedHashMap::new, Collectors.mapping(KeyValueBean::getV, Collectors.reducing("", (s1, s2) -> String.valueOf(s1) + s2))))));
        multiLangBuffer = new ConcurrentHashMap<String, Map<String, Map>>(ret);
        KVBuffer.setBuffer(ret.get(DEFAULT_LANG));
        supportLangSet = ret.keySet();
    }

    private static List<KeyValueBean> loadData() {
        ArrayList<KeyValueBean> arrayList;
        ArrayList<KeyValueBean> list = new ArrayList<KeyValueBean>();
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = DbUtil.getConnection();
            st = conn.createStatement();
            String sql = KVMultilLang.findSuitableSql(conn);
            rs = st.executeQuery(sql);
            KeyValueBean bean = null;
            while (rs.next()) {
                bean = KVMultilLang.createBean(rs);
                list.add(bean);
            }
            arrayList = list;
        }
        catch (Exception e) {
            try {
                logger.error("load key-value error", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(st);
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(st);
        DbUtil.close(conn);
        return arrayList;
    }

    private static KeyValueBean createBean(ResultSet rs) throws SQLException {
        KeyValueBean bean = new KeyValueBean();
        bean.setKEY_ID(rs.getString("KEY_ID"));
        bean.setKEY_NAME(rs.getString("KEY_NAME"));
        int type = rs.getInt("TYPE");
        String k = rs.getString("K");
        String key = type == 1 ? k : Integer.valueOf(Integer.parseInt(k));
        bean.setTYPE(type);
        bean.setK(key);
        bean.setV(rs.getString("V"));
        bean.setLANGUAGE(rs.getString("LANGUAGE"));
        bean.setSEQ(rs.getLong("SEQ"));
        return bean;
    }

    public static void addKey(String lang, String keyName, String type) {
        if (StringUtils.isBlank((CharSequence)keyName)) {
            throw new IllegalArgumentException("keyName is blank");
        }
        HashMap<Object, String> item = new HashMap<Object, String>();
        if (StringUtils.equals((CharSequence)type, (CharSequence)"1")) {
            item.put("1", "value");
        } else {
            item.put(1, "value");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)lang, (CharSequence)DEFAULT_LANG)) {
            KVBuffer.putKey(keyName, item);
        }
        Map<String, Map<Object, String>> langBuffer = multiLangBuffer.get(lang);
        langBuffer.put(keyName, item);
    }

    public static void updateKeyName(String lang, String oldKeyName, String newKeyName) {
        if (StringUtils.isBlank((CharSequence)oldKeyName) || StringUtils.isBlank((CharSequence)newKeyName)) {
            throw new IllegalArgumentException("oldKeyName=" + oldKeyName + ", newKeyName=" + newKeyName);
        }
        Map<String, Map<Object, String>> langBuffer = multiLangBuffer.get(lang);
        Map<Object, String> map = langBuffer.get(oldKeyName);
        if (MapUtils.isNotEmpty(map)) {
            langBuffer.remove(oldKeyName);
            langBuffer.put(newKeyName, map);
            if (StringUtils.equalsIgnoreCase((CharSequence)lang, (CharSequence)DEFAULT_LANG)) {
                KVBuffer.removeKey(oldKeyName);
                KVBuffer.putKey(newKeyName, map);
            }
        } else {
            logger.error("{} not exist", (Object)oldKeyName);
            throw new IllegalArgumentException(String.valueOf(oldKeyName) + "not exist");
        }
    }

    public static void deleteKey(String lang, String keyName) {
        if (StringUtils.isBlank((CharSequence)keyName)) {
            throw new IllegalArgumentException("keyName is blank");
        }
        Map<String, Map<Object, String>> langBuffer = multiLangBuffer.get(lang);
        langBuffer.remove(keyName);
        if (StringUtils.equalsIgnoreCase((CharSequence)lang, (CharSequence)DEFAULT_LANG)) {
            KVBuffer.removeKey(keyName);
        }
    }

    public static void save(String lang, String keyName, Map<Object, String> map) {
        if (StringUtils.isBlank((CharSequence)keyName)) {
            throw new IllegalArgumentException("keyName is blank");
        }
        Map<String, Map<Object, String>> langBuffer = multiLangBuffer.get(lang);
        if (MapUtils.isEmpty(map)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)lang, (CharSequence)DEFAULT_LANG)) {
                KVBuffer.removeKey(keyName);
            }
            langBuffer.remove(keyName);
        } else {
            if (StringUtils.equalsIgnoreCase((CharSequence)lang, (CharSequence)DEFAULT_LANG)) {
                KVBuffer.putKey(keyName, map);
            }
            langBuffer.put(keyName, map);
        }
    }
}

