/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.tool.DictRecord;
import com.wb.util.DbUtil;
import com.wb.util.StringUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Dictionary {
    public static ConcurrentHashMap<String, ConcurrentHashMap<String, DictRecord>> buffer;

    public static DictRecord find(String[] tableNames, String fieldName) {
        String upperFieldName = fieldName.toUpperCase();
        String[] stringArray = tableNames;
        int n = tableNames.length;
        int n2 = 0;
        while (n2 < n) {
            DictRecord dictRecord;
            String tableName = stringArray[n2];
            ConcurrentHashMap<String, DictRecord> fieldMap = buffer.get(tableName.toUpperCase());
            if (fieldMap != null && (dictRecord = fieldMap.get(upperFieldName)) != null) {
                if (dictRecord.linkTo == null) {
                    return dictRecord;
                }
                String[] tableField = StringUtil.split(dictRecord.linkTo.toUpperCase(), '.');
                fieldMap = buffer.get(tableField[0]);
                if (fieldMap == null) {
                    return null;
                }
                return fieldMap.get(tableField[1]);
            }
            ++n2;
        }
        return null;
    }

    public static HashMap<String, String> getKeyFields(String[] tableNames) {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        String[] stringArray = tableNames;
        int n = tableNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tableName = stringArray[n2];
            ConcurrentHashMap<String, DictRecord> fieldMap = buffer.get(tableName.toUpperCase());
            if (fieldMap != null) {
                Set<Map.Entry<String, DictRecord>> es = fieldMap.entrySet();
                for (Map.Entry<String, DictRecord> e : es) {
                    DictRecord dictRecord = e.getValue();
                    if (dictRecord.keyName == null) continue;
                    keyMap.put(e.getKey(), dictRecord.keyName);
                }
            }
            ++n2;
        }
        return keyMap;
    }

    public static DictRecord getDictRecord(ResultSet rs) throws Exception {
        DictRecord dictRecord = new DictRecord();
        dictRecord.linkTo = StringUtil.force(rs.getString("LINK_TO"));
        dictRecord.listable = !"0".equals(rs.getString("LISTABLE"));
        dictRecord.editable = !"0".equals(rs.getString("EDITABLE"));
        dictRecord.dispText = StringUtil.force(rs.getString("DISP_TEXT"));
        dictRecord.dispWidth = rs.getInt("DISP_WIDTH");
        if (rs.wasNull()) {
            dictRecord.dispWidth = -1;
        }
        dictRecord.dispFormat = StringUtil.force(rs.getString("DISP_FORMAT"));
        dictRecord.autoWrap = "1".equals(rs.getString("AUTO_WRAP"));
        dictRecord.allowBlank = StringUtil.getBoolA(rs.getString("ALLOW_BLANK"));
        dictRecord.readOnly = StringUtil.getBoolA(rs.getString("READ_ONLY"));
        dictRecord.keyName = StringUtil.force(rs.getString("KEY_NAME"));
        dictRecord.fieldSize = rs.getInt("FIELD_SIZE");
        if (rs.wasNull()) {
            dictRecord.fieldSize = -1;
        }
        dictRecord.decimalPrecision = rs.getInt("DECIMAL_PRECISION");
        if (rs.wasNull()) {
            dictRecord.decimalPrecision = -1;
        }
        dictRecord.validator = StringUtil.force(rs.getString("VALIDATOR"));
        dictRecord.renderer = StringUtil.force(rs.getString("RENDERER"));
        dictRecord.controlType = StringUtil.force(rs.getString("CONTROL_TYPE"));
        dictRecord.asInput = "1".equals(rs.getString("AS_INPUT"));
        dictRecord.dataSource = StringUtil.opt(rs.getString("DATA_SOURCE"));
        dictRecord.defaultValue = StringUtil.force(rs.getString("DEFAULT_VALUE"));
        dictRecord.tagValue = StringUtil.force(rs.getString("TAG_VALUE"));
        dictRecord.opType = StringUtil.force(rs.getString("OPTYPE"));
        dictRecord.showStar = "1".equals(rs.getString("SHOW_STAR"));
        return dictRecord;
    }

    public static synchronized void load() {
        try {
            buffer = new ConcurrentHashMap();
            Connection conn = null;
            Statement st = null;
            ResultSet rs = null;
            String tableName = null;
            String preTableName = null;
            ConcurrentHashMap<String, DictRecord> map = new ConcurrentHashMap<String, DictRecord>();
            try {
                conn = DbUtil.getConnection();
                st = conn.createStatement();
                rs = st.executeQuery("select * from WB_DICT order by TABLE_NAME");
                while (rs.next()) {
                    tableName = rs.getString("TABLE_NAME").toUpperCase();
                    if (preTableName != null && !preTableName.equals(tableName)) {
                        buffer.put(preTableName, map);
                        map = new ConcurrentHashMap();
                    }
                    map.put(rs.getString("FIELD_NAME").toUpperCase(), Dictionary.getDictRecord(rs));
                    preTableName = tableName;
                }
                if (preTableName != null) {
                    buffer.put(preTableName, map);
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(st);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

