/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.alibaba.fastjson.JSON;
import com.aspose.slides.Collections.ArrayList;
import com.wb.common.FileBuffer;
import com.wb.common.Parser;
import com.wb.common.ScriptBuffer;
import com.wb.common.SysConfigDbSyn;
import com.wb.common.UrlBuffer;
import com.wb.common.Var;
import com.wb.tool.Encrypter;
import com.wb.tool.TaskManager;
import com.wb.tool.WebVarOpt;
import com.wb.util.FileUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.SystemKit;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Base
implements Filter {
    private static Log log = LogFactory.getLog(Base.class);
    public static ServletContext servletContext;
    public static File path;
    public static int pathLen;
    public static File modulePath;
    public static String modulePathText;
    public static int modulePathLen;
    public static Date startTime;
    public static ConcurrentHashMap<String, Object> map;
    private static boolean initFailed;
    private static Throwable initError;
    private static String _polishProductTag;

    static {
        map = new ConcurrentHashMap();
        _polishProductTag = "-9999";
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String AccessControlExposeHeaders;
        String AccessControlAllowOrigin;
        if (initFailed) {
            throw new RuntimeException(initError);
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String xFrameOptions = Var.getString("sys.iframeCross-domain.x-frame-options");
        if ("DENY".equals(xFrameOptions) || "SAMEORIGIN".equals(xFrameOptions) || "ALLOW-FROM".equals(xFrameOptions)) {
            resp.addHeader("x-frame-options", xFrameOptions);
        }
        if (!"".equals(AccessControlAllowOrigin = Var.getString("sys.iframeCross-domain.Access-Control-Allow-Origin"))) {
            resp.addHeader("Access-Control-Allow-Origin", AccessControlAllowOrigin);
        }
        if (!"".equals(AccessControlExposeHeaders = Var.getString("sys.iframeCross-domain.Access-Control-Expose-Headers"))) {
            resp.addHeader("Access-Control-Expose-Headers", AccessControlExposeHeaders);
        } else {
            resp.addHeader("Access-Control-Expose-Headers", "Access-Token");
        }
        resp.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept, Access-Token");
        String url = req.getServletPath();
        String xwl = UrlBuffer.get(url);
        if (xwl != null) {
            long startTms = System.currentTimeMillis();
            request.setCharacterEncoding("utf-8");
            if (xwl.isEmpty()) {
                xwl = request.getParameter("xwl");
                if (xwl == null) {
                    resp.sendError(400, "null xwl ");
                    return;
                }
                xwl = StringUtil.concat(xwl, ".xwl");
            }
            this.setRequest(req);
            Parser parser = new Parser(req, resp);
            parser.parse(xwl);
            log.info((Object)(String.valueOf(SystemKit.getClientIP((HttpServletRequest)request)) + "'s wb request url:" + xwl));
            log.info((Object)("cost ********:" + (System.currentTimeMillis() - startTms)));
        } else {
            String lowerUrl = url.toLowerCase();
            if (lowerUrl.startsWith("/wb/modules/") || lowerUrl.startsWith("/wb/system/")) {
                resp.sendError(403, url);
            } else if (Var.cacheEnabled && lowerUrl.startsWith("/wb/")) {
                FileBuffer.service(url, req, resp);
            } else {
                chain.doFilter(request, response);
            }
        }
    }

    public void init(FilterConfig config) throws ServletException {
        try {
            startTime = new Date();
            servletContext = config.getServletContext();
            path = new File(servletContext.getRealPath("/"));
            pathLen = FileUtil.getPath(path).length() + 1;
            modulePath = new File(path, "wb/modules");
            modulePathText = FileUtil.getPath(modulePath);
            modulePathLen = modulePathText.length() + 1;
            SysUtil.reload(2);
            if (!Var.jndi.isEmpty() && !Var.getBool("sys.service.allowInstall")) {
                SysUtil.reload(3);
                TaskManager.start();
            }
            this.runInitScript();
            SysConfigDbSyn.startSyn();
            WebVarOpt.webInfo2VarConfig();
        }
        catch (Throwable e) {
            initFailed = true;
            initError = e;
            log.error((Object)"", e);
        }
    }

    private void setRequest(HttpServletRequest request) {
        long time = System.currentTimeMillis();
        request.setAttribute("sys.date", (Object)new Date(time - time % 1000L));
        request.setAttribute("sys.id", (Object)SysUtil.getId());
    }

    private void setSession(HttpServletRequest req) {
        ArrayList list = new ArrayList();
        Enumeration paramNames = req.getParameterNames();
        while (paramNames.hasMoreElements()) {
            HashMap<String, String> map = new HashMap<String, String>();
            String paramName = (String)paramNames.nextElement();
            String paramValue = req.getParameter(paramName);
            map.put(paramName, paramValue);
            list.add(map);
        }
        System.out.println("\u53c2\u6570\uff1a" + JSON.toJSONString((Object)list));
        HttpSession session = req.getSession(false);
        session.setAttribute("twoCabinets", (Object)JSON.toJSONString((Object)list));
    }

    private void checkLicense() throws Exception {
        String code = FileUtil.readString(new File(path, "wb/system/lic.dat"));
        String validCode = "2782051B84F1254EA33242FCC377861A";
        String key = "wblic";
        int index = code.indexOf("lic=");
        if (index != -1 && ((code = code.substring(index + 4)).equals(validCode) || code.equals(Encrypter.getMD5(String.valueOf(SysUtil.getMacAddress()) + key)))) {
            return;
        }
        System.exit(0);
    }

    private void runInitScript() throws Exception {
        File file = new File(path, "wb/system/init.js");
        if (file.exists()) {
            ScriptBuffer.run(FileUtil.readString(file), "init.js");
        }
    }

    public void destroy() {
        try {
            TaskManager.stop();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

