/*
 * Decompiled with CFR 0.152.
 */
package com.wb.workflow;

import com.wb.common.Base;
import com.wb.tool.MailSender;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import ks.fintech.basic.api.model.CustomFile;
import ks.fintech.basic.api.service.FileService;
import ks.fintech.framework.utils.SpringContextUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class SyncSendFlowMail {
    private static final Logger log = LoggerFactory.getLogger(SyncSendFlowMail.class);
    private String smtp;
    private String username;
    private String password;
    private boolean needAuth;

    public SyncSendFlowMail(String smtp, String username, String password, boolean needAuth) throws Exception {
        this.smtp = smtp;
        this.username = username;
        this.password = password;
        this.needAuth = needAuth;
    }

    public void syncSendEmail(final String from, final String to, final String cc, final String bcc, final String title, final String content, final String attachFiles, final HttpServletRequest request, final String attachObjects, final String attachObjectNames) throws Exception {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block15: {
                    MailSender mailSender = null;
                    String attachFileNames = null;
                    List attachFileList = null;
                    try {
                        try {
                            mailSender = new MailSender(SyncSendFlowMail.this.smtp, SyncSendFlowMail.this.username, SyncSendFlowMail.this.password, SyncSendFlowMail.this.needAuth);
                            attachFileList = SyncSendFlowMail.this.getAttachFileList(attachFiles);
                            if (attachFileList != null && attachFileList.size() != 0) {
                                attachFileNames = StringUtils.join((Collection)attachFileList, (String)",");
                            }
                            mailSender.send(from, to, cc, bcc, title, content, attachFileNames, request, attachObjects, attachObjectNames);
                        }
                        catch (Exception e) {
                            log.error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25", (Throwable)e);
                            if (mailSender != null) {
                                try {
                                    mailSender.close();
                                }
                                catch (Exception e2) {
                                    log.error("\u5173\u95ed\u90ae\u4ef6\u8fde\u63a5\u5931\u8d25", (Throwable)e2);
                                }
                            }
                            SyncSendFlowMail.this.delTmpFiles(attachFileList);
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        if (mailSender != null) {
                            try {
                                mailSender.close();
                            }
                            catch (Exception e) {
                                log.error("\u5173\u95ed\u90ae\u4ef6\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                            }
                        }
                        SyncSendFlowMail.this.delTmpFiles(attachFileList);
                        throw throwable;
                    }
                    if (mailSender != null) {
                        try {
                            mailSender.close();
                        }
                        catch (Exception e) {
                            log.error("\u5173\u95ed\u90ae\u4ef6\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                        }
                    }
                    SyncSendFlowMail.this.delTmpFiles(attachFileList);
                }
            }
        }, "SyncSendFlowMail").start();
    }

    private List<String> getAttachFileList(String attachFiles) throws Exception {
        try {
            SpringContextUtil.getBean((String)"dynamicDataSources");
            return this.getFilesByNewMutiFileDown(attachFiles);
        }
        catch (Exception e) {
            return this.getFilesBySql(attachFiles);
        }
    }

    private List<String> getFilesByNewMutiFileDown(String attachFiles) throws Exception {
        String[] objectIds;
        List files;
        FileService fileService = (FileService)SpringContextUtil.getBean((String)"dwl_fileService");
        ArrayList<String> fileList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)attachFiles) && (files = fileService.getFilesByObjIds(objectIds = StringUtils.split((String)attachFiles.trim(), (String)","))) != null && files.size() != 0) {
            for (CustomFile file : files) {
                File destFile = new File(Base.path, file.getFileName());
                FileUtils.writeByteArrayToFile((File)destFile, (byte[])file.getFileContent());
                fileList.add(file.getFileName());
            }
        }
        return fileList;
    }

    private List<String> getFilesBySql(String attachFiles) throws Exception {
        String[] objectIds;
        List<Map<String, Object>> list;
        ArrayList<String> fileList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)attachFiles) && (list = this.getsFilesByObjId(objectIds = StringUtils.split((String)attachFiles.trim(), (String)","))) != null && list.size() != 0) {
            for (Map<String, Object> map : list) {
                String fileName = String.valueOf(String.valueOf(map.get("name"))) + "." + String.valueOf(map.get("extension"));
                byte[] content = (byte[])map.get("content");
                File destFile = new File(Base.path, fileName);
                FileUtils.writeByteArrayToFile((File)destFile, (byte[])content);
                fileList.add(fileName);
            }
        }
        return fileList;
    }

    private void delTmpFiles(List<String> attachFileList) {
        if (attachFileList != null && attachFileList.size() != 0) {
            for (String fileName : attachFileList) {
                File tmpFile = new File(Base.path, fileName);
                tmpFile.delete();
            }
        }
    }

    private List<Map<String, Object>> getsFilesByObjId(String[] objectIds) {
        List files = null;
        if (objectIds != null && objectIds.length != 0) {
            JdbcTemplate jdbcTemplate = (JdbcTemplate)SpringContextUtil.getBean((String)"jdbcTemplate");
            String sql = "select a.name as name,a.extension as extension,a.create_time as create_time,b.content as content from wolfdata.t_files a left join wolfdata.t_file_content b on a.id = b.id where a.object_id = ? order by a.create_time asc";
            String[] stringArray = objectIds;
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                String objectId = stringArray[n2];
                Object[] params = new Object[]{objectId};
                files = jdbcTemplate.queryForList(sql, params);
                ++n2;
            }
        }
        return files;
    }
}

