/*
 * Decompiled with CFR 0.152.
 */
package com.wb.workflow;

import cn.hutool.core.util.StrUtil;
import com.alibaba.druid.util.StringUtils;
import com.wb.common.ScriptBuffer;
import com.wb.common.Str;
import com.wb.common.Var;
import com.wb.tool.MailSender;
import com.wb.util.DateUtil;
import com.wb.util.DbUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WbUtil;
import com.wb.util.WebUtil;
import com.wb.workflow.Flow;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class FlowObject {
    private String startName;
    private String endName;
    public JSONObject flowJson;
    private JSONObject flowProp;
    private JSONObject params;
    private String activeNodeName;
    private String sysOpinion = "";
    private String sysToUser = "";
    private String subFlowId = "";
    private JSONObject activeNode;
    private JSONArray history;
    private JSONArray shareData;
    private JSONArray actionVar;
    private JSONObject nodeAction;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String userId;
    private String userName;
    private String userDispName;
    private String flowId;
    private String parentFlowId;
    private JSONArray nodes;
    private JSONArray links;
    private Timestamp actionDate;
    private boolean nodeChanged;
    private boolean needSpecify = false;
    private boolean isLikeNode = false;
    private boolean setProcessed = true;
    private ArrayList<String> newUserList = new ArrayList();

    public FlowObject(JSONObject flowData, JSONObject extraParams, HttpServletRequest request, HttpServletResponse response, String flowName, boolean isStart) {
        this.actionDate = DateUtil.now();
        this.flowJson = flowData;
        this.flowProp = this.flowJson.getJSONObject("flow");
        if (isStart) {
            this.flowProp.put("flowName", (Object)flowName.substring(0, flowName.length() - 4));
        }
        this.nodes = this.flowJson.getJSONArray("nodes");
        this.links = this.flowJson.getJSONArray("links");
        this.getStartAndEndNodeName();
        this.history = this.flowJson.optJSONArray("history");
        if (this.history == null) {
            this.history = new JSONArray();
            this.flowJson.put("history", (Object)this.history);
        }
        this.params = this.flowJson.optJSONObject("params");
        if (this.params == null) {
            this.params = new JSONObject();
            this.flowJson.put("params", (Object)this.params);
        }
        this.parentFlowId = this.flowJson.optString("parentFlowId");
        String shareStr = this.getAttribute(this.flowProp, "shareData");
        if (StrUtil.isNotBlank((CharSequence)shareStr)) {
            this.shareData = JsonUtil.getArray(shareStr);
        }
        if (this.shareData != null && this.shareData.length() > 0) {
            this.applyShareData(this.shareData);
        }
        if (extraParams != null) {
            String actionStr = this.getAttribute(extraParams, "actionVar");
            if (StrUtil.isNotBlank((CharSequence)actionStr)) {
                this.actionVar = JsonUtil.getArray(actionStr);
            }
            this.applyExtraParams(extraParams);
        }
        if (this.actionVar != null && this.actionVar.length() > 0) {
            this.applyShareData(this.actionVar);
        }
        this.activeNodeName = this.flowJson.optString("activeNode", this.startName);
        this.activeNode = this.getNode(this.activeNodeName);
        this.request = request;
        this.response = response;
        this.setUserVar();
        if (isStart) {
            this.setStartParams();
        }
        this.params.put("flow.lastDate", (Object)this.actionDate);
        this.params.put("flow.lastUserId", (Object)this.userId);
        this.params.put("flow.lastUserName", (Object)this.userName);
        this.params.put("flow.lastUserDispName", (Object)this.userDispName);
        this.params.put("flow.lastNodeName", (Object)this.activeNodeName);
        this.flowId = this.params.getString("flow.id");
    }

    private void applyExtraParams(JSONObject extraParams) {
        Set es = extraParams.entrySet();
        for (Map.Entry e : es) {
            String key = (String)e.getKey();
            if (key.indexOf(46) != -1) {
                throw new IllegalArgumentException("Invalid parameter name \"" + key + "\".");
            }
            if ("parentFlowId".equalsIgnoreCase(key)) {
                this.parentFlowId = e.getValue().toString();
                this.flowJson.put("parentFlowId", (Object)this.parentFlowId);
            }
            this.params.put(key, e.getValue());
        }
    }

    private void applyShareData(JSONArray shareData) {
        int i = 0;
        while (i < shareData.length()) {
            JSONObject obj = shareData.getJSONObject(i);
            String name = obj.getString("name");
            String value = obj.getString("value");
            if (name.indexOf(46) != -1) {
                throw new IllegalArgumentException("Invalid parameter name \"" + name + "\".");
            }
            this.params.put(name, (Object)value);
            ++i;
        }
    }

    private JSONObject removeFlowParams(JSONObject params) {
        Set es = params.entrySet();
        JSONObject newParams = new JSONObject();
        for (Map.Entry e : es) {
            String key = (String)e.getKey();
            if (key.indexOf(46) != -1) continue;
            newParams.put(key, e.getValue());
        }
        return newParams;
    }

    public void verifyNodePassUser() throws Exception {
        HashSet<String> hs;
        int passValue;
        boolean isPercent;
        String passUser = this.getAttribute(this.activeNode, "passUsers");
        if (StrUtil.isNotBlank((CharSequence)passUser) && !(isPercent = passUser.endsWith("%")) && StringUtil.isInteger(passUser) && (passValue = Integer.parseInt(passUser)) > (hs = this.getUsers(this.getRequestConnection(), false)).size()) {
            throw new IllegalArgumentException("\u6d41\u7a0b\u914d\u7f6e\u9519\u8bef\uff1a\u8282\u70b9\u201c" + this.activeNodeName + "\u201d\u914d\u7f6e\u7684\u901a\u8fc7\u4eba\u6570\u5927\u4e8e\u914d\u7f6e\u7684\u5904\u7406\u4eba\u6570\uff01");
        }
    }

    public void verifyAllNode() throws Exception {
        int j = this.nodes.length();
        boolean hasDefaultDialog = StrUtil.isNotBlank((CharSequence)this.getFlowAttribute("defaultDialog"));
        boolean hasDefaultViewDialog = StrUtil.isNotBlank((CharSequence)this.getFlowAttribute("defaultViewDialog"));
        boolean isExistEndName = false;
        int i = 0;
        while (i < j) {
            JSONObject node = this.nodes.getJSONObject(i);
            String nodeName = node.optString("name");
            boolean hasDoUser = StrUtil.isNotBlank((CharSequence)this.getAttribute(node, "doUser"));
            boolean hasCcUser = StrUtil.isNotBlank((CharSequence)this.getAttribute(node, "ccUser"));
            boolean hasPassUsers = StrUtil.isNotBlank((CharSequence)this.getAttribute(node, "passUsers"));
            boolean specifyUser = node.optBoolean("specifyUser");
            String dialog = this.getAttribute(node, "dialog");
            boolean hasDialog = StrUtil.isNotBlank((CharSequence)dialog);
            String viewDialog = this.getAttribute(node, "viewDialog");
            boolean hasViewDialog = StrUtil.isNotBlank((CharSequence)viewDialog);
            boolean hasSubFlowPath = StrUtil.isNotBlank((CharSequence)this.getAttribute(node, "subFlowPath"));
            boolean hasConcurrentNum = StrUtil.isNotBlank((CharSequence)this.getAttribute(node, "subFlowConcurrentNum"));
            boolean hasRobot = StrUtil.isNotBlank((CharSequence)this.getAttribute(node, "robot"));
            boolean hasMultSubFlow = StrUtil.isNotBlank((CharSequence)this.getAttribute(node, "multSubFlow"));
            if (nodeName.equals(this.startName)) {
                if (hasSubFlowPath || hasConcurrentNum || hasMultSubFlow) {
                    throw new IllegalArgumentException("\u6d41\u7a0b\u7b2c\u4e00\u4e2a\u8282\u70b9\u4e0d\u80fd\u914d\u7f6e\u4e3a\u5b50\u6d41\u7a0b\u8282\u70b9");
                }
                if (hasRobot) {
                    if (hasDoUser || hasCcUser || hasPassUsers || specifyUser || hasDefaultDialog && !"-".equals(dialog) || !hasDefaultDialog && hasDialog && !"-".equals(dialog) || hasDefaultViewDialog && !"-".equals(viewDialog) || !hasDefaultViewDialog && hasViewDialog && !"-".equals(viewDialog)) {
                        throw new IllegalArgumentException("\u6d41\u7a0b\u81ea\u52a8\u5316\u8282\u70b9\u914d\u7f6e\u9519\u8bef\uff01");
                    }
                } else if (specifyUser) {
                    throw new IllegalArgumentException("\u6d41\u7a0b\u7b2c\u4e00\u4e2a\u8282\u70b9\u7684\u662f\u5426\u6307\u5b9a\u4eba\u4e0d\u80fd\u4e3atrue\uff01");
                }
            } else if (nodeName.equals(this.endName)) {
                isExistEndName = true;
                if (hasCcUser || hasDoUser || hasPassUsers || hasDialog || specifyUser || hasViewDialog || hasSubFlowPath || hasConcurrentNum || hasRobot || hasMultSubFlow) {
                    throw new IllegalArgumentException("\u6d41\u7a0b\u6700\u540e\u4e00\u4e2a\u8282\u70b9\u914d\u7f6e\u9519\u8bef\uff01");
                }
            } else if (hasSubFlowPath || hasMultSubFlow) {
                if (hasDoUser || hasCcUser || hasPassUsers || hasRobot || specifyUser || hasDefaultDialog && !"-".equals(dialog) || !hasDefaultDialog && hasDialog && !"-".equals(dialog)) {
                    throw new IllegalArgumentException("\u6d41\u7a0b\u5b50\u6d41\u7a0b\u8282\u70b9\u914d\u7f6e\u9519\u8bef\uff01");
                }
                if (hasDefaultViewDialog && "-".equals(viewDialog) || !hasDefaultViewDialog && hasViewDialog && "-".equals(viewDialog)) {
                    throw new IllegalArgumentException("\u6d41\u7a0b\u5b50\u6d41\u7a0b\u8282\u70b9\u9700\u914d\u7f6e\u67e5\u770b\u5bf9\u8bdd\u6846\uff01");
                }
                if (hasMultSubFlow && (hasSubFlowPath || hasConcurrentNum)) {
                    throw new IllegalArgumentException("\u6d41\u7a0b\u7684\u5b50\u6d41\u7a0b\u8282\u70b9\u591a\u4e2a\u5b50\u6d41\u7a0b\u914d\u7f6e\u9879\u548c\u5355\u4e2a\u5b50\u6d41\u7a0b\u4e0d\u80fd\u540c\u65f6\u914d\u7f6e");
                }
            } else if (hasRobot && (hasDoUser || hasCcUser || hasPassUsers || specifyUser || hasConcurrentNum || hasDefaultDialog && !"-".equals(dialog) || !hasDefaultDialog && hasDialog && !"-".equals(dialog) || hasDefaultViewDialog && !"-".equals(viewDialog) || !hasDefaultViewDialog && hasViewDialog && !"-".equals(viewDialog))) {
                throw new IllegalArgumentException("\u6d41\u7a0b\u81ea\u52a8\u5316\u8282\u70b9\u914d\u7f6e\u9519\u8bef\uff01");
            }
            ++i;
        }
        if (!isExistEndName) {
            throw new IllegalArgumentException("\u6d41\u7a0b\u914d\u7f6e\u9519\u8bef\uff1a\u6700\u540e\u4e00\u4e2a\u8282\u70b9\u7684\u540d\u79f0\u5fc5\u987b\u4e3a\u201c\u7ed3\u675f\u201d\uff01");
        }
    }

    public void verifyStartNode() throws Exception {
        if (StrUtil.isNotBlank((CharSequence)this.activeNode.optString("subFlowPath"))) {
            throw new IllegalArgumentException("\u6d41\u7a0b\u7b2c\u4e00\u4e2a\u8282\u70b9\u4e0d\u80fd\u4e3a\u5b50\u6d41\u7a0b\u8282\u70b9");
        }
        if (StrUtil.isBlank((CharSequence)this.activeNode.optString("robot"))) {
            if (StringUtil.isEmpty(this.activeNode.optString("doUser"))) {
                throw new IllegalArgumentException("\u5f00\u59cb\u8282\u70b9\u5fc5\u987b\u914d\u7f6e\u5904\u7406\u4eba\u3002");
            }
            HashSet<String> doUserIdSet = this.getUsers(this.getRequestConnection(), false);
            this.setEntrustUser(doUserIdSet);
            if (doUserIdSet.size() > 0 && !doUserIdSet.contains(this.userId)) {
                throw new IllegalArgumentException("\u60a8\u4e0d\u662f\u6d41\u7a0b\u53d1\u8d77\u4eba\uff01");
            }
        }
    }

    private void setStartParams() {
        HttpSession session = this.request.getSession();
        String id = "";
        if (session != null) {
            id = (String)this.request.getSession().getAttribute("flow.id");
        }
        if (StrUtil.isBlank((CharSequence)id)) {
            this.params.put("flow.id", (Object)SysUtil.getId());
        } else {
            this.params.put("flow.id", (Object)id);
        }
        this.params.put("flow.nodeName", (Object)this.activeNodeName);
        this.params.put("flow.nodeTitle", (Object)this.getTitle(this.activeNode));
        this.params.put("flow.startDate", (Object)this.actionDate);
        this.params.put("flow.userId", (Object)this.userId);
        this.params.put("flow.userName", (Object)this.userName);
        this.params.put("flow.userDispName", (Object)this.userDispName);
        this.params.put("flow.flowName", (Object)this.getFlowAttribute("flowName"));
        this.params.put("flow.action", (Object)"pass");
        this.params.put("flow.actionDisplayName", (Object)"\u901a\u8fc7");
        this.params.put("flowId", (Object)this.params.getString("flow.id"));
        this.params.put("xprocessid", (Object)this.params.getString("flow.id"));
        int j = this.nodes.length();
        int i = 0;
        while (i < j) {
            JSONObject node = this.nodes.getJSONObject(i);
            node.put("doUserCount", 0);
            node.put("doActionUserIds", (Object)new JSONArray());
            node.put("retreatUserIds", (Object)new JSONArray());
            node.put("assistAndTurnUser", (Object)new JSONArray());
            ++i;
        }
        this.flowJson.put("rawLinks", (Object)this.links.toString());
    }

    private void setUserVar() {
        if (this.request == null) {
            this.userId = "-";
            this.userName = "-";
            this.userDispName = "-";
        } else {
            HttpSession session = this.request.getSession(false);
            if (session == null) {
                this.userId = "-";
                this.userName = "-";
                this.userDispName = "\u7cfb\u7edf\u81ea\u52a8\u53d1\u8d77";
            } else {
                this.userId = (String)session.getAttribute("sys.user");
                this.userName = (String)session.getAttribute("sys.username");
                this.userDispName = (String)session.getAttribute("sys.dispname");
            }
        }
    }

    public JSONObject getParams() {
        return this.params;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public void forward() throws Exception {
        boolean isMainFill = this.flowJson.optBoolean("isMainFill");
        this.checkEnd();
        String passUsers = this.getAttribute(this.activeNode, "passUsers");
        int doUserCount = this.activeNode.getInt("doUserCount");
        JSONArray doActionUsers = this.activeNode.optJSONArray("retreatUserIds");
        HashSet<String> doUserIdSet = JsonUtil.toHashSet(doActionUsers);
        if (!doUserIdSet.contains(this.userId)) {
            doActionUsers.put((Object)this.userId);
            this.activeNode.put("retreatUserIds", (Object)doActionUsers);
        }
        this.recordHistory("pass");
        this.activeNode.put("doUserCount", ++doUserCount);
        if (isMainFill) {
            this.setActiveNode(this.endName);
            this.flowJson.put("isMainFill", false);
        } else if (!StringUtil.isEmpty(passUsers)) {
            int totalUserCount;
            boolean isPercent = passUsers.endsWith("%");
            String passValue = isPercent ? passUsers.substring(0, passUsers.length() - 1) : passUsers;
            if (!StringUtil.isInteger(passValue)) {
                throw new RuntimeException("\u8282\u70b9\u201c" + this.activeNode + "\u201d\u7684\u901a\u8fc7\u4eba\u6570\u5c5e\u6027\u503c\u201c" + passUsers + "\u201d\u65e0\u6548\u3002");
            }
            int countValue = Integer.parseInt(passValue);
            if (isPercent ? (double)doUserCount * 100.0 / (double)(totalUserCount = this.activeNode.getInt("totalUserCount")) < (double)countValue : doUserCount < countValue) {
                return;
            }
            this.doForward(new HashMap<String, Integer>());
        } else if (doUserCount == 1) {
            this.doForward(new HashMap<String, Integer>());
        }
    }

    private JSONObject isExistLink() {
        int j = this.links.length();
        int i = 0;
        while (i < j) {
            JSONObject link = this.links.getJSONObject(i);
            boolean isFillSign = link.optBoolean("isFillSign");
            if (isFillSign) {
                link.put("isFillSign", false);
                return link;
            }
            ++i;
        }
        return null;
    }

    private void doForward(HashMap<String, Integer> forwardNodes) throws Exception {
        JSONArray multSubFlow = null;
        int j = this.links.length();
        boolean forwarded = false;
        boolean hasDefaultDialog = !StringUtil.isEmpty(this.getFlowAttribute("defaultDialog"));
        boolean isRobotNode = false;
        String fromNodeName = this.activeNodeName;
        int i = 0;
        while (i < j) {
            String condition;
            JSONObject link = this.isExistLink();
            if (link == null) {
                link = this.links.getJSONObject(i);
            }
            if (fromNodeName.equals(link.optString("from")) && (StringUtil.isEmpty(condition = link.optString("condition")) || ScriptBuffer.evalCondition(condition, this.params))) {
                Integer forwardTimes;
                if (forwarded) {
                    throw new RuntimeException("\u8282\u70b9 \u201c" + fromNodeName + "\u201d\u53ef\u4ee5\u6d41\u8f6c\u5230\u591a\u4e2a\u8282\u70b9\u3002");
                }
                String toNodeName = link.optString("to");
                this.setActiveNode(toNodeName);
                this.verifyNodePassUser();
                this.activeNode.put("doUserCount", 0);
                forwarded = true;
                String subFlowPath = this.activeNode.optString("subFlowPath");
                String multSub = this.getAttribute(this.activeNode, "multSubFlow");
                if (StrUtil.isNotBlank((CharSequence)multSub)) {
                    multSubFlow = JsonUtil.getArray(multSub);
                }
                String dialog = this.activeNode.optString("dialog");
                String robot = this.activeNode.optString("robot");
                boolean bl = isRobotNode = ("-".equals(dialog) || !hasDefaultDialog && StringUtil.isEmpty(dialog)) && !this.endName.endsWith(toNodeName);
                if (!isRobotNode) break;
                if (StrUtil.isNotBlank((CharSequence)subFlowPath) || multSubFlow != null) {
                    this.flowJson.put("subFlowCount", 0);
                    this.flowJson.put("subNodeName", (Object)this.activeNodeName);
                    break;
                }
                if (!StringUtil.isEmpty(robot)) {
                    ScriptBuffer.run(robot, this.request, this.response, this.params);
                }
                if ((forwardTimes = forwardNodes.get(toNodeName)) == null) {
                    forwardTimes = 0;
                }
                if ((forwardTimes = Integer.valueOf(forwardTimes + 1)) > 10) {
                    throw new RuntimeException("\u8282\u70b9\u201c" + fromNodeName + "\u201d\u5230\u201c" + toNodeName + "\u201d\u7684\u6d41\u8f6c\u5df2\u7ecf\u591a\u6b21\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5b58\u5728\u65e0\u9650\u5faa\u73af\u3002");
                }
                forwardNodes.put(toNodeName, forwardTimes);
                this.doForward(forwardNodes);
                break;
            }
            ++i;
        }
        if (!forwarded) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u8282\u70b9 \u201c" + fromNodeName + "\u201d\u7684\u4e0b\u4e00\u4e2a\u8282\u70b9\u3002");
        }
    }

    private void setActiveNode(String nodeName) {
        if (nodeName.equals(this.activeNodeName)) {
            return;
        }
        this.activeNode = this.getNode(nodeName);
        this.activeNodeName = nodeName;
        this.flowJson.put("activeNode", (Object)nodeName);
        this.params.put("flow.nodeName", (Object)nodeName);
        this.params.put("flow.nodeTitle", (Object)this.getTitle(this.activeNode));
        this.nodeChanged = true;
    }

    public void setSubFlowNode() {
        this.nodeChanged = true;
    }

    public HashSet<String> getUsers(Connection conn, boolean isCc) throws Exception {
        String respText;
        String module;
        int i;
        int j;
        String users = this.replaceParams(this.activeNode.optString(isCc ? "ccUser" : "doUser"));
        HashSet<String> hs = new HashSet<String>();
        if (StringUtil.isEmpty(users)) {
            return null;
        }
        JSONObject userData = new JSONObject(users);
        JSONArray ja = userData.optJSONArray("userId");
        if (ja != null) {
            JsonUtil.addAll(hs, ja);
        }
        if ((ja = userData.optJSONArray("roleId")) != null) {
            j = ja.length();
            i = 0;
            while (i < j) {
                this.addUsers(conn, hs, "select distinct USER_ID from KS_USER_ROLE where ROLE_ID in (" + StringUtil.joinQuote(JsonUtil.createArray(ja)) + ")");
                ++i;
            }
        }
        if ((ja = userData.optJSONArray("deptId")) != null) {
            j = ja.length();
            i = 0;
            while (i < j) {
                this.addUsers(conn, hs, "select distinct USER_ID from WB_USER where DEPT_ID in (" + StringUtil.joinQuote(JsonUtil.createArray(ja)) + ")");
                ++i;
            }
        }
        if (!(StringUtil.isEmpty(module = userData.optString("module")) || "undefined".equals(respText = this.request == null ? WbUtil.run(module, this.params, true) : WbUtil.run(module, this.params, this.request, true)) || StringUtil.isEmpty(respText))) {
            JsonUtil.addAll(hs, new JSONArray(respText));
        }
        String sql = userData.optString("sql");
        this.addUsersFormSQL(hs, sql);
        String node = userData.optString("node");
        this.addUsersFormNode(hs, node, isCc);
        this.replaceQuitUser(conn, hs);
        return hs;
    }

    private HashSet<String> replaceQuitUser(Connection conn, HashSet<String> hs) throws SQLException {
        String[] userId = hs.toArray(new String[hs.size()]);
        String ids = StringUtil.joinQuote(userId);
        ResultSet rs = null;
        ResultSet rs1 = null;
        PreparedStatement st = null;
        try {
            rs = conn.createStatement().executeQuery("select client from wb_flow_entrust where entrust_type = '1' and client in (" + ids + ")");
            while (rs.next()) {
                String quitUserId = rs.getString(1);
                hs.remove(quitUserId);
                st = conn.prepareStatement("select a.entrustment, CONNECT_BY_ISLEAF from (select entrustment, client from wb_flow_entrust where entrust_type = '1') a left join wb_user b on a.entrustment = b.user_id where CONNECT_BY_ISLEAF = 1 and b.status = '1' start with a.client = ? connect by prior a.entrustment = a.client");
                st.setString(1, quitUserId);
                rs1 = st.executeQuery();
                while (rs1.next()) {
                    String entrstUserId = rs1.getString(1);
                    if (hs.contains(entrstUserId)) {
                        String name = this.getNameById(conn, quitUserId);
                        throw new IllegalArgumentException("\u539f\u59cb\u5904\u7406\u4eba\u201c" + name + "\u201d\u7684\u6700\u7ec8\u59d4\u6258\u4eba\u4e3a\u4e0b\u4e00\u8282\u70b9\u5904\u7406\u4eba\uff0c\u8bf7\u901a\u77e5\u7ba1\u7406\u5458\u91cd\u65b0\u59d4\u6258\u518d\u8fdb\u884c\u5904\u7406\u8be5\u5f85\u529e\uff01");
                    }
                    hs.add(rs1.getString(1));
                }
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(rs1);
            DbUtil.close(st);
            DbUtil.close(rs);
            throw throwable;
        }
        DbUtil.close(rs1);
        DbUtil.close(st);
        DbUtil.close(rs);
        return hs;
    }

    private String getNameById(Connection conn, String userId) throws SQLException {
        String displayName = "";
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            st = conn.prepareStatement("select DISPLAY_NAME from WB_USER where USER_ID=?");
            st.setString(1, userId);
            rs = st.executeQuery();
            if (rs.next()) {
                displayName = rs.getString(1);
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(st);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(st);
        return displayName;
    }

    private void setEntrustUser(HashSet<String> hs) throws Exception {
        JSONArray entrustUsersArray = this.flowJson.optJSONArray("entrustUsers");
        JSONObject entrustUserObj = null;
        if (entrustUsersArray != null) {
            int k = 0;
            while (k < entrustUsersArray.length()) {
                entrustUserObj = entrustUsersArray.getJSONObject(k);
                String client = entrustUserObj.optString("CLIENT");
                String entrustment = entrustUserObj.optString("ENTRUSTMENT");
                if (hs.contains(entrustment)) {
                    String name = this.getNameById(this.getRequestConnection(), entrustment);
                    throw new IllegalArgumentException("\u539f\u59cb\u5904\u7406\u4eba\u201c" + name + "\u201d\u7684\u6700\u7ec8\u59d4\u6258\u4eba\u4e3a\u4e0b\u4e00\u8282\u70b9\u5904\u7406\u4eba\uff0c\u8bf7\u901a\u77e5\u7ba1\u7406\u5458\u91cd\u65b0\u59d4\u6258\u518d\u8fdb\u884c\u5904\u7406\u8be5\u5f85\u529e\uff01");
                }
                if (hs.contains(client)) {
                    hs.remove(client);
                    hs.add(entrustment);
                }
                ++k;
            }
        }
    }

    private void addUsers(Connection conn, HashSet<String> users, String sql) throws Exception {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery(sql);
            while (rs.next()) {
                users.add(rs.getString(1));
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(st);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(st);
    }

    private void deleteUsers(Connection conn) throws Exception {
        String passUsers = this.getAttribute(this.activeNode, "passUsers");
        Object st = null;
        Object rs = null;
        int totalUserCount = this.activeNode.optInt("totalUserCount");
        JSONArray doActionUsers = this.activeNode.optJSONArray("doActionUserIds");
        HashSet<String> doUserIdSet = JsonUtil.toHashSet(doActionUsers);
        int notProcessCount = doActionUsers.length();
        HashSet<String> doUsers = this.getUsers(this.getRequestConnection(), false);
        this.setEntrustUser(doUsers);
        if (doUserIdSet != null && doUsers != null && doUserIdSet.size() > 0 && doUsers.size() > 0) {
            doUsers.removeAll(doUserIdSet);
            String[] userId = doUsers.toArray(new String[doUsers.size()]);
            String ids = StringUtil.joinQuote(userId);
            if (!StringUtil.isEmpty(passUsers)) {
                boolean isPercent = passUsers.endsWith("%");
                String passValue = isPercent ? passUsers.substring(0, passUsers.length() - 1) : passUsers;
                if (!StringUtil.isInteger(passValue)) {
                    throw new RuntimeException("\u8282\u70b9\u201c" + this.activeNode + "\u201d\u7684\u901a\u8fc7\u4eba\u6570\u5c5e\u6027\u503c\u201c" + passUsers + "\u201d\u65e0\u6548\u3002");
                }
                int countValue = Integer.parseInt(passValue);
                if (isPercent) {
                    if ((double)notProcessCount * 100.0 / (double)totalUserCount >= (double)countValue) {
                        this.delOrUpdateUser(conn, ids);
                    }
                } else if (countValue == notProcessCount) {
                    this.delOrUpdateUser(conn, ids);
                }
            } else {
                this.delOrUpdateUser(conn, ids);
            }
        }
    }

    private void delOrUpdateUser(Connection conn, String ids) throws Exception {
        PreparedStatement st = null;
        try {
            st = conn.prepareStatement("delete from WB_FLOW_USER where FLOW_ID=? and IS_PROCESSED=0 and USER_ID in (" + ids + ")");
            st.setString(1, this.flowId);
            st.executeUpdate();
            st.close();
            st = conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=0 where FLOW_ID=? and NEED_PROCESS=1 and IS_PROCESSED=1 and USER_ID in (" + ids + ")");
            st.setString(1, this.flowId);
            st.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtil.close(st);
            throw throwable;
        }
        DbUtil.close(st);
    }

    private ResultSet excuteSql(JSONObject sql) throws Exception {
        ResultSet rs = null;
        Object result = DbUtil.run(this.request, sql.optString("sql"), sql.optString("jndi"));
        if (result instanceof ResultSet) {
            rs = (ResultSet)result;
        } else if (result instanceof HashMap) {
            HashMap map = (HashMap)result;
            rs = (ResultSet)map.get("result");
        }
        WebUtil.setObject(this.request, SysUtil.getId(), rs);
        return rs;
    }

    private void addUsersFormSQL(HashSet<String> users, String sql) throws Exception {
        JSONObject sqlObject;
        ResultSet rs;
        if (!StringUtil.isEmpty(sql) && (rs = this.excuteSql(sqlObject = new JSONObject(sql))) != null) {
            while (rs.next()) {
                users.add(rs.getString(1));
            }
        }
    }

    private void addUsersFormNode(HashSet<String> users, String nodes, boolean isCc) {
        if (!StringUtil.isEmpty(nodes)) {
            if (!isCc) {
                this.isLikeNode = true;
            }
            String[] nodeArray = nodes.split(",");
            int i = 0;
            while (i < nodeArray.length) {
                String node = nodeArray[i];
                JSONObject nodeLike = this.getNode(node);
                JSONArray doAction = nodeLike.optJSONArray("doActionUserIds");
                if (doAction.length() > 0) {
                    HashSet<String> user = JsonUtil.toHashSet(doAction);
                    users.addAll(user);
                }
                ++i;
            }
        }
    }

    public void checkSubFlowStart(Connection conn) throws Exception {
        boolean isSubFlowNode;
        JSONObject subNumParams = new JSONObject();
        JSONObject multNumParams = new JSONObject();
        String subFlowPath = this.activeNode.optString("subFlowPath");
        String oneConcurrentNum = null;
        String oneSubFLowPath = null;
        JSONArray multSubFlow = null;
        String multSub = this.getAttribute(this.activeNode, "multSubFlow");
        if (StrUtil.isNotBlank((CharSequence)multSub)) {
            multSubFlow = JsonUtil.getArray(multSub);
        }
        boolean bl = isSubFlowNode = StrUtil.isNotBlank((CharSequence)subFlowPath) || multSubFlow != null;
        if (this.nodeChanged && isSubFlowNode) {
            if (this.getUsers(conn, false) != null) {
                throw new IllegalArgumentException("\u5b50\u6d41\u7a0b\u8282\u70b9\u4e0d\u53ef\u914d\u7f6e\u5904\u7406\u4eba");
            }
            if (StrUtil.isNotBlank((CharSequence)this.activeNode.optString("passUsers"))) {
                throw new IllegalArgumentException("\u5b50\u6d41\u7a0b\u8282\u70b9\u4e0d\u53ef\u914d\u7f6e\u901a\u8fc7\u4eba\u6570");
            }
            String parentFlowId = this.flowId;
            JSONObject parentParams = this.removeFlowParams(this.params);
            JSONObject parentFlowData = this.flowJson;
            if (StrUtil.isNotBlank((CharSequence)subFlowPath)) {
                oneConcurrentNum = this.activeNode.optString("subFlowConcurrentNum");
                oneSubFLowPath = subFlowPath;
                subNumParams = this.startOneSubFlow(oneSubFLowPath, oneConcurrentNum, conn, parentFlowId, parentParams, parentFlowData);
            } else if (multSubFlow != null) {
                int i = 0;
                while (i < multSubFlow.length()) {
                    JSONObject oneSubFlow = multSubFlow.getJSONObject(i);
                    oneSubFLowPath = oneSubFlow.optString("oneSubFlowPath");
                    oneConcurrentNum = oneSubFlow.optString("oneConcurrentNum");
                    multNumParams = this.startOneSubFlow(oneSubFLowPath, oneConcurrentNum, conn, parentFlowId, parentParams, parentFlowData);
                    Iterator iterator = multNumParams.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        String value = multNumParams.getString(key);
                        subNumParams.put(key, (Object)value);
                    }
                    ++i;
                }
            }
        }
        this.flowJson.put("subNumParams", (Object)subNumParams);
        this.recordSubFlowTo(subNumParams);
    }

    private JSONObject startOneSubFlow(String subFlowPath, String concurrentNum, Connection conn, String parentFlowId, JSONObject parentParams, JSONObject parentFlowData) throws Exception {
        this.flowJson = parentFlowData;
        this.flowId = parentFlowId;
        JSONObject subStartParamsInfo = new JSONObject();
        int subFlowCount = this.flowJson.optInt("subFlowCount");
        if (StrUtil.isNotBlank((CharSequence)concurrentNum)) {
            JSONObject concurrentSql = new JSONObject(concurrentNum);
            ResultSet rs = this.excuteSql(concurrentSql);
            if (rs != null) {
                ResultSetMetaData rsmd = rs.getMetaData();
                int columnCount = rsmd.getColumnCount();
                if (columnCount % 2 != 0) {
                    throw new IllegalArgumentException("\u67e5\u8be2\u7684\u5217\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u5e94\u4e3a\u5076\u6570\u5217");
                }
                JSONArray paramsArray = new JSONArray();
                ArrayList<String> list = new ArrayList<String>();
                while (rs.next()) {
                    ++subFlowCount;
                    JSONObject param = new JSONObject();
                    for (String key : parentParams.keySet()) {
                        Object value = parentParams.get(key);
                        param.put(key, value);
                    }
                    param.put("parentFlowId", (Object)parentFlowId);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int i = 1;
                    while (i < columnCount) {
                        param.put(rs.getString(i), rs.getObject(i + 1));
                        arrayList.add(String.valueOf(rs.getString(i)) + "=" + rs.getObject(i + 1));
                        i += 2;
                    }
                    paramsArray.put((Object)param);
                    list.add(StrUtil.join((CharSequence)"&", (Object[])new Object[]{arrayList}));
                }
                this.flowJson.put("subFlowCount", subFlowCount);
                this.updateMainFlow(conn);
                int i = 0;
                while (i < paramsArray.length()) {
                    String subFlowId = Flow.startSubFlow(subFlowPath, paramsArray.getJSONObject(i), this.request, this.response, conn);
                    subStartParamsInfo.put(subFlowId, list.get(i));
                    ++i;
                }
            }
        } else {
            this.flowJson.put("subFlowCount", ++subFlowCount);
            this.updateMainFlow(conn);
            JSONObject param = parentParams;
            param.put("parentFlowId", (Object)parentFlowId);
            String subFlowId = Flow.startSubFlow(subFlowPath, param, this.request, this.response, conn);
            subStartParamsInfo.put(subFlowId, (Object)"");
        }
        return subStartParamsInfo;
    }

    private JSONObject getNode(String nodeName, boolean slient) {
        if (StringUtil.isEmpty(nodeName)) {
            throw new NullPointerException("Node name is empty.");
        }
        int j = this.nodes.length();
        int i = 0;
        while (i < j) {
            JSONObject node = this.nodes.getJSONObject(i);
            if (nodeName.equals(node.getString("name"))) {
                return node;
            }
            ++i;
        }
        if (slient) {
            return null;
        }
        throw new NullPointerException("Node name \"" + nodeName + "\" is not found.");
    }

    public JSONObject getNode(String nodeName) {
        return this.getNode(nodeName, false);
    }

    private String replaceParams(String value) {
        return StringUtil.replaceParams(this.params, value);
    }

    public String getAttribute(JSONObject node, String attributeName) {
        return this.replaceParams(node.optString(attributeName, null));
    }

    public String getFlowAttribute(String attributeName) {
        return this.replaceParams(this.flowProp.optString(attributeName, null));
    }

    private String getTitle(JSONObject node) {
        String title = this.getAttribute(node, "nodeTitle");
        if (StrUtil.isNotBlank((CharSequence)title)) {
            title = WebUtil.replaceParams(this.request, title);
        }
        return StringUtil.select(title, node.getString("name"));
    }

    public Connection getRequestConnection() throws Exception {
        if (this.request == null) {
            return null;
        }
        Connection conn = DbUtil.getConnection(this.request);
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        return conn;
    }

    public JSONObject insert(Connection conn) throws Exception {
        boolean newConn;
        JSONObject result = new JSONObject();
        PreparedStatement st = null;
        if (conn == null) {
            newConn = true;
            conn = DbUtil.getConnection();
        } else {
            newConn = false;
        }
        try {
            if (newConn) {
                conn.setAutoCommit(false);
            }
            int status = this.endName.equals(this.activeNodeName) ? 2 : 1;
            st = conn.prepareStatement("insert into WB_FLOW_LIST(LIST_ID,FLOW_ID,NODE_NAME,TITLE,START_DATE,START_USER_ID,START_USER_DISP_NAME,LAST_MODIFY_DATE,LAST_USER_ID,LAST_USER_DISP_NAME,FLOW_NAME,STATUS,PARENT_FLOW_ID) values(?,?,?,?,?,?,?,?,?,?,?,?,?)");
            st.setString(1, SysUtil.getId());
            st.setString(2, this.flowId);
            st.setString(3, this.activeNodeName);
            st.setString(4, this.getTitle(this.activeNode));
            st.setTimestamp(5, this.actionDate);
            DbUtil.setObject(st, 6, 12, this.userId);
            DbUtil.setObject(st, 7, 12, this.userDispName);
            st.setTimestamp(8, this.actionDate);
            DbUtil.setObject(st, 9, 12, this.userId);
            DbUtil.setObject(st, 10, 12, this.userDispName);
            st.setString(11, this.getFlowAttribute("flowName"));
            st.setInt(12, status);
            st.setString(13, this.parentFlowId);
            st.executeUpdate();
            st.close();
            if (!this.needSpecify) {
                this.reloadUsers(conn, null, false);
            }
            st = conn.prepareStatement("insert into WB_FLOW_INSTANCE(FLOW_ID,FLOW_DATA) values(?,?)");
            st.setString(1, this.flowId);
            DbUtil.setText(st, 2, this.flowJson.toString());
            st.executeUpdate();
            st.close();
            this.addNodeActionToHistory(conn);
            if (newConn) {
                conn.commit();
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(st);
            if (newConn) {
                DbUtil.close(conn);
            }
            throw throwable;
        }
        DbUtil.close(st);
        if (newConn) {
            DbUtil.close(conn);
        }
        return result;
    }

    public JSONObject update(Connection conn, String doUserId, String actionName) throws Exception {
        boolean newConn;
        PreparedStatement st = null;
        PreparedStatement delSt = null;
        PreparedStatement st1 = null;
        PreparedStatement selSt = null;
        JSONObject result = new JSONObject();
        ResultSet rs = null;
        if (conn == null) {
            newConn = true;
            conn = DbUtil.getConnection();
        } else {
            newConn = false;
        }
        try {
            if (newConn) {
                conn.setAutoCommit(false);
            }
            if (this.nodeChanged) {
                st = conn.prepareStatement("update WB_FLOW_LIST set LIST_ID=? where FLOW_ID=?");
                st.setString(1, SysUtil.getId());
                st.setString(2, this.flowId);
                st.executeUpdate();
                st.close();
            }
            st = conn.prepareStatement("update WB_FLOW_LIST set NODE_NAME=?,TITLE=?,LAST_MODIFY_DATE=?, LAST_USER_ID=?, LAST_USER_DISP_NAME=?, STATUS=? where FLOW_ID=?");
            st.setString(1, this.activeNodeName);
            String title = this.getTitle(this.activeNode);
            st.setString(2, title);
            st.setTimestamp(3, this.actionDate);
            DbUtil.setObject(st, 4, 12, this.userId);
            DbUtil.setObject(st, 5, 12, this.userDispName);
            int status = this.endName.equals(this.activeNodeName) ? 2 : 1;
            st.setInt(6, status);
            st.setString(7, this.flowId);
            st.executeUpdate();
            st.close();
            result.put("NODE_NAME", (Object)this.activeNodeName);
            result.put("TITLE", (Object)title);
            result.put("LAST_MODIFY_DATE", (Object)this.actionDate);
            result.put("LAST_USER_ID", (Object)this.userId);
            result.put("LAST_USER_DISP_NAME", (Object)this.userDispName);
            result.put("STATUS", status);
            if (!this.needSpecify) {
                if (this.setProcessed) {
                    st = conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=0,IS_PROCESSED=1 where FLOW_ID=? and USER_ID=? and IS_CC=0");
                    st.setString(1, this.flowId);
                    st.setString(2, this.userId);
                    int k = st.executeUpdate();
                    st.close();
                    if (k != 1) {
                        throw new RuntimeException("\u60a8\u4e0d\u662f\u8be5\u6d41\u7a0b\u7684\u5904\u7406\u4eba\u5458\u3002");
                    }
                    result.put("NEED_PROCESS", 0);
                    result.put("IS_PROCESSED", 1);
                    st = conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=1,IS_ASSIST=? where FLOW_ID=? and IS_ASSIST=?");
                    st.setString(1, "");
                    st.setString(2, this.flowId);
                    st.setString(3, this.userId);
                    st.executeUpdate();
                    st.close();
                    st = conn.prepareStatement("update WB_FLOW_USER set IS_TURN=? where FLOW_ID=? and IS_TURN=?");
                    st.setString(1, "");
                    st.setString(2, this.flowId);
                    st.setString(3, this.userId);
                    st.executeUpdate();
                    st.close();
                }
                if (this.nodeChanged) {
                    st = conn.prepareStatement("delete from WB_FLOW_USER where FLOW_ID=? and IS_PROCESSED=0");
                    st.setString(1, this.flowId);
                    st.executeUpdate();
                    st.close();
                    st = conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=0 where FLOW_ID=?");
                    st.setString(1, this.flowId);
                    st.executeUpdate();
                    st.close();
                    if (StrUtil.isNotBlank((CharSequence)doUserId)) {
                        st = conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=1 where FLOW_ID=? and USER_ID in (" + doUserId + ")");
                        st.setString(1, this.flowId);
                        st.executeUpdate();
                        st.close();
                    } else {
                        this.reloadUsers(conn, result, false);
                    }
                } else {
                    int j = this.newUserList.size();
                    if (j > 0) {
                        int i;
                        String newUserId = this.newUserList.get(0);
                        selSt = conn.prepareStatement("select count(1) from WB_FLOW_USER where FLOW_ID=? and IS_TURN=?");
                        selSt.setString(1, this.flowId);
                        selSt.setString(2, newUserId);
                        rs = selSt.executeQuery();
                        if (rs.next() && (i = rs.getInt(1)) == 1) {
                            throw new IllegalArgumentException("\u8be5\u7528\u6237\u5df2\u662f\u8f6c\u529e\u4eba\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                        }
                        rs.close();
                        selSt.close();
                        selSt = conn.prepareStatement("select count(1) from WB_FLOW_USER where FLOW_ID=? and IS_ASSIST=?");
                        selSt.setString(1, this.flowId);
                        selSt.setString(2, newUserId);
                        rs = selSt.executeQuery();
                        if (rs.next() && (i = rs.getInt(1)) == 1) {
                            throw new IllegalArgumentException("\u8be5\u7528\u6237\u5df2\u662f\u534f\u529e\u4eba\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                        }
                        rs.close();
                        selSt.close();
                        delSt = "turn".equals(actionName) ? conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=0,IS_TURN=? where FLOW_ID=? and USER_ID=?") : conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=0,IS_ASSIST=? where FLOW_ID=? and USER_ID=?");
                        delSt.setString(1, newUserId);
                        delSt.setString(2, this.flowId);
                        delSt.setString(3, this.userId);
                        delSt.executeUpdate();
                        delSt.close();
                        if (newUserId.equals(this.userId)) {
                            result.put("NEED_PROCESS", 1);
                        }
                        st = conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=1,IS_CC=0 where FLOW_ID=? and USER_ID=? and IS_PROCESSED=1");
                        st.setString(1, this.flowId);
                        st.setString(2, newUserId);
                        int count = st.executeUpdate();
                        if (count != 1) {
                            st1 = conn.prepareStatement("insert into WB_FLOW_USER(S_ID,FLOW_ID,USER_ID,NEED_PROCESS,IS_PROCESSED,IS_CC) values(?,?,?,1,0,0)");
                            st1.setString(1, SysUtil.getId());
                            st1.setString(2, this.flowId);
                            st1.setString(3, newUserId);
                            st1.executeUpdate();
                            st1.close();
                        }
                        st.close();
                    }
                    this.deleteUsers(conn);
                }
            }
            st = conn.prepareStatement("update WB_FLOW_INSTANCE set FLOW_DATA=? where FLOW_ID=?");
            DbUtil.setText(st, 1, this.flowJson.toString());
            st.setString(2, this.flowId);
            st.executeUpdate();
            st.close();
            this.addNodeActionToHistory(conn);
            if (newConn) {
                conn.commit();
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(st);
            DbUtil.close(delSt);
            if (newConn) {
                DbUtil.close(conn);
            }
            throw throwable;
        }
        DbUtil.close(st);
        DbUtil.close(delSt);
        if (newConn) {
            DbUtil.close(conn);
        }
        return result;
    }

    public void updateMainFlow(Connection conn) throws Exception {
        PreparedStatement st = null;
        st = conn.prepareStatement("update WB_FLOW_INSTANCE set FLOW_DATA=? where FLOW_ID=?");
        DbUtil.setText(st, 1, this.flowJson.toString());
        st.setString(2, this.flowId);
        st.executeUpdate();
        st.close();
    }

    public void remove(Connection conn) throws Exception {
        boolean newConn;
        PreparedStatement st = null;
        if (conn == null) {
            newConn = true;
            conn = DbUtil.getConnection();
        } else {
            newConn = false;
        }
        try {
            if (newConn) {
                conn.setAutoCommit(false);
            }
            st = conn.prepareStatement("delete from  WB_FLOW_LIST where FLOW_ID=?");
            st.setString(1, this.flowId);
            st.executeUpdate();
            st.close();
            st = conn.prepareStatement("delete from WB_FLOW_USER where FLOW_ID=?");
            st.setString(1, this.flowId);
            st.executeUpdate();
            st.close();
            st = conn.prepareStatement("delete from WB_FLOW_INSTANCE where FLOW_ID=?");
            st.setString(1, this.flowId);
            st.executeUpdate();
            st.close();
            st = conn.prepareStatement("delete from WB_FLOW_HISTORY where FLOW_ID=?");
            st.setString(1, this.flowId);
            st.executeUpdate();
            st.close();
            if (newConn) {
                conn.commit();
            }
        }
        finally {
            if (newConn) {
                DbUtil.close(conn);
            }
        }
    }

    private void reloadUsers(Connection conn, JSONObject result, boolean isInsert) throws Exception {
        HashSet<String> doUsers = null;
        int index = 1;
        HashSet<String> updateUsers = new HashSet<String>();
        PreparedStatement st1 = null;
        PreparedStatement st2 = null;
        PreparedStatement st3 = null;
        ResultSet rs = null;
        boolean hasResult = result != null;
        try {
            boolean needUpdate;
            if (isInsert) {
                needUpdate = false;
            } else {
                st3 = conn.prepareStatement("select USER_ID from WB_FLOW_USER where FLOW_ID=?");
                st3.setString(1, this.flowId);
                rs = st3.executeQuery();
                while (rs.next()) {
                    updateUsers.add(rs.getString(1));
                }
                rs.close();
                st3.close();
                needUpdate = !updateUsers.isEmpty();
            }
            st1 = conn.prepareStatement("insert into WB_FLOW_USER(S_ID,FLOW_ID,USER_ID,NEED_PROCESS,IS_PROCESSED,IS_CC) values(?,?,?,?,?,?)");
            st1.setString(2, this.flowId);
            if (needUpdate) {
                st2 = conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=?,IS_CC=? where FLOW_ID=? and USER_ID=?");
                st2.setString(3, this.flowId);
            }
            int i = 0;
            while (i < 2) {
                st1.setInt(6, i);
                st1.setInt(4, i == 0 ? 1 : 0);
                st1.setInt(5, 0);
                if (needUpdate) {
                    st2.setInt(1, i == 0 ? 1 : 0);
                    st2.setInt(2, i);
                }
                HashSet<String> users = this.getUsers(conn, i != 0);
                if (i == 0) {
                    this.setEntrustUser(users);
                    doUsers = users;
                    if (users != null && users.size() == 1 && users.toArray()[0] == null || users != null && users.size() == 0) {
                        throw new IllegalArgumentException("\u4e0b\u4e00\u8282\u70b9\u6ca1\u6709\u5904\u7406\u4eba\u63a5\u6536\u5f85\u529e\u4e86");
                    }
                } else if (users != null && doUsers != null) {
                    users.removeAll(doUsers);
                }
                if (users != null) {
                    if (i == 0) {
                        this.activeNode.put("totalUserCount", users.size());
                    }
                    for (String user : users) {
                        if (needUpdate && updateUsers.contains(user)) {
                            if (hasResult && user.equals(this.userId)) {
                                result.put("NEED_PROCESS", 1);
                                result.put("IS_CC", i);
                            }
                            st2.setString(4, user);
                            st2.addBatch();
                            if (index % 1000 == 0) {
                                st2.executeBatch();
                            }
                        } else {
                            st1.setString(1, SysUtil.getId());
                            st1.setString(3, user);
                            st1.addBatch();
                            if (index % 1000 == 0) {
                                st1.executeBatch();
                            }
                        }
                        ++index;
                    }
                }
                ++i;
            }
            st1.executeBatch();
            if (needUpdate) {
                st2.executeBatch();
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(st1);
            DbUtil.close(st2);
            throw throwable;
        }
        DbUtil.close(st1);
        DbUtil.close(st2);
    }

    private void checkEnd() {
        if (this.endName.equals(this.activeNodeName)) {
            throw new RuntimeException("\u8be5\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f\u3002");
        }
    }

    public JSONObject insert() throws Exception {
        return this.insert(this.getRequestConnection());
    }

    public JSONObject update(String userId, String actionName) throws Exception {
        return this.update(this.getRequestConnection(), userId, actionName);
    }

    public JSONObject getDialog(int flowNum, String flowIds) throws Exception {
        String dialog = this.getAttribute(this.activeNode, "dialog");
        String multDialog = this.getAttribute(this.activeNode, "multDialog");
        if (flowNum > 1 && StrUtil.isBlank((CharSequence)multDialog)) {
            throw new NullPointerException("\u6d41\u7a0b\u5f53\u524d\u8282\u70b9\u6ca1\u6709\u914d\u7f6e\u6279\u91cf\u5904\u7406\u5bf9\u8bdd\u6846\u5c5e\u6027\u3002");
        }
        if (flowNum > 1 && StrUtil.isNotBlank((CharSequence)multDialog)) {
            dialog = multDialog;
        } else if (StringUtil.isEmpty(dialog) ? StringUtil.isEmpty(dialog = this.getFlowAttribute("defaultDialog")) : "-".equals(dialog)) {
            return null;
        }
        JSONObject result = new JSONObject();
        JSONArray selActions = new JSONArray();
        JSONArray allActions = JsonUtil.getArray(this.getAttribute(this.activeNode, "actionType"));
        if (allActions != null) {
            int j = allActions.length();
            int i = 0;
            while (i < j) {
                JSONObject action = allActions.getJSONObject(i);
                String iconCls = action.optString("iconCls");
                if (!iconCls.isEmpty()) {
                    action.put("iconCls", (Object)(String.valueOf(iconCls) + "_icon"));
                }
                if (action.getInt("selected") == 1) {
                    action.remove("selected");
                    selActions.put((Object)action);
                }
                ++i;
            }
        }
        JSONObject configs = WbUtil.getModuleConfigs(dialog);
        String content = configs.optString("serverScript");
        content = content.replaceAll("/\\*{1,2}[\\s\\S]*?\\*/", "");
        if (StrUtil.isNotBlank((CharSequence)(content = content.replaceAll("//[\\s\\S]*?\\n", ""))) && StrUtil.containsIgnoreCase((CharSequence)content, (CharSequence)"app.procSql")) {
            int startIndex = StrUtil.indexOf((CharSequence)content, (CharSequence)"app.procSql", (int)0, (boolean)false);
            int endIndex = StrUtil.indexOf((CharSequence)content, (CharSequence)"?})}", (int)0, (boolean)false);
            String procSql = StrUtil.sub((CharSequence)content, (int)startIndex, (int)(endIndex + 5));
            result.put("procSql", (Object)StringUtil.concat("{", StringUtils.subString((String)procSql, (String)"{", (String)"}", (boolean)true), "}"));
        } else {
            result.put("procSql", (Object)"");
        }
        result.put("module", (Object)WbUtil.run(dialog, this.params, this.request, true));
        result.put("path", (Object)dialog);
        Integer minWidth = (Integer)JsonUtil.opt(this.activeNode, "minWidth");
        if (minWidth == null) {
            minWidth = (Integer)JsonUtil.opt(this.flowProp, "defaultMinWidth");
        }
        if (minWidth != null) {
            result.put("minWidth", (Object)minWidth);
        }
        result.put("actions", (Object)selActions);
        result.put("flowParams", (Object)this.params);
        result.put("history", (Object)this.history);
        result.put("assistAndTurnUser", (Object)this.activeNode.optJSONArray("assistAndTurnUser"));
        result.put("isMainFill", this.flowJson.optBoolean("isMainFill"));
        this.MultDealNode(result);
        return result;
    }

    private void MultDealNode(JSONObject result) {
        String passUsers = this.activeNode.optString("passUsers");
        if (StrUtil.isNotBlank((CharSequence)passUsers)) {
            boolean isPercent = passUsers.endsWith("%");
            String passValue = isPercent ? passUsers.substring(0, passUsers.length() - 1) : passUsers;
            if (!StringUtil.isInteger(passValue)) {
                throw new RuntimeException("\u8282\u70b9\u201c" + this.activeNode + "\u201d\u7684\u901a\u8fc7\u4eba\u6570\u5c5e\u6027\u503c\u201c" + passUsers + "\u201d\u65e0\u6548\u3002");
            }
            int countValue = Integer.parseInt(passValue);
            if (isPercent) {
                int totalUserCount = this.activeNode.getInt("totalUserCount");
                int passUserCount = (int)Math.ceil((double)countValue / 100.0 * (double)totalUserCount);
                if (passUserCount == 1) {
                    result.put("isMultPassUser", false);
                } else {
                    result.put("isMultPassUser", true);
                }
            } else if (countValue == 1) {
                result.put("isMultPassUser", false);
            } else {
                result.put("isMultPassUser", true);
            }
        } else {
            result.put("isMultPassUser", false);
        }
    }

    public JSONObject getViewDialog(String type) throws Exception {
        JSONObject result = new JSONObject();
        result.put("flowParams", (Object)this.params);
        result.put("history", (Object)this.history);
        if (this.history.length() > 1) {
            this.getRetreatUser(result);
        }
        this.getCancelAssiUser(result);
        this.getCancelTurnUser(result);
        String dialog = null;
        if ("2".equals(type)) {
            this.getDoneNode();
        }
        if (StringUtil.isEmpty(dialog = this.getAttribute(this.activeNode, "viewDialog")) ? StringUtil.isEmpty(dialog = this.getFlowAttribute("defaultViewDialog")) : "-".equals(dialog)) {
            return null;
        }
        result.put("module", (Object)WbUtil.run(dialog, this.params, this.request, true));
        result.put("path", (Object)dialog);
        return result;
    }

    public JSONObject getRetreatUser(JSONObject result) throws Exception {
        boolean isSub;
        boolean needRetreat = false;
        boolean bl = isSub = StrUtil.isNotBlank((CharSequence)this.parentFlowId) && this.endName.equals(this.activeNodeName);
        if (isSub) {
            FlowObject mainFlow = new FlowObject(Flow.getFlowData(this.parentFlowId, this.request), null, this.request, this.response, null, false);
            needRetreat = mainFlow.subRetreat();
        }
        JSONObject lastRecord = this.history.getJSONObject(this.history.length() - 1);
        String lastNodeName = lastRecord.optString("node");
        JSONArray userArray = new JSONArray();
        if (isSub && !needRetreat) {
            userArray = null;
        } else if (!lastNodeName.equals(this.activeNodeName)) {
            if (!lastNodeName.equals(this.startName) || StrUtil.isNotBlank((CharSequence)this.parentFlowId)) {
                this.setActiveNode(lastNodeName);
                userArray = this.activeNode.optJSONArray("retreatUserIds");
            }
        } else {
            userArray = this.activeNode.optJSONArray("retreatUserIds");
        }
        result.put("serialUser", (Object)userArray);
        return result;
    }

    public JSONObject getCancelAssiUser(JSONObject result) throws Exception {
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        JSONArray userArray = new JSONArray();
        try {
            conn = DbUtil.getConnection();
            st = conn.prepareStatement("select USER_ID from WB_FLOW_USER where FLOW_ID=? and IS_ASSIST is not null");
            st.setString(1, this.flowId);
            rs = st.executeQuery();
            while (rs.next()) {
                userArray.put((Object)rs.getString(1));
            }
            result.put("cancelAssiUser", (Object)userArray);
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(st);
        DbUtil.close(conn);
        return result;
    }

    public JSONObject getCancelTurnUser(JSONObject result) throws Exception {
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        JSONArray userArray = new JSONArray();
        try {
            conn = DbUtil.getConnection();
            st = conn.prepareStatement("select USER_ID from WB_FLOW_USER where FLOW_ID=? and IS_TURN is not null");
            st.setString(1, this.flowId);
            rs = st.executeQuery();
            while (rs.next()) {
                userArray.put((Object)rs.getString(1));
            }
            result.put("cancelTurnUser", (Object)userArray);
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(st);
        DbUtil.close(conn);
        return result;
    }

    public void checkActiveNode(String nodeName) {
        if (!this.activeNodeName.equals(nodeName)) {
            throw new IllegalArgumentException("\u6d41\u7a0b\u5f53\u524d\u8282\u70b9\u4e0d\u662f\u201c" + nodeName + "\u201d\u3002");
        }
    }

    public String reject(JSONArray rejectTo, boolean isMainFlow, Connection conn) throws Exception {
        this.sysOpinion = rejectTo.getJSONObject(0).optString("systemOpinion");
        int j = rejectTo.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> subFlowArrayList = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        if (isMainFlow) {
            String nodeName = rejectTo.getJSONObject(0).optString("node");
            int i = 0;
            while (i < j) {
                JSONObject nodeInfo = rejectTo.getJSONObject(i);
                String itemId = nodeInfo.optString("itemId");
                JSONObject item = JsonUtil.findObject(this.history, "itemId", itemId);
                if (item == null) {
                    throw new RuntimeException("\u65e0\u6cd5\u9000\u56de\u5230\u6307\u5b9a\u8282\u70b9\uff0c\u56e0\u4e3a\u8be5\u8282\u70b9\u4e0d\u5b58\u5728\u3002");
                }
                nodeName = item.getString("node");
                String user = item.getString("userId");
                arrayList.add(user);
                if (!this.inHistory(nodeName)) {
                    throw new RuntimeException("\u65e0\u6cd5\u9000\u56de\u5230\u6307\u5b9a\u8282\u70b9\uff0c\u56e0\u4e3a\u8be5\u8282\u70b9\u4e0d\u5728\u5904\u7406\u5386\u53f2\u8bb0\u5f55\u4e2d\u3002");
                }
                if (nodeName.equals(this.activeNodeName)) {
                    throw new RuntimeException("\u65e0\u6cd5\u9000\u56de\u5230\u5f53\u524d\u8282\u70b9\u3002");
                }
                ++i;
            }
            this.recordHistory("reject");
            JSONArray doActionUsers = this.activeNode.optJSONArray("retreatUserIds");
            HashSet<String> doUserIdSet = JsonUtil.toHashSet(doActionUsers);
            if (!doUserIdSet.contains(this.userId)) {
                doActionUsers.put((Object)this.userId);
                this.activeNode.put("retreatUserIds", (Object)doActionUsers);
            }
            this.setActiveNode(nodeName);
            int doUserCount = this.activeNode.getInt("doUserCount");
            this.activeNode.put("doUserCount", doUserCount - j);
        } else {
            this.recordHistory("reject");
            HashSet<String> hs = new HashSet<String>();
            JSONObject subNumParams = this.flowJson.optJSONObject("subNumParams");
            int i = 0;
            while (i < j) {
                JSONObject subFlowInfo = rejectTo.optJSONObject(i);
                if (subFlowInfo != null) {
                    String nodeName = subFlowInfo.optString("node");
                    hs.add(nodeName);
                    String subFlowId = subFlowInfo.optString("flowId");
                    subFlowArrayList.add(subFlowId);
                    String rejectUserId = subFlowInfo.optString("userId");
                    arrayList.add(rejectUserId);
                    FlowObject subFlow = new FlowObject(Flow.getFlowData(subFlowId, this.request), null, this.request, this.response, null, false);
                    subFlow.rejectToSubFlow(nodeName, rejectUserId, conn);
                    String nodeKey = "\u3010\u5b50\u6d41\u7a0b\u3011" + subNumParams.optString(subFlowId) + "\u3010\u6d41\u5411\u8282\u70b9\u3011" + nodeName;
                    String userInfo = String.valueOf(subFlowInfo.optString("displayName")) + "(" + subFlowInfo.optString("userName") + ")";
                    if (map.containsKey(nodeKey)) {
                        String oldValue = (String)map.get(nodeKey);
                        map.put(nodeKey, String.valueOf(oldValue) + "," + userInfo);
                    } else {
                        map.put(nodeKey, userInfo);
                    }
                }
                ++i;
            }
            this.flowJson.put("subFlowCount", hs.size());
            WebUtil.replaceAllAttributes(this.request, this.params);
            this.setActiveNode(this.flowJson.optString("subNodeName"));
            this.activeNode.put("doUserCount", 0);
            this.nodeChanged = false;
            ArrayList<String> toInfo = new ArrayList<String>();
            int count = 0;
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                toInfo.add("\u3010" + ++count + "\u3011" + key + "\u3010\u6d41\u5411\u5904\u7406\u4eba\u3011" + val);
            }
            this.sysToUser = StrUtil.join((CharSequence)"</br>", (Object[])new Object[]{toInfo});
        }
        String needDealUser = StringUtil.joinQuote(arrayList);
        this.subFlowId = StrUtil.join((CharSequence)",", (Object[])new Object[]{subFlowArrayList});
        return needDealUser;
    }

    private void rejectToSubFlow(String nodeName, String rejectUserId, Connection conn) throws Exception {
        WebUtil.replaceAllAttributes(this.request, this.params);
        this.setActiveNode(nodeName);
        int doUserCount = this.activeNode.getInt("doUserCount");
        this.activeNode.put("doUserCount", --doUserCount);
        PreparedStatement st = null;
        st = conn.prepareStatement("update WB_FLOW_LIST set LIST_ID=?,NODE_NAME=?,TITLE=?, STATUS=? where FLOW_ID=?");
        st.setString(1, SysUtil.getId());
        st.setString(2, this.activeNodeName);
        st.setString(3, this.getTitle(this.activeNode));
        st.setInt(4, 1);
        st.setString(5, this.flowId);
        st.executeUpdate();
        st.close();
        st = conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=1 where FLOW_ID=? and USER_ID=?");
        st.setString(1, this.flowId);
        st.setString(2, rejectUserId);
        st.executeUpdate();
        st.close();
        st = conn.prepareStatement("update WB_FLOW_INSTANCE set FLOW_DATA=? where FLOW_ID=?");
        DbUtil.setText(st, 1, this.flowJson.toString());
        st.setString(2, this.flowId);
        st.executeUpdate();
        st.close();
    }

    public String fillSign(JSONArray fillSignTo, boolean isMainFlow, Connection conn) throws Exception {
        this.sysOpinion = fillSignTo.getJSONObject(0).optString("systemOpinion");
        int j = fillSignTo.length();
        String filledUser = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> subFlowArrayList = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        if (isMainFlow) {
            String nodeName = fillSignTo.getJSONObject(0).optString("node");
            int i = 0;
            while (i < j) {
                JSONObject nodeInfo = fillSignTo.getJSONObject(i);
                String userInfo = String.valueOf(nodeInfo.optString("displayName")) + "(" + nodeInfo.optString("userName") + ")";
                String itemId = nodeInfo.optString("itemId");
                JSONObject item = JsonUtil.findObject(this.history, "itemId", itemId);
                filledUser = item.getString("userId");
                arrayList.add(filledUser);
                if (item == null) {
                    throw new RuntimeException("\u65e0\u6cd5\u8865\u7b7e\u5230\u6307\u5b9a\u8282\u70b9\uff0c\u56e0\u4e3a\u8be5\u8282\u70b9\u4e0d\u5b58\u5728\u3002");
                }
                nodeName = item.getString("node");
                if (!this.inHistory(nodeName)) {
                    throw new RuntimeException("\u65e0\u6cd5\u8865\u7b7e\u5230\u6307\u5b9a\u8282\u70b9\uff0c\u56e0\u4e3a\u8be5\u8282\u70b9\u4e0d\u5728\u5904\u7406\u5386\u53f2\u8bb0\u5f55\u4e2d\u3002");
                }
                if (nodeName.equals(this.activeNodeName)) {
                    throw new RuntimeException("\u65e0\u6cd5\u8865\u7b7e\u5230\u5f53\u524d\u8282\u70b9\u3002");
                }
                ++i;
            }
            this.recordHistory("fillSign");
            JSONArray doActionUsers = this.activeNode.optJSONArray("retreatUserIds");
            HashSet<String> doUserIdSet = JsonUtil.toHashSet(doActionUsers);
            if (!doUserIdSet.contains(this.userId)) {
                doActionUsers.put((Object)this.userId);
                this.activeNode.put("retreatUserIds", (Object)doActionUsers);
            }
            this.addFillLink(nodeName, filledUser);
            this.setActiveNode(nodeName);
            int doUserCount = this.activeNode.getInt("doUserCount");
            this.activeNode.put("doUserCount", doUserCount - j);
        } else {
            this.recordHistory("fillSign");
            HashSet<String> hs = new HashSet<String>();
            JSONObject subNumParams = this.flowJson.optJSONObject("subNumParams");
            this.flowJson.put("mainFillNodeName", (Object)this.activeNodeName);
            this.flowJson.put("mainFillUserId", (Object)this.userId);
            int i = 0;
            while (i < j) {
                JSONObject subFlowInfo = fillSignTo.optJSONObject(i);
                if (subFlowInfo != null) {
                    String nodeName = subFlowInfo.optString("node");
                    hs.add(nodeName);
                    String subFlowId = subFlowInfo.optString("flowId");
                    subFlowArrayList.add(subFlowId);
                    String fillUserId = subFlowInfo.optString("userId");
                    FlowObject subFlow = new FlowObject(Flow.getFlowData(subFlowId, this.request), null, this.request, this.response, null, false);
                    subFlow.fillSignToSubFlow(nodeName, fillUserId, conn);
                    arrayList.add(fillUserId);
                    String nodeKey = "\u3010\u5b50\u6d41\u7a0b\u3011" + subNumParams.optString(subFlowId) + "\u3010\u6d41\u5411\u8282\u70b9\u3011" + nodeName;
                    String userInfo = String.valueOf(subFlowInfo.optString("displayName")) + "(" + subFlowInfo.optString("userName") + ")";
                    if (map.containsKey(nodeKey)) {
                        String oldValue = (String)map.get(nodeKey);
                        map.put(nodeKey, String.valueOf(oldValue) + "," + userInfo);
                    } else {
                        map.put(nodeKey, userInfo);
                    }
                }
                ++i;
            }
            this.flowJson.put("subFlowCount", hs.size());
            WebUtil.replaceAllAttributes(this.request, this.params);
            this.setActiveNode(this.flowJson.optString("subNodeName"));
            this.activeNode.put("doUserCount", 0);
            this.nodeChanged = false;
            ArrayList<String> toInfo = new ArrayList<String>();
            int count = 0;
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                toInfo.add("\u3010" + ++count + "\u3011" + key + "\u3010\u6d41\u5411\u5904\u7406\u4eba\u3011" + val);
            }
            this.sysToUser = StrUtil.join((CharSequence)"</br>", (Object[])new Object[]{toInfo});
        }
        String needDealUser = StringUtil.joinQuote(arrayList);
        this.subFlowId = StrUtil.join((CharSequence)",", (Object[])new Object[]{subFlowArrayList});
        return needDealUser;
    }

    private void fillSignToSubFlow(String nodeName, String fillUserId, Connection conn) throws Exception {
        WebUtil.replaceAllAttributes(this.request, this.params);
        this.setActiveNode(nodeName);
        int doUserCount = this.activeNode.getInt("doUserCount");
        this.activeNode.put("doUserCount", --doUserCount);
        this.flowJson.put("isMainFill", true);
        PreparedStatement st = null;
        st = conn.prepareStatement("update WB_FLOW_LIST set LIST_ID=?,NODE_NAME=?,TITLE=?, STATUS=? where FLOW_ID=?");
        st.setString(1, SysUtil.getId());
        st.setString(2, this.activeNodeName);
        st.setString(3, this.getTitle(this.activeNode));
        st.setInt(4, 1);
        st.setString(5, this.flowId);
        st.executeUpdate();
        st.close();
        st = conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=1 where FLOW_ID=? and USER_ID = ?");
        st.setString(1, this.flowId);
        st.setString(2, fillUserId);
        st.executeUpdate();
        st.close();
        st = conn.prepareStatement("update WB_FLOW_INSTANCE set FLOW_DATA=? where FLOW_ID=?");
        DbUtil.setText(st, 1, this.flowJson.toString());
        st.setString(2, this.flowId);
        st.executeUpdate();
        st.close();
    }

    public void recordHistory(String actionName) {
        this.nodeAction = new JSONObject();
        this.nodeAction.put("itemId", (Object)SysUtil.getId());
        this.nodeAction.put("date", (Object)this.actionDate);
        this.nodeAction.put("userId", (Object)this.userId);
        this.nodeAction.put("userName", (Object)this.userName);
        this.nodeAction.put("userDispName", (Object)this.userDispName);
        this.nodeAction.put("node", (Object)this.activeNodeName);
        this.nodeAction.put("title", (Object)this.getTitle(this.activeNode));
        this.nodeAction.put("action", (Object)actionName);
        this.nodeAction.put("actionDisplayName", (Object)this.request.getParameter("actionDisplayName"));
        this.history.put((Object)this.nodeAction);
        this.params.put("flow.action", (Object)actionName);
        this.params.put("flow.actionDisplayName", (Object)this.request.getParameter("actionDisplayName"));
    }

    public void recordActionUser() {
        JSONArray doActionUsers = this.activeNode.optJSONArray("doActionUserIds");
        HashSet<String> doUserIdSet = JsonUtil.toHashSet(doActionUsers);
        JSONArray assiAndTurnUser = this.activeNode.optJSONArray("assistAndTurnUser");
        HashSet<String> assiAndTurnSet = JsonUtil.toHashSet(assiAndTurnUser);
        if (!doUserIdSet.contains(this.userId) && !assiAndTurnSet.contains(this.userId)) {
            doActionUsers.put((Object)this.userId);
            this.activeNode.put("doActionUserIds", (Object)doActionUsers);
        }
    }

    public void remove(String action) {
        if (this.nodeChanged && ("pass".equals(action) || "reject".equals(action) || "fillSign".equals(action))) {
            this.activeNode.put("retreatUserIds", (Object)new JSONArray());
            this.activeNode.put("assistAndTurnUser", (Object)new JSONArray());
        }
        int j = this.links.length();
        JSONObject link = null;
        int i = 0;
        while (i < j) {
            link = this.links.optJSONObject(i);
            boolean isFillSign = link.optBoolean("isFillSign");
            String fillSignUser = link.optString("fillSignUser");
            if (StrUtil.isNotBlank((CharSequence)fillSignUser) && this.userId.equals(fillSignUser) && !isFillSign) {
                this.links.remove(i);
            }
            ++i;
        }
    }

    private void addNodeActionToHistory(Connection conn) throws Exception {
        if (this.nodeAction != null) {
            PreparedStatement st = null;
            int length = this.history.length();
            Timestamp date = length > 1 ? this.history.getJSONObject(length - 2).getTimestamp("date") : this.actionDate;
            try {
                st = conn.prepareStatement("INSERT INTO WB_FLOW_HISTORY(ITEM_ID,FLOW_ID,ACTION,DEAL_DATE,NODE,TITLE,USER_DISP_NAME,USER_ID,USER_NAME,ACTION_DISP_NAME,SYS_OPINION,TO_SUBFLOW,SUBFLOW_ID,RECEIVE_DATE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                st.setString(1, this.nodeAction.optString("itemId"));
                st.setString(2, this.flowId);
                st.setString(3, this.nodeAction.optString("action"));
                st.setTimestamp(4, this.actionDate);
                st.setString(5, this.nodeAction.optString("node"));
                st.setString(6, this.nodeAction.optString("title"));
                st.setString(7, this.userDispName);
                st.setString(8, this.userId);
                st.setString(9, this.userName);
                st.setString(10, this.nodeAction.optString("actionDisplayName"));
                st.setString(11, this.sysOpinion);
                st.setString(12, this.sysToUser);
                st.setString(13, this.subFlowId);
                st.setTimestamp(14, date);
                st.executeUpdate();
            }
            finally {
                DbUtil.close(st);
            }
        }
    }

    private boolean inHistory(String nodeName) {
        int j = this.history.length();
        int i = 0;
        while (i < j) {
            if (nodeName.equals(this.history.getJSONObject(i).getString("node"))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void insertNode(String newNodeName, String actionText, String nodeTitle, String passUsers, JSONObject userData, boolean insertBefore) {
        JSONObject node = this.getNode(newNodeName, true);
        if (node != null) {
            throw new RuntimeException("\u8282\u70b9\u540d\u79f0\u201c" + newNodeName + "\u201d\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6307\u5b9a\u4e00\u4e2a\u8282\u70b9\u540d\u79f0\u3002");
        }
        node = new JSONObject();
        this.nodes.put((Object)node);
        JSONArray actions = new JSONArray();
        JSONObject action = new JSONObject();
        action.put("selected", 1);
        action.put("name", (Object)"pass");
        action.put("text", (Object)actionText);
        action.put("iconCls", (Object)"ok");
        actions.put((Object)action);
        action = new JSONObject();
        action.put("selected", 1);
        action.put("name", (Object)"cancel");
        action.put("text", (Object)Str.format(this.request, "cancel"));
        action.put("iconCls", (Object)"cancel");
        actions.put((Object)action);
        node.put("actionType", (Object)actions);
        node.put("dialog", (Object)this.getAttribute(this.activeNode, "dialog"));
        node.put("doUser", (Object)userData);
        node.put("name", (Object)newNodeName);
        node.put("nodeTitle", (Object)nodeTitle);
        node.put("passUsers", (Object)passUsers);
        node.put("doUserCount", 0);
        node.put("insertBefore", insertBefore);
        this.insertLink(newNodeName, insertBefore);
    }

    private void insertLink(String newNodeName, boolean insertBefore) {
        JSONObject link;
        int j = this.links.length();
        int i = 0;
        while (i < j) {
            link = this.links.getJSONObject(i);
            if (insertBefore) {
                if (this.activeNodeName.equals(link.getString("to"))) {
                    link.put("to", (Object)newNodeName);
                }
            } else if (this.activeNodeName.equals(link.getString("from"))) {
                link.put("from", (Object)newNodeName);
            }
            ++i;
        }
        link = new JSONObject();
        this.links.put((Object)link);
        if (insertBefore) {
            link.put("from", (Object)newNodeName);
            link.put("to", (Object)this.activeNodeName);
            link.put("signUser", (Object)this.userId);
        } else {
            link.put("from", (Object)this.activeNodeName);
            link.put("to", (Object)newNodeName);
        }
    }

    private void addFillLink(String fillNodeName, String filledUser) {
        JSONObject link = new JSONObject();
        this.links.put((Object)link);
        link.put("from", (Object)fillNodeName);
        link.put("to", (Object)this.activeNodeName);
        link.put("isFillSign", true);
        link.put("fillSignUser", (Object)this.userId);
        link.put("filledUser", (Object)filledUser);
    }

    public void beforeSign(String newNodeName, String passName, String nodeTitle, String passUsers, JSONObject userData) {
        this.recordHistory("beforeSign");
        this.insertNode(newNodeName, passName, nodeTitle, passUsers, userData, true);
        this.setActiveNode(newNodeName);
    }

    public void afterSign(String newNodeName, String passName, String nodeTitle, String passUsers, JSONObject userData) {
        this.recordHistory("afterSign");
        this.setProcessed = false;
        this.insertNode(newNodeName, passName, nodeTitle, passUsers, userData, false);
    }

    public void counterSign(String newNodeName, String passName, String nodeTitle, String passUsers, JSONObject userData) {
        this.recordHistory("counterSign");
        this.insertNode(newNodeName, passName, nodeTitle, passUsers, userData, true);
        this.setActiveNode(newNodeName);
    }

    public void assistSign(JSONObject userData, String opinionData) throws Exception {
        this.recordHistory("assistSign");
        this.sysOpinion = opinionData;
        this.addNewUsers(userData);
        int doUserCount = this.activeNode.getInt("doUserCount");
        this.activeNode.put("doUserCount", --doUserCount);
        JSONArray doActionUsers = this.activeNode.optJSONArray("assistAndTurnUser");
        HashSet<String> doUserIdSet = JsonUtil.toHashSet(doActionUsers);
        if (!doUserIdSet.contains(this.newUserList.get(0))) {
            doActionUsers.put((Object)this.newUserList.get(0));
            this.activeNode.put("assistAndTurnUser", (Object)doActionUsers);
        }
    }

    public JSONObject cancelAssiOrTurn(String actionName, String opinionData, Connection conn) throws Exception {
        this.sysOpinion = opinionData;
        JSONObject result = new JSONObject();
        PreparedStatement selSt = null;
        PreparedStatement delSt = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        selSt = conn.prepareStatement("select IS_ASSIST,IS_TURN from WB_FLOW_USER where FLOW_ID=? and USER_ID=?");
        selSt.setString(1, this.flowId);
        selSt.setString(2, this.userId);
        rs = selSt.executeQuery();
        while (rs.next()) {
            String assistUserId;
            if ("cancelAssiSign".equals(actionName)) {
                assistUserId = rs.getString(1);
                int doUserCount = this.activeNode.getInt("doUserCount");
                this.activeNode.put("doUserCount", ++doUserCount);
            } else {
                assistUserId = "cancelTurn".equals(actionName) ? rs.getString(2) : "";
            }
            delSt = conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=0 where FLOW_ID=? and USER_ID=? and IS_PROCESSED=1");
            delSt.setString(1, this.flowId);
            delSt.setString(2, assistUserId);
            delSt.executeUpdate();
            delSt.close();
            delSt = conn.prepareStatement("delete from WB_FLOW_USER where FLOW_ID=? and IS_PROCESSED=0 and USER_ID=?");
            delSt.setString(1, this.flowId);
            delSt.setString(2, assistUserId);
            delSt.executeUpdate();
            delSt.close();
        }
        rs.close();
        selSt.close();
        st = "cancelAssiSign".equals(actionName) ? conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=1,IS_ASSIST=? where FLOW_ID=? and USER_ID=?") : conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=1,IS_TURN=? where FLOW_ID=? and USER_ID=?");
        st.setString(1, null);
        st.setString(2, this.flowId);
        st.setString(3, this.userId);
        st.executeUpdate();
        st.close();
        result.put("NEED_PROCESS", 1);
        st = conn.prepareStatement("update WB_FLOW_INSTANCE set FLOW_DATA=? where FLOW_ID=?");
        DbUtil.setText(st, 1, this.flowJson.toString());
        st.setString(2, this.flowId);
        st.executeUpdate();
        st.close();
        this.addNodeActionToHistory(conn);
        if (this.nodeChanged) {
            st = conn.prepareStatement("update WB_FLOW_LIST set LIST_ID=? where FLOW_ID=?");
            st.setString(1, SysUtil.getId());
            st.setString(2, this.flowId);
            st.executeUpdate();
            st.close();
        }
        st = conn.prepareStatement("update WB_FLOW_LIST set NODE_NAME=?,TITLE=?,LAST_MODIFY_DATE=?, LAST_USER_ID=?, LAST_USER_DISP_NAME=?, STATUS=? where FLOW_ID=?");
        st.setString(1, this.activeNodeName);
        String title = this.getTitle(this.activeNode);
        st.setString(2, title);
        st.setTimestamp(3, this.actionDate);
        DbUtil.setObject(st, 4, 12, this.userId);
        DbUtil.setObject(st, 5, 12, this.userDispName);
        int status = this.endName.equals(this.activeNodeName) ? 2 : 1;
        st.setInt(6, status);
        st.setString(7, this.flowId);
        st.executeUpdate();
        result.put("NODE_NAME", (Object)this.activeNodeName);
        result.put("TITLE", (Object)title);
        result.put("LAST_MODIFY_DATE", (Object)this.actionDate);
        result.put("LAST_USER_ID", (Object)this.userId);
        result.put("LAST_USER_DISP_NAME", (Object)this.userDispName);
        result.put("STATUS", status);
        st.close();
        return result;
    }

    public void multSign(String newNodeName, String passName, String nodeTitle, String passUsers, JSONObject userData) {
        this.recordHistory("multSign");
        this.insertNode(newNodeName, passName, nodeTitle, passUsers, userData, true);
        this.setActiveNode(newNodeName);
    }

    private void addNewUsers(JSONObject userData) throws Exception {
        Connection conn = this.getRequestConnection();
        HashSet<String> doUserIdSet = this.getUsers(conn, false);
        String ccUserInfo = this.getAttribute(this.activeNode, "ccUser");
        HashSet<String> ccUserIdSet = null;
        if (StrUtil.isNotBlank((CharSequence)ccUserInfo)) {
            ccUserIdSet = this.getUsers(conn, true);
        }
        JSONArray userId = userData.getJSONArray("userId");
        JSONArray userName = userData.getJSONArray("userName");
        int j = userId.length();
        if (j > 0) {
            String userIdStr = userId.getString(0);
            if (doUserIdSet.contains(userIdStr)) {
                throw new IllegalArgumentException("\u7528\u6237\u540d\u79f0\u4e3a\"" + userName.getString(0) + "\"\u7684\u7528\u6237\u5df2\u662f\u8be5\u8282\u70b9\u5904\u7406\u4eba");
            }
            if (ccUserIdSet != null && ccUserIdSet.contains(userIdStr)) {
                throw new IllegalArgumentException("\u7528\u6237\u540d\u79f0\u4e3a\"" + userName.getString(0) + "\"\u7684\u7528\u6237\u5df2\u662f\u8be5\u8282\u70b9\u6284\u9001\u4eba");
            }
            this.newUserList.add(userIdStr);
        }
    }

    public void plusSign(JSONObject userData) throws Exception {
        this.recordHistory("plusSign");
        this.setProcessed = false;
        this.addNewUsers(userData);
    }

    public void turn(JSONObject userData, String opinionData) throws Exception {
        this.recordHistory("turn");
        this.sysOpinion = opinionData;
        this.addNewUsers(userData);
        JSONArray doActionUsers = this.activeNode.optJSONArray("assistAndTurnUser");
        HashSet<String> doUserIdSet = JsonUtil.toHashSet(doActionUsers);
        if (!doUserIdSet.contains(this.newUserList.get(0))) {
            doActionUsers.put((Object)this.newUserList.get(0));
            this.activeNode.put("assistAndTurnUser", (Object)doActionUsers);
        }
    }

    public boolean subRetreat() {
        boolean needRetreat = false;
        String toNodeName = "";
        String fromNodeName = this.flowJson.optString("subNodeName");
        if (this.activeNodeName.equals(fromNodeName)) {
            needRetreat = true;
        } else {
            int j = this.links.length();
            int i = 0;
            while (i < j) {
                JSONObject link = this.links.getJSONObject(i);
                if (fromNodeName.equals(link.optString("from"))) {
                    toNodeName = link.optString("to");
                    break;
                }
                ++i;
            }
            JSONArray retreatUser = this.activeNode.optJSONArray("retreatUserIds");
            JSONArray assistOrTurnUser = this.activeNode.optJSONArray("assistAndTurnUser");
            if (this.activeNodeName.equals(toNodeName) && (retreatUser.length() == 0 || assistOrTurnUser.length() == 0)) {
                needRetreat = true;
            }
        }
        return needRetreat;
    }

    public boolean needChange() {
        boolean needChange = false;
        if (StrUtil.isNotBlank((CharSequence)this.parentFlowId) && this.endName.equals(this.activeNodeName)) {
            needChange = true;
        }
        return needChange;
    }

    public void changeMainFlow(Connection conn) throws Exception {
        int subFlowCount = this.flowJson.optInt("subFlowCount");
        this.flowJson.put("subFlowCount", ++subFlowCount);
        this.setActiveNode(this.flowJson.optString("subNodeName"));
        this.activeNode.put("doUserCount", 0);
        PreparedStatement st = null;
        st = conn.prepareStatement("update WB_FLOW_INSTANCE set FLOW_DATA=? where FLOW_ID=?");
        DbUtil.setText(st, 1, this.flowJson.toString());
        st.setString(2, this.flowId);
        st.executeUpdate();
        st.close();
        st = conn.prepareStatement("update WB_FLOW_LIST set LIST_ID=?,NODE_NAME=?,TITLE=?,LAST_MODIFY_DATE=?, LAST_USER_ID=?, LAST_USER_DISP_NAME=?, STATUS=? where FLOW_ID=?");
        st.setString(1, SysUtil.getId());
        st.setString(2, this.activeNodeName);
        String title = this.getTitle(this.activeNode);
        st.setString(3, title);
        st.setTimestamp(4, this.actionDate);
        DbUtil.setObject(st, 5, 12, this.userId);
        DbUtil.setObject(st, 6, 12, this.userDispName);
        int status = this.endName.equals(this.activeNodeName) ? 2 : 1;
        st.setInt(7, status);
        st.setString(8, this.flowId);
        st.executeUpdate();
        st.close();
        st = conn.prepareStatement("delete from WB_FLOW_USER where FLOW_ID=? and IS_PROCESSED=0");
        st.setString(1, this.flowId);
        st.executeUpdate();
        st.close();
        st = conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=0 where FLOW_ID=?");
        st.setString(1, this.flowId);
        st.executeUpdate();
        st.close();
    }

    public boolean isDeal() {
        Boolean isDeal = true;
        JSONObject lastRecord = this.history.getJSONObject(this.history.length() - 1);
        String lastNodeName = lastRecord.optString("node");
        String lastAction = lastRecord.optString("action");
        if (!lastNodeName.equals(this.activeNodeName)) {
            boolean isFillSign;
            int i;
            JSONObject link;
            int j;
            if ("fillSign".equals(lastAction)) {
                j = this.links.length();
                link = null;
                i = 0;
                while (i < j) {
                    link = this.links.optJSONObject(i);
                    isFillSign = link.optBoolean("isFillSign");
                    if (isFillSign) {
                        this.links.remove(i);
                    }
                    ++i;
                }
            }
            j = this.links.length();
            link = null;
            i = 0;
            while (i < j) {
                link = this.links.optJSONObject(i);
                isFillSign = link.optBoolean("isFillSign");
                String filledUser = link.optString("filledUser");
                if (StrUtil.isNotBlank((CharSequence)filledUser) && !isFillSign) {
                    link.put("isFillSign", true);
                }
                ++i;
            }
            this.setActiveNode(lastNodeName);
            this.params.put("flow.lastNodeName", (Object)lastNodeName);
            isDeal = false;
        }
        int doUserCount = this.activeNode.getInt("doUserCount");
        this.activeNode.put("doUserCount", --doUserCount);
        this.recordHistory("retreat");
        return isDeal;
    }

    public JSONObject doRetreat(boolean isDeal, String opinionData, Connection conn) throws Exception {
        this.sysOpinion = opinionData;
        PreparedStatement st = null;
        JSONObject result = new JSONObject();
        String specifyUser = this.getAttribute(this.activeNode, "specifyUser");
        String passUsers = this.getAttribute(this.activeNode, "passUsers");
        if (!isDeal) {
            result = this.update(this.getRequestConnection(), "'" + this.userId + "'", "retreat");
        } else {
            st = conn.prepareStatement("update WB_FLOW_INSTANCE set FLOW_DATA=? where FLOW_ID=?");
            DbUtil.setText(st, 1, this.flowJson.toString());
            st.setString(2, this.flowId);
            st.executeUpdate();
            st.close();
            if (this.nodeChanged) {
                st = conn.prepareStatement("update WB_FLOW_LIST set LIST_ID=? where FLOW_ID=?");
                st.setString(1, SysUtil.getId());
                st.setString(2, this.flowId);
                st.executeUpdate();
                st.close();
            }
            st = conn.prepareStatement("update WB_FLOW_LIST set NODE_NAME=?,TITLE=?,LAST_MODIFY_DATE=?, LAST_USER_ID=?, LAST_USER_DISP_NAME=?, STATUS=? where FLOW_ID=?");
            st.setString(1, this.activeNodeName);
            String title = this.getTitle(this.activeNode);
            st.setString(2, title);
            st.setTimestamp(3, this.actionDate);
            DbUtil.setObject(st, 4, 12, this.userId);
            DbUtil.setObject(st, 5, 12, this.userDispName);
            int status = this.endName.equals(this.activeNodeName) ? 2 : 1;
            st.setInt(6, status);
            st.setString(7, this.flowId);
            st.executeUpdate();
            st.close();
            result.put("NODE_NAME", (Object)this.activeNodeName);
            result.put("TITLE", (Object)title);
            result.put("LAST_MODIFY_DATE", (Object)this.actionDate);
            result.put("LAST_USER_ID", (Object)this.userId);
            result.put("LAST_USER_DISP_NAME", (Object)this.userDispName);
            result.put("STATUS", status);
            this.addNodeActionToHistory(conn);
            st = conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=1 where FLOW_ID=? and USER_ID=?");
            st.setString(1, this.flowId);
            st.setString(2, this.userId);
            st.executeUpdate();
            st.close();
        }
        if (!StringUtil.isEmpty(specifyUser)) {
            result.put("PASS_USER_COUNT", (Object)passUsers);
        }
        result.put("flowId", (Object)this.flowId);
        return result;
    }

    public String getParentFlowId() {
        return this.parentFlowId;
    }

    public boolean startRobot(boolean isHandStart, Connection conn) throws Exception {
        String robot = this.activeNode.optString("robot");
        if (!StringUtil.isEmpty(robot)) {
            String sql = StringUtil.concat("{", StringUtils.subString((String)robot, (String)"{", (String)"}", (boolean)true), "}");
            DbUtil.run(this.request, sql);
            if (isHandStart) {
                this.insertStartUser(conn);
            }
            this.forward();
            this.verifyRobtAfterNode();
            this.checkSubFlowStart(conn);
            this.insert(conn);
            this.recordFlowTo(conn);
            this.isSendMail();
            this.isSendSms();
            return true;
        }
        return false;
    }

    public void setSetPorcessed(boolean setPorcessed) {
        this.setProcessed = setPorcessed;
    }

    public void verifyRobtAfterNode() {
        if (this.activeNode.optBoolean("specifyUser")) {
            throw new IllegalArgumentException("\u81ea\u52a8\u5316\u8282\u70b9\u540e\u4e00\u4e2a\u8282\u70b9\u4e0d\u80fd\u5c06\u662f\u5426\u6307\u5b9a\u4eba\u8bbe\u4e3atrue\uff01");
        }
    }

    public void doFinishAllSubFlow(Connection conn) throws Exception {
        String mainFillNodeName = this.flowJson.optString("mainFillNodeName");
        String mainFillUserId = this.flowJson.optString("mainFillUserId");
        if (StrUtil.isNotBlank((CharSequence)mainFillNodeName) && StrUtil.isNotBlank((CharSequence)mainFillUserId)) {
            this.setActiveNode(mainFillNodeName);
            this.setSetPorcessed(false);
            this.flowJson.put("mainFillNodeName", (Object)"");
            this.flowJson.put("mainFillUserId", (Object)"");
            this.activeNode.put("retreatUserIds", (Object)new JSONArray());
            this.activeNode.put("assistAndTurnUser", (Object)new JSONArray());
            this.update(conn, "'" + mainFillUserId + "'", "");
        } else {
            this.forward();
            this.setSetPorcessed(false);
            this.activeNode.put("retreatUserIds", (Object)new JSONArray());
            this.activeNode.put("assistAndTurnUser", (Object)new JSONArray());
            this.update(conn, null, "");
        }
    }

    private void getSpecifyUsers(Connection conn, JSONObject result, String passUsers) throws Exception {
        ResultSet rs = null;
        JSONObject specifyUsers = null;
        JSONArray specifyUsersArray = new JSONArray();
        HashSet<String> userIds = this.getUsers(conn, false);
        String[] userId = userIds.toArray(new String[userIds.size()]);
        String ids = StringUtil.joinQuote(userId);
        int passUserCount = 0;
        try {
            rs = conn.createStatement().executeQuery("select A.user_id,A.user_name,A.display_name,A.phone,B.DEPT_NAME from WB_USER A left join WB_DEPT B on A.dept_id=B.dept_id where A.user_id in (" + ids + ")");
            while (rs.next()) {
                specifyUsers = new JSONObject();
                specifyUsers.put("USER_ID", (Object)rs.getString(1));
                specifyUsers.put("USER_NAME", (Object)rs.getString(2));
                specifyUsers.put("DISPLAY_NAME", (Object)rs.getString(3));
                specifyUsers.put("PHONE", (Object)rs.getString(4));
                specifyUsers.put("DEPT_NAME", (Object)rs.getString(5));
                specifyUsersArray.put((Object)specifyUsers);
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            throw throwable;
        }
        DbUtil.close(rs);
        int totalDoUserCount = specifyUsersArray.length();
        if (totalDoUserCount == 0) {
            throw new IllegalArgumentException("\u4e0b\u4e00\u8282\u70b9\u6ca1\u6709\u5904\u7406\u4eba\u63a5\u6536\u5f85\u529e\u4e86");
        }
        if (!StringUtil.isEmpty(passUsers)) {
            String passValue;
            Boolean isPercent = passUsers.endsWith("%");
            if (isPercent.booleanValue()) {
                passValue = passUsers.substring(0, passUsers.length() - 1);
            } else {
                passValue = passUsers;
                if (totalDoUserCount < Integer.parseInt(passValue)) {
                    throw new IllegalArgumentException("\u8282\u70b9\u201c" + this.activeNode + "\u201d\u7684\u901a\u8fc7\u4eba\u6570\u5c5e\u6027\u503c\u201c" + passUsers + "\u201d\u5927\u4e8e\u914d\u7f6e\u7684\u5904\u7406\u4eba\u6570\u91cf\u3002");
                }
            }
            if (!StringUtil.isInteger(passValue)) {
                throw new RuntimeException("\u8282\u70b9\u201c" + this.activeNode + "\u201d\u7684\u901a\u8fc7\u4eba\u6570\u5c5e\u6027\u503c\u201c" + passUsers + "\u201d\u65e0\u6548\u3002");
            }
            passUserCount = 1;
        } else {
            passUserCount = 1;
        }
        result.put("PASS_USER_COUNT", passUserCount);
        result.put("specifyUsers", (Object)specifyUsersArray);
    }

    public void getEntrustUser(String fileName) throws Exception {
        Date nowDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String now = sdf.format(nowDate);
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        JSONObject entrustUsers = null;
        JSONArray entrustUsersArray = new JSONArray();
        try {
            conn = DbUtil.getConnection();
            st = conn.prepareStatement("select CLIENT,ENTRUSTMENT from WB_FLOW_ENTRUST where ? between BEGIN_DATE and END_DATE and IS_ENABLE='1' and ENTRUST_BUSINESS=? and ENTRUST_TYPE='0'");
            st.setString(1, now);
            st.setString(2, fileName);
            rs = st.executeQuery();
            while (rs.next()) {
                entrustUsers = new JSONObject();
                entrustUsers.put("CLIENT", (Object)rs.getString(1));
                entrustUsers.put("ENTRUSTMENT", (Object)rs.getString(2));
                entrustUsersArray.put((Object)entrustUsers);
            }
            this.flowJson.put("entrustUsers", (Object)entrustUsersArray);
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(conn);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(conn);
    }

    public void reloadSpecifyUsers(HashSet<String> hs, String flowId, boolean isInsert, Connection conn, boolean isStart) throws Exception {
        boolean needUpdate;
        this.needSpecify = true;
        this.activeNode.put("totalUserCount", hs.size());
        this.getUsers(this.getRequestConnection(), false);
        String passUsers = this.getAttribute(this.activeNode, "passUsers");
        if (this.isLikeNode && StringUtil.isEmpty(passUsers)) {
            this.activeNode.put("passUsers", (Object)"100%");
        }
        HashSet<String> doUsers = null;
        int index = 1;
        HashSet<String> updateUsers = new HashSet<String>();
        PreparedStatement st = null;
        PreparedStatement st1 = null;
        PreparedStatement st2 = null;
        PreparedStatement st3 = null;
        ResultSet rs = null;
        if (hs.size() > 0) {
            this.setEntrustUser(hs);
        }
        if (!isStart) {
            st = conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=0,IS_PROCESSED=1 where FLOW_ID=? and USER_ID=? and IS_CC=0");
            st.setString(1, flowId);
            st.setString(2, this.userId);
            int k = st.executeUpdate();
            st.close();
            if (k != 1) {
                throw new RuntimeException("\u60a8\u4e0d\u662f\u8be5\u6d41\u7a0b\u7684\u5904\u7406\u4eba\u5458\u3002");
            }
        }
        st = conn.prepareStatement("delete from WB_FLOW_USER where FLOW_ID=? and IS_PROCESSED=0");
        st.setString(1, flowId);
        st.executeUpdate();
        st.close();
        st = conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=0 where FLOW_ID=?");
        st.setString(1, flowId);
        st.executeUpdate();
        st.close();
        if (isInsert) {
            needUpdate = false;
        } else {
            st3 = conn.prepareStatement("select USER_ID from WB_FLOW_USER where FLOW_ID=?");
            st3.setString(1, flowId);
            rs = st3.executeQuery();
            while (rs.next()) {
                updateUsers.add(rs.getString(1));
            }
            rs.close();
            st3.close();
            needUpdate = !updateUsers.isEmpty();
        }
        st1 = conn.prepareStatement("insert into WB_FLOW_USER(S_ID,FLOW_ID,USER_ID,NEED_PROCESS,IS_PROCESSED,IS_CC) values(?,?,?,?,?,?)");
        st1.setString(2, flowId);
        if (needUpdate) {
            st2 = conn.prepareStatement("update WB_FLOW_USER set NEED_PROCESS=?,IS_CC=? where FLOW_ID=? and USER_ID=?");
            st2.setString(3, flowId);
        }
        int i = 0;
        while (i < 2) {
            HashSet<String> users;
            st1.setInt(6, i);
            st1.setInt(4, i == 0 ? 1 : 0);
            st1.setInt(5, 0);
            if (needUpdate) {
                st2.setInt(1, i == 0 ? 1 : 0);
                st2.setInt(2, i);
            }
            HashSet<String> hashSet = i == 0 ? hs : (users = this.getUsers(conn, i != 0));
            if (i == 0) {
                doUsers = users;
            } else if (users != null && doUsers != null) {
                users.removeAll(doUsers);
            }
            if (users != null) {
                for (String user : users) {
                    if (needUpdate && updateUsers.contains(user)) {
                        st2.setString(4, user);
                        st2.addBatch();
                        if (index % 1000 == 0) {
                            st2.executeBatch();
                        }
                    } else {
                        st1.setString(1, SysUtil.getId());
                        st1.setString(3, user);
                        st1.addBatch();
                        if (index % 1000 == 0) {
                            st1.executeBatch();
                        }
                    }
                    ++index;
                }
            }
            ++i;
        }
        st1.executeBatch();
        if (needUpdate) {
            st2.executeBatch();
        }
        if (st1 != null) {
            st1.close();
        }
        if (st2 != null) {
            st2.close();
        }
    }

    private void getStartAndEndNodeName() {
        int j = this.nodes.length();
        int k = 0;
        int m = 0;
        int i = 0;
        while (i < j) {
            JSONObject node = this.nodes.getJSONObject(i);
            String nodeType = this.getAttribute(node, "type");
            if ("\u5f00\u59cb".equals(nodeType)) {
                this.startName = this.getAttribute(node, "name");
                ++k;
            }
            if ("\u7ed3\u675f".equals(nodeType)) {
                this.endName = this.getAttribute(node, "name");
                ++m;
            }
            ++i;
        }
        if (k > 1) {
            throw new IllegalArgumentException("\u6d41\u7a0b\u914d\u7f6e\u9519\u8bef\uff1a\u5b58\u5728\u591a\u4e2a\u6837\u5f0f\u4e3a\u5f00\u59cb\u7684\u8282\u70b9\uff01");
        }
        if (k == 0) {
            throw new IllegalArgumentException("\u6d41\u7a0b\u914d\u7f6e\u9519\u8bef\uff1a\u672a\u5c06\u6d41\u7a0b\u7b2c\u4e00\u4e2a\u8282\u70b9\u7684\u6837\u5f0f\u8bbe\u4e3a\u201c\u5f00\u59cb\u201d\uff01");
        }
        if (m > 1) {
            throw new IllegalArgumentException("\u6d41\u7a0b\u914d\u7f6e\u9519\u8bef\uff1a\u5b58\u5728\u591a\u4e2a\u6837\u5f0f\u4e3a\u7ed3\u675f\u7684\u8282\u70b9\uff01");
        }
        if (m == 0) {
            throw new IllegalArgumentException("\u6d41\u7a0b\u914d\u7f6e\u9519\u8bef\uff1a\u672a\u5c06\u6d41\u7a0b\u6700\u540e\u4e00\u4e2a\u8282\u70b9\u7684\u6837\u5f0f\u8bbe\u4e3a\u201c\u7ed3\u675f\u201d\uff01");
        }
    }

    public void insertStartUser(Connection conn) throws Exception {
        this.activeNode.put("passUsers", (Object)"");
        PreparedStatement st = null;
        int index = 1;
        HashSet<String> users = this.getUsers(conn, true);
        st = conn.prepareStatement("delete from WB_FLOW_USER where FLOW_ID=?");
        st.setString(1, this.flowId);
        st.executeUpdate();
        st.close();
        if (users != null) {
            users.remove(this.userId);
            st = conn.prepareStatement("insert into WB_FLOW_USER(S_ID,FLOW_ID,USER_ID,NEED_PROCESS,IS_PROCESSED,IS_CC) values(?,?,?,?,?,?)");
            st.setString(2, this.flowId);
            st.setInt(4, 0);
            st.setInt(5, 0);
            st.setInt(6, 1);
            for (String user : users) {
                st.setString(1, SysUtil.getId());
                st.setString(3, user);
                st.addBatch();
                if (index % 1000 == 999) {
                    st.executeBatch();
                }
                ++index;
            }
            st.executeBatch();
            st.close();
        }
        st = conn.prepareStatement("insert into WB_FLOW_USER(S_ID,FLOW_ID,USER_ID,NEED_PROCESS,IS_PROCESSED,IS_CC) values(?,?,?,?,?,?)");
        st.setString(1, SysUtil.getId());
        st.setString(2, this.flowId);
        st.setString(3, this.userId);
        st.setInt(4, 0);
        st.setInt(5, 1);
        st.setInt(6, 0);
        st.executeUpdate();
        st.close();
    }

    public void isSendMail() throws Exception {
        String sendMail = this.activeNode.optString("sendMail");
        if (StrUtil.isNotBlank((CharSequence)sendMail) && "\u662f".equals(sendMail) && this.nodeChanged && StrUtil.isNotBlank((CharSequence)this.getAttribute(this.activeNode, "doUser"))) {
            Connection conn = null;
            PreparedStatement st = null;
            ResultSet rs = null;
            try {
                conn = DbUtil.getConnection();
                st = conn.prepareStatement("select email from wb_user where user_id in(select user_id from wb_flow_user where flow_id=? and need_process = 1)");
                st.setString(1, this.flowId);
                rs = st.executeQuery();
                while (rs.next()) {
                    String mail = rs.getString(1);
                    if (!StrUtil.isNotBlank((CharSequence)mail)) continue;
                    this.sendMail(mail);
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(st);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
        }
    }

    public void isSendSms() throws Exception {
        String sendSms = this.activeNode.optString("sendSms");
        if (StrUtil.isNotBlank((CharSequence)sendSms) && "\u662f".equals(sendSms) && this.nodeChanged && StrUtil.isNotBlank((CharSequence)this.getAttribute(this.activeNode, "doUser"))) {
            Connection conn = null;
            PreparedStatement st = null;
            ResultSet rs = null;
            try {
                conn = DbUtil.getConnection();
                st = conn.prepareStatement("select phone from wb_user where user_id in(select user_id from wb_flow_user where flow_id=? and need_process = 1)");
                st.setString(1, this.flowId);
                rs = st.executeQuery();
                while (rs.next()) {
                    String phone = rs.getString(1);
                    if (!StrUtil.isNotBlank((CharSequence)phone)) continue;
                    this.sendSms(phone);
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(st);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
        }
    }

    public void sendMail(String toUser) throws Exception {
        String smtp = Var.getString("sys.mail.smtp.host");
        String username = Var.getString("sys.mail.smtp.username");
        String password = Var.getString("sys.mail.smtp.password");
        boolean needAuth = Var.getBool("sys.mail.smtp.auth");
        String fromUser = Var.getString("sys.mail.smtp.fromUser");
        MailSender mailSender = new MailSender(smtp, username, password, needAuth);
        mailSender.send(fromUser, toUser, null, null, "\u60a8\u6709\u65b0\u7684\u6d41\u7a0b\u5f85\u529e\u9700\u8981\u5904\u7406", "\u60a8\u6709\u65b0\u7684\u6d41\u7a0b\u5f85\u529e\u9700\u8981\u5904\u7406\uff0c\u8bf7\u767b\u5f55\u7cfb\u7edf\u53ca\u65f6\u5904\u7406\u3002", null, null, null, null);
        mailSender.close();
    }

    public void sendSms(String toUser) {
    }

    public void recordFlowTo(Connection conn) throws Exception {
        if (StrUtil.isBlank((CharSequence)this.sysToUser) && this.history.length() > 0) {
            String userInfo;
            String user = "";
            if (this.nodeAction != null) {
                String action = this.nodeAction.optString("action");
                if ("turn".equals(action) || "assistSign".equals(action)) {
                    user = this.newUserList.get(0);
                } else if ("retreat".equals(action) || "cancelTurn".equals(action) || "cancelAssiSign".equals(action)) {
                    user = this.userId;
                }
            }
            PreparedStatement st = null;
            ResultSet rs = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (StrUtil.isNotBlank((CharSequence)user)) {
                if (user.equals(this.userId)) {
                    arrayList.add(String.valueOf(this.userDispName) + "(" + this.userName + ")");
                } else {
                    st = conn.prepareStatement("select DISPLAY_NAME,USER_NAME from WB_USER where USER_ID=?");
                    st.setString(1, user);
                    rs = st.executeQuery();
                    while (rs.next()) {
                        userInfo = String.valueOf(rs.getString(1)) + "(" + rs.getString(2) + ")";
                        arrayList.add(userInfo);
                    }
                    rs.close();
                    st.close();
                }
            } else if (this.nodeChanged) {
                st = conn.prepareStatement("select B.DISPLAY_NAME,B.USER_NAME from WB_FLOW_USER A left join WB_USER B on A.USER_ID = B.USER_ID where A.FLOW_ID=? and A.NEED_PROCESS=1");
                st.setString(1, this.flowId);
                rs = st.executeQuery();
                while (rs.next()) {
                    userInfo = String.valueOf(rs.getString(1)) + "(" + rs.getString(2) + ")";
                    arrayList.add(userInfo);
                }
                rs.close();
                st.close();
            }
            if (arrayList.size() > 0) {
                JSONObject newRecord = this.history.getJSONObject(this.history.length() - 1);
                String itemId = newRecord.optString("itemId");
                this.sysToUser = StrUtil.join((CharSequence)",", (Object[])new Object[]{arrayList});
                st = conn.prepareStatement("update WB_FLOW_HISTORY set TO_NODE=?,TO_DEAL_USER=? where FLOW_ID=? and ITEM_ID=?");
                st.setString(1, this.activeNodeName);
                st.setString(2, this.sysToUser);
                st.setString(3, this.flowId);
                st.setString(4, itemId);
                st.executeUpdate();
                st.close();
            }
        }
    }

    public void recordSubFlowTo(JSONObject numParams) throws Exception {
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            conn = DbUtil.getConnection();
            conn.setAutoCommit(false);
            HashMap<String, String> map = new HashMap<String, String>();
            st = conn.prepareStatement("select B.FLOW_ID,B.NODE_NAME,C.DISPLAY_NAME,C.USER_NAME from WB_FLOW_USER A left join WB_FLOW_LIST B on A.FLOW_ID = B.FLOW_ID left join WB_USER C on A.USER_ID = C.USER_ID where B.PARENT_FLOW_ID=? and A.NEED_PROCESS=1");
            st.setString(1, this.flowId);
            rs = st.executeQuery();
            while (rs.next()) {
                String key = "\u3010\u5b50\u6d41\u7a0b\u3011" + numParams.optString(rs.getString(1)) + "\u3010\u6d41\u5411\u8282\u70b9\u3011" + rs.getString(2);
                String value = String.valueOf(rs.getString(3)) + "(" + rs.getString(4) + ")";
                if (map.containsKey(key)) {
                    String oldValue = (String)map.get(key);
                    map.put(key, String.valueOf(oldValue) + "," + value);
                    continue;
                }
                map.put(key, value);
            }
            ArrayList<String> toInfo = new ArrayList<String>();
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                ++i;
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (StrUtil.isNotBlank((CharSequence)val)) {
                    toInfo.add("\u3010" + i + "\u3011" + key + "\u3010\u6d41\u5411\u5904\u7406\u4eba\u3011" + val);
                    continue;
                }
                toInfo.add("\u3010" + i + "\u3011" + key);
            }
            this.sysToUser = StrUtil.join((CharSequence)"</br>", (Object[])new Object[]{toInfo});
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(st);
        DbUtil.close(conn);
    }

    private void getDoneNode() throws Exception {
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            conn = DbUtil.getConnection();
            st = conn.prepareStatement("select NODE from (select NODE from WB_FLOW_HISTORY where FLOW_ID=? and USER_ID=? order by DEAL_DATE desc) where rownum=1");
            st.setString(1, this.flowId);
            st.setString(2, this.userId);
            rs = st.executeQuery();
            while (rs.next()) {
                this.setActiveNode(rs.getString(1));
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(st);
        DbUtil.close(conn);
    }

    public boolean isSpecify(boolean isStart, Connection conn) throws Exception {
        this.getUsers(this.getRequestConnection(), false);
        if (this.nodeChanged && (this.activeNode.optBoolean("specifyUser") || this.isLikeNode)) {
            if (isStart) {
                PreparedStatement st = null;
                st = conn.prepareStatement("delete from WB_FLOW_USER where FLOW_ID=?");
                st.setString(1, this.flowId);
                st.executeUpdate();
                st.close();
            }
            return true;
        }
        return false;
    }

    public JSONObject doSpecify(boolean isStart) throws Exception {
        JSONObject result = new JSONObject();
        Connection conn = this.getRequestConnection();
        String passUsers = this.getAttribute(this.activeNode, "passUsers");
        result.put("isStart", isStart);
        if (isStart) {
            result.put("flowId", (Object)this.flowId);
            this.getSpecifyUsers(conn, result, passUsers);
        } else {
            JSONObject flowParams = new JSONObject(this.request.getParameter("xFlowParams"));
            String flowIds = flowParams.optString("flowId");
            if (StrUtil.isNotBlank((CharSequence)flowIds)) {
                int length;
                String[] idArray = flowIds.split(",");
                if (this.flowId.equals(idArray[(length = idArray.length) - 1])) {
                    result.put("flowId", (Object)flowIds);
                    this.getSpecifyUsers(conn, result, passUsers);
                }
            } else {
                result.put("flowId", (Object)this.flowId);
                this.getSpecifyUsers(conn, result, passUsers);
            }
        }
        return result;
    }
}

