/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XssShieldUtil {
    public static final String XSS_EXCEPTION_MSG = "\u53ef\u80fd\u5b58\u5728xss\u653b\u51fb\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01";
    private static List<Pattern> patterns = null;

    private static List<Object[]> getXssPatternList() {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        ret.add(new Object[]{"<(no)?script[^>]*>.*?</(no)?script>", 2});
        ret.add(new Object[]{"eval\\((.*?)\\)", 42});
        ret.add(new Object[]{"expression\\((.*?)\\)", 42});
        ret.add(new Object[]{"(javascript:|vbscript:|view-source:)*", 2});
        ret.add(new Object[]{"src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42});
        ret.add(new Object[]{"src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42});
        ret.add(new Object[]{"src[\r\n]*=[\r\n]*.", 42});
        ret.add(new Object[]{"<(no)?input[\r\n].*?>", 42});
        ret.add(new Object[]{"<([^>]*)>", 42});
        ret.add(new Object[]{"/\\*.*\\*/", 42});
        ret.add(new Object[]{"(window\\.location|window\\.|\\.location|document\\.cookie|document\\.|<input|alert\\(.*?\\)|confirm\\(.*?\\)|window\\.open\\()*", 42});
        ret.add(new Object[]{"[<|\"]*+\\s*\\w*\\s*(oncontrolselect|oncopy|oncut|ondataavailable|ondatasetchanged|ondatasetcomplete|ondblclick|ondeactivate|ondrag|ondragend|ondragenter|ondragleave|ondragover|ondragstart|ondrop|onerror=|onerroupdate|onfilterchange|onfinish|onfocus|onfocusin|onfocusout|onhelp|onkeydown|onkeypress|onkeyup|onlayoutcomplete|onload|onlosecapture|onmousedown|onmouseenter|onmouseleave|onmousemove|onmousout|onmouseover|onmouseup|onmousewheel|onmove|onmoveend|onmovestart|onabort|onactivate|onafterprint|onafterupdate|onbefore|onbeforeactivate|onbeforecopy|onbeforecut|onbeforedeactivate|onbeforeeditocus|onbeforepaste|onbeforeprint|onbeforeunload|onbeforeupdate|onblur|onbounce|oncellchange|onchange|onclick|oncontextmenu|onpaste|onpropertychange|onreadystatechange|onreset|onresize|onresizend|onresizestart|onrowenter|onrowexit|onrowsdelete|onrowsinserted|onscroll|onselect|onselectionchange|onselectstart|onstart|onstop|onsubmit|onunload)+\\s*=+", 42});
        return ret;
    }

    private static List<Pattern> getPatterns() {
        if (patterns == null) {
            ArrayList<Pattern> list = new ArrayList<Pattern>();
            String regex = null;
            Integer flag = null;
            int arrLength = 0;
            for (Object[] arr : XssShieldUtil.getXssPatternList()) {
                arrLength = arr.length;
                int i = 0;
                while (i < arrLength) {
                    regex = (String)arr[0];
                    flag = (Integer)arr[1];
                    list.add(Pattern.compile(regex, flag));
                    ++i;
                }
            }
            patterns = list;
        }
        return patterns;
    }

    public static String stripXss(String value) {
        if (StrUtil.isNotBlank((CharSequence)value)) {
            Matcher matcher = null;
            for (Pattern pattern : XssShieldUtil.getPatterns()) {
                matcher = pattern.matcher(value);
                if (!matcher.find()) continue;
                value = matcher.replaceAll("");
            }
        }
        return value;
    }

    public static void main(String[] args) {
        String value = null;
        value = XssShieldUtil.stripXss("<script language=text/javascript>alert(document.cookie);</script>");
        System.out.println("type-1: '" + value + "'");
        value = XssShieldUtil.stripXss("<script src='' onerror='alert(document.cookie)'></script>");
        System.out.println("type-2: '" + value + "'");
        value = XssShieldUtil.stripXss("</script>");
        System.out.println("type-3: '" + value + "'");
        value = XssShieldUtil.stripXss(" eval(abc);");
        System.out.println("type-4: '" + value + "'");
        value = XssShieldUtil.stripXss(" expression(abc);");
        System.out.println("type-5: '" + value + "'");
        value = XssShieldUtil.stripXss("jllja<img src='a' onerror='alert(document.cookie);'></img>jlfjdlfjdlf");
        System.out.println("type-6: '" + value + "'");
        value = XssShieldUtil.stripXss("<img src='Http://t.com/RT8Karn' onerror='alert(document.cookie);'/>");
        System.out.println("type-7: '" + value + "'");
        value = XssShieldUtil.stripXss("<img src='' onerror='alert(document.cookie);'>");
        System.out.println("type-8: '" + value + "'");
        value = XssShieldUtil.stripXss("<script language=text/javascript>alert(document.cookie);");
        System.out.println("type-9: '" + value + "'");
        value = XssShieldUtil.stripXss("<script>window.location='url'");
        System.out.println("type-10: '" + value + "'");
        value = XssShieldUtil.stripXss(" onload='alert(\"abc\");");
        System.out.println("type-11: '" + value + "'");
        value = XssShieldUtil.stripXss("<img src=x<!--'<\"-->>");
        System.out.println("type-12: '" + value + "'");
        value = XssShieldUtil.stripXss("<=img onstop=");
        System.out.println("type-13: '" + value + "'");
        value = XssShieldUtil.stripXss("<IMG SRC=\u201djavascript:alert(\u2018XSS\u2019);\u201d>");
        System.out.println("type-14: '" + value + "'");
        value = XssShieldUtil.stripXss("<SCRIPT SRC=http://xss.rocks/xss.js></SCRIPT>");
        System.out.println("type-15: '" + value + "'");
        value = XssShieldUtil.stripXss("0044WU5D13KMZ<script>alert(1)</script>");
        System.out.println("type-16: '" + value + "'");
        value = XssShieldUtil.stripXss("<p >");
        System.out.println("type-17: '" + value + "'");
        value = XssShieldUtil.stripXss("\" onmouseover=\"mzorwx(6129)\"> ");
        System.out.println("type-18: '" + value + "'");
        value = XssShieldUtil.stripXss("<a href=\"dsadas\">XSS</a>");
        System.out.println("type-19: '" + value + "'");
        value = XssShieldUtil.stripXss("select * /**/from/*gjiwjgioewj*/wb_user");
        System.out.println("type-20: '" + value + "'");
        value = XssShieldUtil.stripXss("><img src=#onerror=confirm(1)><");
        System.out.println("type-20: '" + value + "'");
    }
}

