/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.common.Base;
import com.wb.common.Parser;
import com.wb.common.SessionBridge;
import com.wb.common.Str;
import com.wb.common.UrlBuffer;
import com.wb.common.UserList;
import com.wb.common.Var;
import com.wb.common.XwlBuffer;
import com.wb.tool.Console;
import com.wb.util.DbUtil;
import com.wb.util.FileUtil;
import com.wb.util.LogUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.XssShieldUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebUtil {
    static Log log = LogFactory.getLog(WebUtil.class);

    public static String submit(String url, JSONObject params) throws IOException {
        return WebUtil.submit(url, "POST", params);
    }

    public static String submit(String url, String method, JSONObject params) throws IOException {
        return new String(WebUtil.submitBytes(url, method, params), "utf-8");
    }

    public static byte[] submitBytes(String url, JSONObject params) throws IOException {
        return WebUtil.submitBytes(url, "POST", params);
    }

    public static byte[] submitBytes(String url, String method, JSONObject params) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        try {
            int timeout = Var.getInt("sys.session.submitTimeout");
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
            conn.setUseCaches(false);
            conn.setRequestMethod(method);
            if (params != null) {
                byte[] data = WebUtil.getParamsText(params).getBytes("utf-8");
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                conn.setRequestProperty("Content-Length", Integer.toString(data.length));
                try (OutputStream os = conn.getOutputStream();){
                    os.write(data);
                    os.flush();
                }
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (InputStream is = conn.getInputStream();){
                IOUtils.copy((InputStream)is, (OutputStream)bos);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            conn.disconnect();
        }
    }

    private static String getParamsText(JSONObject jo) throws IOException {
        StringBuilder sb = new StringBuilder();
        Set es = jo.entrySet();
        boolean isFirst = true;
        for (Map.Entry e : es) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("&");
            }
            sb.append((String)e.getKey());
            sb.append("=");
            sb.append(URLEncoder.encode(e.getValue().toString(), "utf-8"));
        }
        return sb.toString();
    }

    public static String[] getSortInfo(HttpServletRequest request) {
        String sort = request.getParameter("sort");
        if (StringUtil.isEmpty(sort)) {
            return null;
        }
        JSONObject jo = new JSONArray(sort).getJSONObject(0);
        String[] result = new String[]{jo.getString("property"), jo.optString("direction")};
        return result;
    }

    public static String encodeFilename(HttpServletRequest request, String filename) throws IOException {
        String agent = StringUtil.opt(request.getHeader("user-agent")).toLowerCase();
        if (agent.indexOf("opera") != -1) {
            return StringUtil.concat("filename*=\"utf-8''", WebUtil.encode(filename), "\"");
        }
        if (agent.indexOf("trident") != -1 || agent.indexOf("msie") != -1 || agent.indexOf("edge") != -1) {
            return StringUtil.concat("filename=\"", WebUtil.encode(filename), "\"");
        }
        return StringUtil.concat("filename=\"", new String(filename.getBytes("utf-8"), "ISO-8859-1"), "\"");
    }

    public static String encode(String string) throws IOException {
        return StringUtil.replaceAll(URLEncoder.encode(string, "utf-8"), "+", "%20");
    }

    public static String decode(String string) throws IOException {
        if (Var.urlEncoding.isEmpty() || StringUtil.isEmpty(string)) {
            return string;
        }
        return new String(string.getBytes(Var.urlEncoding), "utf-8");
    }

    public static void clearUpload(HttpServletRequest request, List<FileItem> list) {
        for (FileItem item : list) {
            if (!item.isFormField()) {
                IOUtils.closeQuietly((InputStream)((InputStream)request.getAttribute(item.getFieldName())));
            }
            item.delete();
        }
        String uploadId = (String)request.getAttribute("sys.uploadId");
        if (uploadId != null) {
            HttpSession session = request.getSession(true);
            session.removeAttribute("sys.upread." + uploadId);
            session.removeAttribute("sys.uplen." + uploadId);
        }
    }

    public static String getIdWithUser(HttpServletRequest request, String id) {
        String user = WebUtil.fetch(request, "sys.user");
        return StringUtil.concat(id, "@", StringUtil.opt(user));
    }

    public static void setSessionValue(HttpServletRequest request, String name, Object value) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new RuntimeException("Session does not exist.");
        }
        session.setAttribute(name, value);
    }

    public static Object fetchObject(HttpServletRequest request, String name) {
        Object value;
        HttpSession session = request.getSession(false);
        if (session == null || (value = session.getAttribute(name)) == null) {
            value = request.getAttribute(name);
            if (value == null) {
                return request.getParameter(name);
            }
            return value;
        }
        return value;
    }

    public static String fetch(HttpServletRequest request, String name) {
        Object object = WebUtil.fetchObject(request, name);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static JSONObject fetch(HttpServletRequest request) {
        String name;
        JSONObject json = new JSONObject();
        Iterator requestParams = request.getParameterMap().entrySet().iterator();
        Enumeration requestAttrs = request.getAttributeNames();
        while (requestParams.hasNext()) {
            Map.Entry entry = requestParams.next();
            json.put((String)entry.getKey(), (Object)XssShieldUtil.stripXss(((String[])entry.getValue())[0]));
        }
        while (requestAttrs.hasMoreElements()) {
            name = requestAttrs.nextElement().toString();
            if (name.startsWith("sysx.")) continue;
            json.put(name, request.getAttribute(name));
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            Enumeration sessionAttrs = session.getAttributeNames();
            while (sessionAttrs.hasMoreElements()) {
                name = sessionAttrs.nextElement().toString();
                if (name.startsWith("sysx.")) continue;
                json.put(name, session.getAttribute(name));
            }
        }
        return json;
    }

    public static String replaceParams(HttpServletRequest request, String text) {
        if (request == null) {
            return text;
        }
        int start = 0;
        int startPos = text.indexOf("{#", start);
        int endPos = text.indexOf("#}", startPos + 2);
        if (startPos != -1 && endPos != -1) {
            StringBuilder buf = new StringBuilder(text.length());
            while (startPos != -1 && endPos != -1) {
                String paramName = text.substring(startPos + 2, endPos);
                String paramValue = paramName.startsWith("Var.") ? Var.getString(paramName.substring(4)) : (paramName.startsWith("Str.") ? Str.format(request, paramName.substring(4)) : WebUtil.fetch(request, paramName));
                buf.append(text.substring(start, startPos));
                if (paramValue != null) {
                    buf.append(paramValue);
                }
                start = endPos + 2;
                startPos = text.indexOf("{#", start);
                endPos = text.indexOf("#}", startPos + 2);
            }
            buf.append(text.substring(start));
            return buf.toString();
        }
        return text;
    }

    public static String replaceParams(JSONObject jo, String text) {
        if (jo == null) {
            return text;
        }
        int start = 0;
        int startPos = text.indexOf("{#", start);
        int endPos = text.indexOf("#}", startPos + 2);
        if (startPos != -1 && endPos != -1) {
            StringBuilder buf = new StringBuilder(text.length());
            while (startPos != -1 && endPos != -1) {
                String paramName = text.substring(startPos + 2, endPos);
                String paramValue = paramName.startsWith("Var.") ? Var.getString(paramName.substring(4)) : jo.optString(paramName);
                buf.append(text.substring(start, startPos));
                if (paramValue != null) {
                    buf.append(paramValue);
                }
                start = endPos + 2;
                startPos = text.indexOf("{#", start);
                endPos = text.indexOf("#}", startPos + 2);
            }
            buf.append(text.substring(start));
            return buf.toString();
        }
        return text;
    }

    public static String replaceParams2(JSONObject jo, String text) {
        if (jo == null) {
            return text;
        }
        int start = 0;
        int startPos = text.indexOf("{$", start);
        int endPos = text.indexOf("$}", startPos + 2);
        if (startPos != -1 && endPos != -1) {
            StringBuilder buf = new StringBuilder(text.length());
            while (startPos != -1 && endPos != -1) {
                String paramName = text.substring(startPos + 2, endPos);
                String paramValue = paramName.startsWith("Var.") ? Var.getString(paramName.substring(4)) : jo.optString(paramName);
                buf.append(text.substring(start, startPos));
                if (paramValue != null) {
                    buf.append(paramValue);
                }
                start = endPos + 2;
                startPos = text.indexOf("{$", start);
                endPos = text.indexOf("$}", startPos + 2);
            }
            buf.append(text.substring(start));
            return buf.toString();
        }
        return text;
    }

    public static void send(HttpServletResponse response, Object object) throws IOException {
        try (InputStream inputStream = object instanceof InputStream ? (InputStream)object : null;){
            if (response.isCommitted()) {
                return;
            }
            ServletOutputStream outputStream = response.getOutputStream();
            if (inputStream == null) {
                byte[] bytes;
                if (object instanceof byte[]) {
                    bytes = (byte[])object;
                } else {
                    String text = object == null ? "" : object.toString();
                    bytes = text.getBytes("utf-8");
                    if (StringUtil.isEmpty(response.getContentType())) {
                        response.setContentType("text/html;charset=utf-8");
                    }
                }
                int len = bytes.length;
                if (len >= Var.sendGzipMinSize && Var.sendGzipMinSize != -1) {
                    response.setHeader("Content-Encoding", "gzip");
                    try (GZIPOutputStream gos = new GZIPOutputStream((OutputStream)outputStream);){
                        gos.write(bytes);
                    }
                } else {
                    response.setContentLength(len);
                    outputStream.write(bytes);
                }
            } else if (Var.sendStreamGzip) {
                response.setHeader("Content-Encoding", "gzip");
                try (GZIPOutputStream gos = new GZIPOutputStream((OutputStream)outputStream);){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)gos);
                }
            } else {
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            response.flushBuffer();
        }
    }

    public static void send(HttpServletResponse response, String text, boolean successful) throws IOException {
        WebUtil.send(response, (Object)StringUtil.textareaQuote(StringUtil.concat("{success:", Boolean.toString(successful), ",value:", StringUtil.quote(text), "}")));
    }

    public static boolean fromAjax(HttpServletRequest request) {
        try {
            return "XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With"));
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void showException(Throwable exception, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        block11: {
            boolean isAjax = WebUtil.fromAjax(request);
            boolean jsonResp = WebUtil.jsonResponse(request);
            boolean directOutput = isAjax || jsonResp;
            StringWriter writer = new StringWriter();
            PrintWriter pwriter = new PrintWriter((Writer)writer, true);
            WebUtil.discardInputStream(request);
            exception.printStackTrace(pwriter);
            String errorMessage = writer.toString();
            Console.printToClient(request, (Object)errorMessage, "error", false);
            if (Var.printError && !directOutput) {
                Throwable rootExcept = SysUtil.getRootExcept(exception);
                if (rootExcept instanceof ServletException) {
                    throw (ServletException)rootExcept;
                }
                throw new ServletException(rootExcept);
            }
            try {
                try {
                    if (Var.printError) {
                        System.err.println(errorMessage);
                    }
                    if (response.isCommitted()) break block11;
                    String rootError = SysUtil.getRootError(exception);
                    response.reset();
                    if (directOutput) {
                        if (jsonResp) {
                            WebUtil.send(response, rootError, false);
                        } else {
                            response.setStatus(500);
                            WebUtil.send(response, (Object)rootError);
                        }
                        break block11;
                    }
                    response.sendError(500, rootError);
                }
                catch (Throwable e) {
                    log.error((Object)"", e);
                    pwriter.close();
                }
            }
            finally {
                pwriter.close();
            }
        }
    }

    public static boolean checkLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("sys.logined") == null) {
            boolean directOutput;
            boolean isAjax = WebUtil.fromAjax(request);
            boolean jsonResp = WebUtil.jsonResponse(request);
            boolean bl = directOutput = isAjax || jsonResp;
            if (directOutput) {
                if (jsonResp) {
                    WebUtil.send(response, "$WBE201: Login required", false);
                } else {
                    response.setStatus(401);
                    WebUtil.send(response, (Object)"Login required");
                }
            } else {
                Parser parser = new Parser(request, response);
                if (WebUtil.isTouchModule(request)) {
                    parser.parse("sys/session/tlogin.xwl");
                } else {
                    parser.parse("sys/session/login.xwl");
                }
            }
            WebUtil.discardInputStream(request);
            return false;
        }
        return true;
    }

    private static boolean isTouchModule(HttpServletRequest request) throws IOException {
        JSONObject module;
        String xwl = UrlBuffer.get(request.getServletPath());
        if (xwl.isEmpty()) {
            xwl = request.getParameter("xwl");
            if (StringUtil.isEmpty(xwl)) {
                return false;
            }
            xwl = StringUtil.concat(xwl, ".xwl");
        }
        if ((module = XwlBuffer.get(xwl, true)) == null) {
            return false;
        }
        return module.has("hasTouch");
    }

    public static boolean hasRole(HttpServletRequest request, String roleName) {
        String[] roles = (String[])WebUtil.fetchObject(request, "sys.roles");
        return StringUtil.indexOf(roles, roleName) != -1;
    }

    public static List<FileItem> setUploadFile(HttpServletRequest request) throws Exception {
        List list;
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        final String uploadId = request.getParameter("uploadId");
        String objectId = request.getParameter("objectId");
        int maxKbSize = Var.getInt("sys.service.upload.maxSize");
        HashMap<String, Integer> multiFilesMap = null;
        Integer maxSize = maxKbSize != -1 ? Integer.valueOf(maxKbSize * 1024) : Integer.valueOf(-1);
        factory.setSizeThreshold(Var.getInt("sys.service.upload.bufferSize"));
        if (uploadId != null && uploadId.indexOf(46) == -1) {
            request.setAttribute("sys.uploadId", (Object)uploadId);
            final HttpSession session = request.getSession(true);
            if (session != null) {
                upload.setProgressListener(new ProgressListener(){

                    public void update(long read, long length, int id) {
                        session.setAttribute("sys.upread." + uploadId, (Object)read);
                        session.setAttribute("sys.uplen." + uploadId, (Object)length);
                    }
                });
            }
        }
        if ((list = upload.parseRequest(request)) == null || list.size() == 0) {
            return null;
        }
        try {
            for (FileItem item : list) {
                String fieldName = item.getFieldName();
                if (fieldName.indexOf(46) != -1 || fieldName.indexOf(64) != -1) continue;
                if (item.isFormField()) {
                    if (request.getAttribute(fieldName) != null) {
                        throw new RuntimeException("Duplicate parameters \"" + fieldName + "\" found.");
                    }
                    request.setAttribute(fieldName, (Object)item.getString("utf-8"));
                    continue;
                }
                String fileName = FileUtil.getFilename(item.getName());
                String fieldExtType = FileUtil.getFileExt(fileName);
                if (StringUtils.isNotBlank((String)Var.allowType) && !StringUtils.containsIgnoreCase((String)Var.allowType, (String)fieldExtType)) {
                    throw new IllegalArgumentException("\u6587\u4ef6\u7c7b\u578b\u8d85\u51fa\u4e86\u5141\u8bb8\u8303\u56f4(" + Var.allowType + ")");
                }
                if (StringUtils.isBlank((String)Var.allowType) && StringUtils.isNotBlank((String)Var.notAllowType) && StringUtils.containsIgnoreCase((String)Var.notAllowType, (String)fieldExtType)) {
                    throw new IllegalArgumentException("\u8be5\u7c7b\u578b\u6587\u4ef6\u4e0d\u5141\u8bb8\u4e0a\u4f20!!!");
                }
                long fileSize = item.getSize();
                if (maxSize != -1 && fileSize > (long)maxSize.intValue()) {
                    throw new IllegalArgumentException("\u6587\u4ef6\u8d85\u51fa\u6700\u5927\u503c" + maxKbSize / 1024 + "M");
                }
                if (request.getAttribute(fieldName) != null) {
                    Integer fileIndex;
                    if (multiFilesMap == null) {
                        multiFilesMap = new HashMap<String, Integer>();
                    }
                    if ((fileIndex = (Integer)multiFilesMap.get(fieldName)) == null) {
                        fileIndex = 0;
                    }
                    fileIndex = fileIndex + 1;
                    multiFilesMap.put(fieldName, fileIndex);
                    String fileIndexText = "@" + Integer.toString(fileIndex);
                    if (StringUtil.isEmpty(fileName) && fileSize == 0L) {
                        request.setAttribute(String.valueOf(fieldName) + fileIndexText, (Object)"");
                    } else if (StringUtils.isNotBlank((String)objectId)) {
                        WebUtil.saveFileToDB(item, objectId, WebUtil.fetch(request, "sys.username"));
                    } else {
                        request.setAttribute(String.valueOf(fieldName) + fileIndexText, (Object)item.getInputStream());
                    }
                    request.setAttribute(StringUtil.concat(fieldName, fileIndexText, "__name"), (Object)fileName);
                    request.setAttribute(StringUtil.concat(fieldName, fileIndexText, "__size"), (Object)fileSize);
                    continue;
                }
                if (StringUtil.isEmpty(fileName) && fileSize == 0L) {
                    request.setAttribute(fieldName, (Object)"");
                } else if (StringUtils.isNotBlank((String)objectId)) {
                    WebUtil.saveFileToDB(item, objectId, WebUtil.fetch(request, "sys.username"));
                } else {
                    request.setAttribute(fieldName, (Object)item.getInputStream());
                }
                request.setAttribute(String.valueOf(fieldName) + "__name", (Object)fileName);
                request.setAttribute(String.valueOf(fieldName) + "__size", (Object)fileSize);
            }
        }
        catch (Throwable e) {
            WebUtil.clearUploadFile(request, list);
            throw new Exception(e);
        }
        return list;
    }

    public static void saveFileToDB(FileItem item, String objectId, String username) throws Exception {
        String id = SysUtil.getId();
        String fileInfoSql = "insert into t_files(ID,OBJECT_ID,NAME,FILE_SIZE,EXTENSION,CREATE_BY,CREATE_TIME,FILE_FLAG) values(?,?,?,?,?,?,?,?)";
        String sql = "insert into t_file_content(id,content) values(?,?)";
        Connection conn = null;
        PreparedStatement st = null;
        InputStream inputStream = null;
        File tempFile = null;
        try {
            tempFile = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + id);
            cn.hutool.core.io.FileUtil.writeFromStream((InputStream)item.getInputStream(), (File)tempFile);
            try {
                conn = DbUtil.getConnection(Var.wolfDataConn);
            }
            catch (Exception e) {
                conn = DbUtil.getConnection("");
            }
            conn.setAutoCommit(false);
            st = conn.prepareStatement(fileInfoSql);
            st.setString(1, id);
            st.setString(2, objectId);
            st.setString(3, FileUtil.removeExtension(FileUtil.getFilename(item.getName())));
            st.setDouble(4, item.getSize());
            st.setString(5, FileUtil.getFileExt(item.getName()));
            st.setString(6, username);
            st.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
            st.setString(8, username);
            st.executeUpdate();
            st.close();
            inputStream = new FileInputStream(tempFile);
            st = conn.prepareStatement(sql);
            st.setString(1, id);
            st.setBlob(2, inputStream);
            st.executeUpdate();
            conn.commit();
        }
        catch (Throwable throwable) {
            DbUtil.close(st);
            DbUtil.close(conn);
            if (inputStream != null) {
                inputStream.close();
            }
            cn.hutool.core.io.FileUtil.del(tempFile);
            throw throwable;
        }
        DbUtil.close(st);
        DbUtil.close(conn);
        if (inputStream != null) {
            inputStream.close();
        }
        cn.hutool.core.io.FileUtil.del((File)tempFile);
    }

    public static File zipImage(FileItem item) {
        BufferedImage bi;
        File file;
        block5: {
            file = null;
            file = cn.hutool.core.io.FileUtil.touch((File)Base.path, (String)("template" + File.separatorChar + "tempUpload" + File.separatorChar + item.getName()));
            bi = ImageIO.read(file);
            if (bi != null) break block5;
            return null;
        }
        try {
            int width = bi.getWidth();
            int height = bi.getHeight();
            if (width > 1800) {
                width = 1800;
            }
            if (height > 1800) {
                height = 1800;
            }
            Thumbnails.of((InputStream[])new InputStream[]{item.getInputStream()}).size(width, height).toFile(file);
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
        return file;
    }

    public static File checkImage(FileItem item) throws Exception {
        File file = null;
        BufferedImage bi = null;
        try (ImageInputStream iis = null;){
            iis = ImageIO.createImageInputStream(item.getInputStream());
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                return null;
            }
            bi = ImageIO.read(item.getInputStream());
            if (bi == null) {
                return null;
            }
            try {
                int width = bi.getWidth();
                int height = bi.getHeight();
                boolean resize = false;
                if (width > 1800) {
                    width = 1800;
                    resize = true;
                }
                if (height > 1800) {
                    height = 1800;
                    resize = true;
                }
                if (resize) {
                    String uploadDirectory = Var.getString("sys.controls.uploadDirectory");
                    file = StringUtil.isEmpty(uploadDirectory) ? cn.hutool.core.io.FileUtil.file((File)Base.path, (String)("template" + File.separator + "tempUpload" + File.separator + FileUtil.getFilename(item.getName()))) : cn.hutool.core.io.FileUtil.file((String)(String.valueOf(uploadDirectory) + File.separator + FileUtil.getFilename(item.getName())));
                    Thumbnails.of((InputStream[])new InputStream[]{item.getInputStream()}).size(width, height).toFile(file);
                }
            }
            catch (IOException e) {
                log.error((Object)"", (Throwable)e);
                LogUtil.error(e.getMessage());
                throw e;
            }
        }
        return file;
    }

    public static boolean hasFile(HttpServletRequest request, String name) {
        return request.getAttribute(name) instanceof InputStream;
    }

    public static void discardInputStream(HttpServletRequest request) {
        try {
            ServletInputStream stream = request.getInputStream();
            byte[] skipBuffer = new byte[2048];
            while (stream.read(skipBuffer) != -1) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void clearUploadFile(HttpServletRequest request, List<FileItem> list) {
        for (FileItem item : list) {
            if (item.isFormField() || item.isInMemory()) continue;
            Object object = request.getAttribute(item.getFieldName());
            if (object instanceof InputStream) {
                IOUtils.closeQuietly((InputStream)((InputStream)object));
            }
            item.delete();
        }
        String uploadId = (String)request.getAttribute("sys.uploadId");
        if (uploadId != null) {
            HttpSession session = request.getSession(true);
            session.removeAttribute("sys.upread." + uploadId);
            session.removeAttribute("sys.uplen." + uploadId);
        }
    }

    public static boolean jsonResponse(HttpServletRequest request) {
        return WebUtil.exists(request, "_jsonresp");
    }

    public static boolean exists(HttpServletRequest request, String name) {
        Object value = name.startsWith("sys.") ? request.getAttribute(name) : WebUtil.fetch(request, name);
        if (value == null) {
            return false;
        }
        return "1".equals(value.toString());
    }

    public static Object getObject(HttpServletRequest request, String name) {
        Object object = request.getAttribute("sysx.varMap");
        if (object != null) {
            ConcurrentHashMap map = JSONObject.toConHashMap((Object)object);
            return map.get(name);
        }
        return null;
    }

    public static void include(HttpServletRequest request, HttpServletResponse response, String path) throws Exception {
        WebUtil.doInclude(request, response, path, false);
    }

    public static void forward(HttpServletRequest request, HttpServletResponse response, String path) throws Exception {
        WebUtil.doInclude(request, response, path, true);
    }

    private static void doInclude(HttpServletRequest request, HttpServletResponse response, String path, boolean isForward) throws Exception {
        String xwl = path.endsWith(".xwl") ? path : UrlBuffer.get("/" + path);
        if (xwl == null) {
            if (isForward) {
                request.getRequestDispatcher(path).forward((ServletRequest)request, (ServletResponse)response);
            } else {
                request.getRequestDispatcher(path).include((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            if (isForward) {
                response.resetBuffer();
            }
            if (xwl.isEmpty()) {
                xwl = request.getParameter("xwl");
                if (xwl == null) {
                    response.sendError(400, "null xwl");
                    return;
                }
                xwl = StringUtil.concat(xwl, ".xwl");
            }
            Parser parser = new Parser(request, response);
            parser.parse(xwl);
        }
    }

    public static void setObject(HttpServletRequest request, String name, Object value) {
        Object object = request.getAttribute("sysx.varMap");
        if (object != null) {
            ConcurrentHashMap map = JSONObject.toConHashMap((Object)object);
            if (map.containsKey(name)) {
                throw new IllegalArgumentException("Key \"" + name + "\" already exists.");
            }
            map.put(name, value);
        }
    }

    public static void applyAttributes(HttpServletRequest request, JSONObject params) {
        if (params == null) {
            return;
        }
        Set es = params.entrySet();
        for (Map.Entry e : es) {
            request.setAttribute((String)e.getKey(), e.getValue());
        }
    }

    public static void replaceAllAttributes(HttpServletRequest request, JSONObject params) {
        Enumeration attributeNames = request.getAttributeNames();
        if (attributeNames != null) {
            while (attributeNames.hasMoreElements()) {
                String name = ((String)attributeNames.nextElement()).toString();
                request.removeAttribute(name);
            }
        }
        WebUtil.applyAttributes(request, params);
    }

    public static ArrayList<Session> getSocketSessions(String name) throws IOException {
        String[] users = UserList.getUsers();
        ArrayList<Session> allSessions = new ArrayList<Session>();
        String[] stringArray = users;
        int n = users.length;
        int n2 = 0;
        while (n2 < n) {
            String user = stringArray[n2];
            ArrayList<Session> val = WebUtil.getSocketSessions(user, name);
            if (val != null) {
                allSessions.addAll(val);
            }
            ++n2;
        }
        return allSessions;
    }

    public static ArrayList<Session> getSocketSessions(String userId, String name) throws IOException {
        HttpSession[] httpSessions = UserList.getSessions(userId);
        if (httpSessions == null) {
            return null;
        }
        ArrayList<Session> allSessions = new ArrayList<Session>();
        HttpSession[] httpSessionArray = httpSessions;
        int n = httpSessions.length;
        int n2 = 0;
        while (n2 < n) {
            HttpSession httpSession = httpSessionArray[n2];
            Session[] sessions = SessionBridge.getSessions(httpSession, name);
            if (sessions != null) {
                Session[] sessionArray = sessions;
                int n3 = sessions.length;
                int n4 = 0;
                while (n4 < n3) {
                    Session session = sessionArray[n4];
                    allSessions.add(session);
                    ++n4;
                }
            }
            ++n2;
        }
        return allSessions.size() > 0 ? allSessions : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendSocketText(Session session, String data, boolean successful, boolean feedback) throws IOException {
        StringBuilder buf = new StringBuilder(data == null ? 44 : 44 + data.length());
        buf.append("{\"success\":");
        buf.append(successful ? "true" : "false");
        buf.append(",\"feedback\":");
        buf.append(feedback ? "true" : "false");
        buf.append(",\"data\":");
        buf.append(StringUtil.quote(data));
        buf.append("}");
        String result = buf.toString();
        RemoteEndpoint.Basic basic = session.getBasicRemote();
        Session session2 = session;
        synchronized (session2) {
            basic.sendText(result);
        }
    }

    public static void sendSocketText(Session session, String data) throws IOException {
        WebUtil.sendSocketText(session, data, true, false);
    }

    public static void send(String name, Object object) throws IOException {
        ArrayList<Session> socketSessions = WebUtil.getSocketSessions(name);
        String text = object == null ? "" : object.toString();
        for (Session session : socketSessions) {
            if (!session.isOpen()) continue;
            WebUtil.sendSocketText(session, text);
        }
    }

    public static void send(String userId, String name, Object object) throws IOException {
        ArrayList<Session> socketSessions = WebUtil.getSocketSessions(userId, name);
        if (socketSessions == null) {
            return;
        }
        String text = object == null ? "" : object.toString();
        for (Session session : socketSessions) {
            if (!session.isOpen()) continue;
            WebUtil.sendSocketText(session, text);
        }
    }

    public static void send(HttpSession httpSession, String name, Object object) throws IOException {
        Session[] sessions = SessionBridge.getSessions(httpSession, name);
        if (sessions == null) {
            return;
        }
        String text = object == null ? "" : object.toString();
        Session[] sessionArray = sessions;
        int n = sessions.length;
        int n2 = 0;
        while (n2 < n) {
            Session session = sessionArray[n2];
            if (session.isOpen()) {
                WebUtil.sendSocketText(session, text);
            }
            ++n2;
        }
    }
}

