/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.ks.fintech.bw.support.FunctionUtils;
import com.wb.common.Base;
import com.wb.common.Parser;
import com.wb.common.Session;
import com.wb.common.Str;
import com.wb.common.XwlBuffer;
import com.wb.fit.CustomRequest;
import com.wb.fit.CustomResponse;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class WbUtil {
    public static String run(String url, JSONObject params, boolean isInvoke) throws Exception {
        CustomResponse response = new CustomResponse(null);
        CustomRequest request = new CustomRequest();
        request.setParams(params);
        Parser parser = new Parser((HttpServletRequest)request, (HttpServletResponse)response);
        String moduleFile = FileUtil.getModuleFile(url);
        parser.parse(moduleFile, true, isInvoke);
        return WbUtil.getResponseString(response);
    }

    public static String run(String url, JSONObject params, HttpServletRequest request, boolean isInvoke) throws Exception {
        CustomResponse response = new CustomResponse(null);
        if (params != null) {
            WebUtil.applyAttributes(request, params);
        }
        Parser parser = new Parser(request, (HttpServletResponse)response);
        String moduleFile = FileUtil.getModuleFile(url);
        String funcId = StringUtil.toString(FunctionUtils.getFuncByPath((String)moduleFile).getFuncId());
        parser.execute(moduleFile, isInvoke ? 5 : 4, null, funcId);
        return WbUtil.getResponseString(response);
    }

    public static void run(String url, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Parser parser = new Parser(request, response);
        String moduleFile = FileUtil.getModuleFile(url);
        String funcId = StringUtil.toString(FunctionUtils.getFuncByPath((String)moduleFile).getFuncId());
        parser.execute(moduleFile, 1, null, funcId);
    }

    public static JSONObject getAppInfo(String url, HttpServletRequest request) throws Exception {
        String path = FileUtil.getModuleFile(url);
        JSONObject obj = XwlBuffer.get(path);
        String[] names = new String[]{"title", "iconCls"};
        JSONObject info = JsonUtil.copy(obj, names);
        String title = info.optString("title");
        if (title.startsWith("Str.")) {
            info.put("title", (Object)Str.format(request, title.substring(4)));
        }
        info.put("url", (Object)path);
        return info;
    }

    public static JSONObject getModuleRoles() throws Exception {
        JSONObject perms = new JSONObject();
        WbUtil.scanModulePerm(Base.modulePath, perms);
        return perms;
    }

    public static String getResponseString(CustomResponse response) throws Exception {
        String result;
        byte[] data = response.getBytes();
        if (data.length > 2 && data[0] == 31 && data[1] == -117) {
            try (GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(data));){
                result = StringUtil.getString(is);
            }
        } else {
            result = new String(data, "utf-8");
        }
        return result;
    }

    private static void scanModulePerm(File path, JSONObject perms) throws Exception {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles(path);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                WbUtil.scanModulePerm(file, perms);
            } else {
                String filename = file.getName();
                if (filename.endsWith(".xwl")) {
                    String filePath = FileUtil.getModulePath(file);
                    JSONObject jo = XwlBuffer.get(filePath);
                    JSONObject roles = (JSONObject)jo.opt("roles");
                    perms.put(filePath, (Object)roles);
                }
            }
            ++n2;
        }
    }

    public static boolean canAccess(HttpServletRequest request, String path) throws Exception {
        if (request == null || path == null) {
            return false;
        }
        JSONObject module = XwlBuffer.get(FileUtil.getModuleFile(path));
        String[] roles = Session.getRoles(request);
        return WbUtil.canAccess(module, roles);
    }

    public static boolean canAccess(HttpSession session, String path) throws Exception {
        if (session == null || path == null) {
            return false;
        }
        JSONObject module = XwlBuffer.get(FileUtil.getModuleFile(path));
        String[] roles = (String[])session.getAttribute("sys.roles");
        return WbUtil.canAccess(module, roles);
    }

    public static boolean canAccess(JSONObject module, String[] roles) {
        boolean noLoginRequired = Boolean.FALSE.equals(module.opt("loginRequired"));
        if (noLoginRequired) {
            return true;
        }
        if (roles == null) {
            return false;
        }
        JSONObject setRoles = (JSONObject)module.opt("roles");
        String[] stringArray = roles;
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            String role = stringArray[n2];
            if (setRoles.has(role)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static JSONObject getModuleConfigs(String url) throws Exception {
        String moduleFile = FileUtil.getModuleFile(url);
        JSONObject fullModule = XwlBuffer.get(moduleFile, false);
        JSONObject module = (JSONObject)((JSONArray)fullModule.opt("children")).opt(0);
        return (JSONObject)module.opt("configs");
    }
}

