/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.util.DateUtil;
import com.wb.util.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TradeDateUtil {
    public static String getPrevTradeDate() {
        return TradeDateUtil.getTradeDate(DateUtil.format(new Date(), "yyyyMMdd"), -1);
    }

    public static String getNowTradeDate() {
        return DateUtil.format(new Date(), "yyyyMMdd");
    }

    public static String getTradeDate(String date, int flag) {
        try {
            Connection conn = null;
            PreparedStatement st = null;
            ResultSet rs = null;
            String prevTradeDate = null;
            String sql = "select wolf.f_get_tradedate(?,?) as tradeDate from dual ";
            try {
                conn = DbUtil.getConnection();
                st = conn.prepareStatement(sql);
                st.setString(1, date);
                st.setInt(2, flag);
                rs = st.executeQuery();
                if (rs.next()) {
                    prevTradeDate = rs.getString("tradeDate");
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(st);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
            return prevTradeDate;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String getNowYearFirstDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Calendar cyf = Calendar.getInstance();
        cyf.add(1, 0);
        cyf.set(6, 1);
        String cyff = format.format(cyf.getTime());
        return cyff;
    }

    public static String getNowYMonthFirstDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Calendar c = Calendar.getInstance();
        c.add(2, 0);
        c.set(5, 1);
        String first = format.format(c.getTime());
        return first;
    }

    public static String getBeforeMonthfirstDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Calendar c = Calendar.getInstance();
        c.add(2, -1);
        c.set(5, 1);
        String first = format.format(c.getTime());
        return first;
    }

    public static String getBeforeMonthEndDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        c.add(5, -1);
        String first = format.format(c.getTime());
        return first;
    }

    public static String getNowYFirstMonth() {
        return String.valueOf(DateUtil.format(new Date(), "yyyy")) + "01";
    }

    public static String getNowMonth() {
        return DateUtil.format(new Date(), "yyyyMM");
    }

    public static String getBeforeMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, -1);
        return DateUtil.format(cal.getTime(), "yyyyMM");
    }
}

