/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.util.DbUtil;
import com.wb.util.StringUtil;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ks.fintech.framework.core.exception.KException;
import ks.fintech.framework.core.exception.SqlException;
import ks.fintech.framework.sp.ResultSetBean;
import ks.fintech.framework.sp.SPUtils;
import ks.fintech.framework.sp.SpParamUnit;
import ks.fintech.framework.sql.DbUtils;
import ks.fintech.framework.sql.SqlExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.jdbc.core.JdbcTemplate;

public class SqlUtil {
    public static Log log = LogFactory.getLog(SqlUtil.class);

    public static List<Map<String, Object>> executeSql(SqlExecutor sqlExe, String sql) throws KException {
        try {
            return sqlExe.queryMapList(sql, null);
        }
        catch (SqlException e) {
            throw new KException((Throwable)e);
        }
    }

    public static List<Map<String, Object>> executeSql(JdbcTemplate jdbcTemplate, String sql) throws KException {
        try {
            return jdbcTemplate.queryForList(sql);
        }
        catch (SqlException e) {
            throw new KException((Throwable)e);
        }
    }

    public static List<Map<String, Object>> executeSp(SqlExecutor sqlExe, String sp, Map<String, Object> paramMap) throws KException {
        List list;
        block5: {
            HashMap<String, Object> ret = null;
            String dealedSp = SqlUtil.replaceMacros(sp);
            Connection conn = sqlExe.getConnection();
            CallableStatement statement = null;
            list = null;
            try {
                try {
                    statement = conn.prepareCall(dealedSp);
                    ret = SqlUtil.getOutParameter(SqlUtil.regParameters(sp.trim(), statement, paramMap), statement);
                    list = (List)ret.get("result");
                }
                catch (Exception e) {
                    log.error((Object)("sp\u6267\u884c\u51fa\u9519---------sp params\u4e3a---------" + paramMap), (Throwable)e);
                    DbUtils.closeQuietly((Statement)statement);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(statement);
                throw throwable;
            }
            DbUtils.closeQuietly((Statement)statement);
        }
        return list;
    }

    public static String replaceParams(JSONObject jo, String text) {
        if (jo == null || text == null) {
            return text;
        }
        Set keySet = jo.keySet();
        for (String key : keySet) {
            text = text.replaceAll("\\{\\?" + key + "\\?\\}", "'" + jo.get(key).toString() + "'");
        }
        return text;
    }

    public static String getClobString(Clob c) {
        Reader reader;
        block4: {
            reader = c.getCharacterStream();
            if (reader != null) break block4;
            return null;
        }
        try {
            StringBuffer sb = new StringBuffer();
            char[] charbuf = new char[4096];
            int i = reader.read(charbuf);
            while (i > 0) {
                sb.append(charbuf, 0, i);
                i = reader.read(charbuf);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String replaceMacros(String sql) {
        StringBuilder buf = new StringBuilder();
        int startPos = 0;
        int endPos = 0;
        int lastPos = 0;
        while ((startPos = sql.indexOf("{?", startPos)) > -1 && (endPos = sql.indexOf("?}", endPos)) > -1) {
            buf.append(sql.substring(lastPos, startPos));
            startPos += 2;
            buf.append("'{?");
            buf.append(sql.substring((endPos += 2) - 1, endPos));
            buf.append('\'');
            lastPos = endPos;
        }
        buf.append(sql.substring(lastPos));
        String debugSql = buf.toString();
        String formattedSql = StringUtil.replaceAll(debugSql, "'{?}'", "?");
        return formattedSql;
    }

    public static List<Object[]> regParameters(String sql, PreparedStatement statement, Map<String, Object> paramMap) throws Exception {
        int index = 1;
        int startPos = 0;
        int endPos = 0;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        LinkedHashMap<String, Object> paramValMap = new LinkedHashMap<String, Object>();
        CallableStatement callStatement = statement instanceof CallableStatement ? (CallableStatement)statement : null;
        boolean isCall = callStatement != null;
        while ((startPos = sql.indexOf("{?", startPos)) > -1 && (endPos = sql.indexOf("?}", endPos)) > -1) {
            int type;
            Integer typeObj;
            String paraName;
            int dotPos;
            boolean isOutParam;
            String param = sql.substring(startPos += 2, endPos);
            endPos += 2;
            String orgParam = param;
            boolean bl = isOutParam = isCall && param.startsWith("@");
            if (isOutParam) {
                boolean hasSub;
                String typeText;
                dotPos = (param = param.substring(1)).indexOf(46);
                if (dotPos == -1) {
                    typeText = "varchar";
                    paraName = param;
                } else {
                    typeText = param.substring(0, dotPos);
                    paraName = param.substring(dotPos + 1);
                }
                boolean bl2 = hasSub = typeText.indexOf(61) != -1;
                if (hasSub) {
                    typeObj = DbUtil.getFieldType(StringUtil.getNamePart(typeText));
                    if (typeObj == null) {
                        throw new Exception("Invalid type " + typeText);
                    }
                    type = typeObj;
                    int subType = Integer.parseInt(StringUtil.getValuePart(typeText));
                    callStatement.registerOutParameter(index, type, subType);
                } else {
                    typeObj = DbUtil.getFieldType(typeText);
                    if (typeObj == null) {
                        throw new Exception("Invalid type " + typeText);
                    }
                    type = typeObj;
                    callStatement.registerOutParameter(index, type);
                }
            } else {
                dotPos = param.indexOf(46);
                if (dotPos == -1) {
                    type = 12;
                    paraName = param;
                } else {
                    typeObj = DbUtil.getFieldType(param.substring(0, dotPos));
                    if (typeObj == null) {
                        type = 12;
                        paraName = param;
                    } else {
                        type = typeObj;
                        paraName = param.substring(dotPos + 1);
                    }
                }
                Object obj = paramMap.get(paraName);
                DbUtil.setObject(statement, index, type, obj);
                paramValMap.put(paraName, obj);
            }
            Object[] paramObjects = new Object[]{paraName, type, isOutParam};
            paramList.add(paramObjects);
            ++index;
        }
        return paramList;
    }

    public static HashMap<String, Object> getOutParameter(List<Object[]> paramList, PreparedStatement statement) throws Exception {
        CallableStatement st = (CallableStatement)statement;
        statement.execute();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < paramList.size()) {
            block8: {
                Object[] param = paramList.get(i);
                if (((Boolean)param[2]).booleanValue()) {
                    Object object = DbUtil.getObject(st, i + 1, (int)((Integer)param[1]));
                    map.put((String)param[0], object);
                    if (object != null && object instanceof ResultSet) {
                        ResultSet rs = (ResultSet)object;
                        try {
                            try {
                                map.put((String)param[0], SqlUtil.getDataFromResultSet(rs));
                            }
                            catch (Exception e) {
                                log.error((Object)"", (Throwable)e);
                                DbUtils.closeQuietly((ResultSet)rs);
                                break block8;
                            }
                        }
                        catch (Throwable throwable) {
                            DbUtils.closeQuietly((ResultSet)rs);
                            throw throwable;
                        }
                        DbUtils.closeQuietly((ResultSet)rs);
                    }
                }
            }
            ++i;
        }
        return map;
    }

    public static List<Map<String, Object>> getDataFromResultSet(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> rets = new ArrayList<Map<String, Object>>();
        ResultSetBean rsb = new ResultSetBean("result");
        SPUtils.injectBean((ResultSetBean)rsb, (ResultSetMetaData)rs.getMetaData());
        ResultSetMetaData metaData = rs.getMetaData();
        int i = 1;
        while (i <= metaData.getColumnCount()) {
            System.out.println(metaData.getColumnName(i));
            ++i;
        }
        while (rs.next()) {
            LinkedHashMap<String, Object> one = new LinkedHashMap<String, Object>();
            for (SpParamUnit unit : rsb.getParams()) {
                one.put(unit.getName(), rs.getObject(unit.getName()));
            }
            rets.add(one);
        }
        return rets;
    }
}

