/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.tool.GlobeStorage;
import com.wb.util.SystemKit;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSAUtils {
    public static final String CHARSET = "UTF-8";
    public static final String RSA_ALGORITHM = "RSA";
    private static final int MAX_ENCRYPT_BLOCK = 117;

    public static HashMap<String, Object> getKeys() throws NoSuchAlgorithmException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(RSA_ALGORITHM, (Provider)new BouncyCastleProvider());
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        String privateKeyStr = Base64.encodeBase64URLSafeString((byte[])privateKey.getEncoded());
        String publicKeyStr = Base64.encodeBase64URLSafeString((byte[])publicKey.getEncoded());
        map.put("public", publicKey);
        map.put("private", privateKey);
        map.put("publicKeyStr", publicKeyStr);
        map.put("privateKeyStr", privateKeyStr);
        return map;
    }

    public static RSAPublicKey getPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKey));
        RSAPublicKey key = (RSAPublicKey)keyFactory.generatePublic(x509KeySpec);
        return key;
    }

    public static RSAPrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
        RSAPrivateKey key = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
        return key;
    }

    public static RSAPublicKey getPublicKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM, (Provider)new BouncyCastleProvider());
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(b1, b2);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RSAPrivateKey getPrivateKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM, (Provider)new BouncyCastleProvider());
            RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(b1, b2);
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encryptByPublicKey(String data, RSAPublicKey publicKey) throws Exception {
        byte[][] arrays;
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM, (Provider)new BouncyCastleProvider());
        cipher.init(1, publicKey);
        int key_len = publicKey.getModulus().bitLength() / 8;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] bytes = data.getBytes();
        byte[][] byArray = arrays = RSAUtils.splitArray(bytes, key_len - 11);
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] arr = byArray[n2];
            byte[] cache = cipher.doFinal(arr);
            out.write(cache, 0, cache.length);
            ++n2;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return RSAUtils.bcd2Str(encryptedData);
    }

    public static String decryptByPrivateKey(String data, RSAPrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM, (Provider)new BouncyCastleProvider());
        cipher.init(2, privateKey);
        int key_len = privateKey.getModulus().bitLength() / 8;
        byte[] bytes = data.getBytes();
        byte[] bcd = RSAUtils.ASCII_To_BCD(bytes, bytes.length);
        String ming = "";
        byte[][] arrays = RSAUtils.splitArray(bcd, key_len);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[][] byArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] arr = byArray[n2];
            ming = String.valueOf(ming) + new String(cipher.doFinal(arr));
            byte[] cache = cipher.doFinal(arr);
            out.write(cache, 0, cache.length);
            ++n2;
        }
        byte[] decryptData = out.toByteArray();
        out.close();
        return new String(decryptData);
    }

    public static byte[] ASCII_To_BCD(byte[] ascii, int asc_len) {
        byte[] bcd = new byte[asc_len / 2];
        int j = 0;
        int i = 0;
        while (i < (asc_len + 1) / 2) {
            bcd[i] = RSAUtils.asc_to_bcd(ascii[j++]);
            bcd[i] = (byte)((j >= asc_len ? (byte)0 : RSAUtils.asc_to_bcd(ascii[j++])) + (bcd[i] << 4));
            ++i;
        }
        return bcd;
    }

    public static byte asc_to_bcd(byte asc) {
        byte bcd = asc >= 48 && asc <= 57 ? (byte)(asc - 48) : (asc >= 65 && asc <= 70 ? (byte)(asc - 65 + 10) : (asc >= 97 && asc <= 102 ? (byte)(asc - 97 + 10) : (byte)(asc - 48)));
        return bcd;
    }

    public static String bcd2Str(byte[] bytes) {
        char[] temp = new char[bytes.length * 2];
        int i = 0;
        while (i < bytes.length) {
            char val = (char)((bytes[i] & 0xF0) >> 4 & 0xF);
            temp[i * 2] = (char)(val > '\t' ? val + 65 - 10 : val + 48);
            val = (char)(bytes[i] & 0xF);
            temp[i * 2 + 1] = (char)(val > '\t' ? val + 65 - 10 : val + 48);
            ++i;
        }
        return new String(temp);
    }

    public static String[] splitString(String string, int len) {
        int x = string.length() / len;
        int y = string.length() % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        String[] strings = new String[x + z];
        String str = "";
        int i = 0;
        while (i < x + z) {
            str = i == x + z - 1 && y != 0 ? string.substring(i * len, i * len + y) : string.substring(i * len, i * len + len);
            strings[i] = str;
            ++i;
        }
        return strings;
    }

    public static byte[][] splitArray(byte[] data, int len) {
        int x = data.length / len;
        int y = data.length % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        byte[][] arrays = new byte[x + z][];
        int i = 0;
        while (i < x + z) {
            byte[] arr = new byte[len];
            if (i == x + z - 1 && y != 0) {
                System.arraycopy(data, i * len, arr, 0, y);
            } else {
                System.arraycopy(data, i * len, arr, 0, len);
            }
            arrays[i] = arr;
            ++i;
        }
        return arrays;
    }

    public static Map<String, Object> getPublicKey(HttpServletRequest request) throws NoSuchAlgorithmException {
        HashMap<String, Object> key;
        HashMap<String, Object> map = new HashMap<String, Object>();
        ConcurrentHashMap<String, HashMap<String, Object>> keyMap = GlobeStorage.globeStorage;
        String ipAddr = SystemKit.getClientIP(request);
        if (keyMap.containsKey(ipAddr)) {
            key = keyMap.get(ipAddr);
        } else {
            key = RSAUtils.getKeys();
            GlobeStorage.globeStorage.put(ipAddr, key);
        }
        RSAPublicKey publicKey = (RSAPublicKey)key.get("public");
        String publicKeyExponent = publicKey.getPublicExponent().toString(16);
        String publicKeyModulus = publicKey.getModulus().toString(16);
        map.put("publicKeyExponent", publicKeyExponent);
        map.put("publicKeyModulus", publicKeyModulus);
        return map;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> map = RSAUtils.getKeys();
        RSAPublicKey publicKey = (RSAPublicKey)map.get("public");
        RSAPrivateKey privateKey = (RSAPrivateKey)map.get("private");
        RSAUtils.test(publicKey, privateKey);
        publicKey = RSAUtils.getPublicKey((String)map.get("publicKeyStr"));
        privateKey = RSAUtils.getPrivateKey((String)map.get("privateKeyStr"));
        RSAUtils.test(publicKey, privateKey);
    }

    private static void test(RSAPublicKey publicKey, RSAPrivateKey privateKey) throws Exception {
        String modulus = publicKey.getModulus().toString();
        System.out.println("pubkey modulus=" + modulus);
        String public_exponent = publicKey.getPublicExponent().toString();
        System.out.println("pubkey exponent=" + public_exponent);
        String private_exponent = privateKey.getPrivateExponent().toString();
        System.out.println("private exponent=" + private_exponent);
        String ming = "\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c\u548c\u6307\u6570\u751f\u6210\u516c\u94a5\u548c1111";
        RSAPublicKey pubKey = RSAUtils.getPublicKey(modulus, public_exponent);
        RSAPrivateKey priKey = RSAUtils.getPrivateKey(modulus, private_exponent);
        String mi = RSAUtils.encryptByPublicKey(ming, pubKey);
        System.err.println("mi=" + mi);
        String ming2 = RSAUtils.decryptByPrivateKey(mi, priKey);
        System.err.println("ming2=" + ming2);
    }
}

