/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.ks.fintech.bw.api.FunctionEObj;
import com.ks.fintech.bw.api.MenuEObj;
import com.wb.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ks.fintech.bw.api.service.BasicServiceAware;
import ks.fintech.bw.api.service.CacheServiceAware;
import ks.fintech.bw.api.service.FunctionContentCacheAware;
import ks.fintech.bw.api.utils.RoleUtils;
import ks.fintech.framework.core.exception.KException;
import ks.fintech.framework.utils.SpringContextUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class ExportUtil {
    private static BasicServiceAware basicService = (BasicServiceAware)SpringContextUtil.getBean((String)"bwBasicService");
    private static String XWL = ".xwl";

    public static void downloadModules(String floderPath, String shortPath) throws Exception {
        CacheServiceAware cacheService = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
        MenuEObj mEobjRes = cacheService.getMenu(shortPath);
        if (mEobjRes != null) {
            ExportUtil.mkMenu(mEobjRes, floderPath, mEobjRes.getMenuName(), null);
        } else {
            ExportUtil.mkFunction(floderPath, shortPath, null);
        }
    }

    public static void zipModules(String floderPath, String shortPath, Date lastModified) throws Exception {
        CacheServiceAware cacheService = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
        if ("modules".equals(shortPath)) {
            Map menuMap = cacheService.getMenuMap();
            ArrayList<MenuEObj> menuList = new ArrayList<MenuEObj>();
            for (MenuEObj menuEObj : menuMap.values()) {
                if (!RoleUtils._root.equals(menuEObj.getParentId())) continue;
                menuList.add(menuEObj);
            }
            for (MenuEObj menu : menuList) {
                if (menu == null) continue;
                ExportUtil.mkMenu(menu, floderPath, menu.getMenuName(), lastModified);
            }
        } else if (!shortPath.toLowerCase().endsWith(XWL.toLowerCase())) {
            MenuEObj menuEobj = cacheService.getMenu(shortPath);
            String subPath = "";
            if (menuEobj != null) {
                subPath = ExportUtil.mkParentMenu(menuEobj, floderPath);
                ExportUtil.mkMenu(menuEobj, String.valueOf(floderPath) + subPath, menuEobj.getMenuName(), lastModified);
            }
        } else {
            String xwlParent = shortPath.substring(0, shortPath.lastIndexOf("/", shortPath.lastIndexOf("/")));
            MenuEObj parentEobj = cacheService.getMenu(xwlParent);
            String subPath = "";
            if (parentEobj != null) {
                subPath = ExportUtil.mkParentMenu(parentEobj, floderPath);
                FileUtil.createMkdirs(String.valueOf(floderPath) + subPath + File.separator + parentEobj.getMenuName());
                ExportUtil.mkFolder(parentEobj, String.valueOf(floderPath) + subPath + File.separator + parentEobj.getMenuName());
            }
            ExportUtil.mkFunction(String.valueOf(floderPath) + File.separator + xwlParent, shortPath, lastModified);
        }
    }

    public static void findParentMenu(Long parentId, List<MenuEObj> pList) throws KException {
        Long rootId = RoleUtils._root;
        if (!rootId.equals(parentId)) {
            CacheServiceAware cacheService = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
            MenuEObj menu = cacheService.getMenuById(parentId);
            pList.add(menu);
            if (menu.getParentId() != rootId) {
                ExportUtil.findParentMenu(menu.getParentId(), pList);
            }
        }
    }

    private static String mkParentMenu(MenuEObj menuEobj, String floderPath) throws Exception {
        ArrayList<MenuEObj> pList = new ArrayList<MenuEObj>();
        ExportUtil.findParentMenu(menuEobj.getParentId(), pList);
        StringBuilder subPath = new StringBuilder();
        if (pList.size() > 0) {
            int i = pList.size() - 1;
            while (i >= 0) {
                subPath.append("/");
                subPath.append(((MenuEObj)pList.get(i)).getMenuName());
                FileUtil.createMkdirs(String.valueOf(floderPath) + File.separator + subPath.toString());
                ExportUtil.mkFolder((MenuEObj)pList.get(i), String.valueOf(floderPath) + File.separator + subPath.toString());
                --i;
            }
        }
        return subPath.toString();
    }

    private static void mkMenu(MenuEObj mEobjRes, String floderPath, String path, Date lastModified) throws Exception {
        CacheServiceAware cacheService = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
        List subMenuList = cacheService.getChildMenus(mEobjRes.getMenuId());
        List sunFunctionList = cacheService.getMenuChildFunction(mEobjRes.getMenuId());
        if (lastModified == null || subMenuList != null && subMenuList.size() > 0) {
            FileUtil.createMkdirs(String.valueOf(floderPath) + File.separator + path);
            ExportUtil.mkFolder(mEobjRes, String.valueOf(floderPath) + File.separator + path);
        } else {
            Boolean flag = null;
            if (sunFunctionList != null && sunFunctionList.size() > 0) {
                for (FunctionEObj functionEObj : sunFunctionList) {
                    flag = FileUtil.checkLastModified(lastModified, functionEObj.getLastUpdateTms());
                    if (flag.booleanValue()) break;
                }
                if (flag.booleanValue()) {
                    FileUtil.createMkdirs(String.valueOf(floderPath) + File.separator + path);
                    ExportUtil.mkFolder(mEobjRes, String.valueOf(floderPath) + File.separator + path);
                }
            } else {
                FileUtil.createMkdirs(String.valueOf(floderPath) + File.separator + path);
                ExportUtil.mkFolder(mEobjRes, String.valueOf(floderPath) + File.separator + path);
            }
        }
        if (subMenuList != null && subMenuList.size() > 0) {
            for (MenuEObj sub : subMenuList) {
                ExportUtil.mkMenu(sub, String.valueOf(floderPath) + File.separator + path, sub.getMenuName(), lastModified);
            }
        }
        if (sunFunctionList != null && sunFunctionList.size() > 0) {
            for (MenuEObj sub : sunFunctionList) {
                ExportUtil.mkFunction(String.valueOf(floderPath) + File.separator + path, sub.getFuncPath(), lastModified);
            }
        }
    }

    private static void mkFolder(MenuEObj mEobjRes, String floderPath) throws Exception {
        CacheServiceAware cacheService = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
        File file = new File(String.valueOf(floderPath) + File.separator + "folder.json");
        List childMenus = cacheService.getChildMenus(mEobjRes.getMenuId());
        List childFunction = cacheService.getMenuChildFunction(mEobjRes.getMenuId());
        JSONObject content = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        content.put("hidden", !"1".equals(mEobjRes.getMenuStatus()));
        content.put("title", (Object)mEobjRes.getMenuTitle());
        content.put("iconCls", (Object)mEobjRes.getMenuIcon());
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        for (MenuEObj menuEObj : childMenus) {
            map.put(menuEObj.getMenuName(), menuEObj.getMenuSeq());
        }
        for (FunctionEObj functionEObj : childFunction) {
            map.put(functionEObj.getShortPath(), functionEObj.getFuncSeq());
        }
        ExportUtil.sortByValueAscending(map, jsonArray);
        content.put("index", (Object)jsonArray);
        FileUtils.writeStringToFile((File)file, (String)content.toString(), (String)"UTF-8");
    }

    public static <K, V extends Comparable<? super V>> void sortByValueAscending(Map<K, V> map, JSONArray jsonArray) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                int compare = ((Comparable)o1.getValue()).compareTo(o2.getValue());
                return compare;
            }
        });
        for (Map.Entry entry : list) {
            jsonArray.put(entry.getKey());
        }
    }

    private static void mkFunction(String floderPath, String path, Date lastModified) throws Exception {
        FunctionEObj funceobj = new FunctionEObj();
        funceobj.setFuncPath(path);
        FunctionEObj tempFunction = basicService.getFunctionEObjByFunc(funceobj);
        if (tempFunction != null) {
            if (lastModified == null || FileUtil.checkLastModified(lastModified, tempFunction.getLastUpdateTms()).booleanValue()) {
                File file = new File(String.valueOf(floderPath) + File.separator + tempFunction.getShortPath());
                JSONObject jsonContent = ExportUtil.getFileCacheXwl(path);
                String content = jsonContent.toString();
                FileUtil.writeString(file, content);
            }
        } else {
            throw new KException("\u5bfc\u51fa\u6587\u4ef6\u9519\u8bef", new Object[]{"\u5e93\u4e2d\u672a\u627e\u5230\u6b64\u6587\u4ef6\u7684\u5b58\u5728\uff01\uff01"});
        }
    }

    private static JSONObject getFileCacheXwl(String path) throws Exception {
        JSONObject content = new JSONObject();
        path = RoleUtils.getRelativePath((String)path);
        CacheServiceAware cs = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
        FunctionContentCacheAware contentCache = (FunctionContentCacheAware)SpringContextUtil.getBean((String)"contentCacheServcie");
        JSONArray tempResult = new JSONArray();
        FunctionEObj function = cs.getFunctionByPath(path);
        content.put("pkId", (Object)function.getPkId());
        content.put("hidden", "0".equals(function.getFuncStatus()));
        JSONObject dbContent = contentCache.getContent(function.getFuncId());
        tempResult.add(0, (Object)dbContent);
        content.put("children", (Object)tempResult);
        JSONObject EmptyRoles = new JSONObject();
        content.put("roles", (Object)EmptyRoles);
        content.put("iconCls", (Object)function.getFuncIcon());
        content.put("title", (Object)function.getFuncName());
        content.put("inframe", "1".equals(function.getInframe()));
        content.put("pageLink", (Object)("".equals(function.getPageLink()) ? "" : function.getPageLink()));
        content.put("qtip", (Object)("".equals(function.getQtip()) ? "" : function.getQtip()));
        return content;
    }

    public static String getXwlName(String xwlPath) {
        String[] names = StringUtils.split((String)xwlPath, (String)"/");
        return names[names.length - 1];
    }
}

