/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.util.ExportUtil;
import com.wb.util.FileUtil;
import com.wb.util.WebUtil;
import com.wb.util.ZipUtil;
import java.io.File;
import java.io.OutputStream;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ks.fintech.bw.api.utils.RoleUtils;
import ks.fintech.framework.core.exception.KException;
import ks.fintech.framework.utils.DateUtils;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class ExportModuleUtil {
    private static String WB_MODULES = "/wb/modules";
    private static String LASTDATESTR = "-1";

    public static void exportModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Date lastModified = null;
        JSONObject app = WebUtil.fetch(request);
        JSONArray fileRange = new JSONArray(app.getString("fileRange"));
        int j = fileRange.length();
        String dateStr = app.getString("lastModified");
        if (LASTDATESTR.equals(dateStr)) {
            dateStr = null;
        }
        if (app.has("lastModified") && dateStr != null) {
            lastModified = DateUtils.parse((String)dateStr, (String)"yyyy-MM-dd");
        }
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        String zipTmpPath = String.valueOf(request.getSession().getServletContext().getRealPath("downloadTemp/")) + uuid;
        FileUtil.createMkdirs(zipTmpPath);
        if (j == 0) {
            ExportUtil.zipModules(zipTmpPath, "modules", lastModified);
        } else {
            int i = 0;
            while (i < j) {
                if (!fileRange.optString(i).contains(WB_MODULES)) {
                    throw new KException("\u5bfc\u51fa\u6a21\u5757\u5305\u9519\u8bef", new Object[]{"\u5bfc\u51fa\u7684\u6a21\u5757\u5fc5\u987b\u4f4d\u4e8e\u6a21\u5757\u76ee\u5f55\u4e0b\u3002"});
                }
                ExportUtil.zipModules(zipTmpPath, RoleUtils.getRelativePath((String)fileRange.optString(i)), lastModified);
                ++i;
            }
        }
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, FileUtil.addExtension(app.get("filename").toString(), "wb")));
        File[] files = new File(zipTmpPath).listFiles();
        if (files.length <= 0) {
            throw new KException("", new Object[]{"\u672a\u627e\u5230\u7b26\u5408\u6307\u5b9a\u8303\u56f4\u5185\u7684\u6587\u4ef6\u6216\u76ee\u5f55\u3002\u3002"});
        }
        ZipUtil.zip(files, (OutputStream)response.getOutputStream());
        response.flushBuffer();
        FileUtils.deleteDirectory((File)new File(zipTmpPath));
    }
}

