/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.controls.page.PageHandler;
import com.wb.controls.page.PageHandlerFactory;
import com.wb.util.DbUtil;
import com.wb.util.RDTypeEnum;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import ks.fintech.framework.core.exception.KException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbPageUtil {
    private static Log log = LogFactory.getLog(DbPageUtil.class);

    private static RDTypeEnum getDbType(Connection connection) throws Exception {
        try {
            RDTypeEnum rdType;
            DatabaseMetaData metaData = connection.getMetaData();
            String dbName = metaData.getDatabaseProductName();
            RDTypeEnum rDTypeEnum = rdType = RDTypeEnum.getRdTypeFromDbName(dbName);
            return rDTypeEnum;
        }
        catch (Exception e) {
            log.error((Object)"error", (Throwable)e);
            throw new KException("error", (Throwable)e);
        }
        finally {
            DbUtil.close(connection);
        }
    }

    public static PageHandler getPageHandler(String jndi) throws Exception {
        RDTypeEnum dbType = DbPageUtil.getDbType(DbUtil.getConnection(jndi));
        PageHandler provider = PageHandlerFactory.createPageHandler(dbType);
        return provider;
    }
}

