/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorKit {
    private static final Logger logger = LoggerFactory.getLogger(ColorKit.class);
    private static String msg = "";
    private static String regHex = "^#([0-9a-fA-f]{3}|[0-9a-fA-f]{6})$";
    private static String regRgb = "^(RGB\\(|rgb\\()([0-9]{1,3},){2}[0-9]{1,3}\\)$";
    private static String regRepRgb = "(rgb|\\(|\\)|RGB)*";

    public static byte[] hex2Rgb(String hex) {
        StringBuilder sb = new StringBuilder();
        String c = hex.toUpperCase().replace("#", "");
        if (HexUtil.isHexNumber((String)c)) {
            msg = "\u989c\u8272\u5341\u516d\u8fdb\u5236\u683c\u5f0f \u3010" + hex + "\u3011 \u4e0d\u5408\u6cd5\uff0c\u8bf7\u786e\u8ba4\uff01";
            logger.error(msg);
            return null;
        }
        byte[] rgb = new byte[]{(byte)Integer.parseInt(c.length() == 3 ? String.valueOf(c.substring(0, 1)) + c.substring(0, 1) : c.substring(0, 2), 16), (byte)Integer.parseInt(c.length() == 3 ? String.valueOf(c.substring(1, 2)) + c.substring(1, 2) : c.substring(2, 4), 16), (byte)Integer.parseInt(c.length() == 3 ? String.valueOf(c.substring(2, 3)) + c.substring(2, 3) : c.substring(4, 6), 16)};
        return rgb;
    }

    public static String rgb2Hex(String rgb) {
        StringBuilder sb = new StringBuilder();
        if (!ColorKit.isRgb(rgb)) {
            msg = "\u989c\u8272 RGB \u683c\u5f0f\u3010" + rgb + "\u3011 \u4e0d\u5408\u6cd5\uff0c\u8bf7\u786e\u8ba4\uff01";
            logger.error(msg);
            return null;
        }
        String r = Integer.toHexString(ColorKit.getRed(rgb)).toUpperCase();
        String g = Integer.toHexString(ColorKit.getGreen(rgb)).toUpperCase();
        String b = Integer.toHexString(ColorKit.getBlue(rgb)).toUpperCase();
        sb.append("#");
        sb.append(r.length() == 1 ? "0" + r : r);
        sb.append(g.length() == 1 ? "0" + g : g);
        sb.append(b.length() == 1 ? "0" + b : b);
        return sb.toString();
    }

    public static int getRed(String rgb) {
        return Integer.valueOf(ColorKit.getRGB(rgb)[0]);
    }

    public static int getGreen(String rgb) {
        return Integer.valueOf(ColorKit.getRGB(rgb)[1]);
    }

    public static int getBlue(String rgb) {
        return Integer.valueOf(ColorKit.getRGB(rgb)[2]);
    }

    public static String[] getRGB(String rgb) {
        return StrUtil.trim((CharSequence)rgb).replace(regRepRgb, "").split(",");
    }

    public static boolean isRgb(String rgb) {
        boolean b;
        boolean r = ColorKit.getRed(rgb) >= 0 && ColorKit.getRed(rgb) <= 255;
        boolean g = ColorKit.getGreen(rgb) >= 0 && ColorKit.getGreen(rgb) <= 255;
        boolean bl = b = ColorKit.getBlue(rgb) >= 0 && ColorKit.getBlue(rgb) <= 255;
        return ColorKit.isRgbFormat(rgb) && r && g && b;
    }

    public static boolean isRgbFormat(String rgb) {
        return rgb.matches(regRgb);
    }
}

